/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.TabList;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.Snd;
import com.Zrips.CMI.Modules.ModuleHandling.CMIModule;
import com.Zrips.CMI.Modules.ModuleHandling.CMIModuleManager;
import com.Zrips.CMI.Modules.Permissions.PermissionInfo;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.Modules.TabList.CMITabSortingOrder;
import com.Zrips.CMI.Modules.TabList.CMITabSortingType;
import com.Zrips.CMI.Modules.TabList.TabList;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Schedulers.CMITask;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TabListManager {
    private HashMap<Integer, TabList> TabList = new HashMap();
    private CMI plugin;
    private CMITask sched = null;
    private CMITask sortSched = null;
    private double interval = 1.0;
    private boolean async = true;
    private boolean UpdateTabListNames = true;
    private boolean GroupedEnabled = true;
    private boolean UpdatesOnJoin = true;
    private boolean UpdatesOnLeave = true;
    private boolean UpdatesOnWorldChange = true;
    private boolean UpdatesOnPlayerDeath = false;
    private boolean UpdatesOnAfkStateChange = false;
    private boolean UpdatesOnPlayerTeleport = false;
    private boolean UpdatesOnNickChange = false;
    private boolean addTabListHeader = true;
    private boolean addTabListFooter = true;
    private boolean sortingEnabled = false;
    private CMITabSortingType sortingType = CMITabSortingType.Name;
    private CMITabSortingOrder sortingOrder = CMITabSortingOrder.ASC;
    private List<String> SortingCustomGroup = new ArrayList<String>();
    private int SortingBalanceInterval = 10;
    private int SortingAutoUpdate = 1;
    private String fileName = "TabList.yml";

    public TabListManager(CMI cMI) {
        this.plugin = cMI;
    }

    public void stop() {
        if (this.sched != null) {
            this.sched.cancel();
            this.sched = null;
        }
        if (this.sortSched != null) {
            this.sortSched.cancel();
            this.sortSched = null;
        }
    }

    public void loadConfig() {
        ConfigReader configReader;
        block47: {
            Set set;
            Boolean bl;
            this.stop();
            CMI.getInstance().safeRenameFile("tabList.yml", "Settings" + File.separator + this.fileName);
            configReader = null;
            try {
                configReader = new ConfigReader((Plugin)CMI.getInstance(), "Settings" + File.separator + this.fileName);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (configReader == null) {
                return;
            }
            ConfigReader configReader2 = this.plugin.getConfigManager().getConfig();
            if (configReader2.getC().isBoolean("TabList.UpdateTabListNames")) {
                configReader.set("TabList", configReader2.getC().get("TabList"));
                configReader.save();
                try {
                    configReader = new ConfigReader((Plugin)CMI.getInstance(), "Settings" + File.separator + this.fileName);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            configReader.addComment("TabList", new String[]{"To disable tablist handling visit Modules.yml file"});
            Boolean bl2 = bl = configReader.getC().isBoolean("TabList.Enabled") ? Boolean.valueOf(configReader.getC().getBoolean("TabList.Enabled", true)) : null;
            if (bl != null) {
                CMIModuleManager.switchInFile(CMIModule.tablist, bl);
                if (!CMIModule.tablist.isEnabled() && bl.booleanValue()) {
                    CMIModule.tablist.setEnabled(true);
                    CMIModule.tablist.registerListener();
                }
            }
            configReader.addComment("TabList.Async", new String[]{"Defines if we want to run tablist updater in async mode", "While enabled it can increase overall performance but some plugins can have same issues handling async placeholder requests"});
            this.async = configReader.get("TabList.Async", Boolean.valueOf(true));
            configReader.addComment("TabList.UpdateTabListNamess", new String[]{"Defines if you want to update tablist player names with CMI format"});
            this.UpdateTabListNames = configReader.get("TabList.UpdateTabListNames", Boolean.valueOf(true));
            configReader.addComment("TabList.GroupedEnabled", new String[]{"Enable or disable grouped format tablist's", "You can save some resources by disabling this if you are not interested in grouped format tablist feature", "If disabled then this will use only default format and will skip checking for custom one to save some resources if needed"});
            this.GroupedEnabled = configReader.get("TabList.GroupedEnabled", Boolean.valueOf(true));
            configReader.addComment("TabList.Updates.AutoInterval", new String[]{"automatically updates tab list every x seconds for ALL online players", "If you are using static Footer and Header you can disable this by setting to -1", "Consider setting this to -1 if its completely enough to update on player events"});
            this.interval = configReader.get("TabList.Updates.AutoInterval", 60);
            this.UpdatesOnJoin = configReader.get("TabList.Updates.OnJoin", Boolean.valueOf(true));
            this.UpdatesOnLeave = configReader.get("TabList.Updates.OnLeave", Boolean.valueOf(true));
            this.UpdatesOnAfkStateChange = configReader.get("TabList.Updates.afkStateChange", Boolean.valueOf(true));
            this.UpdatesOnWorldChange = configReader.get("TabList.Updates.OnWorldChange", Boolean.valueOf(true));
            this.UpdatesOnPlayerDeath = configReader.get("TabList.Updates.OnDeath", Boolean.valueOf(false));
            this.UpdatesOnPlayerTeleport = configReader.get("TabList.Updates.OnTeleport", Boolean.valueOf(false));
            this.UpdatesOnNickChange = configReader.get("TabList.Updates.OnNickChange", Boolean.valueOf(true));
            configReader.addComment("TabList.addTabListHeader", new String[]{"When set to false we will not add header text to tablist"});
            this.addTabListHeader = configReader.get("TabList.addTabListHeader", Boolean.valueOf(true));
            configReader.addComment("TabList.addTabListFooter", new String[]{"When set to false we will not add footer text to tablist"});
            this.addTabListFooter = configReader.get("TabList.addTabListFooter", Boolean.valueOf(true));
            configReader.addComment("TabList.GeneralFormat", new String[]{"PlaceholderAPI supported for any custom variable you want to insert into this", "In addition CMI will handle some placeholders without PlaceHolderAPI", "Full list can be checked ingame with /cmi placeholders"});
            TabList tabList = new TabList();
            configReader.addComment("TabList.GeneralFormat.PlayerName", new String[]{"This will define how others see players name in tab list"});
            tabList.setPlayerNameFormat(configReader.get("TabList.GeneralFormat.PlayerName", "[playerDisplayName]"));
            List list2 = null;
            if (configReader.getC().isList("TabList.GeneralFormat.Header")) {
                list2 = configReader.getC().getStringList("TabList.GeneralFormat.Header");
            }
            if (list2 != null) {
                tabList.addHeaderAnimation(configReader.get("TabList.GeneralFormat.Header.1", list2));
            } else if (!configReader.getC().isConfigurationSection("TabList.GeneralFormat.Header")) {
                tabList.addHeaderAnimation(configReader.get("TabList.GeneralFormat.Header.1", Arrays.asList("&f------------------------------------", "&7Welcome", "&7Online &f%server_online%&7/&f%server_max_players%", "&f------------------------------------")));
            } else {
                set = configReader.getC().getConfigurationSection("TabList.GeneralFormat.Header").getKeys(false);
                for (String string : set) {
                    tabList.addHeaderAnimation(configReader.get("TabList.GeneralFormat.Header." + string, new ArrayList()));
                }
            }
            list2 = null;
            if (configReader.getC().isList("TabList.GeneralFormat.Footer")) {
                list2 = configReader.getC().getStringList("TabList.GeneralFormat.Footer");
            }
            if (list2 != null) {
                tabList.addFooterAnimation(configReader.get("TabList.GeneralFormat.Footer.1", list2));
            } else if (!configReader.getC().isConfigurationSection("TabList.GeneralFormat.Footer")) {
                tabList.addFooterAnimation(configReader.get("TabList.GeneralFormat.Footer.1", Arrays.asList("&f------------------------------------", "&7%player_world% &f%player_x%:&7%player_y%:&f%player_z%", "&7Money: &f%vault_eco_balance_formatted% &7Time: &f%server_time_HH:mm:ss%", "&f------------------------------------")));
            } else {
                set = configReader.getC().getConfigurationSection("TabList.GeneralFormat.Footer").getKeys(false);
                for (String string : set) {
                    tabList.addFooterAnimation(configReader.get("TabList.GeneralFormat.Footer." + string, new ArrayList()));
                }
            }
            this.TabList.put(-1, tabList);
            configReader.addComment("TabList.useGeneralHeader", new String[]{"When this set to true, in case you dint defined PlayerName, Header or Footer in GroupFormat, then default one from GeneralFormat will be used"});
            boolean bl3 = configReader.get("TabList.useGeneralName", Boolean.valueOf(false));
            boolean bl4 = configReader.get("TabList.useGeneralHeader", Boolean.valueOf(false));
            boolean bl5 = configReader.get("TabList.useGeneralFooter", Boolean.valueOf(false));
            configReader.addComment("TabList.GroupFormat", new String[]{"Defines custom formats to be used for players.", "Any player which have cmi.tablist.[number] permission node will use defined grouped format in tablist", "Id should be a number and in case player has more than one, bigger number id will be used", "You can have as many groups as you want by increasing increment"});
            if (!configReader.getC().isConfigurationSection("TabList.GroupFormat")) {
                tabList = new TabList();
                tabList.setPlayerNameFormat(configReader.get("TabList.GroupFormat.1.PlayerName", "&2{&r[playerDisplayName]&2}"));
                tabList.addHeaderAnimation(configReader.get("TabList.GroupFormat.1.Header.1", Arrays.asList("&f------------------------------------", "&7Online &f%server_online%&7/&f%server_max_players%", "&f------------------------------------")));
                tabList.addFooterAnimation(configReader.get("TabList.GroupFormat.1.Footer.1", Arrays.asList("&f------------------------------------", "&7%player_world% &f%player_x%:&7%player_y%:&f%player_z%", "&7Time: &f%server_time_HH:mm:ss%", "&f------------------------------------")));
                this.TabList.put(1, tabList);
                tabList = new TabList();
                tabList.setPlayerNameFormat(configReader.get("TabList.GroupFormat.2.PlayerName", "&c[&r[playerDisplayName]&c]"));
                tabList.addHeaderAnimation(configReader.get("TabList.GroupFormat.2.Header.1", Arrays.asList("&f------------------------------------", "&7Online &f%server_online%&7/&f%server_max_players%", "&f------------------------------------")));
                tabList.addFooterAnimation(configReader.get("TabList.GroupFormat.2.Footer.1", Arrays.asList("&f------------------------------------", "&7Money: &f%vault_eco_balance_formatted% &7Time: &f%server_time_HH:mm:ss%", "&f------------------------------------")));
                this.TabList.put(2, tabList);
            } else {
                try {
                    if (!configReader.getC().isConfigurationSection("TabList.GroupFormat")) break block47;
                    for (String string : configReader.getC().getConfigurationSection("TabList.GroupFormat").getKeys(false)) {
                        Set set2;
                        Integer n = null;
                        try {
                            n = Integer.parseInt(string);
                        }
                        catch (Exception exception) {
                            continue;
                        }
                        tabList = new TabList();
                        if (configReader.getC().isString("TabList.GroupFormat." + String.valueOf(n) + ".PlayerName")) {
                            tabList.setPlayerNameFormat(configReader.get("TabList.GroupFormat." + String.valueOf(n) + ".PlayerName", "&c->&r[playerDisplayName]&c<-"));
                        } else if (bl3) {
                            tabList.setPlayerNameFormat(this.TabList.get(-1).getPlayerNameFormat());
                        }
                        list2 = null;
                        if (configReader.getC().isList("TabList.GroupFormat." + String.valueOf(n) + ".Header")) {
                            list2 = configReader.getC().getStringList("TabList.GroupFormat." + String.valueOf(n) + ".Header");
                        }
                        if (list2 != null) {
                            tabList.addHeaderAnimation(configReader.get("TabList.GroupFormat." + String.valueOf(n) + ".Header.1", list2));
                        } else if (!configReader.getC().isConfigurationSection("TabList.GroupFormat." + String.valueOf(n) + ".Header")) {
                            if (bl4) {
                                tabList.setHeaderMap(new HashMap<Integer, List<String>>(this.TabList.get(-1).getHeaderMap()));
                            } else {
                                tabList.addHeaderAnimation(Arrays.asList(new String[0]));
                            }
                        } else {
                            set2 = configReader.getC().getConfigurationSection("TabList.GroupFormat." + String.valueOf(n) + ".Header").getKeys(false);
                            for (String string2 : set2) {
                                tabList.addHeaderAnimation(configReader.get("TabList.GroupFormat." + String.valueOf(n) + ".Header." + string2, new ArrayList()));
                            }
                        }
                        list2 = null;
                        if (configReader.getC().isList("TabList.GroupFormat." + String.valueOf(n) + ".Footer")) {
                            list2 = configReader.getC().getStringList("TabList.GroupFormat." + String.valueOf(n) + ".Footer");
                        }
                        if (list2 != null) {
                            tabList.addFooterAnimation(configReader.get("TabList.GroupFormat." + String.valueOf(n) + ".Footer.1", list2));
                        } else if (!configReader.getC().isConfigurationSection("TabList.GroupFormat." + String.valueOf(n) + ".Footer")) {
                            if (bl5) {
                                tabList.setFooterMap(new HashMap<Integer, List<String>>(this.TabList.get(-1).getFooterMap()));
                            } else {
                                tabList.addFooterAnimation(Arrays.asList(new String[0]));
                            }
                        } else {
                            set2 = configReader.getC().getConfigurationSection("TabList.GroupFormat." + String.valueOf(n) + ".Footer").getKeys(false);
                            for (String string2 : set2) {
                                tabList.addFooterAnimation(configReader.get("TabList.GroupFormat." + String.valueOf(n) + ".Footer." + string2, new ArrayList()));
                            }
                        }
                        this.TabList.put(n, tabList);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        configReader.save();
        if (this.plugin.isEnabled()) {
            this.tasker();
        }
    }

    private void tasker() {
        if (this.sched != null) {
            return;
        }
        if (this.interval < 0.0) {
            this.stop();
            return;
        }
        int n = (int)(this.interval * 20.0);
        if (n < 1) {
            n = 1;
        }
        this.sched = CMIScheduler.runTimerAsync(this::updateTabList, (long)0L, (long)n);
    }

    public TabList getTL(Player player) {
        PermissionInfo permissionInfo = null;
        if (this.GroupedEnabled) {
            permissionInfo = this.plugin.getPermissionsManager().getPermissionInfo(player, PermissionsManager.CMIPerm.tablist_$1, (Long)1000L);
        }
        if (permissionInfo == null || permissionInfo.getMaxValue() == null) {
            return this.TabList.get(-1);
        }
        int n = permissionInfo.getMaxValue().intValue();
        return this.TabList.containsKey(n) ? this.TabList.get(n) : this.TabList.get(-1);
    }

    public void updateTabList(int n) {
        if (!CMIModule.tablist.isEnabled()) {
            return;
        }
        CMIScheduler.runTaskLater(() -> this.plugin.getTabListManager().updateTabList(), (long)n);
    }

    public void updateTabList() {
        if (!CMIModule.tablist.isEnabled()) {
            return;
        }
        for (Player object : Bukkit.getOnlinePlayers()) {
            this.updateTabList(object);
        }
        for (Map.Entry entry : this.TabList.entrySet()) {
            ((TabList)entry.getValue()).prepareNextAnimationForFooter();
            ((TabList)entry.getValue()).prepareNextAnimationForHeader();
        }
    }

    public void updateTablistName(Player player) {
        Snd snd = new Snd().setSender(player).setTarget(player);
        TabList tabList = this.getTL(player);
        if (tabList != null && tabList.getPlayerNameFormat() != null && !tabList.getPlayerNameFormat().isEmpty()) {
            String string = this.plugin.getLM().updateSnd(snd, tabList.getPlayerNameFormat());
            string = this.plugin.getPlaceholderAPIManager().updatePlaceHolders(player, string);
            if (!player.getPlayerListName().equals(string)) {
                if (Version.isCurrentEqualOrLower((Version)Version.v1_7_R4) && CMIChatColor.translate((String)string).length() > 16) {
                    player.setPlayerListName(CMIChatColor.translate((String)string).substring(0, 15));
                } else {
                    player.setPlayerListName(CMIChatColor.translate((String)string));
                }
            }
        }
    }

    public void updateTabList(Player player) {
        if (this.async) {
            this.updateTabListAsync(player);
        } else {
            this.updateTabListSync(player);
        }
    }

    public void updateTabListSync(Player player) {
        if (!CMIModule.tablist.isEnabled()) {
            return;
        }
        Snd snd = new Snd().setSender(player).setTarget(player);
        TabList tabList = this.getTL(player);
        if (this.isUpdateTabListNames()) {
            this.updateTablistName(player);
        }
        List<String> list2 = null;
        if (this.addTabListHeader) {
            list2 = tabList.getHeader();
            list2 = this.plugin.getPlaceholderAPIManager().updatePlaceHolders(player, list2);
            list2 = this.plugin.getLM().updateSnd(snd, list2);
        }
        List<String> list3 = null;
        if (this.addTabListFooter) {
            list3 = tabList.getFooter();
            list3 = this.plugin.getPlaceholderAPIManager().updatePlaceHolders(player, list3);
            list3 = this.plugin.getLM().updateSnd(snd, list3);
        }
        this.plugin.getTabListHandler().send(player, list2, list3);
    }

    public void updateTabListAsync(Player player) {
        if (!CMIModule.tablist.isEnabled()) {
            return;
        }
        Snd snd = new Snd().setSender(player).setTarget(player);
        TabList tabList = this.getTL(player);
        if (tabList == null) {
            return;
        }
        CMIScheduler.runTaskAsynchronously(() -> {
            if (this.isUpdateTabListNames()) {
                this.updateTablistName(player);
            }
            List<String> list2 = null;
            if (this.addTabListHeader) {
                list2 = tabList.getHeader();
                list2 = this.plugin.getPlaceholderAPIManager().updatePlaceHolders(player, list2);
                list2 = this.plugin.getLM().updateSnd(snd, list2);
            }
            List<String> list3 = null;
            if (this.addTabListFooter) {
                list3 = tabList.getFooter();
                list3 = this.plugin.getPlaceholderAPIManager().updatePlaceHolders(player, list3);
                list3 = this.plugin.getLM().updateSnd(snd, list3);
            }
            this.plugin.getTabListHandler().send(player, list2, list3);
        });
    }

    public boolean isUpdatesOnJoin() {
        return this.UpdatesOnJoin;
    }

    public boolean isUpdatesOnLeave() {
        return this.UpdatesOnLeave;
    }

    public boolean isUpdatesOnWorldChange() {
        return this.UpdatesOnWorldChange;
    }

    public boolean isUpdatesOnPlayerDeath() {
        return this.UpdatesOnPlayerDeath;
    }

    public boolean isUpdatesOnPlayerTeleport() {
        return this.UpdatesOnPlayerTeleport;
    }

    public boolean isUpdatesOnNickChange() {
        return this.UpdatesOnNickChange;
    }

    public boolean isUpdatesOnAfkStateChange() {
        return this.UpdatesOnAfkStateChange;
    }

    public boolean isEnabled() {
        return CMIModule.tablist.isEnabled();
    }

    public boolean isUpdateTabListNames() {
        return this.UpdateTabListNames;
    }

    public boolean isSortingEnabled() {
        return this.sortingEnabled;
    }

    public CMITabSortingType getSortingType() {
        return this.sortingType;
    }

    public CMITabSortingOrder getSortingOrder() {
        return this.sortingOrder;
    }
}

