/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Vanish;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.Modules.Vanish.VanishAction;
import com.Zrips.CMI.commands.list.util;
import com.Zrips.CMI.commands.list.vanish;
import net.Zrips.CMILib.Messages.CMIMessages;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.SpawnerSpawnEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.util.Vector;

public class VanishListener
implements Listener {
    private CMI plugin;

    public VanishListener(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onFishingRodUseOnPlayer(PlayerFishEvent playerFishEvent) {
        if (playerFishEvent.getState() != PlayerFishEvent.State.CAUGHT_ENTITY) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(playerFishEvent.getPlayer());
        if (cMIUser == null) {
            return;
        }
        if (cMIUser.isCMIVanished() && cMIUser.getVanish().is(VanishAction.hookPlayers)) {
            playerFishEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void PlayerPickupItemEvent(PlayerPickupItemEvent playerPickupItemEvent) {
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(playerPickupItemEvent.getPlayer());
        if (cMIUser == null) {
            return;
        }
        if (cMIUser.isCMIVanished() && !cMIUser.getVanish().is(VanishAction.itemPickup)) {
            playerPickupItemEvent.setCancelled(true);
            playerPickupItemEvent.getItem().setPickupDelay(playerPickupItemEvent.getItem().getPickupDelay() < 20 ? 20 : playerPickupItemEvent.getItem().getPickupDelay());
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void CreatureSpawnEvent(CreatureSpawnEvent creatureSpawnEvent) {
        if (creatureSpawnEvent.isCancelled()) {
            return;
        }
        if (this.plugin.getVanishManager().getAllVanished().isEmpty()) {
            return;
        }
        if ((creatureSpawnEvent.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.NATURAL) || creatureSpawnEvent.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.SPAWNER)) && !this.plugin.getVanishManager().nearActivePlayer(creatureSpawnEvent.getLocation())) {
            creatureSpawnEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void CreatureSpawnEvent(SpawnerSpawnEvent spawnerSpawnEvent) {
        if (spawnerSpawnEvent.isCancelled()) {
            return;
        }
        if (this.plugin.getVanishManager().getAllVanished().isEmpty()) {
            return;
        }
        if (!this.plugin.getVanishManager().nearActivePlayer(spawnerSpawnEvent.getLocation())) {
            spawnerSpawnEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void EntityDamageByEntityEvent(ProjectileHitEvent projectileHitEvent) {
        if (!Version.isCurrentEqualOrHigher((Version)Version.v1_12_R1)) {
            return;
        }
        try {
            Projectile projectile = projectileHitEvent.getEntity();
            Entity entity = projectileHitEvent.getHitEntity();
            if (entity == null) {
                return;
            }
            if (!(projectile instanceof Projectile)) {
                return;
            }
            if (!(entity instanceof Player) || !(projectile.getShooter() instanceof Player)) {
                return;
            }
            Projectile projectile2 = projectile;
            Vector vector = projectile2.getVelocity();
            Location location = projectile2.getLocation();
            Player player = (Player)entity;
            GameMode gameMode = player.getGameMode();
            Location location2 = player.getLocation();
            CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
            if (cMIUser == null) {
                return;
            }
            if (!cMIUser.isCMIVanished()) {
                return;
            }
            try {
                player.setGameMode(GameMode.SPECTATOR);
            }
            catch (Exception exception) {
                return;
            }
            projectile2.teleport(location);
            projectile2.setVelocity(vector);
            projectile2.setBounce(false);
            CMIScheduler.runTaskLater(() -> {
                projectile2.teleport(location);
                projectile2.setVelocity(vector);
                projectile2.setBounce(false);
            }, (long)1L);
            CMIScheduler.runTaskLater(() -> {
                player.setGameMode(gameMode);
                player.teleport(location2);
            }, (long)2L);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return;
        }
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent playerQuitEvent) {
        if (!this.plugin.getBungeeCordManager().isBungeeCord()) {
            this.plugin.getUtilManager().removeMessageReplyTo(playerQuitEvent.getPlayer().getName());
        }
        this.plugin.getVanishManager().removePlayer(playerQuitEvent.getPlayer().getUniqueId(), false);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerJoinHideOthers(PlayerJoinEvent playerJoinEvent) {
        this.plugin.getVanishManager().hideVanishedPlayersFor(playerJoinEvent.getPlayer());
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(playerJoinEvent.getPlayer());
        if (cMIUser == null) {
            return;
        }
        this.plugin.getVanishManager().applyVanish(cMIUser, false, false, true);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerJoinHideYou(PlayerJoinEvent playerJoinEvent) {
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(playerJoinEvent.getPlayer());
        if (cMIUser == null) {
            return;
        }
        if (!cMIUser.isCMIVanished()) {
            if (!cMIUser.getVanish().is(VanishAction.joinVanished) || !PermissionsManager.CMIPerm.command_$1.hasPermission((CommandSender)playerJoinEvent.getPlayer(), vanish.class.getSimpleName())) {
                return;
            }
            cMIUser.setVanished(true, false);
        }
        if (cMIUser.getVanish().is(VanishAction.relogDisable)) {
            cMIUser.setVanished(false, false);
            if (!cMIUser.getVanish().is(VanishAction.informOnJoin)) {
                playerJoinEvent.setJoinMessage("");
            }
            return;
        }
        if (cMIUser.isCMIVanished() && !cMIUser.getVanish().is(VanishAction.informOnJoin)) {
            playerJoinEvent.setJoinMessage("");
        }
        this.plugin.getVanishManager().hidePlayerForEveryone(playerJoinEvent.getPlayer());
    }

    @EventHandler
    public void onEntityTarget(EntityTargetEvent entityTargetEvent) {
        if (!(entityTargetEvent.getTarget() instanceof Player)) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser((Player)entityTargetEvent.getTarget());
        if (cMIUser == null) {
            return;
        }
        if (entityTargetEvent.getEntity() instanceof ExperienceOrb && cMIUser.isCMIVanished() && !cMIUser.getVanish().is(VanishAction.itemPickup)) {
            Player player = (Player)entityTargetEvent.getTarget();
            if (player == null) {
                return;
            }
            entityTargetEvent.setCancelled(true);
            entityTargetEvent.setTarget(null);
            return;
        }
        if (cMIUser.isCMIVanished() && !cMIUser.getVanish().is(VanishAction.mobAggro)) {
            entityTargetEvent.setCancelled(true);
            entityTargetEvent.setTarget(null);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent entityDamageEvent) {
        CMIUser cMIUser;
        Player player;
        Entity entity = entityDamageEvent.getEntity();
        if (entity instanceof Player) {
            player = (Player)entity;
            cMIUser = this.plugin.getPlayerManager().getUser(player);
            if (cMIUser == null) {
                return;
            }
            if (cMIUser.isCMIVanished() && !cMIUser.getVanish().is(VanishAction.playerDamage)) {
                if (util.imortaldebug) {
                    CMIMessages.consoleMessage((String)"Vanish onEntityDamage->EntityDamageEvent");
                }
                entityDamageEvent.setCancelled(true);
            }
        }
        if (entityDamageEvent instanceof EntityDamageByEntityEvent) {
            Object object;
            player = (EntityDamageByEntityEvent)entityDamageEvent;
            cMIUser = player.getDamager();
            Player player2 = null;
            if (cMIUser instanceof Player) {
                player2 = (Player)cMIUser;
            } else if (cMIUser instanceof Projectile && (object = (Projectile)cMIUser).getShooter() != null && object.getShooter() instanceof Player) {
                player2 = (Player)object.getShooter();
            }
            object = this.plugin.getPlayerManager().getUser(player2);
            if (object == null) {
                return;
            }
            if (((CMIUser)object).isCMIVanished() && !((CMIUser)object).getVanish().is(VanishAction.damageToEntity)) {
                if (util.imortaldebug) {
                    CMIMessages.consoleMessage((String)"Vanish2 onEntityDamage->EntityDamageEvent");
                }
                entityDamageEvent.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onPlayerInteractEvent(PlayerInteractEvent playerInteractEvent) {
        if (!playerInteractEvent.getAction().equals((Object)Action.PHYSICAL)) {
            return;
        }
        Player player = playerInteractEvent.getPlayer();
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        if (cMIUser.isCMIVanished() && !cMIUser.getVanish().is(VanishAction.interaction)) {
            playerInteractEvent.setCancelled(true);
        }
    }

    /*
     * Unable to fully structure code
     */
    @EventHandler
    public void ping(ServerListPingEvent var1_1) {
        try {
            var2_2 = var1_1.iterator();
            if (true) ** GOTO lbl11
        }
        catch (UnsupportedOperationException var3_3) {
            return;
        }
        do {
            var3_4 = (Player)var2_2.next();
            var4_5 = this.plugin.getPlayerManager().getUser(var3_4);
            if (var4_5 == null || !var4_5.isVanished()) continue;
            var2_2.remove();
lbl11:
            // 3 sources

        } while (var2_2.hasNext());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onQuit(PlayerQuitEvent playerQuitEvent) {
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(playerQuitEvent.getPlayer());
        if (cMIUser == null) {
            return;
        }
        if (cMIUser.isCMIVanished() && !cMIUser.getVanish().is(VanishAction.informOnLeave)) {
            playerQuitEvent.setQuitMessage("");
        }
        cMIUser.hideBossBars();
        cMIUser.clearBossMaps();
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerDeathEvent(PlayerDeathEvent playerDeathEvent) {
        Player player = playerDeathEvent.getEntity();
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        if (cMIUser.isCMIVanished() && !cMIUser.getVanish().is(VanishAction.deathMessages)) {
            playerDeathEvent.setDeathMessage("");
        }
    }
}

