/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Warps;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Containers.Snd;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Permissions.PermissionInfo;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.Modules.Warps.CmiWarp;
import com.Zrips.CMI.commands.list.editwarp;
import com.Zrips.CMI.commands.list.homes;
import com.Zrips.CMI.commands.list.kiteditor;
import com.Zrips.CMI.commands.list.warp;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Chat.ChatMessageEdit;
import net.Zrips.CMILib.Chat.ChatMessageListEdit;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMILocation;
import net.Zrips.CMILib.Container.CMIText;
import net.Zrips.CMILib.Container.PageInfo;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.GUI.CMIGui;
import net.Zrips.CMILib.GUI.CMIGuiButton;
import net.Zrips.CMILib.GUI.GUIManager;
import net.Zrips.CMILib.Items.CMIItemStack;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Locale.LC;
import net.Zrips.CMILib.Messages.CMIMessages;
import net.Zrips.CMILib.RawMessages.RawMessage;
import net.Zrips.CMILib.RawMessages.RawMessageCommand;
import net.Zrips.CMILib.Sounds.CMISoundPreset;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Schedulers.CMITask;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class WarpManager {
    private CMI plugin;
    LinkedHashMap<String, CmiWarp> warps = new LinkedHashMap();
    HashMap<UUID, HashMap<String, CmiWarp>> userWarps = new HashMap();
    private boolean warpGUI = true;
    private boolean GUIOnCreation = true;
    private boolean warpShowCreator = true;
    private boolean warpRequirePerm = false;
    private int warpPerPage = 50;
    private int MinLength = 4;
    private int MaxLength = 16;
    private Boolean guiCloseButton;
    private int guiCloseButtonSlot;
    private CMIItemStack guiCloseButtonItem;
    private List<String> guiCloseButtonCommands;
    private boolean guiInfoButton;
    private int guiInfoButtonSlot;
    private CMIItemStack guiInfoButtonItem;
    private List<String> guiInfoButtonCommands;
    private String fileName = "Warps.yml";
    boolean saving = false;
    private CMITask saveId = null;

    public WarpManager(CMI cMI) {
        this.plugin = cMI;
    }

    public void onDisable() {
        if (this.saveId != null) {
            this.saveId.cancel();
            this.saveId = null;
            this.save();
        }
    }

    public HashMap<String, CmiWarp> getWarps() {
        return this.warps;
    }

    public int getWarpCount(Player player) {
        return this.userWarps.get(player.getUniqueId()) == null ? 0 : this.userWarps.get(player.getUniqueId()).size();
    }

    public int getMaxWarps(CommandSender commandSender) {
        if (commandSender instanceof Player) {
            return this.getMaxWarps((Player)commandSender);
        }
        return 9999;
    }

    public int getMaxWarps(Player player) {
        int n = 1;
        if (player == null || !player.isOnline()) {
            return n;
        }
        if (PermissionsManager.CMIPerm.command_setwarp_unlimited.hasPermission((CommandSender)player)) {
            return 9999;
        }
        PermissionInfo permissionInfo = this.plugin.getPermissionsManager().getPermissionInfo(player, PermissionsManager.CMIPerm.command_setwarp_$1);
        if (permissionInfo == null) {
            return 0;
        }
        if (permissionInfo.getMaxValue() == null) {
            return 0;
        }
        return permissionInfo.getMaxValue().intValue();
    }

    public List<CmiWarp> getWarps(Player player, String string) {
        return this.getWarps(player, null, string, true, false);
    }

    public List<CmiWarp> getWarps(Player player) {
        return this.getWarps(player, null, null, true, false);
    }

    public List<CmiWarp> getWarps(Player player, Integer n, String string) {
        return this.getWarps(player, n, string, true, false);
    }

    public List<CmiWarp> getWarps(Player player, Integer n, String string, boolean bl) {
        return this.getWarps(player, n, string, bl, false);
    }

    public List<CmiWarp> getWarps(Player player, Integer n, String string, boolean bl, boolean bl2) {
        ArrayList<CmiWarp> arrayList = new ArrayList<CmiWarp>();
        boolean bl3 = PermissionsManager.CMIPerm.command_warp_$1.hasPermission((CommandSender)player, "*");
        if (n != null) {
            for (Map.Entry<String, CmiWarp> entry : this.warps.entrySet()) {
                if (bl2 && !entry.getValue().getCreator().equals(player.getUniqueId()) || !bl && entry.getValue().isHidden() || !entry.getValue().getLoc().isValid() || entry.getValue().getLoc() == null || entry.getValue().getLoc().getWorld() == null || entry.getValue().getSlot() == null || entry.getValue().getPage() != n || !bl3 && entry.getValue().isReqPerm() && !PermissionsManager.CMIPerm.command_warp_$1.hasPermission((CommandSender)player, entry.getKey().toLowerCase()) && !entry.getValue().isShowUnavailable().booleanValue() || string != null && !entry.getValue().sameGroup(string)) continue;
                arrayList.add(entry.getValue());
            }
            for (Map.Entry<String, CmiWarp> entry : this.warps.entrySet()) {
                if (bl2 && !entry.getValue().getCreator().equals(player.getUniqueId()) || !bl && entry.getValue().isHidden() || !entry.getValue().getLoc().isValid() || entry.getValue().getLoc() == null || entry.getValue().getLoc().getWorld() == null || entry.getValue().getSlot() != null || entry.getValue().getPage() != n || !bl3 && entry.getValue().isReqPerm() && !PermissionsManager.CMIPerm.command_warp_$1.hasPermission((CommandSender)player, entry.getKey().toLowerCase()) && !entry.getValue().isShowUnavailable().booleanValue() || string != null && !entry.getValue().sameGroup(string)) continue;
                arrayList.add(entry.getValue());
            }
        } else {
            for (Map.Entry<String, CmiWarp> entry : this.warps.entrySet()) {
                if (bl2 && !entry.getValue().getCreator().equals(player.getUniqueId()) || !bl && entry.getValue().isHidden() || !bl3 && entry.getValue().isReqPerm() && !PermissionsManager.CMIPerm.command_warp_$1.hasPermission((CommandSender)player, entry.getKey().toLowerCase()) && !entry.getValue().isShowUnavailable().booleanValue() || string != null && !entry.getValue().sameGroup(string)) continue;
                arrayList.add(entry.getValue());
            }
        }
        return arrayList;
    }

    public HashMap<Integer, HashMap<Integer, CmiWarp>> getPagedWarps(Player player, String string, boolean bl, boolean bl2) {
        int n;
        int n2;
        Serializable serializable22;
        int n3;
        HashMap<Integer, HashMap<Integer, CmiWarp>> hashMap = new HashMap<Integer, HashMap<Integer, CmiWarp>>();
        ArrayList<CmiWarp> arrayList = new ArrayList<CmiWarp>();
        boolean bl3 = PermissionsManager.CMIPerm.command_warp_$1.hasPermission((CommandSender)player, "*");
        LinkedHashMap<String, CmiWarp> linkedHashMap = new LinkedHashMap<String, CmiWarp>(this.warps);
        for (Map.Entry<String, CmiWarp> object : this.warps.entrySet()) {
            if (bl2 && !object.getValue().getCreator().equals(player.getUniqueId())) {
                linkedHashMap.remove(object.getKey());
                continue;
            }
            if (!bl && object.getValue().isHidden()) {
                linkedHashMap.remove(object.getKey());
                continue;
            }
            if (!object.getValue().getLoc().isValid()) {
                linkedHashMap.remove(object.getKey());
                continue;
            }
            if (object.getValue().getLoc() == null || object.getValue().getLoc().getWorld() == null) {
                linkedHashMap.remove(object.getKey());
                continue;
            }
            if (!bl3 && object.getValue().isReqPerm() && !PermissionsManager.CMIPerm.command_warp_$1.hasPermission((CommandSender)player, object.getKey().toLowerCase()) && !object.getValue().isShowUnavailable().booleanValue()) {
                linkedHashMap.remove(object.getKey());
                continue;
            }
            if (string != null && !object.getValue().sameGroup(string)) {
                linkedHashMap.remove(object.getKey());
                continue;
            }
            if (object.getValue().getPage() == null) continue;
            HashMap<Integer, CmiWarp> hashMap2 = hashMap.getOrDefault(object.getValue().getPage(), new HashMap());
            if (hashMap2.size() >= 28 || object.getValue().getSlot() != null && object.getValue().getSlot() >= 28) {
                arrayList.add(object.getValue());
                linkedHashMap.remove(object.getKey());
                continue;
            }
            if (object.getValue().getSlot() == null || hashMap2.containsKey(object.getValue().getSlot())) {
                int n4 = object.getValue().getSlot() == null ? 0 : object.getValue().getSlot();
                n3 = 0;
                int n5 = n4;
                while (n5 < 28) {
                    if (!hashMap2.containsKey(n5)) {
                        n3 = 1;
                        hashMap2.put(n5, object.getValue());
                        hashMap.put(object.getValue().getPage(), hashMap2);
                        break;
                    }
                    ++n5;
                }
                if (n3 == 0) {
                    arrayList.add(object.getValue());
                }
                linkedHashMap.remove(object.getKey());
                continue;
            }
            hashMap2.put(object.getValue().getSlot(), object.getValue());
            hashMap.put(object.getValue().getPage(), hashMap2);
            linkedHashMap.remove(object.getKey());
        }
        for (CmiWarp cmiWarp : arrayList) {
            linkedHashMap.put(cmiWarp.getName().toLowerCase(), cmiWarp);
        }
        boolean bl4 = true;
        for (Serializable serializable22 : hashMap.keySet()) {
            if ((Integer)serializable22 <= n2) continue;
            n2 = (Integer)serializable22;
        }
        serializable22 = new LinkedHashMap<String, CmiWarp>(linkedHashMap);
        block4: for (Map.Entry<String, CmiWarp> entry : linkedHashMap.entrySet()) {
            n3 = 1;
            while (n3 <= n2) {
                HashMap<Integer, CmiWarp> hashMap3 = hashMap.getOrDefault(n3, new HashMap());
                if (hashMap3.size() < 28) {
                    int n6 = n = entry.getValue().getSlot() == null ? 0 : entry.getValue().getSlot();
                    while (n6 < 28) {
                        if (!hashMap3.containsKey(n6)) {
                            hashMap3.put(n6, entry.getValue());
                            hashMap.put(n3, hashMap3);
                            serializable22.remove(entry.getKey());
                            continue block4;
                        }
                        ++n6;
                    }
                }
                ++n3;
            }
        }
        if (!serializable22.isEmpty()) {
            block7: for (Map.Entry<String, CmiWarp> entry : serializable22.entrySet()) {
                int n7;
                HashMap<Integer, CmiWarp> hashMap4 = hashMap.getOrDefault(n2 + 1, new HashMap());
                if (hashMap4.size() >= 28) continue;
                n = n7 = entry.getValue().getSlot() == null ? 0 : entry.getValue().getSlot();
                while (n < 28) {
                    if (!hashMap4.containsKey(n)) {
                        hashMap4.put(n, entry.getValue());
                        hashMap.put(n2 + 1, hashMap4);
                        continue block7;
                    }
                    ++n;
                }
            }
        }
        return hashMap;
    }

    public void openWarpEditor(Player player, String string) {
        this.openWarpEditor(player, this.getWarp(string));
    }

    public void openWarpEditor(final Player player, final CmiWarp cmiWarp) {
        if (player == null) {
            return;
        }
        if (!player.isOnline()) {
            return;
        }
        if (cmiWarp == null) {
            return;
        }
        CMIGui cMIGui = new CMIGui(player){

            public void onClose() {
                WarpManager.this.safeSave();
            }
        };
        cMIGui.setTitle(cmiWarp.getName());
        cMIGui.setInvSize(GUIManager.GUIRows.r6);
        CMIGuiButton cMIGuiButton = new CMIGuiButton(warpEditorSlots.icon.getSlot(), cmiWarp.getIcon()){

            public void click() {
                ItemStack itemStack = player.getOpenInventory().getCursor();
                if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) {
                    cmiWarp.setItem(null);
                } else {
                    cmiWarp.setItem(itemStack.clone());
                }
                WarpManager.this.safeSave();
                WarpManager.this.openWarpEditor(player, cmiWarp);
            }
        };
        cMIGuiButton.addLore("");
        cMIGuiButton.addLore(CMILC.getIM(editwarp.class, "placeItem", new Object[0]));
        cMIGui.addButton(cMIGuiButton);
        cMIGuiButton = new CMIGuiButton(warpEditorSlots.offIcon.getSlot(), cmiWarp.getOffIcon()){

            public void click() {
                ItemStack itemStack = player.getOpenInventory().getCursor();
                if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) {
                    cmiWarp.setOffItem(null);
                } else {
                    cmiWarp.setOffItem(itemStack.clone());
                }
                WarpManager.this.safeSave();
                WarpManager.this.plugin.getWarpManager().openWarpEditor(player, cmiWarp);
            }
        };
        cMIGuiButton.addLore("");
        cMIGuiButton.addLore(CMILC.getIM(editwarp.class, "placeOffItem", new Object[0]));
        cMIGui.addButton(cMIGuiButton);
        cMIGuiButton = new CMIGuiButton(warpEditorSlots.randomYaw.getSlot(), cmiWarp.isAutoLore() != false ? CMIMaterial.COMPASS.newItemStack() : CMIMaterial.COMPASS.newItemStack()){

            public void click() {
                cmiWarp.setRandomizeYaw(!cmiWarp.isRandomizeYaw());
                WarpManager.this.plugin.getWarpManager().openWarpEditor(player, cmiWarp);
                WarpManager.this.safeSave();
            }
        };
        cMIGuiButton.setName(CMILC.getIM(editwarp.class, "randomizeYaw", "[state]", cmiWarp.isRandomizeYaw()));
        cMIGui.addButton(cMIGuiButton);
        cMIGuiButton = new CMIGuiButton(warpEditorSlots.autoLore.getSlot(), cmiWarp.isAutoLore() != false ? CMIMaterial.GREEN_WOOL.newItemStack() : CMIMaterial.RED_WOOL.newItemStack()){

            public void click() {
                cmiWarp.setAutoLore(cmiWarp.isAutoLore() == false);
                WarpManager.this.plugin.getWarpManager().openWarpEditor(player, cmiWarp);
                WarpManager.this.safeSave();
            }
        };
        cMIGuiButton.setName(CMILC.getIM(editwarp.class, "autoLore", "[state]", cmiWarp.isAutoLore()));
        cMIGui.addButton(cMIGuiButton);
        cMIGuiButton = new CMIGuiButton(warpEditorSlots.permission.getSlot(), cmiWarp.isReqPerm() ? CMIMaterial.GREEN_WOOL.newItemStack() : CMIMaterial.RED_WOOL.newItemStack()){

            public void click() {
                cmiWarp.setReqPerm(!cmiWarp.isReqPerm());
                WarpManager.this.plugin.getWarpManager().openWarpEditor(player, cmiWarp);
                WarpManager.this.safeSave();
            }
        };
        cMIGuiButton.setName(CMILC.getIM(editwarp.class, "permission", "[state]", cmiWarp.isReqPerm()));
        cMIGui.addButton(cMIGuiButton);
        cMIGuiButton = new CMIGuiButton(warpEditorSlots.reqPermission.getSlot(), cmiWarp.isShowUnavailable() != false ? CMIMaterial.GREEN_WOOL.newItemStack() : CMIMaterial.RED_WOOL.newItemStack()){

            public void click() {
                cmiWarp.setShowUnavailable(cmiWarp.isShowUnavailable() == false);
                WarpManager.this.plugin.getWarpManager().openWarpEditor(player, cmiWarp);
                WarpManager.this.safeSave();
            }
        };
        cMIGuiButton.setName(CMILC.getIM(editwarp.class, "reqPermission", "[state]", cmiWarp.isShowUnavailable()));
        cMIGui.addButton(cMIGuiButton);
        cMIGuiButton = new CMIGuiButton(warpEditorSlots.hidden.getSlot()){

            public void click() {
                cmiWarp.setHidden(!cmiWarp.isHidden());
                this.updateLooks();
                this.update();
                WarpManager.this.safeSave();
            }

            public void updateLooks() {
                this.setItem(!cmiWarp.isHidden() ? CMIMaterial.GREEN_WOOL.newItemStack() : CMIMaterial.YELLOW_WOOL.newItemStack());
                this.setName(CMILC.getIM(editwarp.class, "hidden", "[state]", cmiWarp.isHidden()));
            }
        };
        cMIGui.addButton(cMIGuiButton);
        if (this.plugin.getWarpManager().isWarpGUI()) {
            cMIGuiButton = new CMIGuiButton(warpEditorSlots.back.getSlot(), CMILib.getInstance().getConfigManager().getGUIPreviousPage()){

                public void click() {
                    WarpManager.this.safeSave();
                }
            };
            cMIGuiButton.setName(LC.info_Back.getLocale(new Object[0]));
            cMIGuiButton.addCommand("cmi warp -p:" + String.valueOf(cmiWarp.getPage()));
            cMIGui.addButton(cMIGuiButton);
        }
        cMIGuiButton = new CMIGuiButton(warpEditorSlots.location.getSlot(), CMIMaterial.STICK.newItemStack()){

            public void click() {
                cmiWarp.setLoc(new CMILocation(player.getLocation()));
                WarpManager.this.plugin.getWarpManager().openWarpEditor(player, cmiWarp);
                WarpManager.this.safeSave();
            }
        };
        cMIGuiButton.setName(CMILC.getIM(editwarp.class, "primaryLocation", new Object[0]));
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(CMIChatColor.translate((String)("&e" + cmiWarp.getLoc().getWorldName())));
        arrayList.add(CMIChatColor.translate((String)("&e" + cmiWarp.getLoc().getBlockX() + ":" + cmiWarp.getLoc().getBlockY() + ":" + cmiWarp.getLoc().getBlockZ())));
        cMIGuiButton.addLore(arrayList);
        cMIGui.addButton(cMIGuiButton);
        if (PermissionsManager.CMIPerm.command_setwarp_unlimited.hasPermission((CommandSender)player)) {
            cMIGuiButton = new CMIGuiButton(warpEditorSlots.seclocation.getSlot(), CMIMaterial.LADDER.newItemStack()){

                public void click() {
                    player.closeInventory();
                    ChatMessageListEdit chatMessageListEdit = new ChatMessageListEdit((CommandSender)player, cmiWarp.getLocations(), ChatMessageListEdit.ChatEditType.Location, 10){

                        public void onUpdate() {
                            cmiWarp.resetQueue();
                            WarpManager.this.safeSave();
                        }
                    };
                    RawMessage rawMessage = new RawMessage();
                    RawMessageCommand rawMessageCommand = new RawMessageCommand(){

                        public void run(CommandSender commandSender) {
                            cmiWarp.resetQueue();
                            (this).WarpManager.this.plugin.getWarpManager().openWarpEditor(player, cmiWarp);
                        }
                    };
                    rawMessageCommand.setKeep(true);
                    rawMessage.addText(LC.Locations.getLocale(new Object[0])).addHover(CMILC.getIM(kiteditor.class, "ListTitleHover", new Object[0])).addCommand(rawMessageCommand.getCommand());
                    chatMessageListEdit.setTopLine(rawMessage);
                    chatMessageListEdit.print();
                    WarpManager.this.safeSave();
                }
            };
            cMIGuiButton.setName(CMILC.getIM(editwarp.class, "secondaryLocation", new Object[0]));
            arrayList = new ArrayList();
            for (CMILocation object2 : cmiWarp.getLocations()) {
                arrayList.add(CMIChatColor.translate((String)("&f" + CMILocation.toString((Location)object2))));
            }
            arrayList.add("");
            arrayList.add(LC.modify_ChangeHover.getLocale(new Object[0]));
            cMIGuiButton.addLore(arrayList);
            cMIGui.addButton(cMIGuiButton);
            if (!cmiWarp.getLocations().isEmpty()) {
                cMIGuiButton = new CMIGuiButton(warpEditorSlots.repeat.getSlot(), CMIMaterial.RAIL.newItemStack()){

                    public void click() {
                        cmiWarp.setRepeatingLocation(!cmiWarp.isRepeatingLocation());
                        WarpManager.this.plugin.getWarpManager().openWarpEditor(player, cmiWarp);
                        WarpManager.this.safeSave();
                    }
                };
                cMIGuiButton.setName(CMILC.getIM(editwarp.class, "uniqueLocation", "[state]", cmiWarp.isRepeatingLocation()));
                arrayList = new ArrayList();
                cMIGuiButton.addLore(arrayList);
                cMIGui.addButton(cMIGuiButton);
            }
        }
        cMIGuiButton = new CMIGuiButton(warpEditorSlots.group.getSlot(), CMIMaterial.BOOK.newItemStack()){

            public void click() {
                player.closeInventory();
                CMILC.info(editwarp.class, (CommandSender)player, "newGroup", new Object[0]);
                ChatMessageEdit chatMessageEdit = new ChatMessageEdit((CommandSender)player, cmiWarp.getGroup()){

                    public void run(String string) {
                        if (!CMIText.isValidString((String)(string = CMIChatColor.stripColor((String)CMIText.getFirstVariable((String)string))))) {
                            return;
                        }
                        if (string.contains(" ")) {
                            string = string.split(" ")[0];
                        }
                        cmiWarp.setGroup(string);
                        WarpManager.this.openWarpEditor(player, cmiWarp);
                        WarpManager.this.safeSave();
                    }

                    public void onCancel() {
                        WarpManager.this.openWarpEditor(player, cmiWarp);
                    }
                };
                chatMessageEdit.setCheckForCancel(true);
                chatMessageEdit.printMessage();
            }
        };
        cMIGuiButton.setName(CMILC.getIM(editwarp.class, "group", "[group]", cmiWarp.getGroup() == null ? "N/A" : cmiWarp.getGroup()));
        cMIGui.addButton(cMIGuiButton);
        cMIGuiButton = new CMIGuiButton(warpEditorSlots.displayName.getSlot(), CMIMaterial.ITEM_FRAME){

            public void click() {
                player.closeInventory();
                CMILC.info(editwarp.class, (CommandSender)player, "newDisplayName", new Object[0]);
                ChatMessageEdit chatMessageEdit = new ChatMessageEdit((CommandSender)player, cmiWarp.getDisplayName()){

                    public void run(String string) {
                        if (!CMIText.isValidString((String)string)) {
                            return;
                        }
                        if (!CMIChatColor.stripColor((String)string).equalsIgnoreCase(cmiWarp.getName()) && !PermissionsManager.CMIPerm.command_warp_diffdisplayname.hasPermission((CommandSender)player, true, new String[0])) {
                            WarpManager.this.openWarpEditor(player, cmiWarp);
                            return;
                        }
                        cmiWarp.setDisplayName(string);
                        WarpManager.this.openWarpEditor(player, cmiWarp);
                        WarpManager.this.safeSave();
                    }

                    public void onCancel() {
                        WarpManager.this.openWarpEditor(player, cmiWarp);
                    }
                };
                chatMessageEdit.setCheckForCancel(true);
                chatMessageEdit.printMessage();
            }
        };
        cMIGuiButton.setName(CMILC.getIM(editwarp.class, "displayName", "[displayName]", cmiWarp.getDisplayName() == null ? "N/A" : cmiWarp.getDisplayName()));
        cMIGui.addButton(cMIGuiButton);
        cMIGuiButton = new CMIGuiButton(warpEditorSlots.iconSlot.getSlot(), CMIMaterial.BROWN_WOOL.newItemStack()){

            public void click(GUIManager.GUIClickType gUIClickType) {
                int n = cmiWarp.getSlot() == null ? -1 : cmiWarp.getSlot();
                switch (gUIClickType) {
                    case Left: {
                        cmiWarp.setSlot(n + 1);
                        break;
                    }
                    case LeftShift: {
                        cmiWarp.setSlot(n + 10);
                        break;
                    }
                    case Right: {
                        cmiWarp.setSlot(n - 1);
                        break;
                    }
                    case RightShift: {
                        cmiWarp.setSlot(n - 10);
                        break;
                    }
                }
                WarpManager.this.safeSave();
                WarpManager.this.plugin.getWarpManager().openWarpEditor(player, cmiWarp);
            }
        };
        cMIGuiButton.setName(CMILC.getIM(editwarp.class, "slot", "[slot]", cmiWarp.getSlot() == null ? CMILC.getIM(editwarp.class, "notSet", new Object[0]) : Integer.valueOf(cmiWarp.getSlot() + 1)));
        List<CmiWarp> list2 = this.getWarps(cmiWarp.getPage(), cmiWarp.getSlot(), cmiWarp.getGroup());
        ArrayList<String> arrayList2 = new ArrayList();
        if (list2.size() > 1) {
            arrayList2.add(CMILC.getIM(editwarp.class, "overllaps", new Object[0]));
            for (CmiWarp cmiWarp2 : list2) {
                if (cmiWarp2.equals(cmiWarp)) continue;
                arrayList2.add("&7" + cmiWarp2.getName());
            }
            cMIGuiButton.addLore((List)arrayList2);
        }
        cMIGui.addButton(cMIGuiButton);
        cMIGuiButton = new CMIGuiButton(warpEditorSlots.page.getSlot(), CMIMaterial.PURPLE_WOOL.newItemStack()){

            public void click(GUIManager.GUIClickType gUIClickType) {
                int n = cmiWarp.getPage() == null ? -1 : cmiWarp.getPage();
                switch (gUIClickType) {
                    case Left: 
                    case LeftShift: {
                        cmiWarp.setPage(n + 1);
                        break;
                    }
                    case Right: 
                    case RightShift: {
                        cmiWarp.setPage(n - 1);
                        break;
                    }
                }
                WarpManager.this.safeSave();
                WarpManager.this.plugin.getWarpManager().openWarpEditor(player, cmiWarp);
            }
        };
        cMIGuiButton.setName(CMILC.getIM(editwarp.class, "page", "[page]", cmiWarp.getPage()));
        List<CmiWarp> list3 = this.getWarps(cmiWarp.getPage(), cmiWarp.getSlot(), cmiWarp.getGroup());
        arrayList2 = new ArrayList<String>();
        if (list3.size() > 1) {
            arrayList2.add(CMILC.getIM(editwarp.class, "overllaps", new Object[0]));
            for (CmiWarp cmiWarp2 : list3) {
                if (cmiWarp2.equals(cmiWarp)) continue;
                arrayList2.add("&7" + cmiWarp2.getName());
            }
            cMIGuiButton.addLore(arrayList2);
        }
        cMIGui.addButton(cMIGuiButton);
        cMIGui.fillEmptyButtons();
        cMIGui.open();
    }

    public List<CmiWarp> getWarps(int n, String string) {
        ArrayList<CmiWarp> arrayList = new ArrayList<CmiWarp>();
        for (Map.Entry<String, CmiWarp> entry : this.getWarps().entrySet()) {
            if (!entry.getValue().sameGroup(string) || entry.getValue().getPage() != n) continue;
            arrayList.add(entry.getValue());
        }
        return arrayList;
    }

    public int getPageCountFrom(int n, String string) {
        int n2 = n;
        for (Map.Entry<String, CmiWarp> entry : this.getWarps().entrySet()) {
            if (!entry.getValue().sameGroup(string) || entry.getValue().getPage() <= n2) continue;
            n2 = entry.getValue().getPage();
        }
        return n2 - n;
    }

    public int getPageCount(Player player) {
        return this.getPageCount(this.getWarps(player));
    }

    public int getPageCount(List<CmiWarp> list2) {
        int n = 1;
        for (CmiWarp cmiWarp : list2) {
            if (cmiWarp.getPage() == null || cmiWarp.getPage() <= n) continue;
            n = cmiWarp.getPage();
        }
        if (Math.ceil((double)list2.size() / 28.0) > (double)n) {
            n = (int)Math.ceil((double)list2.size() / 28.0);
        }
        return n;
    }

    public List<CmiWarp> getWarps(int n, Integer n2, String string) {
        ArrayList<CmiWarp> arrayList = new ArrayList<CmiWarp>();
        for (Map.Entry<String, CmiWarp> entry : this.getWarps().entrySet()) {
            if (!entry.getValue().sameGroup(string) || entry.getValue().getPage() != n || entry.getValue().getSlot() == null || n2 == null || entry.getValue().getSlot() != n2) continue;
            arrayList.add(entry.getValue());
        }
        return arrayList;
    }

    private static int slotToGUIrelativeSlot(int n) {
        return 9 + (n / 7 * 2 + 1) + n;
    }

    public CMIGui openComplexGUI(Player player, int n, String string) {
        HashMap<Integer, HashMap<Integer, CmiWarp>> hashMap = this.getPagedWarps(player, string, false, false);
        return this.openComplexGUI(player, n, hashMap);
    }

    public CMIGui openComplexGUI(final Player player, int n, final HashMap<Integer, HashMap<Integer, CmiWarp>> hashMap) {
        Map.Entry<Integer, CmiWarp> entry22;
        CMIGui cMIGui = new CMIGui(player){

            public void pageChange(int n) {
                WarpManager.this.openComplexGUI(player, n, hashMap);
            }
        };
        cMIGui.setOpenSound(CMISoundPreset.WarpGuiOpen.getSound());
        boolean bl = PermissionsManager.CMIPerm.command_$1.hasPermission((CommandSender)player, editwarp.class.getSimpleName());
        boolean bl2 = PermissionsManager.CMIPerm.command_$1_others.hasPermission((CommandSender)player, editwarp.class.getSimpleName());
        cMIGui.setInvSize(GUIManager.GUIRows.r6);
        CMIGuiButton cMIGuiButton = new CMIGuiButton(this.guiCloseButtonSlot, this.guiCloseButtonItem){

            public void click(GUIManager.GUIClickType gUIClickType) {
                Snd snd = new Snd();
                snd.setTarget(player);
                snd.setSender(player);
                snd.setSource(player);
                WarpManager.this.plugin.getSpecializedCommandManager().processCmds(WarpManager.this.plugin.getLM().updateSnd(snd, new ArrayList<String>(WarpManager.this.guiCloseButtonCommands)), player);
            }
        };
        cMIGuiButton.setName(CMILC.getIM(homes.class, "closeButton", new Object[0]));
        if (this.guiCloseButton.booleanValue()) {
            cMIGui.addButton(cMIGuiButton);
        }
        cMIGuiButton = new CMIGuiButton(this.guiInfoButtonSlot, this.guiInfoButtonItem){

            public void click(GUIManager.GUIClickType gUIClickType) {
                Snd snd = new Snd();
                snd.setTarget(player);
                snd.setSender(player);
                snd.setSource(player);
                WarpManager.this.plugin.getSpecializedCommandManager().processCmds(WarpManager.this.plugin.getLM().updateSnd(snd, new ArrayList<String>(WarpManager.this.guiInfoButtonCommands)), player);
            }
        };
        cMIGuiButton.setName(CMILC.getIM(homes.class, "infoButton", new Object[0]));
        if (this.guiInfoButton) {
            cMIGui.addButton(cMIGuiButton);
        }
        HashMap<Integer, CmiWarp> hashMap2 = hashMap.get(n);
        int n2 = 1;
        for (Map.Entry<Integer, HashMap<Integer, CmiWarp>> pageInfo2 : hashMap.entrySet()) {
            if (pageInfo2.getKey() <= n2) continue;
            n2 = pageInfo2.getKey();
        }
        PageInfo pageInfo = new PageInfo(1, n2, n);
        cMIGui.addPagination(pageInfo);
        cMIGui.fillInEdges();
        if (hashMap2 != null) {
            for (Map.Entry<Integer, CmiWarp> entry22 : hashMap2.entrySet()) {
                CmiWarp cmiWarp = entry22.getValue();
                if (cmiWarp.getLoc() == null || cmiWarp.getLoc().getWorld() == null) continue;
                Integer n3 = WarpManager.slotToGUIrelativeSlot(entry22.getKey());
                cMIGuiButton = new CMIGuiButton(n3, cmiWarp.getIcon());
                cMIGuiButton.hideItemFlags();
                if (cmiWarp.isReqPerm() && !PermissionsManager.CMIPerm.command_warp_$1.hasPermission((CommandSender)player, cmiWarp.getName().toLowerCase()) && cmiWarp.isShowUnavailable().booleanValue()) {
                    cMIGuiButton.setItem(cmiWarp.getOffIcon());
                }
                cMIGuiButton.addCommand(GUIManager.GUIClickType.Left, "cmi warp " + cmiWarp.getName());
                cMIGuiButton.addCommand(GUIManager.GUIClickType.Right, "cmi warp " + cmiWarp.getName());
                cMIGuiButton.addCommand(GUIManager.GUIClickType.MiddleMouse, "cmi editwarp " + cmiWarp.getName());
                cMIGuiButton.addCommand(GUIManager.GUIClickType.Q, "cmi editwarp " + cmiWarp.getName());
                if (bl && (cmiWarp.getCreator().equals(player.getUniqueId()) || bl2)) {
                    cMIGuiButton.addLore(" ");
                    cMIGuiButton.addLore(LC.modify_middlemouse.getLocale(new Object[0]));
                    cMIGuiButton.addLore(" ");
                    cMIGuiButton.addLore(CMILC.getIM(editwarp.class, "autoLore", "[state]", cmiWarp.isAutoLore()));
                    cMIGuiButton.addLore(CMILC.getIM(editwarp.class, "randomizeYaw", "[state]", cmiWarp.isRandomizeYaw()));
                    cMIGuiButton.addLore(CMILC.getIM(editwarp.class, "permission", "[state]", cmiWarp.isReqPerm()));
                    cMIGuiButton.addLore(CMILC.getIM(editwarp.class, "reqPermission", "[state]", cmiWarp.isShowUnavailable()));
                }
                cMIGui.addButton(cMIGuiButton, 44);
            }
        }
        cMIGui.addLock(GUIManager.InvType.Gui);
        entry22 = CMILC.getIM(warp.class, "guiTitle", new Object[0]);
        List<String> list2 = CMILC.getIML(warp.class, "pageTitles", new Object[0]);
        if (list2.size() >= n) {
            entry22 = (String)list2.get(n - 1);
        }
        cMIGui.setTitle(entry22);
        cMIGui.open();
        return cMIGui;
    }

    public CMIGui openGUI(Player player, int n, String string) {
        return this.openGUI(player, this.plugin.getWarpManager().getWarps(player, n, string, false), string);
    }

    public CMIGui openGUI(final Player player, List<CmiWarp> list2, final String string) {
        Object object;
        CmiWarp cmiWarp2;
        CMIGui cMIGui = new CMIGui(player){

            public void pageChange(int n) {
                WarpManager.this.openGUI(player, n, string);
            }
        };
        cMIGui.setOpenSound(CMISoundPreset.WarpGuiOpen.getSound());
        boolean bl = PermissionsManager.CMIPerm.command_$1.hasPermission((CommandSender)player, editwarp.class.getSimpleName());
        boolean bl2 = PermissionsManager.CMIPerm.command_$1_others.hasPermission((CommandSender)player, editwarp.class.getSimpleName());
        int n = 1;
        for (CmiWarp cmiWarp2 : list2) {
            if (cmiWarp2.getLoc() == null || cmiWarp2.getLoc().getWorld() == null || cmiWarp2.getSlot() != null && cmiWarp2.getSlot() >= 45) continue;
            if (cMIGui.getButtons().size() > 45) {
                cmiWarp2.setPage(cmiWarp2.getPage() + 1);
                continue;
            }
            object = new CMIGuiButton(cmiWarp2.getSlot(), cmiWarp2.getIcon());
            object.hideItemFlags();
            if (cmiWarp2.isReqPerm() && !PermissionsManager.CMIPerm.command_warp_$1.hasPermission((CommandSender)player, cmiWarp2.getName().toLowerCase()) && cmiWarp2.isShowUnavailable().booleanValue()) {
                object.setItem(cmiWarp2.getOffIcon());
            }
            object.addCommand(GUIManager.GUIClickType.Left, "cmi warp " + cmiWarp2.getName());
            object.addCommand(GUIManager.GUIClickType.Right, "cmi warp " + cmiWarp2.getName());
            object.addCommand(GUIManager.GUIClickType.MiddleMouse, "cmi editwarp " + cmiWarp2.getName());
            object.addCommand(GUIManager.GUIClickType.Q, "cmi editwarp " + cmiWarp2.getName());
            if (bl && (cmiWarp2.getCreator().equals(player.getUniqueId()) || bl2)) {
                object.addLore(" ");
                object.addLore(LC.modify_middlemouse.getLocale(new Object[0]));
                object.addLore(" ");
                object.addLore(CMILC.getIM(editwarp.class, "autoLore", "[state]", cmiWarp2.isAutoLore()));
                object.addLore(CMILC.getIM(editwarp.class, "randomizeYaw", "[state]", cmiWarp2.isRandomizeYaw()));
                object.addLore(CMILC.getIM(editwarp.class, "permission", "[state]", cmiWarp2.isReqPerm()));
                object.addLore(CMILC.getIM(editwarp.class, "reqPermission", "[state]", cmiWarp2.isShowUnavailable()));
            }
            n = cmiWarp2.getPage();
            cMIGui.addButton((CMIGuiButton)object, 45);
        }
        cMIGui.autoResize();
        cMIGui.addLock(GUIManager.InvType.Gui);
        cmiWarp2 = new PageInfo(1, this.getPageCountFrom(n, string) + n, n);
        cMIGui.addPagination((PageInfo)cmiWarp2);
        cMIGui.fillEmptyButtons();
        Object object2 = CMILC.getIM(warp.class, "guiTitle", new Object[0]);
        object = CMILC.getIML(warp.class, "pageTitles", new Object[0]);
        if (object.size() >= n) {
            object2 = (String)object.get(n - 1);
        }
        cMIGui.setTitle((String)object2);
        cMIGui.open();
        return cMIGui;
    }

    public void remove(CmiWarp cmiWarp) {
        this.warps.remove(cmiWarp.getName().toLowerCase());
        HashMap<String, CmiWarp> hashMap = this.userWarps.remove(cmiWarp.getCreator());
        if (hashMap != null) {
            hashMap.remove(cmiWarp.getName().toLowerCase());
            if (!hashMap.isEmpty()) {
                this.userWarps.put(cmiWarp.getCreator(), hashMap);
            }
        }
        this.safeSave();
    }

    public void addWarp(CmiWarp cmiWarp) {
        this.addWarp(cmiWarp, true);
    }

    public void addWarp(CmiWarp cmiWarp, boolean bl) {
        this.warps.put(cmiWarp.getName().toLowerCase(), cmiWarp);
        HashMap<String, CmiWarp> hashMap = this.userWarps.get(cmiWarp.getCreator());
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        hashMap.put(cmiWarp.getName().toLowerCase(), cmiWarp);
        this.userWarps.put(cmiWarp.getCreator(), hashMap);
        if (bl) {
            this.safeSave();
        }
    }

    public CmiWarp getWarp(Player player, String string) {
        if (string == null) {
            return null;
        }
        CmiWarp cmiWarp = this.warps.get(string.toLowerCase());
        if (cmiWarp != null) {
            if (cmiWarp.isReqPerm() && !PermissionsManager.CMIPerm.command_warp_$1.hasPermission((CommandSender)player, cmiWarp.getName().toLowerCase())) {
                return null;
            }
            return cmiWarp;
        }
        return null;
    }

    public CmiWarp getWarp(String string) {
        if (string == null) {
            return null;
        }
        return this.warps.get(string.toLowerCase());
    }

    public void loadConfig(ConfigReader configReader) {
        configReader.addComment("Warps.GUI", new String[]{"When set to true, warps list will be shown in GUI instead of chat list"});
        this.warpGUI = configReader.get("Warps.GUI", Boolean.valueOf(true));
        configReader.addComment("Warps.GUIOnCreation", new String[]{"Automatically opens GUI when created new warp point"});
        this.GUIOnCreation = configReader.get("Warps.GUIOnCreation", Boolean.valueOf(true));
        configReader.addComment("Warps.MinLength", new String[]{"Minimal length of warp name"});
        this.MinLength = configReader.get("Warps.MinLength", configReader.getC().getInt("Warps.MinLenght", 4));
        configReader.addComment("Warps.MaxLength", new String[]{"Maximal length of warp name"});
        this.MaxLength = configReader.get("Warps.MaxLength", configReader.getC().getInt("Warps.MaxLenght", 16));
        configReader.addComment("Warps.perPage", new String[]{"How many warps to show in each page"});
        this.warpPerPage = configReader.get("Warps.perPage", 50);
        configReader.addComment("Warps.showCreator", new String[]{"Do you want to show creator in warp list"});
        this.warpShowCreator = configReader.get("Warps.showCreator", Boolean.valueOf(false));
        configReader.addComment("Warps.requirePerm", new String[]{"When set to true, new warps by default will require permission node to use them"});
        this.warpRequirePerm = configReader.get("Warps.requirePerm", Boolean.valueOf(false));
        String string = "Warps.Complex.CloseButton.";
        this.guiCloseButton = configReader.get(string + "Use", Boolean.valueOf(true));
        this.guiCloseButtonSlot = configReader.get(string + "Slot", 9) - 1;
        this.guiCloseButtonItem = CMILib.getInstance().getItemManager().getItem(configReader.get(string + "Material", "head:eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNmNjYmY5ODgzZGQzNTlmZGYyMzg1YzkwYTQ1OWQ3Mzc3NjUzODJlYzQxMTdiMDQ4OTVhYzRkYzRiNjBmYyJ9fX0="));
        this.guiCloseButtonCommands = configReader.get(string + "Commands", Arrays.asList("closeinv!"));
        string = "Warps.Complex.InfoButton.";
        configReader.addComment(string + "Use", new String[]{"Extra button to be used in case you want to provide any aditional information when clicking on it"});
        this.guiInfoButton = configReader.get(string + "Use", Boolean.valueOf(false));
        this.guiInfoButtonSlot = configReader.get(string + "Slot", 1) - 1;
        this.guiInfoButtonItem = CMILib.getInstance().getItemManager().getItem(configReader.get(string + "Material", "head:eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNDZiYTYzMzQ0ZjQ5ZGQxYzRmNTQ4OGU5MjZiZjNkOWUyYjI5OTE2YTZjNTBkNjEwYmI0MGE1MjczZGM4YzgyIn19fQ=="));
        this.guiInfoButtonCommands = configReader.get(string + "Commands", Arrays.asList("closeinv!"));
    }

    public boolean isWarpGUI() {
        return this.warpGUI;
    }

    public void load() {
        this.onDisable();
        CMI.getInstance().safeRenameFile(this.fileName.toLowerCase(), "Saves" + File.separator + this.fileName);
        Long l = System.currentTimeMillis();
        File file = new File(this.plugin.getDataFolder(), "Saves" + File.separator + this.fileName);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
        }
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        if (yamlConfiguration.getKeys(false).isEmpty()) {
            return;
        }
        this.warps.clear();
        Map map = yamlConfiguration.getValues(false);
        for (Map.Entry entry : map.entrySet()) {
            CmiWarp cmiWarp;
            block46: {
                cmiWarp = this.getWarp((String)entry.getKey());
                if (cmiWarp == null) {
                    cmiWarp = new CmiWarp((String)entry.getKey());
                } else {
                    cmiWarp.reset();
                }
                try {
                    ItemStack itemStack;
                    Object object;
                    Map map2 = yamlConfiguration.getConfigurationSection((String)entry.getKey()).getValues(false);
                    if (map2.containsKey("ReqPerm")) {
                        cmiWarp.setReqPerm((Boolean)map2.get("ReqPerm"));
                    }
                    if (map2.containsKey("ShowWithNoPerm")) {
                        cmiWarp.setShowUnavailable((boolean)((Boolean)map2.get("ShowWithNoPerm")));
                    }
                    if (map2.containsKey("HideFromList")) {
                        cmiWarp.setHidden((Boolean)map2.get("HideFromList"));
                    }
                    if (map2.containsKey("AutoLore")) {
                        cmiWarp.setAutoLore((boolean)((Boolean)map2.get("AutoLore")));
                    }
                    if (map2.containsKey("RandYaw")) {
                        cmiWarp.setRandomizeYaw((Boolean)map2.get("RandYaw"));
                    }
                    try {
                        if (map2.containsKey("Slot")) {
                            cmiWarp.setSlot((Integer)map2.get("Slot"));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        cmiWarp.setSlot((Integer)map2.get("Slots") - 1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (map2.containsKey("Page")) {
                        try {
                            cmiWarp.setPage((Integer)map2.get("Page"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (map2.containsKey("Group")) {
                        cmiWarp.setGroup((String)map2.get("Group"));
                    }
                    if (map2.containsKey("DisName")) {
                        cmiWarp.setDisplayName((String)map2.get("DisName"));
                    }
                    try {
                        if (map2.containsKey("Creator")) {
                            if (map2.get("Creator") instanceof UUID) {
                                cmiWarp.setCreator((UUID)map2.get("Creator"));
                            } else if (((String)map2.get("Creator")).length() == 36) {
                                object = this.plugin.getPlayerManager().getUser(UUID.fromString((String)map2.get("Creator")));
                                if (object != null) {
                                    cmiWarp.setCreator(((CMIUser)object).getUniqueId());
                                } else {
                                    cmiWarp.setCreator(UUID.fromString((String)map2.get("Creator")));
                                }
                            } else {
                                object = this.plugin.getPlayerManager().getUser((String)map2.get("Creator"));
                                if (object == null) {
                                    cmiWarp.setCreator(this.plugin.getServerUUID());
                                } else {
                                    cmiWarp.setCreator(((CMIUser)object).getUniqueId());
                                }
                            }
                        } else {
                            cmiWarp.setCreator(this.plugin.getServerUUID());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    object = null;
                    if (yamlConfiguration.isConfigurationSection(cmiWarp.getName() + ".Location")) {
                        object = this.plugin.getPlayerManager().getLoc(yamlConfiguration, cmiWarp.getName() + ".Location.");
                    } else if (yamlConfiguration.isString(cmiWarp.getName() + ".Location")) {
                        object = this.plugin.getPlayerManager().convertStringToLocation(yamlConfiguration.getString(cmiWarp.getName() + ".Location"));
                    }
                    if (object == null) continue;
                    if (yamlConfiguration.isList(cmiWarp.getName() + ".sLocs")) {
                        cmiWarp.setLocations(CMILocation.fromString((List)yamlConfiguration.getStringList(cmiWarp.getName() + ".sLocs")));
                    }
                    if (yamlConfiguration.isBoolean(cmiWarp.getName() + ".Repeat")) {
                        cmiWarp.setRepeatingLocation((Boolean)map2.get("HideFromList"));
                    }
                    cmiWarp.setLoc((CMILocation)object);
                    if (map2.containsKey("Item")) {
                        try {
                            itemStack = ItemStack.deserialize((Map)yamlConfiguration.getConfigurationSection((String)entry.getKey() + ".Item").getValues(true));
                            cmiWarp.setItem(itemStack);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!map2.containsKey("OffItem")) break block46;
                    try {
                        itemStack = ItemStack.deserialize((Map)yamlConfiguration.getConfigurationSection((String)entry.getKey() + ".OffItem").getValues(true));
                        cmiWarp.setOffItem(itemStack);
                    }
                    catch (Exception exception) {}
                }
                catch (Exception exception) {
                    CMIMessages.sendMessage((CommandSender)Bukkit.getConsoleSender(), (String)("Cant load warp (" + (String)entry.getKey() + ")"));
                    exception.printStackTrace();
                    continue;
                }
            }
            this.addWarp(cmiWarp, false);
        }
        this.plugin.loadMessage(this.warps.size(), "warps", System.currentTimeMillis() - l);
    }

    public void safeSave() {
        if (this.saveId != null) {
            return;
        }
        this.saveId = CMIScheduler.runTaskLater(() -> {
            this.asyncSave();
            this.saveId = null;
        }, (long)20L);
    }

    public void asyncSave() {
        if (this.saving) {
            return;
        }
        CMIScheduler.runTaskAsynchronously(() -> {
            this.saving = true;
            this.save();
            this.saving = false;
        });
    }

    public void save() {
        try {
            File file = new File(this.plugin.getDataFolder(), "Saves" + File.separator + this.fileName);
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return;
            }
            try {
                YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
                for (String object : yamlConfiguration.getKeys(false)) {
                    yamlConfiguration.set(object, null);
                }
                for (Map.Entry entry : new HashMap<String, CmiWarp>(this.warps).entrySet()) {
                    try {
                        Map map;
                        String string = ((CmiWarp)entry.getValue()).getName().replace(".", "_");
                        CmiWarp cmiWarp = (CmiWarp)entry.getValue();
                        yamlConfiguration.set(string + ".Location", (Object)this.plugin.getPlayerManager().convertLocToString(cmiWarp.getLoc()));
                        if (cmiWarp.hasSecondaryLocations()) {
                            yamlConfiguration.set(string + ".sLocs", (Object)CMILocation.toString(cmiWarp.getLocations()));
                        }
                        if (cmiWarp.isRepeatingLocation()) {
                            yamlConfiguration.set(string + ".Repeat", (Object)cmiWarp.isRepeatingLocation());
                        }
                        if (cmiWarp.getGroup() != null) {
                            yamlConfiguration.set(string + ".Group", (Object)cmiWarp.getGroup());
                        }
                        if (cmiWarp.getDisplayName() != null) {
                            yamlConfiguration.set(string + ".DisName", (Object)cmiWarp.getDisplayName());
                        }
                        if (cmiWarp.isReqPerm()) {
                            yamlConfiguration.set(string + ".ReqPerm", (Object)cmiWarp.isReqPerm());
                        }
                        if (cmiWarp.isShowUnavailable().booleanValue()) {
                            yamlConfiguration.set(string + ".ShowWithNoPerm", (Object)cmiWarp.isShowUnavailable());
                        }
                        if (cmiWarp.isHidden()) {
                            yamlConfiguration.set(string + ".HideFromList", (Object)cmiWarp.isHidden());
                        }
                        if (!cmiWarp.isAutoLore().booleanValue()) {
                            yamlConfiguration.set(string + ".AutoLore", (Object)cmiWarp.isAutoLore());
                        }
                        if (cmiWarp.isRandomizeYaw()) {
                            yamlConfiguration.set(string + ".RandYaw", (Object)cmiWarp.isRandomizeYaw());
                        }
                        yamlConfiguration.set(string + ".Slots", cmiWarp.getSlot() == null ? null : Integer.valueOf(cmiWarp.getSlot() + 1));
                        yamlConfiguration.set(string + ".Page", (Object)(cmiWarp.getPage() == 1 ? null : cmiWarp.getPage()));
                        yamlConfiguration.set(string + ".Creator", cmiWarp.getCreator() == null || cmiWarp.getCreator().equals(this.plugin.getServerUUID()) ? null : cmiWarp.getCreator().toString());
                        yamlConfiguration.set(string + ".Item", null);
                        if (cmiWarp.getItem() != null) {
                            map = cmiWarp.getItem().serialize();
                            yamlConfiguration.set(string + ".Item", (Object)map);
                        }
                        yamlConfiguration.set(string + ".OffItem", null);
                        if (cmiWarp.getOffItem() == null) continue;
                        map = cmiWarp.getOffItem().serialize();
                        yamlConfiguration.set(string + ".OffItem", (Object)map);
                    }
                    catch (Throwable throwable) {
                        this.plugin.consoleMessage("&cFailed to save " + ((CmiWarp)entry.getValue()).getName() + " warp into file");
                        throwable.printStackTrace();
                    }
                }
                try {
                    yamlConfiguration.save(file);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                this.saving = false;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        finally {
            this.saving = false;
        }
    }

    public int getWarpPerPage() {
        return this.warpPerPage;
    }

    public boolean isWarpShowCreator() {
        return this.warpShowCreator;
    }

    public boolean isGUIOnCreation() {
        return this.GUIOnCreation;
    }

    public int getMinLength() {
        return this.MinLength;
    }

    public void setMinLenght(int n) {
        this.MinLength = n;
    }

    public int getMaxLength() {
        return this.MaxLength;
    }

    public void setMaxLenght(int n) {
        this.MaxLength = n;
    }

    public boolean isWarpRequirePerm() {
        return this.warpRequirePerm;
    }

    private static enum warpEditorSlots {
        icon(10),
        offIcon(19),
        randomYaw(20),
        autoLore(11),
        permission(13),
        reqPermission(22),
        hidden(32),
        group(25),
        displayName(34),
        iconSlot(14),
        page(23),
        back(8),
        location(37),
        seclocation(38),
        repeat(39);

        private int slot;

        private warpEditorSlots(int n2) {
            this.slot = n2;
        }

        public int getSlot() {
            return this.slot;
        }

        public void setSlot(int n) {
            this.slot = n;
        }
    }
}

