/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Worlds;

import com.Zrips.CMI.Modules.Worlds.CMIBiome;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.World;
import org.bukkit.block.Biome;

public class CMIChunk {
    private Integer x;
    private Integer z;
    private World world;
    private boolean generated = false;
    private Color color = null;
    private Color mostCommonColor = null;
    private List<CMIBiome> biomes = new ArrayList<CMIBiome>();

    public CMIChunk(Chunk chunk) {
        this(chunk.getWorld(), chunk.getX(), chunk.getZ());
        this.setGenerated(true);
        this.recheckBiomes(chunk);
    }

    public CMIChunk(World world2, int n, int n2) {
        this.x = n;
        this.z = n2;
        this.world = world2;
    }

    public int getRelativeX() {
        return this.x - (this.x >> 5) * 32;
    }

    public int getRelativeZ() {
        return this.z - (this.z >> 5) * 32;
    }

    public Integer getPlace() {
        return this.getRelativeX() + this.getRelativeZ() * 32;
    }

    private static Integer convertBiomePlace(int n, int n2) {
        return n + n2 * 16;
    }

    public Integer getX() {
        return this.x;
    }

    public Integer getZ() {
        return this.z;
    }

    public CMIChunk recheckBiomes(Chunk chunk) {
        this.biomes.clear();
        ChunkSnapshot chunkSnapshot = chunk.getChunkSnapshot(false, true, false);
        if (chunkSnapshot != null) {
            int n = 0;
            while (n < 16) {
                int n2 = 0;
                while (n2 < 16) {
                    Biome biome = chunkSnapshot.getBiome(n, n2);
                    this.biomes.add(CMIBiome.getByName(biome.name()));
                    n2 += 15;
                }
                n += 15;
            }
        }
        return this;
    }

    public CMIChunk recheckBiomes() {
        this.biomes.clear();
        ChunkSnapshot chunkSnapshot = this.getEmptyChunkSnapshot();
        if (chunkSnapshot != null) {
            int n = 4;
            while (n < 16) {
                int n2 = 4;
                while (n2 < 16) {
                    Biome biome = chunkSnapshot.getBiome(n, n2);
                    this.biomes.add(CMIBiome.getByName(biome.name()));
                    n2 += 8;
                }
                n += 8;
            }
        }
        return this;
    }

    public World getWorld() {
        return this.world;
    }

    public ChunkSnapshot getEmptyChunkSnapshot() {
        return this.world.getEmptyChunkSnapshot(this.x.intValue(), this.z.intValue(), true, false);
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public CMIChunk setGenerated(boolean bl) {
        this.generated = bl;
        return this;
    }

    public Chunk getChunk() {
        return this.getWorld().getChunkAt(this.x.intValue(), this.z.intValue());
    }

    public CMIBiome getBiome() {
        Iterator<CMIBiome> iterator = this.biomes.iterator();
        if (iterator.hasNext()) {
            CMIBiome cMIBiome = iterator.next();
            return cMIBiome;
        }
        return CMIBiome.PLAINS;
    }

    public List<CMIBiome> getBiomes() {
        return this.biomes;
    }

    public String getBiomeColorCodes() {
        Object object = "";
        String string = "";
        for (CMIBiome cMIBiome : this.biomes) {
            object = (String)object + cMIBiome.getId();
        }
        int n = 0;
        while (n < this.biomes.size()) {
            if (((String)object).endsWith(string) && ((String)object).substring(0, ((String)object).length() - string.length()).endsWith(string)) {
                object = ((String)object).substring(0, ((String)object).length() - string.length());
            }
            ++n;
        }
        return object;
    }

    public Color getUnbluredColor() {
        if (this.mostCommonColor == null) {
            HashMap<CMIBiome, Integer> hashMap = new HashMap<CMIBiome, Integer>();
            int n = 0;
            CMIBiome cMIBiome = null;
            for (CMIBiome cMIBiome2 : this.biomes) {
                if (hashMap.containsKey((Object)cMIBiome2)) {
                    hashMap.put(cMIBiome2, (Integer)hashMap.get((Object)cMIBiome2) + 1);
                    if (n >= (Integer)hashMap.get((Object)cMIBiome2)) continue;
                    n = (Integer)hashMap.get((Object)cMIBiome2);
                    cMIBiome = cMIBiome2;
                    continue;
                }
                hashMap.put(cMIBiome2, 1);
                if (n >= (Integer)hashMap.get((Object)cMIBiome2)) continue;
                n = (Integer)hashMap.get((Object)cMIBiome2);
                cMIBiome = cMIBiome2;
            }
            if (cMIBiome == null) {
                return CMIBiome.PLAINS.getColor();
            }
            this.mostCommonColor = cMIBiome.getColor();
        }
        return this.mostCommonColor;
    }

    public Color getColor() {
        if (this.color == null) {
            Color color = null;
            for (CMIBiome cMIBiome : this.biomes) {
                color = color == null ? cMIBiome.getColor() : CMIChunk.blend(color, cMIBiome.getColor());
            }
            this.color = color;
        }
        if (this.color == null) {
            return this.getBiome() == null ? null : this.getBiome().getColor();
        }
        return this.color;
    }

    private static Color blend(Color color, Color color2) {
        double d = color.getAlpha() + color2.getAlpha();
        double d2 = (double)color.getAlpha() / d;
        double d3 = (double)color2.getAlpha() / d;
        double d4 = d2 * (double)color.getRed() + d3 * (double)color2.getRed();
        double d5 = d2 * (double)color.getGreen() + d3 * (double)color2.getGreen();
        double d6 = d2 * (double)color.getBlue() + d3 * (double)color2.getBlue();
        double d7 = Math.max(color.getAlpha(), color2.getAlpha());
        return new Color((int)d4, (int)d5, (int)d6, (int)d7);
    }

    public void setBiomes(List<CMIBiome> list2) {
        this.biomes = new ArrayList<CMIBiome>(list2);
    }
}

