/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.commands.list;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Containers.Snd;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.PlayTime.CMIPlayTimeFormat;
import com.Zrips.CMI.Modules.Statistics.StatsManager;
import com.Zrips.CMI.commands.CAnnotation;
import com.Zrips.CMI.commands.Cmd;
import com.Zrips.CMI.commands.CommandsHandler;
import java.util.Map;
import java.util.SortedMap;
import net.Zrips.CMILib.Container.PageInfo;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class playtimetop
implements Cmd {
    @Override
    public void getExtra(ConfigReader configReader) {
        configReader.get("topLine", "&e----- TopPlaytime &e-----");
        configReader.get("scanning", "&eData is being scanned currently, please wait a minute and try again");
        configReader.get("loading", "&eData is not loaded yet. Scan process will start and you will get result after its finished");
        configReader.get("list", "&e[number]. [playerDisplayName] &e- &6[time]");
        configReader.get("place", "&6[playerDisplayName] &eis in &6[place] &eplace");
        configReader.get("ownLine", "&2[number]. &2[playerDisplayName] &2- &2[time]");
    }

    @Override
    @CAnnotation(priority=110, info="&eShows top list of player total play time", args="[page]", tab={}, explanation={}, regVar={0, 1}, consoleVar={0, 1}, others=false)
    public Boolean perform(CMI cMI, CommandSender commandSender, String[] stringArray) {
        StatsManager statsManager = cMI.getStatsManager();
        int n = 1;
        CMIUser cMIUser = null;
        if (stringArray.length > 0) {
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (Exception exception) {
                cMIUser = cMI.getPlayerManager().getUser(stringArray[0]);
            }
        }
        if (statsManager.isScanning()) {
            CMILC.info((Object)this, commandSender, "scanning", new Object[0]);
            return null;
        }
        if (!statsManager.isDataLoaded()) {
            CMILC.info((Object)this, commandSender, "loading", new Object[0]);
            String string = null;
            if (cMIUser != null) {
                string = cMIUser.getName();
            }
            statsManager.loadStats(commandSender, string);
            return true;
        }
        if (cMIUser != null) {
            Snd snd = new Snd().setSender(commandSender).setTarget(cMIUser);
            int n2 = statsManager.getPlace(cMIUser);
            CMILC.info((Object)this, commandSender, "place", "[place]", n2, snd);
            return true;
        }
        if (n < 1) {
            n = 1;
        }
        SortedMap<Long, CMIUser> sortedMap = cMI.getStatsManager().getTop();
        PageInfo pageInfo = new PageInfo(10, cMI.getStatsManager().getTotalCount(), n);
        int n3 = 0;
        cMIUser = cMI.getUser(commandSender, null, this, commandSender instanceof Player, true);
        CMILC.info((Object)this, commandSender, "topLine", new Object[0]);
        if (cMIUser != null) {
            for (Map.Entry<Long, CMIUser> object2 : sortedMap.entrySet()) {
                ++n3;
                if (cMIUser.getUniqueId().equals(object2.getValue().getUniqueId())) break;
            }
            if (pageInfo.getStart() >= n3) {
                Snd snd = new Snd().setSender(commandSender).setTarget(cMIUser);
                CMILC.info((Object)this, commandSender, "ownLine", "[number]", n3, snd, "[time]", CMIPlayTimeFormat.formatPlaytimePlaceholder(cMIUser.getTotalPlayTime()));
            }
        }
        for (Map.Entry<Long, CMIUser> entry : sortedMap.entrySet()) {
            if (pageInfo.isBreak()) break;
            if (!pageInfo.isEntryOk() || entry.getValue() == null || entry.getValue().getName(false) == null) continue;
            Snd snd = new Snd().setSender(commandSender).setTarget(entry.getValue());
            String string = CMIPlayTimeFormat.formatPlaytimePlaceholder(entry.getKey());
            if (cMIUser != null && entry.getValue().getName(false).equals(cMIUser.getName(false))) {
                CMILC.info((Object)this, commandSender, "ownLine", "[number]", pageInfo.getPositionForOutput(), snd, "[time]", CMIPlayTimeFormat.formatPlaytimePlaceholder(entry.getValue().getTotalPlayTime()));
                continue;
            }
            CMILC.info((Object)this, commandSender, "list", "[number]", pageInfo.getPositionForOutput(), "[time]", string, snd);
        }
        if (cMIUser != null && pageInfo.getEnd() + 1 < n3) {
            Snd snd = new Snd().setSender(commandSender).setTarget(cMIUser);
            CMILC.info((Object)this, commandSender, "ownLine", "[number]", n3, snd, "[time]", CMIPlayTimeFormat.formatPlaytimePlaceholder(cMIUser.getTotalPlayTime()));
        }
        pageInfo.autoPagination(commandSender, CommandsHandler.getLabel() + " " + this.getClass().getSimpleName());
        return true;
    }
}

