/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Containers;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.BlockStateType;
import com.Zrips.CMI.Modules.Portals.CuboidArea;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.Zrips.CMILib.Container.CMINumber;
import net.Zrips.CMILib.Container.CMIWorld;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.type.Snow;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class CMIHitBox {
    private Vector max;
    private Vector min;
    private Block block;
    private Entity ent;
    private World world;
    private ChunkSnapshot snapshot;
    static Method getBlockTypeId = null;

    CMIHitBox(World world2, Vector vector, Vector vector2) {
        this.world = world2;
        this.max = vector2;
        this.min = vector;
    }

    public CMIHitBox(Block block) {
        this.block = block;
        this.world = block.getWorld();
        CMI.getInstance().getNMS().getBlockHitBox(this);
    }

    public CMIHitBox(Entity entity) {
        this.ent = entity;
        if (entity != null) {
            this.world = entity.getWorld();
            CMI.getInstance().getNMS().getEntityHitBox(this);
        }
    }

    public Vector getMax() {
        if (this.max == null) {
            this.max = new Vector(0, 0, 0);
        }
        return this.max;
    }

    public Location getCenterLocation() {
        return new Location(this.world, this.getMinGlobal().getX() + (this.getMaxGlobal().getX() - this.getMinGlobal().getX()) / 2.0, this.getMinGlobal().getY(), this.getMinGlobal().getZ() + (this.getMaxGlobal().getZ() - this.getMinGlobal().getZ()) / 2.0);
    }

    public Double getHeightAtLocation(Location location) {
        double d = 0.0;
        double d2 = 0.01;
        double d3 = location.getBlockY();
        while (d3 <= (double)(location.getBlockY() + 1)) {
            location.setY(d3);
            if (this.isEmptySpace(location)) {
                d = d3 - (double)location.getBlockY();
                break;
            }
            d3 += d2;
        }
        d = (double)((int)(d * 10000.0)) / 10000.0;
        CMIMaterial cMIMaterial = null;
        if (this.getSnapshot() != null) {
            int n = this.getSnapshot().getHighestBlockYAt(location.getBlockX() & 0xF, location.getBlockZ() & 0xF);
            n = CMIWorld.getMinHeight((World)location.getWorld()) > n ? CMIWorld.getMinHeight((World)location.getWorld()) : n;
            int n2 = CMINumber.clamp((int)location.getBlockY(), (int)CMIWorld.getMinHeight((World)location.getWorld()), (int)n);
            cMIMaterial = this.getBlockType(location.getBlockX() & 0xF, n2, location.getBlockZ() & 0xF);
        } else {
            cMIMaterial = CMIMaterial.get((Block)location.getBlock());
        }
        if (d <= d2) {
            CMIHitBox cMIHitBox;
            if (cMIMaterial.equals((Object)CMIMaterial.SNOW)) {
                try {
                    d = (double)(((Snow)location.getBlock().getBlockData()).getLayers() - 1) * 0.125;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (d <= d2 && d < (cMIHitBox = new CMIHitBox(location.getBlock())).getMax().getY() - cMIHitBox.getMin().getY()) {
                d = cMIHitBox.getMax().getY() - cMIHitBox.getMin().getY();
            }
        }
        return d;
    }

    public Vector getMaxGlobal() {
        if (this.block != null) {
            Location location = this.block.getLocation();
            return new Vector(location.getX() + this.getMax().getX(), location.getY() + this.getMax().getY(), location.getZ() + this.getMax().getZ());
        }
        if (this.ent != null) {
            return new Vector(this.getMax().getX() - 0.01, this.getMax().getY() - 0.01, this.getMax().getZ() - 0.01);
        }
        return new Vector(this.getMax().getX(), this.getMax().getY(), this.getMax().getZ());
    }

    public Vector getMin() {
        if (this.min == null) {
            this.min = new Vector(1, 1, 1);
        }
        return this.min;
    }

    public double getHitBoxHeight() {
        return Math.abs(this.getMax().getY() - this.getMin().getY());
    }

    public double getHitBoxWidth() {
        return Math.abs(this.getMax().getX() - this.getMin().getX());
    }

    public double getHitBoxLength() {
        return Math.abs(this.getMax().getZ() - this.getMin().getZ());
    }

    public Vector getMinGlobal() {
        if (this.block != null) {
            Location location = this.block.getLocation();
            return new Vector(location.getX() + this.getMin().getX(), location.getY() + this.getMin().getY(), location.getZ() + this.getMin().getZ());
        }
        if (this.ent != null) {
            return new Vector(this.getMin().getX() + 0.01, this.getMin().getY() + 0.01, this.getMin().getZ() + 0.01);
        }
        return new Vector(this.getMin().getX(), this.getMin().getY(), this.getMin().getZ());
    }

    public void byExactXYZ(double d, double d2, double d3) {
        this.byExactXYZ(d, d2, d3, 0.2);
    }

    private static HashMap<BlockStateType, String> getBlockStates(Block block) {
        HashMap<BlockStateType, String> hashMap = new HashMap<BlockStateType, String>();
        if (!Version.isCurrentEqualOrHigher((Version)Version.v1_13_R1)) {
            return hashMap;
        }
        try {
            String string = block.getBlockData().getAsString();
            if (string.contains("[")) {
                String string2 = string.split("\\[", 2)[1];
                string2 = string2.substring(0, string2.length() - 1);
                String[] stringArray = string2.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string3 = stringArray[n2];
                    String[] stringArray2 = string3.split("=", 2);
                    BlockStateType blockStateType = BlockStateType.getByName(stringArray2[0]);
                    if (blockStateType != null) {
                        hashMap.put(blockStateType, stringArray2[1]);
                    }
                    ++n2;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return hashMap;
    }

    public boolean byExactXYZ(double d, double d2, double d3, double d4) {
        block45: {
            boolean bl;
            String string;
            block46: {
                if (d < 0.0) {
                    d += 1.0;
                }
                if (d3 < 0.0) {
                    d3 += 1.0;
                }
                if (!CMIMaterial.isStairs((Material)this.block.getType())) break block45;
                HashMap<BlockStateType, String> hashMap = CMIHitBox.getBlockStates(this.block);
                String string2 = hashMap.get((Object)BlockStateType.facing);
                string = hashMap.get((Object)BlockStateType.half);
                String string3 = hashMap.get((Object)BlockStateType.shape);
                bl = false;
                if (string2 == null) break block46;
                switch (string2.toLowerCase()) {
                    case "west": {
                        if (d > 1.0 - d4 && string3 != null && string3.equalsIgnoreCase("straight")) {
                            bl = true;
                        }
                        if (string3 == null) break;
                        if (string3.equalsIgnoreCase("outer_left")) {
                            if (!(d > 1.0 - d4) && !(d3 <= d4)) break;
                            bl = true;
                            break;
                        }
                        if (string3.equalsIgnoreCase("outer_right")) {
                            if (!(d > 1.0 - d4) && !(d3 > 1.0 - d4)) break;
                            bl = true;
                            break;
                        }
                        if (string3.equalsIgnoreCase("inner_right")) {
                            if (!(d > 1.0 - d4) || !(d3 > 1.0 - d4)) break;
                            bl = true;
                            break;
                        }
                        if (!string3.equalsIgnoreCase("inner_left") || !(d > 1.0 - d4) || !(d3 <= d4)) break;
                        bl = true;
                        break;
                    }
                    case "north": {
                        if (d3 > 1.0 - d4 && string3 != null && string3.equalsIgnoreCase("straight")) {
                            bl = true;
                        }
                        if (string3 == null) break;
                        if (string3.equalsIgnoreCase("outer_left")) {
                            if (!(d3 > 1.0 - d4) && !(d > 1.0 - d4)) break;
                            bl = true;
                            break;
                        }
                        if (string3.equalsIgnoreCase("outer_right")) {
                            if (!(d3 > 1.0 - d4) && !(d <= d4)) break;
                            bl = true;
                            break;
                        }
                        if (string3.equalsIgnoreCase("inner_right")) {
                            if (!(d3 > 1.0 - d4) || !(d <= d4)) break;
                            bl = true;
                            break;
                        }
                        if (!string3.equalsIgnoreCase("inner_left") || !(d3 > 1.0 - d4) || !(d > 1.0 - d4)) break;
                        bl = true;
                        break;
                    }
                    case "south": {
                        if (d3 < d4 && string3 != null && string3.equalsIgnoreCase("straight")) {
                            bl = true;
                        }
                        if (string3 == null) break;
                        if (string3.equalsIgnoreCase("outer_left")) {
                            if (!(d3 < d4) && !(d < d4)) break;
                            bl = true;
                            break;
                        }
                        if (string3.equalsIgnoreCase("outer_right")) {
                            if (!(d3 < d4) && !(d > 1.0 - d4)) break;
                            bl = true;
                            break;
                        }
                        if (string3.equalsIgnoreCase("inner_right")) {
                            if (!(d3 < d4) || !(d > 1.0 - d4)) break;
                            bl = true;
                            break;
                        }
                        if (!string3.equalsIgnoreCase("inner_left") || !(d3 < d4) || !(d < d4)) break;
                        bl = true;
                        break;
                    }
                    case "east": {
                        if (d <= d4 && string3 != null && string3.equalsIgnoreCase("straight")) {
                            bl = true;
                        }
                        if (string3 == null) break;
                        if (string3.equalsIgnoreCase("outer_left")) {
                            if (!(d <= d4) && !(d3 > 1.0 - d4)) break;
                            bl = true;
                            break;
                        }
                        if (string3.equalsIgnoreCase("outer_right")) {
                            if (!(d <= d4) && !(d3 <= d4)) break;
                            bl = true;
                            break;
                        }
                        if (string3.equalsIgnoreCase("inner_right")) {
                            if (!(d <= d4) || !(d3 <= d4)) break;
                            bl = true;
                            break;
                        }
                        if (!string3.equalsIgnoreCase("inner_left") || !(d <= d4) || !(d3 > 1.0 - d4)) break;
                        bl = true;
                    }
                }
            }
            if (bl && string != null) {
                if (string.equalsIgnoreCase("bottom")) {
                    this.max = new Vector(this.max.getX(), 0.5, this.max.getZ());
                } else {
                    this.min = new Vector(this.min.getX(), 0.5, this.min.getZ());
                }
            }
            return true;
        }
        if (CMIMaterial.isFence((Material)this.block.getType()) || CMIMaterial.isGlassPane((Material)this.block.getType()) || CMIMaterial.IRON_BARS.equals(this.block.getType()) || CMIMaterial.isWall((Material)this.block.getType())) {
            double d5 = 0.0625;
            if (CMIMaterial.isFence((Material)this.block.getType())) {
                d5 = 0.125;
            }
            if (CMIMaterial.isWall((Material)this.block.getType())) {
                d5 = 0.25;
            }
            if (d > 0.5 + d5 + (d4 = 0.5 - d4) && d3 > 0.5 + d5 + d4 || d < 0.5 - d5 - d4 && d3 > 0.5 + d5 + d4 || d > 0.5 + d5 + d4 && d3 < 0.5 - d5 - d4 || d < 0.5 - d5 - d4 && d3 < 0.5 - d5 - d4) {
                this.min = new Vector(0.5 - d5, 0.0, 0.5 - d5);
                this.max = new Vector(0.5 + d5, 1.0, 0.5 + d5);
            }
            return true;
        }
        if (CMIMaterial.HOPPER.equals(this.block.getType())) {
            if (!(d2 > 0.25 || d > 0.35 && d < 0.65 && d3 > 0.35 && d3 < 0.65)) {
                this.min = new Vector(1.0, 0.9, 1.0);
                this.max = new Vector(1, 1, 1);
            } else if (!(d2 > 0.6 || d > 0.25 && d < 0.75 && d3 > 0.25 && d3 < 0.75)) {
                this.min = new Vector(1.0, 0.9, 1.0);
                this.max = new Vector(1, 1, 1);
            }
            return true;
        }
        return false;
    }

    private boolean checkBlock(Block block, boolean bl) {
        CMIMaterial cMIMaterial = null;
        cMIMaterial = this.getSnapshot() != null ? this.getBlockType(block.getLocation().getBlockX() & 0xF, block.getLocation().getBlockY(), block.getLocation().getBlockZ() & 0xF) : CMIMaterial.get((Block)block);
        if (!Version.isCurrentEqualOrHigher((Version)Version.v1_13_R2)) {
            if (CMI.getInstance().getTeleportHandler().isEmpty(cMIMaterial, false)) {
                return true;
            }
        } else {
            return CMI.getInstance().getTeleportHandler().isEmpty(cMIMaterial, false);
        }
        if (bl && cMIMaterial.equals((Object)CMIMaterial.SNOW)) {
            return this.isEmptySpace(block.getWorld(), this.getMinGlobal().clone().setY(this.getMinGlobal().getY() + 0.125), this.getMaxGlobal(), false);
        }
        return false;
    }

    public boolean isPassable() {
        return this.getMin().getBlockX() >= this.getMax().getBlockX();
    }

    public boolean isEmptySpace(Location location) {
        Double d = this.getMaxGlobal().getX() - this.getMinGlobal().getX();
        Double d2 = this.getMaxGlobal().getY() - this.getMinGlobal().getY();
        Double d3 = this.getMaxGlobal().getZ() - this.getMinGlobal().getZ();
        Vector vector = new Vector(location.getX() - d / 2.0, location.getY(), location.getZ() - d3 / 2.0);
        Vector vector2 = new Vector(location.getX() + d / 2.0, location.getY() + d2, location.getZ() + d3 / 2.0);
        return this.isEmptySpace(location.getWorld(), vector, vector2, true);
    }

    public boolean isEmptySpace() {
        return this.isEmptySpace(this.world, this.getMinGlobal(), this.getMaxGlobal(), true);
    }

    public boolean isEmptySpace(World world2, Vector vector, Vector vector2, boolean bl) {
        return this.getCollidingdBlock(world2, vector, vector2, bl) == null;
    }

    public Block getCollidingdBlock() {
        return this.getCollidingdBlock(this.world, this.getMinGlobal(), this.getMaxGlobal(), true);
    }

    public Block getCollidingdBlock(World world2, Vector vector, Vector vector2) {
        return this.getCollidingdBlock(world2, vector, vector2, true);
    }

    public Block getCollidingdBlock(World world2, Vector vector, Vector vector2, boolean bl) {
        Block block = CMI.getInstance().getNMS().getBlockLookingAt(world2, vector, vector2, false);
        if (block != null && !this.checkBlock(block, bl)) {
            return block;
        }
        Vector vector3 = vector.clone().setX(vector2.getX());
        Vector vector4 = vector2.clone().setX(vector.getX());
        block = CMI.getInstance().getNMS().getBlockLookingAt(world2, vector3, vector4, false);
        if (block != null && !this.checkBlock(block, bl)) {
            return block;
        }
        Vector vector5 = vector.clone().setZ(vector2.getZ());
        Vector vector6 = vector2.clone().setZ(vector.getZ());
        block = CMI.getInstance().getNMS().getBlockLookingAt(world2, vector5, vector6, false);
        if (block != null && !this.checkBlock(block, bl)) {
            return block;
        }
        Vector vector7 = vector.clone().setX(vector2.getX()).setZ(vector2.getZ());
        Vector vector8 = vector2.clone().setX(vector.getX()).setZ(vector.getZ());
        block = CMI.getInstance().getNMS().getBlockLookingAt(world2, vector7, vector8, false);
        if (block != null && !this.checkBlock(block, bl)) {
            return block;
        }
        block = CMI.getInstance().getNMS().getBlockLookingAt(world2, vector, vector5, false);
        if (block != null && !this.checkBlock(block, bl)) {
            return block;
        }
        block = CMI.getInstance().getNMS().getBlockLookingAt(world2, vector2, vector6, false);
        if (block != null && !this.checkBlock(block, bl)) {
            return block;
        }
        Vector vector9 = vector.clone();
        Vector vector10 = vector.clone().setX(vector2.getX());
        double d = vector.getZ();
        while (d < vector2.getZ()) {
            block = CMI.getInstance().getNMS().getBlockLookingAt(world2, vector9.setZ(d), vector10.setZ(d), false);
            if (block != null && !this.checkBlock(block, bl)) {
                return block;
            }
            d += 0.1;
        }
        return null;
    }

    public boolean collides(Entity entity) {
        if (entity == null) {
            return false;
        }
        CMIHitBox cMIHitBox = new CMIHitBox(entity);
        if (cMIHitBox.world == null || cMIHitBox.min == null || cMIHitBox.max == null) {
            return false;
        }
        if (this.world == null || this.min == null || this.max == null) {
            return false;
        }
        CuboidArea cuboidArea = new CuboidArea(cMIHitBox.world, cMIHitBox.min, cMIHitBox.max);
        CuboidArea cuboidArea2 = new CuboidArea(this.world, this.min, this.max);
        return cuboidArea.checkCollision(cuboidArea2);
    }

    public boolean canPlayerStand(Location location) {
        if (CMIMaterial.isAir((Material)location.getBlock().getType())) {
            return true;
        }
        CMIMaterial cMIMaterial = null;
        cMIMaterial = this.getSnapshot() != null ? this.getBlockType(this.block.getLocation().getBlockX() & 0xF, this.block.getLocation().getBlockY(), this.block.getLocation().getBlockZ() & 0xF) : CMIMaterial.get((Block)this.block);
        if (!Version.isCurrentEqualOrHigher((Version)Version.v1_13_R2) ? CMI.getInstance().getTeleportHandler().isEmpty(cMIMaterial, false) : location.getBlock().isPassable()) {
            return true;
        }
        this.byExactXYZ(location.getX() % 1.0, location.getY() % 1.0, location.getZ() % 1.0);
        double d = location.getX() % 1.0;
        double d2 = location.getZ() % 1.0;
        double d3 = location.getY() % 1.0;
        if (d < 0.0) {
            d += 1.0;
        }
        if (d2 < 0.0) {
            d2 += 1.0;
        }
        cMIMaterial = null;
        cMIMaterial = this.getSnapshot() != null ? this.getBlockType(location.getBlockX() & 0xF, location.getBlockY(), location.getBlockZ() & 0xF) : CMIMaterial.get((Block)location.getBlock());
        if (cMIMaterial.equals((Object)CMIMaterial.SNOW)) {
            d3 += 0.125;
        }
        double d4 = d - 0.3;
        double d5 = d2 - 0.3;
        double d6 = d3;
        double d7 = d + 0.3;
        double d8 = d2 + 0.3;
        double d9 = d3 + 1.8;
        double d10 = this.getMax().getX();
        double d11 = this.getMin().getX();
        double d12 = this.getMax().getY();
        double d13 = this.getMin().getY();
        double d14 = this.getMax().getZ();
        double d15 = this.getMin().getZ();
        return !(d7 > d11 && d7 < d10 || d4 > d11 && d4 < d10 || d10 > d4 && d10 < d7) && (!(d11 > d4) || !(d11 < d7)) || !(d9 > d13 && d9 < d12 || d6 > d13 && d6 < d12 || d12 > d6 && d12 < d9) && (!(d13 > d6) || !(d13 < d9)) || !(d8 > d15 && d8 < d14 || d5 > d15 && d5 < d14 || d14 > d5 && d14 < d8) && (!(d15 > d5) || !(d15 < d8));
    }

    private CMIMaterial getBlockType(int n, int n2, int n3) {
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_13_R1)) {
            return CMIMaterial.get((Material)this.getSnapshot().getBlockType(n, n2, n3));
        }
        if (getBlockTypeId == null) {
            try {
                getBlockTypeId = this.getSnapshot().getClass().getMethod("getBlockTypeId", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        try {
            return CMIMaterial.get((int)((Integer)getBlockTypeId.invoke((Object)this.getSnapshot(), n, n2, n3)));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return CMIMaterial.AIR;
        }
    }

    public boolean collides(Vector vector) {
        return !(vector.getX() < this.getMinGlobal().getX() || vector.getX() > this.getMaxGlobal().getX() || vector.getY() < this.getMinGlobal().getY() || vector.getY() > this.getMaxGlobal().getY() || vector.getZ() < this.getMinGlobal().getZ() || vector.getZ() > this.getMaxGlobal().getZ());
    }

    public Block getBlock() {
        return this.block;
    }

    public void setMax(Vector vector) {
        this.max = vector;
    }

    public void setMin(Vector vector) {
        this.min = vector;
    }

    public Entity getEntity() {
        return this.ent;
    }

    public void setEntity(Entity entity) {
        this.ent = entity;
    }

    public World getWorld() {
        return this.world;
    }

    public ChunkSnapshot getSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(ChunkSnapshot chunkSnapshot) {
        this.snapshot = chunkSnapshot;
    }
}

