/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Holograms;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIInteractType;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Containers.Snd;
import com.Zrips.CMI.Modules.Display.CMIBillboard;
import com.Zrips.CMI.Modules.Display.CMIDisplay;
import com.Zrips.CMI.Modules.Display.CMIInteractionEntity;
import com.Zrips.CMI.Modules.Display.CMIItemDisplay;
import com.Zrips.CMI.Modules.Display.CMITextAlignment;
import com.Zrips.CMI.Modules.Display.CMITextDisplay;
import com.Zrips.CMI.Modules.Holograms.Animations.CMIHologramAnimation;
import com.Zrips.CMI.Modules.Holograms.Animations.CMIHologramAnimationType;
import com.Zrips.CMI.Modules.Holograms.CMIDataWatcher;
import com.Zrips.CMI.Modules.Holograms.CMIHoloLineType;
import com.Zrips.CMI.Modules.Holograms.CMIHologramBatch;
import com.Zrips.CMI.Modules.Holograms.CMIHologramHoveringPosition;
import com.Zrips.CMI.Modules.Holograms.CMIHologramLine;
import com.Zrips.CMI.Modules.Holograms.CMIHologramPage;
import com.Zrips.CMI.Modules.Holograms.CMIHologramUserData;
import com.Zrips.CMI.Modules.Holograms.HologramManager;
import com.Zrips.CMI.Modules.Packets.FakeInfo;
import com.Zrips.CMI.Modules.Packets.PacketHandler;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.Modules.Portals.CMIPlane;
import com.Zrips.CMI.Modules.Portals.CMIPlaneIntersection;
import com.Zrips.CMI.Modules.Portals.CMIVector2D;
import com.Zrips.CMI.Modules.Portals.CMIVector3D;
import com.Zrips.CMI.Modules.Portals.CuboidArea;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMILocation;
import net.Zrips.CMILib.Container.CMINumber;
import net.Zrips.CMILib.Effects.CMIEffect;
import net.Zrips.CMILib.Effects.CMIEffectManager;
import net.Zrips.CMILib.Items.CMIAsyncHead;
import net.Zrips.CMILib.Items.CMIItemStack;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Schedulers.CMITask;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class CMIHologram {
    private String name = null;
    private CMITask schedId = null;
    private CMITask pageSchedId = null;
    private CMITask lineOfSightSchedId = null;
    private boolean enabled = true;
    private boolean saveToFile = false;
    private boolean showWhenNotPersistent = false;
    private Player playerToShowFor = null;
    private int selfDestructIn = 0;
    private boolean sticky = false;
    private boolean autoPagination = false;
    private int autoPaginationOffset = 0;
    private CuboidArea area;
    private CuboidArea areaExtra;
    private List<String> commands = new ArrayList<String>();
    private double LOSupdateIntervalSec = 0.0;
    private double followPlayer = 1.0;
    private double updateIntervalSec = HologramManager.defaultUpdateInterval;
    private double pageChangeIntervalSec = HologramManager.defaultpageChangeInterval;
    private int updateRange = HologramManager.defaultUpdateRange;
    private int showRange = HologramManager.defaultViewRange;
    private double spacing = 0.24;
    private double iconSpacing = 0.5;
    private boolean downOrder = HologramManager.defaultsPlaceUp;
    private CMILocation loc;
    private Vector centerLocation = null;
    private boolean interactable = false;
    private boolean bigButton = true;
    private boolean showParticle = true;
    private boolean requestPermission = false;
    private static String left = "!leftclick!";
    private static String right = "!rightclick!";
    private static String shiftLeft = "!shiftleftclick!";
    private static String shiftRight = "!shiftrightclick!";
    static Pattern pagePatern = Pattern.compile("(?i)(!nextpage!)");
    private List<String> lines = new ArrayList<String>();
    private int lineCount = 0;
    private List<String> oldLines = new ArrayList<String>();
    private boolean changedLines = false;
    private ConcurrentHashMap<UUID, CMIHologramUserData> userData = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, CMIHologramPage> pages = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, CMIHologramPage> oldPages = new ConcurrentHashMap();
    private Set<UUID> playersInHologramUpdateRange = Collections.synchronizedSet(new HashSet());
    private Set<UUID> playersInHologramVisibilityRange = Collections.synchronizedSet(new HashSet());
    ConcurrentHashMap<Integer, FakeInfo> clickableById = new ConcurrentHashMap();
    ConcurrentHashMap<Integer, String> changed = new ConcurrentHashMap();
    List<Integer> changedPages = new ArrayList<Integer>();
    private boolean uSync = true;
    private boolean newIneractionMethod = true;
    private CMITask hoverOverSchedId = null;
    private double extraInteractionHeight = 0.0;
    private double extraInteractionWidth = 0.0;
    private boolean newDisplayMethod = false;
    private CMIBillboard billboard = null;
    private CMIBillboard iconBillboard = null;
    private CMITextAlignment textAlignment = null;
    private int yaw = 0;
    private int pitch = 0;
    private CMIChatColor backgroundColor = CMIChatColor.BLACK;
    private int backgroundAlpha = 125;
    private int textAlpha = 230;
    private boolean doubleSided = false;
    private boolean shadowed = true;
    private double scaleW = 1.0;
    private double scaleH = 1.0;
    private boolean seeThrough = false;
    private boolean fadeInAnimation = false;
    private double iconScale = 1.0;
    private int iconPitch = 0;
    private int iconYaw = 0;
    private int skyLevel = -1;
    private int blockLevel = -1;
    private short particlePosition = 0;
    private double particleSpacing = 0.0;
    private int particleCount = 1;
    private CMIEffect effect = new CMIEffect(CMIEffectManager.CMIParticle.SMALL_SMOKE);
    private boolean showHoverParticle = true;
    private boolean stabilizedHoverParticles = false;
    private double extraParticleHeight = 0.0;
    private double extraParticleWidth = 0.0;
    private double particleOffsetX = 0.0;
    private double particleOffsetY = 0.0;

    public CMIHologram(String string, Location location) {
        this(string, new CMILocation(location));
    }

    public CMIHologram(String string, Location location, Player player) {
        this(string, new CMILocation(location));
        this.playerToShowFor = player;
        this.playersInHologramVisibilityRange.add(player.getUniqueId());
        this.playersInHologramUpdateRange.add(player.getUniqueId());
        CMI.getInstance().getHologramManager().addHologram(this, false, false);
    }

    public CMIHologram(Location location, Player player, List<String> list2) {
        this.playerToShowFor = player;
        location.setPitch(0.0f);
        location.setYaw(0.0f);
        this.loc = new CMILocation(location);
        this.lines = list2;
        this.playersInHologramVisibilityRange.add(player.getUniqueId());
        this.playersInHologramUpdateRange.add(player.getUniqueId());
    }

    public CMIHologram(String string, CMILocation cMILocation) {
        this.name = string;
        cMILocation.setPitch(0.0f);
        cMILocation.setYaw(0.0f);
        this.loc = cMILocation;
        this.updatePages();
    }

    public void onInteraction(Player player, CMIInteractType cMIInteractType) {
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public List<String> getCommands(Player player) {
        return this.getCommands(player, null);
    }

    public CMIHologramUserData getData(Player player) {
        return this.getData(player.getUniqueId());
    }

    public CMIHologramUserData getData(UUID uUID2) {
        return this.userData.computeIfAbsent(uUID2, uUID -> new CMIHologramUserData());
    }

    private CMIHologramUserData removeData(Player player) {
        return this.removeData(player.getUniqueId());
    }

    private CMIHologramUserData removeData(UUID uUID) {
        return this.userData.remove(uUID);
    }

    public void goToNextPage(Player player) {
        this.goToNextPage(player.getUniqueId());
    }

    public void goToNextPage(UUID uUID) {
        CMIHologramUserData cMIHologramUserData = this.getData(uUID);
        int n = cMIHologramUserData.getPage();
        if (++n > this.pages.size()) {
            n = 1;
        }
        this.checkPageChange(uUID, cMIHologramUserData.getPage(), n);
        cMIHologramUserData.setPage(n);
        cMIHologramUserData.setSkipPageChange(true);
    }

    private void goToNextPageAuto(UUID uUID) {
        CMIHologramUserData cMIHologramUserData = this.getData(uUID);
        if (cMIHologramUserData.isSkipPageChange()) {
            return;
        }
        int n = cMIHologramUserData.getPage();
        if (++n > this.pages.size()) {
            n = 1;
        }
        this.checkPageChange(uUID, cMIHologramUserData.getPage(), n);
        cMIHologramUserData.setPage(n);
    }

    @Deprecated
    public Integer getPlayerPage(UUID uUID) {
        return this.getData(uUID).getPage();
    }

    public void goToPrevPage(Player player) {
        this.goToPrevPage(player.getUniqueId());
    }

    public void goToPrevPage(UUID uUID) {
        CMIHologramUserData cMIHologramUserData = this.getData(uUID);
        int n = cMIHologramUserData.getPage();
        if (--n <= 0) {
            n = this.pages.size();
        }
        this.checkPageChange(uUID, cMIHologramUserData.getPage(), n);
        cMIHologramUserData.setPage(n);
        cMIHologramUserData.setSkipPageChange(true);
    }

    public void goToPage(UUID uUID, int n) {
        CMIHologramUserData cMIHologramUserData = this.getData(uUID);
        if (n <= 0) {
            n = this.pages.size();
        } else if (n > this.pages.size()) {
            n = 1;
        }
        this.checkPageChange(uUID, cMIHologramUserData.getPage(), n);
        cMIHologramUserData.setPage(n);
        cMIHologramUserData.setSkipPageChange(true);
    }

    private void checkPageChange(UUID uUID, Integer n, Integer n2) {
        if (n == null || n2 == null) {
            if (!this.isNewDisplayMethod()) {
                this.removeFromCache(uUID);
            }
            return;
        }
        CMIHologramPage cMIHologramPage = this.getPage(n);
        CMIHologramPage cMIHologramPage2 = this.getPage(n2);
        CMIHologramUserData cMIHologramUserData = this.getData(uUID);
        if (cMIHologramPage != null && cMIHologramPage2 != null) {
            List<String> list2;
            int n3 = cMIHologramPage.getLines().size();
            int n4 = cMIHologramPage2.getLines().size();
            if (n3 > 0 && cMIHologramPage.getLines().get(0).getType() == CMIHoloLineType.image && (list2 = cMIHologramPage.getLines().get(0).getPlainImage()) != null) {
                n3 = list2.size();
            }
            if (n4 > 0 && cMIHologramPage2.getLines().get(0).getType() == CMIHoloLineType.image && (list2 = cMIHologramPage2.getLines().get(0).getPlainImage()) != null) {
                n4 = list2.size();
            }
            if (n3 != n4 && !this.isNewDisplayMethod()) {
                this.removeFromCache(uUID, n4);
            }
            this.clearIconLines(uUID, cMIHologramPage2);
            cMIHologramUserData.setSkipUpdate(true);
        } else if (!this.isNewDisplayMethod()) {
            this.removeFromCache(uUID);
        }
        this.recheckLines();
    }

    private double getLineHeight() {
        return 0.25 * this.getScaleH();
    }

    private List<String> getCommandsByPlayerPage(UUID uUID) {
        if (uUID == null) {
            return this.commands;
        }
        CMIHologramUserData cMIHologramUserData = this.getData(uUID);
        int n = cMIHologramUserData.getPage();
        int n2 = n = this.pages.size() < n ? 1 : n;
        if (this.pages.isEmpty()) {
            return this.commands;
        }
        List<String> list2 = this.pages.get(n).getCommands();
        if (list2.isEmpty() && !this.getCommands().isEmpty()) {
            list2 = new ArrayList<String>(this.getCommands());
        }
        return list2;
    }

    private List<CMIHologramLine> getLinesByPlayerPage(Player player) {
        CMIHologramUserData cMIHologramUserData = this.getData(player);
        int n = cMIHologramUserData.getPage();
        int n2 = n = this.pages.size() < n ? 1 : n;
        if (this.pages.isEmpty()) {
            return Collections.emptyList();
        }
        CMIHologramPage cMIHologramPage = this.pages.get(n);
        if (cMIHologramPage == null) {
            if (this.pages.values().iterator().hasNext()) {
                return this.pages.values().iterator().next().getLines();
            }
            return new ArrayList<CMIHologramLine>();
        }
        return cMIHologramPage.getLines();
    }

    public void updatePages() {
        CMIHologramPage cMIHologramPage;
        Matcher matcher;
        int n = 1;
        this.oldPages.clear();
        this.oldPages.putAll(this.pages);
        this.pages.clear();
        for (String string : this.commands) {
            matcher = pagePatern.matcher(string);
            while (matcher.find()) {
                ++n;
            }
            cMIHologramPage = this.pages.get(n);
            if (cMIHologramPage == null) {
                cMIHologramPage = new CMIHologramPage();
                cMIHologramPage.setPage(n);
                this.pages.put(n, cMIHologramPage);
            }
            cMIHologramPage.getCommands().add(string);
        }
        n = 1;
        for (String string : this.lines) {
            matcher = pagePatern.matcher(string);
            if (matcher.find()) {
                ++n;
                continue;
            }
            cMIHologramPage = this.pages.get(n);
            if (cMIHologramPage == null) {
                cMIHologramPage = new CMIHologramPage();
                cMIHologramPage.setPage(n);
                this.pages.put(n, cMIHologramPage);
            }
            CMIHologramLine cMIHologramLine = new CMIHologramLine(string);
            cMIHologramPage.getLines().add(cMIHologramLine);
            cMIHologramPage.setHeight(this.getHeight(cMIHologramPage.getLines()));
            cMIHologramPage.calculateWidth();
        }
        this.recalculateChangedPages();
        this.centerLocation = null;
    }

    public List<String> getCommands(Player player, CMIInteractType cMIInteractType) {
        Snd snd = new Snd().setSender(player).setTarget(player);
        ArrayList<String> arrayList = new ArrayList<String>();
        block8: for (String string : this.getCommandsByPlayerPage(player == null ? null : player.getUniqueId())) {
            String string2 = string;
            if (string2.startsWith(left) || string2.startsWith(right)) {
                if (cMIInteractType != null) {
                    switch (cMIInteractType) {
                        case LeftClick: {
                            if (!string2.startsWith(left)) continue block8;
                            string2 = string2.substring(left.length());
                            if (player.isSneaking()) continue block8;
                            arrayList.add(CMI.getInstance().getLM().updateSnd(snd, string2));
                            break;
                        }
                        case RightClick: {
                            if (!string2.startsWith(right)) continue block8;
                            string2 = string2.substring(right.length());
                            if (player.isSneaking()) continue block8;
                            arrayList.add(CMI.getInstance().getLM().updateSnd(snd, string2));
                            break;
                        }
                        default: {
                            if (string2.startsWith(left)) {
                                string2 = string2.substring(left.length());
                            }
                            if (string2.startsWith(right)) {
                                string2 = string2.substring(right.length());
                            }
                            arrayList.add(CMI.getInstance().getLM().updateSnd(snd, string2));
                            break;
                        }
                    }
                    continue;
                }
                if (string2.startsWith(left)) {
                    string2 = string2.substring(left.length());
                }
                if (string2.startsWith(right)) {
                    string2 = string2.substring(right.length());
                }
                if (string2.startsWith(shiftLeft)) {
                    string2 = string2.substring(shiftLeft.length());
                }
                if (string2.startsWith(shiftRight)) {
                    string2 = string2.substring(shiftRight.length());
                }
                arrayList.add(CMI.getInstance().getLM().updateSnd(snd, string2));
                continue;
            }
            if (string2.startsWith(shiftLeft) || string2.startsWith(shiftRight)) {
                if (cMIInteractType != null) {
                    switch (cMIInteractType) {
                        case LeftClick: {
                            if (!string2.startsWith(shiftLeft)) continue block8;
                            string2 = string2.substring(shiftLeft.length());
                            if (!player.isSneaking()) continue block8;
                            arrayList.add(CMI.getInstance().getLM().updateSnd(snd, string2));
                            break;
                        }
                        case RightClick: {
                            if (!string2.startsWith(shiftRight)) continue block8;
                            string2 = string2.substring(shiftRight.length());
                            if (!player.isSneaking()) continue block8;
                            arrayList.add(CMI.getInstance().getLM().updateSnd(snd, string2));
                            break;
                        }
                        default: {
                            if (string2.startsWith(shiftLeft)) {
                                string2 = string2.substring(shiftLeft.length());
                            }
                            if (string2.startsWith(shiftRight)) {
                                string2 = string2.substring(shiftRight.length());
                            }
                            arrayList.add(CMI.getInstance().getLM().updateSnd(snd, string2));
                            break;
                        }
                    }
                    continue;
                }
                if (string2.startsWith(left)) {
                    string2 = string2.substring(left.length());
                }
                if (string2.startsWith(right)) {
                    string2 = string2.substring(right.length());
                }
                if (string2.startsWith(shiftLeft)) {
                    string2 = string2.substring(shiftLeft.length());
                }
                if (string2.startsWith(shiftRight)) {
                    string2 = string2.substring(shiftRight.length());
                }
                arrayList.add(CMI.getInstance().getLM().updateSnd(snd, string2));
                continue;
            }
            arrayList.add(CMI.getInstance().getLM().updateSnd(snd, string2));
        }
        return arrayList;
    }

    public void setCommands(List<String> list2) {
        if (this.commands == null) {
            this.commands = new ArrayList<String>();
        }
        this.commands.addAll(list2);
    }

    public World getWorld() {
        return this.loc.getWorld();
    }

    @Deprecated
    public Location getLoc() {
        return this.getLocation();
    }

    public CMILocation getLocation() {
        return this.loc;
    }

    public void setLoc(Location location) {
        location.setPitch(0.0f);
        location.setYaw(0.0f);
        this.loc = new CMILocation(location);
        if (this.getPlayerToShowFor() != null) {
            this.setArea(null);
            this.setAreaExtra(null);
        } else {
            this.setArea(null);
            this.setAreaExtra(null);
            CMI.getInstance().getHologramManager().recalculateChunksExtra(this);
            CMI.getInstance().getHologramManager().addPlayersNearHoloExtra(this, false);
            CMI.getInstance().getHologramManager().recalculateChunks(this);
            CMI.getInstance().getHologramManager().addPlayersNearHolo(this, false);
            this.centerLocation = null;
        }
    }

    public List<String> getLines() {
        return this.lines;
    }

    public String getLine(int n) {
        return this.lines.size() - 1 < n || n < 0 ? "" : (this.lines.get(n) == null ? "" : this.lines.get(n));
    }

    public void setLines(List<String> list2) {
        ArrayList<String> arrayList = new ArrayList<String>(list2);
        int n = 0;
        while (n < arrayList.size()) {
            if (arrayList.get(n) == null || arrayList.get(n).isEmpty()) {
                arrayList.set(n, "_");
            }
            ++n;
        }
        this.oldLines.clear();
        this.oldLines.addAll(this.lines);
        this.lines.clear();
        this.lines.addAll(arrayList);
        this.recheckLines();
    }

    public void addLine(String string) {
        this.oldLines.clear();
        this.oldLines.addAll(this.lines);
        this.lines.add(string);
        this.recheckLines();
    }

    public void setLine(int n, String string) {
        this.oldLines.clear();
        this.oldLines.addAll(this.lines);
        while (this.lines.size() <= n) {
            this.lines.add("");
        }
        this.lines.set(n, string);
        this.recheckLines();
    }

    public void removeLine(int n) {
        if (this.lines.size() >= n) {
            try {
                this.lines.remove(n - 1);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        this.recheckLines();
    }

    public boolean isChangedLine() {
        return this.changedLines;
    }

    private void recheckLines() {
        if (this.oldLines.size() != this.lines.size()) {
            this.changedLines = true;
            this.recalcualteChangedLines();
            return;
        }
        for (String string : this.lines) {
            if (this.oldLines.contains(string)) continue;
            this.changedLines = true;
            this.recalcualteChangedLines();
            return;
        }
        this.changedLines = false;
    }

    public CuboidArea getArea() {
        if (this.area == null) {
            this.area = new CuboidArea(this.getLocation().clone().add((double)(-this.updateRange), (double)(-this.updateRange), (double)(-this.updateRange)), this.getLocation().clone().add((double)this.updateRange, (double)this.updateRange, (double)this.updateRange));
        }
        return this.area;
    }

    public CuboidArea getAreaExtra() {
        if (this.areaExtra == null) {
            this.areaExtra = new CuboidArea(this.getLocation().clone().add((double)(-this.showRange), (double)(-this.showRange), (double)(-this.showRange)), this.getLocation().clone().add((double)this.showRange, (double)this.showRange, (double)this.showRange));
        }
        return this.areaExtra;
    }

    public void setArea(CuboidArea cuboidArea) {
        this.area = cuboidArea;
    }

    public void setAreaExtra(CuboidArea cuboidArea) {
        this.areaExtra = cuboidArea;
    }

    public void recheckPermissionAccess() {
        if (!this.isRequiresPermission()) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!this.getAreaExtra().containsLoc(player.getLocation())) continue;
            if (PermissionsManager.CMIPerm.hologram_$1.hasPermission((CommandSender)player, 1000L, this.getName().toLowerCase())) {
                CMI.getInstance().getHologramManager().handleHoloUpdates(player, player.getLocation());
                continue;
            }
            CMI.getInstance().getHologramManager().removeNearHolo(player.getUniqueId(), this);
            CMI.getInstance().getHologramManager().removeNearHoloExtra(player.getUniqueId(), this);
            this.removeLastHoloInRange(player.getUniqueId());
            this.removeLastHoloInRangeExtra(player.getUniqueId());
        }
    }

    public void update() {
        this.updatePages();
        this.recheckTaskers();
        if (this.getPlayerToShowFor() != null) {
            if (this.getPlayerToShowFor().isOnline()) {
                this.update(this.getPlayerToShowFor());
            }
            return;
        }
        if (this.area != null) {
            for (UUID uUID : this.getLastHoloInRangeExtra()) {
                this.update(CMIUser.getOnlinePlayer(uUID));
            }
        }
    }

    @Deprecated
    public void hide(Player player) {
        if (player == null) {
            return;
        }
        this.hide(player.getUniqueId());
    }

    public void refresh() {
        this.hide();
        this.updatePages();
        this.update();
    }

    public void hide() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.removeFromCache(player.getUniqueId());
        }
        this.stop();
    }

    public void hide(UUID uUID) {
        if (uUID == null) {
            return;
        }
        this.removeFromCache(uUID);
    }

    public double getHeight() {
        double d = 0.0;
        int n = 0;
        while (n < this.lines.size()) {
            String string = this.lines.get(n);
            if (string.equalsIgnoreCase("!nextpage!")) break;
            if (string.equals("_")) {
                string = "";
            }
            d = string.startsWith("SICON:") ? (d += this.getSpacing().doubleValue()) : (string.startsWith("ICON:") ? (d += this.getIconSpacing().doubleValue()) : (d += this.getSpacing().doubleValue()));
            ++n;
        }
        return d;
    }

    private double getHeight(List<CMIHologramLine> list2) {
        double d = this.getSpacing() / 2.0;
        int n = 0;
        while (n < list2.size()) {
            CMIHologramLine cMIHologramLine = list2.get(n);
            String string = cMIHologramLine.getText();
            if (string.equalsIgnoreCase("!nextpage!")) break;
            if (string.equals("_")) {
                string = "";
            }
            if (cMIHologramLine.getType().equals((Object)CMIHoloLineType.staticIcon)) {
                d += this.getSpacing().doubleValue();
            } else if (cMIHologramLine.getType().equals((Object)CMIHoloLineType.icon)) {
                d += this.getIconSpacing().doubleValue();
                d += this.getSpacing() / 2.0;
            } else {
                d += this.getSpacing().doubleValue();
            }
            ++n;
        }
        if (this.isAutoPagination()) {
            d += this.getSpacing().doubleValue();
        }
        return d;
    }

    public Vector getCenterVector() {
        if (this.centerLocation != null) {
            return this.centerLocation.clone();
        }
        this.centerLocation = this.getCenterLocation().toVector();
        return this.centerLocation.clone();
    }

    public Location getCenterLocation() {
        double d = this.getHeight();
        CMILocation cMILocation = this.getLocation().clone();
        cMILocation.add(0.0, 0.25, 0.0);
        if (this.isDownOrder().booleanValue()) {
            cMILocation.add(0.0, -(d / 2.0), 0.0);
        } else {
            cMILocation.add(0.0, d / 2.0, 0.0);
        }
        return cMILocation;
    }

    private void recalcualteChangedLines() {
        if (!this.changedLines) {
            this.changed.clear();
            this.changedPages.clear();
            return;
        }
        List<String> list2 = this.getLines();
        int n = 0;
        while (n < list2.size()) {
            String string = this.lines.get(n);
            String string2 = "";
            if (n < this.oldLines.size()) {
                string2 = this.oldLines.get(n);
            }
            if (!string.equals(string2)) {
                this.changed.put(n, string);
            }
            ++n;
        }
    }

    @Deprecated
    private void recalcualteChangedPages() {
        this.recalculateChangedPages();
    }

    private void recalculateChangedPages() {
        if (!this.changedLines) {
            return;
        }
        this.changedPages.clear();
        for (Map.Entry<Integer, CMIHologramPage> entry : this.pages.entrySet()) {
            Map.Entry<UUID, CMIHologramUserData> entry2 = this.oldPages.get(entry.getKey());
            if (entry2 == null) {
                this.changedPages.add(entry.getKey());
                continue;
            }
            if (((CMIHologramPage)((Object)entry2)).getLines().size() == entry.getValue().getLines().size()) continue;
            this.changedPages.add(entry.getKey());
        }
        for (Integer n : this.changedPages) {
            for (Map.Entry<UUID, CMIHologramUserData> entry2 : new ConcurrentHashMap<UUID, CMIHologramUserData>(this.userData).entrySet()) {
                if (((CMIHologramUserData)entry2.getValue()).getPage() != n.intValue()) continue;
                this.removeFromCache((UUID)entry2.getKey());
            }
        }
    }

    public void moveTo(Location location) {
        this.setLoc(location);
        this.move(this.getLocation().clone().toVector(), location, true);
        if (this.isSaveToFile()) {
            CMI.getInstance().getHologramManager().save();
        }
    }

    public void superficialMoveTo(Location location) {
        this.move(this.getLocation().clone().toVector(), location, false);
    }

    private void move(Vector vector, Location location, boolean bl) {
        if (this.isNewDisplayMethod()) {
            double d = 0.0;
            if (this.isDownOrder().booleanValue()) {
                d = (double)this.lineCount * this.getLineHeight();
            }
            for (UUID uUID : this.playersInHologramVisibilityRange) {
                this.moveHologramFor(uUID, location, d);
            }
            return;
        }
        for (UUID uUID : this.playersInHologramVisibilityRange) {
            this.moveHologramFor(uUID, location, vector, bl);
        }
    }

    private void moveHologramFor(UUID uUID, Location location, double d) {
        CMIHologramUserData cMIHologramUserData = this.getData(uUID);
        CMIHologramBatch cMIHologramBatch = cMIHologramUserData.getHologramBatch();
        if (cMIHologramBatch == null) {
            return;
        }
        for (CMIDisplay object : cMIHologramBatch.getDisplays().values()) {
            object.setLocation(location.clone().add(0.0, -d, 0.0));
            object.update(CMIUser.getOnlinePlayer(uUID));
        }
        for (Map.Entry entry : cMIHologramBatch.getIcons().entrySet()) {
            CMIVector3D cMIVector3D = this.getIconPositionOffset((Integer)entry.getKey());
            ((CMIDisplay)entry.getValue()).setLocation(location.clone().add(cMIVector3D.getX(), cMIVector3D.getY(), cMIVector3D.getZ()));
        }
    }

    private void moveHologramFor(UUID uUID, Location location, Vector vector, boolean bl) {
        Player player = CMIUser.getOnlinePlayer(uUID);
        if (player == null || !player.isOnline()) {
            return;
        }
        CMIHologramUserData cMIHologramUserData = this.getData(uUID);
        List<CMIDataWatcher> list2 = cMIHologramUserData.getDataWatcher();
        if (list2 == null) {
            return;
        }
        for (CMIDataWatcher cMIDataWatcher : list2) {
            Vector vector2 = cMIDataWatcher.getLoc().toVector();
            Vector vector3 = vector2.subtract(vector);
            vector3.setZ(0);
            vector3.setX(0);
            Location location2 = location.clone().add(vector3);
            if (bl) {
                cMIDataWatcher.setLoc(location2);
            }
            CMILib.getInstance().getReflectionManager().superficialEntityTeleport(player, cMIDataWatcher.getStand(), location2);
        }
    }

    public void update(Player player) {
        this.update(player, false);
    }

    private List<CMIVector3D> getLocation(Player player, int n) {
        CMIHologramPage cMIHologramPage = this.getPage(this.getPlayerPage(player.getUniqueId()));
        if (cMIHologramPage == null) {
            cMIHologramPage = this.getPage(1);
        }
        if (cMIHologramPage == null) {
            return null;
        }
        double d = (double)cMIHologramPage.getWidth() / 74.0 * this.getScaleW() + this.getExtraParticleWidth();
        double d2 = cMIHologramPage.getHeight() * this.getScaleH() + this.getExtraParticleHeight();
        if (this.isNewDisplayMethod()) {
            d2 += 0.2;
        }
        int n2 = 10;
        double d3 = 0.1;
        double d4 = 0.1;
        if (this.getParticleSpacing() > 0.0) {
            d3 = this.getParticleSpacing();
            d4 = this.getParticleSpacing();
        } else {
            d3 = d > d2 ? d / (double)n2 : d2 / (double)n2;
            if (d3 < 0.05) {
                d3 = 0.05;
            }
            if (d3 > 0.3) {
                d3 = 0.3;
            }
            d4 = d3;
        }
        double d5 = 0.0;
        if (!this.isStabilizedHoverParticles()) {
            d5 = Math.toRadians(player.getLocation().getYaw());
        } else {
            Location location = player.getLocation().clone();
            Vector vector = this.getLocation().toVector();
            location.setDirection(vector.subtract(location.toVector()));
            d5 = Math.toRadians(location.getYaw());
        }
        double d6 = 0.0;
        if (!this.isStabilizedHoverParticles()) {
            d6 = -player.getLocation().getDirection().getY();
            d6 = Math.max(-0.1, d6);
            d6 = Math.min(0.1, d6);
        }
        if (this.isNewDisplayMethod()) {
            d6 = 0.0;
            switch (this.getBillboard()) {
                case CENTER: {
                    break;
                }
                case FIXED: {
                    d5 = Math.toRadians((360 + this.getYaw()) % 360);
                    d6 = Math.toRadians(this.getPitch() % 90);
                    break;
                }
                case HORIZONTAL: {
                    break;
                }
                case VERTICAL: {
                    break;
                }
            }
        }
        double d7 = d * 2.0 / d3 * 2.0 + (d2 + d4 * 2.0) / d4 * 2.0 - 3.0;
        int n3 = (int)Math.ceil(d7 / (double)n);
        int n4 = this.particlePosition % n3;
        ++n4;
        ArrayList<CMIVector3D> arrayList = new ArrayList<CMIVector3D>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        int n5 = 1;
        while (n5 <= n) {
            double d8;
            int n6 = 0;
            int n7 = n4 + (n5 - 1) * n3;
            if (d * 2.0 / d3 >= (double)n7) {
                d8 = -d + d3;
                while (d8 <= d) {
                    if (n7 == ++n6) {
                        arrayList.add(CMIPlaneIntersection.rotateAroundCenter(d8 + this.getParticleOffsetX(), this.getParticleOffsetY(), d5, d6));
                        break;
                    }
                    d8 += d3;
                }
            } else if (d2 / d4 >= (double)(n7 - (n6 = (int)((double)n6 + Math.ceil(d * 2.0 / d3))))) {
                d8 = d4 / 2.0;
                while (d8 <= d2) {
                    if (n7 == ++n6) {
                        arrayList.add(CMIPlaneIntersection.rotateAroundCenter(d + this.getParticleOffsetX(), d8 + this.getParticleOffsetY(), d5, d6));
                        break;
                    }
                    d8 += d4;
                }
            } else if (d * 2.0 / d3 >= (double)(n7 - (n6 = (int)((double)n6 + Math.ceil(d2 / d4))))) {
                d8 = d - d3;
                while (d8 >= -d) {
                    if (n7 == ++n6) {
                        arrayList.add(CMIPlaneIntersection.rotateAroundCenter(d8 + this.getParticleOffsetX(), d2 + this.getParticleOffsetY(), d5, d6));
                        break;
                    }
                    d8 -= d3;
                }
            } else if (d2 / d4 >= (double)(n7 - (n6 = (int)((double)n6 + Math.ceil(d * 2.0 / d3))))) {
                d8 = d2 - d4 / 2.0;
                while (d8 >= 0.0) {
                    if (n7 == ++n6) {
                        arrayList.add(CMIPlaneIntersection.rotateAroundCenter(-d + this.getParticleOffsetX(), d8 + this.getParticleOffsetY(), d5, d6));
                        break;
                    }
                    d8 -= d4;
                }
            }
            arrayList2.add(n6);
            ++n5;
        }
        return arrayList;
    }

    private int getLineCount(CMIHologramPage cMIHologramPage) {
        return this.isAutoPagination() ? cMIHologramPage.getLines().size() + 1 : cMIHologramPage.getLines().size();
    }

    public void processPrevNextPageClick(Player player) {
        if (!this.isAutoPagination()) {
            return;
        }
        CMIHologramUserData cMIHologramUserData = this.getData(player);
        CMIHologramHoveringPosition cMIHologramHoveringPosition = cMIHologramUserData.getHoveringSide();
        int n = cMIHologramUserData.getHoveringLineAndReset();
        if (cMIHologramHoveringPosition.equals((Object)CMIHologramHoveringPosition.None)) {
            return;
        }
        if (n > 0 && n == this.lineCount) {
            switch (cMIHologramHoveringPosition) {
                case Left: {
                    this.goToPrevPage(player);
                    break;
                }
                case None: {
                    break;
                }
                case Right: {
                    this.goToNextPage(player);
                    break;
                }
            }
            this.update(player);
        }
    }

    public void checkHoverPosition(Player player) {
        if (!this.isNewIneractionMethod()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (player == null || !player.isOnline()) {
            return;
        }
        if (this.getPitch() != 0 && this.getBillboard().equals((Object)CMIBillboard.FIXED)) {
            return;
        }
        CMIScheduler.runTaskAsynchronously(() -> {
            double d;
            boolean bl;
            double d2;
            CMIHologramUserData cMIHologramUserData = this.getData(player);
            CMIHologramPage cMIHologramPage = this.getPage(cMIHologramUserData.getPage());
            if (cMIHologramPage == null) {
                cMIHologramPage = this.getPage(1);
            }
            if (cMIHologramPage == null) {
                if (cMIHologramUserData.getHoveringLineAndReset() > 0) {
                    this.update(player, true);
                }
                return;
            }
            CMIHologramPage cMIHologramPage2 = cMIHologramPage;
            double d3 = d2 = this.isNewDisplayMethod() ? cMIHologramPage2.getHeight() : cMIHologramPage2.getHeight() - this.getSpacing() / 2.0 + this.getExtraInteractionHeight();
            if (CMI.getInstance().getUtilManager().getDistance(player.getEyeLocation(), (Location)this.getLocation()) > (double)this.getUpdateRange()) {
                HologramManager.CMIAiming cMIAiming;
                if (cMIHologramUserData.getHoveringLineAndReset() > 0) {
                    this.update(player, true);
                }
                if ((cMIAiming = CMI.getInstance().getHologramManager().getAimAt(player.getUniqueId())) != null && cMIAiming.getName().equals(this.getName())) {
                    CMI.getInstance().getHologramManager().removeAimAt(player.getUniqueId());
                }
                return;
            }
            if (!CMI.getInstance().getUtilManager().lookingAt(player, this.getCenterVector(), 90.0, 90.0)) {
                if (cMIHologramUserData.getHoveringLineAndReset() > 0) {
                    this.update(player, true);
                }
                return;
            }
            boolean bl2 = bl = this.isDownOrder().booleanValue();
            if (this.getLocation().getY() < 0.0) {
                bl2 = !bl2;
            }
            CMIPlane cMIPlane = new CMIPlane(this.getLocation().clone().add(0.0, this.isDownOrder() != false ? this.getSpacing() / 2.0 - 0.05 : -this.getSpacing().doubleValue() + 0.05, 0.0).toVector(), new CMIVector2D(-((double)cMIHologramPage2.getWidth() / 74.0) + this.getExtraInteractionWidth(), bl2 ? -d2 : 0.0), new CMIVector2D((double)cMIHologramPage2.getWidth() / 74.0 + this.getExtraInteractionWidth(), bl2 ? 0.0 : d2));
            Vector vector = player.getLocation().getDirection().clone();
            Vector vector2 = player.getEyeLocation().toVector();
            Vector vector3 = vector.clone();
            int n = this.getLineCount(cMIHologramPage2);
            if (this.isNewDisplayMethod()) {
                cMIPlane = new CMIPlane(this.getLocation().clone().toVector(), new CMIVector2D(-((double)cMIHologramPage2.getWidth() / 74.0) * this.getScaleW() + this.getExtraInteractionWidth(), bl2 ? -((double)n * this.getLineHeight()) + this.getExtraInteractionHeight() : 0.0), new CMIVector2D((double)cMIHologramPage2.getWidth() / 74.0 * this.getScaleW() + this.getExtraInteractionWidth(), bl2 ? 0.0 : (double)n * this.getLineHeight() + this.getExtraInteractionHeight()));
                switch (this.getBillboard()) {
                    case CENTER: {
                        break;
                    }
                    case FIXED: {
                        d = Math.toRadians(this.getPitch());
                        double d4 = Math.toRadians(this.getYaw());
                        double d5 = Math.cos(d) * Math.sin(d4);
                        double d6 = Math.sin(d);
                        double d7 = -Math.cos(d) * Math.cos(d4);
                        vector3.setX(d5);
                        vector3.setY(d6);
                        vector3.setZ(d7);
                        break;
                    }
                    case HORIZONTAL: {
                        vector3.setX(0);
                        break;
                    }
                    case VERTICAL: {
                        vector3.setY(0);
                        break;
                    }
                }
            }
            d = Math.abs(cMIPlane.getSizeMax().getX() - cMIPlane.getSizeMin().getX());
            CompletableFuture<CMIPlaneIntersection> completableFuture = CMIPlaneIntersection.get(vector, vector2, vector3, cMIPlane);
            completableFuture.thenApply(cMIPlaneIntersection -> {
                Object object;
                CMIHologramHoveringPosition cMIHologramHoveringPosition;
                boolean bl;
                List<CMIVector3D> list2;
                if (cMIPlaneIntersection == null) {
                    int n2 = cMIHologramUserData.getHoveringLineAndReset();
                    HologramManager.CMIAiming cMIAiming = CMI.getInstance().getHologramManager().getAimAt(player.getUniqueId());
                    if (cMIAiming != null && cMIAiming.getName().equals(this.getName())) {
                        CMI.getInstance().getHologramManager().removeAimAt(player.getUniqueId());
                    }
                    if (n2 > 0) {
                        this.update(player, true);
                    }
                    return null;
                }
                if (this.isShowHoverParticle() && (list2 = this.getLocation(player, this.particleCount)) != null && !list2.isEmpty()) {
                    Location location;
                    if (this.isNewDisplayMethod()) {
                        double d3 = this.isDownOrder() != false ? 0.0 : cMIHologramPage2.getHeight();
                        for (CMIVector3D cMIVector3D : list2) {
                            location = this.getLocation().clone().add(cMIVector3D.getX(), cMIVector3D.getY() + d3 + this.getLineHeight() / 2.0, cMIVector3D.getZ());
                            CMILib.getInstance().getReflectionManager().playEffect(player, location, this.getHoverEffect());
                        }
                    } else {
                        for (CMIVector3D cMIVector3D : list2) {
                            double d4 = cMIVector3D.getY();
                            location = this.getLocation().clone().add(cMIVector3D.getX(), d4 += this.isDownOrder() != false ? this.getSpacing() / 2.0 : cMIHologramPage2.getHeight() - this.getSpacing(), cMIVector3D.getZ());
                            CMILib.getInstance().getReflectionManager().playEffect(player, location, this.getHoverEffect());
                        }
                    }
                }
                double d5 = d2 / (double)n;
                if (this.isNewDisplayMethod()) {
                    d5 = this.getLineHeight();
                }
                double d6 = Math.abs(cMIPlaneIntersection.getLocalLoc().getY()) / d5;
                double d7 = d6 = (d6 = (double)(Math.abs((int)d6) + 1)) > (double)n ? (double)n : d6;
                if (this.isNewDisplayMethod() && !this.isDownOrder().booleanValue()) {
                    d6 = (double)n - d6 + 1.0;
                }
                boolean bl2 = bl = cMIPlaneIntersection.getLocalLoc().getX() < 0.0;
                if (this.getTextAlignment().equals((Object)CMITextAlignment.LEFT) || this.getTextAlignment().equals((Object)CMITextAlignment.RIGHT)) {
                    int n3 = CMI.getInstance().getHologramManager().getPrevPageLength();
                    int n4 = CMI.getInstance().getHologramManager().getNextPageLength();
                    double d8 = (double)n3 / 32.0 * this.getScaleW();
                    double d9 = (double)n4 / 32.0 * this.getScaleW();
                    if (this.getAutoPaginationOffset() == 0) {
                        bl = this.getTextAlignment().equals((Object)CMITextAlignment.LEFT) ? cMIPlaneIntersection.getLocalLoc().getX() + d / 2.0 <= d8 + this.getExtraInteractionWidth() : cMIPlaneIntersection.getLocalLoc().getX() + d / 2.0 < d - d9;
                    }
                }
                CMIHologramHoveringPosition cMIHologramHoveringPosition2 = cMIHologramHoveringPosition = bl ? CMIHologramHoveringPosition.Left : CMIHologramHoveringPosition.Right;
                if (cMIHologramUserData.getHoveringLine() != (int)d6) {
                    cMIHologramUserData.setHoveringSide(cMIHologramHoveringPosition);
                    object = CMI.getInstance().getHologramManager().getAimAt(player.getUniqueId());
                    if (object != null) {
                        CMIHologram cMIHologram = CMI.getInstance().getHologramManager().getByName(((HologramManager.CMIAiming)object).getName());
                        if (cMIHologram != null && !cMIHologram.getName().equals(this.getName())) {
                            double d10;
                            double d11 = CMI.getInstance().getUtilManager().getDistance(player.getLocation(), (Location)cMIHologram.getLocation());
                            if (d11 < (d10 = CMI.getInstance().getUtilManager().getDistance(player.getLocation(), (Location)this.getLocation()))) {
                                cMIHologramUserData.setHoveringLine(-1);
                                return null;
                            }
                            cMIHologram.getData(player).setHoveringLine(-1);
                            cMIHologram.update(player, true);
                            CMI.getInstance().getHologramManager().addAimAt(player.getUniqueId(), this.getName(), cMIPlaneIntersection.getGlobalLoc(), cMIPlaneIntersection.getLocalLoc().getX());
                        }
                    } else {
                        CMI.getInstance().getHologramManager().addAimAt(player.getUniqueId(), this.getName(), cMIPlaneIntersection.getGlobalLoc(), cMIPlaneIntersection.getLocalLoc().getX());
                    }
                    cMIHologramUserData.setHoveringLine((int)d6);
                    this.update(player, true);
                } else {
                    object = CMI.getInstance().getHologramManager().getAimAt(player.getUniqueId());
                    boolean bl3 = false;
                    if (object != null && ((HologramManager.CMIAiming)object).getName().equals(this.getName()) && ((HologramManager.CMIAiming)object).getPos().toString().equals(cMIPlaneIntersection.getGlobalLoc().toString())) {
                        bl3 = true;
                    }
                    if (!cMIHologramUserData.getHoveringSide().equals((Object)cMIHologramHoveringPosition)) {
                        cMIHologramUserData.setHoveringSide(cMIHologramHoveringPosition);
                        this.update(player, true);
                    }
                    if (bl3) {
                        return null;
                    }
                    CMI.getInstance().getHologramManager().addAimAt(player.getUniqueId(), this.getName(), cMIPlaneIntersection.getGlobalLoc());
                    cMIHologramUserData.setHoveringLine((int)d6);
                }
                object = cMIHologramUserData.getFakeInfo();
                if (object != null && ((FakeInfo)object).getEntity() != null) {
                    if (Version.isCurrentEqualOrHigher((Version)Version.v1_20_R1)) {
                        CMILib.getInstance().getReflectionManager().superficialEntityTeleport(player, ((FakeInfo)object).getEntity(), cMIPlaneIntersection.getGlobalLoc().toLocation(player.getWorld()).add(0.0, -0.5, 0.0));
                    } else {
                        CMILib.getInstance().getReflectionManager().superficialEntityTeleport(player, ((FakeInfo)object).getEntity(), cMIPlaneIntersection.getGlobalLoc().toLocation(player.getWorld()).add(0.0, -0.25, 0.0));
                    }
                }
                return null;
            });
        });
    }

    private void modifyIcon(CMIItemDisplay cMIItemDisplay) {
        cMIItemDisplay.setScale(0.5 * this.getIconScale() * this.getScaleH());
        cMIItemDisplay.setBillboard(this.getIconBillboard() == null ? this.getBillboard().getBillboard() : this.getIconBillboard().getBillboard());
        cMIItemDisplay.setItemDisplayTransform(ItemDisplay.ItemDisplayTransform.FIXED);
        cMIItemDisplay.setFacing(this.getIconPitch() + this.getPitch(), this.getIconYaw() + this.getYaw());
        cMIItemDisplay.setRange(this.getShowRange());
    }

    private CMIVector3D getIconPositionOffset(int n) {
        double d = this.isDownOrder() != false ? -((double)n * this.getLineHeight()) + this.getLineHeight() / 1.8 : (double)(this.lineCount - n) * this.getLineHeight() + this.getLineHeight() / 1.8;
        CMIVector3D cMIVector3D = new CMIVector3D(0.0, d, 0.0);
        if (this.getPitch() != 0 && this.getBillboard().equals((Object)CMIBillboard.FIXED)) {
            if (this.isDownOrder().booleanValue()) {
                cMIVector3D = CMIPlaneIntersection.rotateAroundCenter(0.0, d + this.getLineHeight() / 1.2, Math.toRadians(this.getYaw()), Math.toRadians(this.getPitch()));
                double d2 = 0.0;
                if (this.isDownOrder().booleanValue()) {
                    d2 = (double)this.lineCount * this.getLineHeight();
                }
                cMIVector3D.setY(cMIVector3D.getY() - d2);
            } else {
                cMIVector3D = CMIPlaneIntersection.rotateAroundCenter(0.0, d, Math.toRadians(this.getYaw()), Math.toRadians(-this.getPitch()));
                cMIVector3D.setY(-cMIVector3D.getY());
            }
        }
        return cMIVector3D;
    }

    private void newUpdate(Player player) {
        Object object;
        Object object2;
        if (this.loc.getWorld() == null) {
            return;
        }
        if (!player.isOnline()) {
            this.removeData(player);
            return;
        }
        CMIHologramUserData cMIHologramUserData = this.getData(player);
        List<CMIHologramLine> list2 = this.getLinesByPlayerPage(player);
        if (list2.isEmpty()) {
            return;
        }
        int n = cMIHologramUserData.getPage();
        ArrayList<CMIHologramLine> arrayList = new ArrayList<CMIHologramLine>();
        int n2 = 0;
        while (n2 < list2.size()) {
            object2 = list2.size() - 1 < n2 || n2 < 0 ? new CMIHologramLine("") : (list2.get(n2) == null ? new CMIHologramLine("") : list2.get(n2));
            arrayList.add((CMIHologramLine)object2);
            ++n2;
        }
        ArrayList arrayList2 = new ArrayList(arrayList);
        if (this.playersInHologramVisibilityRange.isEmpty() && this.playersInHologramUpdateRange.isEmpty()) {
            return;
        }
        object2 = this.pages.get(n);
        if (object2 == null) {
            return;
        }
        arrayList2.clear();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        CMIHologramBatch cMIHologramBatch = cMIHologramUserData.getHologramBatch();
        this.lineCount = arrayList.size();
        if (this.isAutoPagination()) {
            ++this.lineCount;
        }
        if (!this.playersInHologramVisibilityRange.contains(player.getUniqueId()) && !this.playersInHologramUpdateRange.contains(player.getUniqueId())) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        for (final CMIHologramLine object3 : arrayList) {
            ++n4;
            switch (object3.getType()) {
                case icon: 
                case staticIcon: {
                    List<String> list3;
                    Object object4;
                    CMIItemDisplay cMIItemDisplay = null;
                    if (cMIHologramBatch.getIcon(n4) != null) {
                        cMIItemDisplay = (CMIItemDisplay)cMIHologramBatch.getIcon(n4);
                    } else {
                        object4 = this.getIconPositionOffset(n4);
                        cMIItemDisplay = new CMIItemDisplay(this.loc.clone().add(((CMIVector3D)object4).getX() + (double)n4 * 1.0E-4, ((CMIVector3D)object4).getY() + (double)n4 * 1.0E-4, ((CMIVector3D)object4).getZ() + (double)n4 * 1.0E-4));
                        this.modifyIcon(cMIItemDisplay);
                        object = cMIItemDisplay;
                        CMIScheduler.runAtLocation((Location)cMIItemDisplay.getLocation(), () -> this.lambda$3(player, (CMIItemDisplay)object));
                        if (cMIHologramBatch.getIcon(n4) != null) {
                            return;
                        }
                        cMIHologramBatch.addIcon(n4, cMIItemDisplay);
                    }
                    object4 = cMIItemDisplay;
                    object = new CMIAsyncHead((CMIItemDisplay)object4, player){
                        private final /* synthetic */ CMIItemDisplay val$d;
                        private final /* synthetic */ Player val$player;
                        {
                            this.val$d = cMIItemDisplay;
                            this.val$player = player;
                        }

                        public void afterAsyncUpdate(ItemStack itemStack) {
                            object3.setItem(new CMIItemStack(itemStack));
                            this.val$d.setItemStack(itemStack);
                            this.val$d.update(this.val$player);
                        }
                    };
                    object.setForce(true);
                    CMIItemStack cMIItemStack = object3.getItem(player, (CMIAsyncHead)object);
                    if (cMIItemStack != null) {
                        cMIItemDisplay.setItemStack(cMIItemStack);
                        this.modifyIcon(cMIItemDisplay);
                        if (Version.isFolia()) {
                            CMIScheduler.runAtLocation((Location)((CMIDisplay)object4).getLocation(), () -> this.lambda$4((CMIItemDisplay)object4, cMIItemStack, player));
                        } else if (cMIItemDisplay.getItemStack() == null || cMIItemDisplay.getItemStack().getType().isAir() || !cMIItemDisplay.getItemStack().equals((Object)cMIItemStack.getItemStack())) {
                            CMIScheduler.runAtLocation((Location)((CMIDisplay)object4).getLocation(), () -> this.lambda$5(player, (CMIItemDisplay)object4));
                        } else {
                            cMIItemDisplay.update(player);
                        }
                    } else {
                        list3 = null;
                        cMIItemDisplay.setItemStack((ItemStack)list3);
                        CMIScheduler.runAtLocation((Location)((CMIDisplay)object4).getLocation(), () -> this.lambda$6(player, (CMIItemDisplay)object4));
                    }
                    if (n3 == 0) {
                        arrayList3.add(" ");
                    } else {
                        arrayList3.add("");
                    }
                    ++n3;
                    break;
                }
                case image: {
                    List<String> list3 = object3.getPlainImage();
                    if (list3 == null) break;
                    arrayList3.addAll(list3);
                    n3 += list3.size();
                    break;
                }
                case plainText: 
                case placeholder: {
                    int n5 = cMIHologramUserData.getHoveringLine();
                    String string = "";
                    string = n5 == ++n3 ? (object3.getHoverText() == null ? object3.getText(player) : object3.getHoverText(player)) : object3.getText(player);
                    arrayList3.add(CMI.getInstance().getPlaceholderAPIManager().updatePlaceHolders(player, string.isEmpty() ? " " : string));
                    break;
                }
            }
        }
        if (this.isAutoPagination()) {
            StringBuilder d = new StringBuilder();
            CMIHologramHoveringPosition cMIHologramHoveringPosition = cMIHologramUserData.getHoveringSide();
            int cMITextDisplay = cMIHologramUserData.getHoveringLine();
            if (!cMIHologramHoveringPosition.equals((Object)CMIHologramHoveringPosition.None) && cMITextDisplay == this.lineCount) {
                switch (cMIHologramHoveringPosition) {
                    case Left: {
                        d.append(CMI.getInstance().getHologramManager().getPrevPageSection().getHoverText());
                        d.append(CMI.getInstance().getHologramManager().getNextPageSection().getText());
                        break;
                    }
                    case None: {
                        break;
                    }
                    case Right: {
                        d.append(CMI.getInstance().getHologramManager().getPrevPageSection().getText());
                        d.append(CMI.getInstance().getHologramManager().getNextPageSection().getHoverText());
                        break;
                    }
                }
            } else {
                d.append(CMI.getInstance().getHologramManager().getPrevPageSection().getText());
                d.append(CMI.getInstance().getHologramManager().getNextPageSection().getText());
            }
            if (!this.getTextAlignment().equals((Object)CMITextAlignment.CENTER)) {
                int cMITextDisplay2 = 0;
                while (cMITextDisplay2 < this.getAutoPaginationOffset()) {
                    if (this.getTextAlignment().equals((Object)CMITextAlignment.LEFT)) {
                        d.insert(0, " ");
                    } else {
                        d.append(" ");
                    }
                    ++cMITextDisplay2;
                }
            }
            arrayList3.add(d.toString());
        }
        if (arrayList3.isEmpty()) {
            return;
        }
        if (!this.playersInHologramVisibilityRange.contains(player.getUniqueId()) && !this.playersInHologramUpdateRange.contains(player.getUniqueId())) {
            return;
        }
        double d = 0.0;
        if (this.isDownOrder().booleanValue()) {
            d = (double)arrayList3.size() * this.getLineHeight();
        }
        if (cMIHologramBatch.getDisplay(1) == null) {
            if (this.fadeInAnimation) {
                cMIHologramUserData.initializeFadeInAnimation(this.getScaleH(), (double)this.getBackgroundAlpha() / 255.0, (double)this.getTextAlpha() / 255.0);
            }
            CMITextDisplay cMITextDisplay = this.createDisplay(cMIHologramUserData, arrayList3, -d, true);
            cMIHologramBatch.addDisplay(1, cMITextDisplay);
            CMITextDisplay cMITextDisplay2 = cMITextDisplay;
            object = CMIScheduler.runAtLocation((Location)cMITextDisplay2.getLocation(), () -> cMITextDisplay2.show(player));
            if (this.isDoubleSided() && this.getBillboard().equals((Object)CMIBillboard.FIXED)) {
                double d2 = d;
                ((CompletableFuture)object).thenApply(void_ -> {
                    CMITextDisplay cMITextDisplay = this.createDisplay(cMIHologramUserData, arrayList3, -d2, false);
                    cMIHologramBatch.addDisplay(2, cMITextDisplay);
                    CMIScheduler.runAtLocation((Location)cMITextDisplay.getLocation(), () -> cMITextDisplay.show(player));
                    return null;
                });
            }
            if (this.fadeInAnimation) {
                cMIHologramUserData.startFadeInAnimation(this, player);
            }
        }
        ((CMIHologramPage)object2).setHeight((double)this.lineCount * this.getLineHeight());
        int n6 = 0;
        for (CMIDisplay cMIDisplay : cMIHologramBatch.getDisplays().values()) {
            if (!(cMIDisplay instanceof CMITextDisplay)) continue;
            ((CMITextDisplay)cMIDisplay).setText(arrayList3);
            if (++n6 > 1 && !this.getBillboard().equals((Object)CMIBillboard.FIXED)) {
                cMIDisplay.destroy(player);
                continue;
            }
            this.updateDisplaySettings(cMIHologramUserData, (CMITextDisplay)cMIDisplay, n6 == 1);
            cMIDisplay.update(player);
        }
        cMIHologramUserData.setHologramBatch(cMIHologramBatch);
        this.addInteractionCheck(player);
    }

    private void addInteractionCheck(Player player) {
        if (!this.isInteractable() || this.getPitch() != 0 || this.getPitch() != 0 && this.getBillboard().equals((Object)CMIBillboard.FIXED)) {
            return;
        }
        CMIHologramUserData cMIHologramUserData = this.getData(player);
        FakeInfo fakeInfo = cMIHologramUserData.getFakeInfo();
        if (fakeInfo != null) {
            return;
        }
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_20_R1)) {
            CMIInteractionEntity cMIInteractionEntity = new CMIInteractionEntity(this.getCenterLocation());
            FakeInfo fakeInfo2 = new FakeInfo().setObj(this).setPlayer(player).setId(cMIInteractionEntity.getId());
            fakeInfo2.setEntity(cMIInteractionEntity.getDisplay());
            this.clickableById.put(fakeInfo2.getId(), fakeInfo2);
            cMIHologramUserData.setFakeInfo(fakeInfo2);
            PacketHandler.addFakeEntity(fakeInfo2);
            CMIScheduler.runAtLocation((Location)cMIInteractionEntity.getLocation(), () -> cMIInteractionEntity.show(player));
            return;
        }
        FakeInfo fakeInfo3 = CMI.getInstance().getNMS().spawnClickable(player, this.getCenterLocation(), this, this.bigButton);
        if (fakeInfo3 == null) {
            return;
        }
        this.clickableById.put(fakeInfo3.getId(), fakeInfo3);
        cMIHologramUserData.setFakeInfo(fakeInfo3);
        PacketHandler.addFakeEntity(fakeInfo3);
    }

    private void oldUpdate(Player player, boolean bl) {
        CMIHologram cMIHologram = this;
        CMIHologramUserData cMIHologramUserData = this.getData(player);
        if (this.loc.getWorld() == null) {
            return;
        }
        try {
            FakeInfo fakeInfo;
            Object object;
            Object object2;
            Object object3;
            Block block;
            if (!player.isOnline()) {
                this.removeData(player);
                return;
            }
            if (this.isCheckLineOfSight() && (block = CMI.getInstance().getNMS().getBlockLookingAt(this.getLocation().getWorld(), player.getEyeLocation().toVector(), this.getCenterLocation().toVector(), false)) != null) {
                return;
            }
            block = this.getLinesByPlayerPage(player);
            if (block == null || block.isEmpty()) {
                return;
            }
            int n = cMIHologramUserData.getPage();
            int n2 = 0;
            for (Map.Entry<Integer, CMIHologramPage> entry : this.pages.entrySet()) {
                if (entry.getKey() == n) break;
                n2 += entry.getValue().getLines().size() + 1;
            }
            int n3 = n2;
            ArrayList arrayList = new ArrayList();
            int n4 = 0;
            while (n4 < block.size()) {
                object3 = block.size() - 1 < n4 || n4 < 0 ? new CMIHologramLine("") : (block.get(n4) == null ? new CMIHologramLine("") : (CMIHologramLine)block.get(n4));
                arrayList.add(object3);
                ++n4;
            }
            ArrayList arrayList2 = new ArrayList(arrayList);
            if (!this.isDownOrder().booleanValue()) {
                int n5 = 0;
                int n6 = arrayList2.size() - 1;
                while (n6 >= 0) {
                    arrayList.set(n6, (CMIHologramLine)arrayList2.get(n5));
                    ++n5;
                    --n6;
                }
            }
            if (this.playersInHologramVisibilityRange.isEmpty() && this.playersInHologramUpdateRange.isEmpty() && !bl) {
                return;
            }
            object3 = this.pages.get(n);
            if (object3 == null) {
                return;
            }
            Double d = 0.0;
            int n7 = -1;
            int n8 = 0;
            while (n8 < arrayList.size()) {
                Object object4;
                object2 = (CMIHologramLine)arrayList.get(n8);
                object = new ArrayList<String>(Arrays.asList(((CMIHologramLine)object2).getText()));
                if (((CMIHologramLine)object2).getType() == CMIHoloLineType.image) {
                    object.clear();
                    object4 = ((CMIHologramLine)object2).getPlainImage();
                    if (object4 != null) {
                        object.addAll(object4);
                        if (!this.isDownOrder().booleanValue()) {
                            Collections.reverse(object);
                        }
                    }
                }
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object object5;
                    object4 = (String)iterator.next();
                    CMIDataWatcher cMIDataWatcher = this.getCache(player.getUniqueId(), ++n7);
                    if (((CMIHologramLine)object2).getType() != CMIHoloLineType.image && ((CMIHologramLine)object2).isStaticText() && cMIDataWatcher != null && !this.changed.containsKey(n3 + n7)) continue;
                    if (cMIDataWatcher == null) {
                        object5 = this.loc.clone();
                        if (this.isDownOrder().booleanValue()) {
                            object5.add(0.0, -((double)n7 * this.getSpacing()), 0.0);
                            object5.add(0.0, d.doubleValue(), 0.0);
                        } else {
                            object5.add(0.0, (double)n7 * this.getSpacing(), 0.0);
                            object5.add(0.0, -d.doubleValue(), 0.0);
                        }
                        int n9 = n7;
                        if (((CMIHologramLine)object2).getType() == CMIHoloLineType.staticIcon) {
                            CMIAsyncHead cMIAsyncHead = new CMIAsyncHead((CMIHologramLine)object2, player, n9, (Location)object5){
                                private final /* synthetic */ CMIHologramLine val$one;
                                private final /* synthetic */ Player val$player;
                                private final /* synthetic */ int val$ao;
                                private final /* synthetic */ Location val$lc;
                                {
                                    this.val$one = cMIHologramLine;
                                    this.val$player = player;
                                    this.val$ao = n;
                                    this.val$lc = location;
                                }

                                public void afterAsyncUpdate(ItemStack itemStack) {
                                    this.val$one.setItem(new CMIItemStack(itemStack));
                                    CMIDataWatcher cMIDataWatcher = CMIHologram.this.getCache(this.val$player.getUniqueId(), this.val$ao);
                                    if (cMIDataWatcher != null) {
                                        CMIScheduler.runTask(() -> {
                                            CMI.getInstance().getNMS().removeHologram(this.val$player, cMIDataWatcher.getId());
                                            if (cMIDataWatcher.getLoc() != null) {
                                                CMIDataWatcher cMIDataWatcher2 = CMI.getInstance().getNMS().spawnHologram(this.val$player, this.val$lc, null, itemStack);
                                                cMIDataWatcher.setId(cMIDataWatcher2.getId());
                                                cMIDataWatcher.setStand(cMIDataWatcher2.getStand());
                                            }
                                            cMIDataWatcher.setItem(this.val$one.getItem());
                                            if (this.val$player.isOnline()) {
                                                CMIHologram.this.updateCache(this.val$player.getUniqueId(), this.val$ao, cMIDataWatcher);
                                            }
                                            cMIDataWatcher.setUpdatingHead(false);
                                        });
                                    }
                                }
                            };
                            cMIAsyncHead.setForce(true);
                            CMIItemStack cMIItemStack = ((CMIHologramLine)object2).getItem(player, cMIAsyncHead);
                            CMIScheduler.runTask(() -> this.lambda$11(player, (Location)object5, cMIItemStack, n9));
                            continue;
                        }
                        if (((CMIHologramLine)object2).getType() == CMIHoloLineType.icon) {
                            double d2 = -(this.getIconSpacing() / 2.0);
                            if (this.isDownOrder().booleanValue()) {
                                d2 -= this.getSpacing().doubleValue();
                                object5.add(0.0, this.getIconSpacing() / 4.0 - 0.1, 0.0);
                            }
                            d = d + d2;
                            if (this.isDownOrder().booleanValue()) {
                                d = d + this.getSpacing();
                            }
                            object5.add(0.0, d2, 0.0);
                            CMIAsyncHead cMIAsyncHead = new CMIAsyncHead((CMIHologramLine)object2, player, n9){
                                private final /* synthetic */ CMIHologramLine val$one;
                                private final /* synthetic */ Player val$player;
                                private final /* synthetic */ int val$ao;
                                {
                                    this.val$one = cMIHologramLine;
                                    this.val$player = player;
                                    this.val$ao = n;
                                }

                                public void afterAsyncUpdate(ItemStack itemStack) {
                                    this.val$one.setItem(new CMIItemStack(itemStack));
                                    CMIDataWatcher cMIDataWatcher = CMIHologram.this.getCache(this.val$player.getUniqueId(), this.val$ao);
                                    if (cMIDataWatcher != null) {
                                        CMIScheduler.runTask(() -> {
                                            CMI.getInstance().getNMS().removeHologram(this.val$player, cMIDataWatcher.getId());
                                            if (cMIDataWatcher.getLoc() != null) {
                                                CMIDataWatcher cMIDataWatcher2 = CMI.getInstance().getNMS().makeFloatingIcon(this.val$player, cMIDataWatcher.getLoc(), itemStack, this.val$one.isGlowing());
                                                cMIDataWatcher.setId(cMIDataWatcher2.getId());
                                                cMIDataWatcher.setStand(cMIDataWatcher2.getStand());
                                            }
                                            cMIDataWatcher.setItem(this.val$one.getItem());
                                            if (this.val$player.isOnline()) {
                                                CMIHologram.this.updateCache(this.val$player.getUniqueId(), this.val$ao, cMIDataWatcher);
                                            }
                                            cMIDataWatcher.setUpdatingHead(false);
                                        });
                                    }
                                }
                            };
                            cMIAsyncHead.setForce(true);
                            CMIItemStack cMIItemStack = ((CMIHologramLine)object2).getItem(player, cMIAsyncHead);
                            CMIScheduler.runTask(() -> this.lambda$12(cMIItemStack, player, (Location)object5, (CMIHologramLine)object2, cMIAsyncHead, n9));
                            continue;
                        }
                        if (((CMIHologramLine)object2).getType() != CMIHoloLineType.plainText && ((CMIHologramLine)object2).getType() != CMIHoloLineType.placeholder && ((CMIHologramLine)object2).getType() != CMIHoloLineType.image || !player.isOnline()) continue;
                        CMIScheduler.runTask(() -> this.lambda$13((CMIHologramLine)object2, player, (Location)object5, (String)object4, n9));
                        continue;
                    }
                    if (((CMIHologramLine)object2).isIcon() && !cMIDataWatcher.isUpdatingHead()) {
                        object5 = ((CMIHologramLine)object2).getItem(player);
                        if (!(cMIDataWatcher.getItem() == null && object5 != null || cMIDataWatcher.getItem() != null && object5 == null) && (object5 == null || cMIDataWatcher.getItem() == null || cMIDataWatcher.getItem().getType().equals((Object)object5.getType()) && cMIDataWatcher.getItem().getAmount() == object5.getAmount() && cMIDataWatcher.getItem().isSimilar((CMIItemStack)object5))) continue;
                        CMI.getInstance().getNMS().removeHologram(player, cMIDataWatcher.getId());
                        if (object5 != null && object5.getCMIType().isAir()) {
                            cMIDataWatcher.setItem(null);
                            continue;
                        }
                        CMIDataWatcher cMIDataWatcher2 = null;
                        if (object5 != null && object5.getItemStack() != null) {
                            if (cMIDataWatcher.getLoc() != null) {
                                cMIDataWatcher2 = ((CMIHologramLine)object2).getType() == CMIHoloLineType.staticIcon ? CMI.getInstance().getNMS().spawnHologram(player, cMIDataWatcher.getLoc(), null, object5.getItemStack()) : CMI.getInstance().getNMS().makeFloatingIcon(player, cMIDataWatcher.getLoc(), object5.getItemStack(), ((CMIHologramLine)object2).isGlowing());
                                cMIDataWatcher.setId(cMIDataWatcher2.getId());
                                cMIDataWatcher.setStand(cMIDataWatcher2.getStand());
                            }
                            cMIDataWatcher.setItem((CMIItemStack)object5);
                            continue;
                        }
                        if (cMIDataWatcher.getLoc() != null) {
                            cMIDataWatcher2 = CMI.getInstance().getNMS().spawnHologram(player, cMIDataWatcher.getLoc(), null, null);
                            cMIDataWatcher.setId(cMIDataWatcher2.getId());
                            cMIDataWatcher.setStand(cMIDataWatcher2.getStand());
                        }
                        cMIDataWatcher.setItem(null);
                        continue;
                    }
                    if (((CMIHologramLine)object2).getType() == CMIHoloLineType.image) {
                        if (!player.isOnline()) continue;
                        CMI.getInstance().getNMS().updateHologram(player, cMIDataWatcher, (String)object4, null);
                        continue;
                    }
                    if (this.isNewIneractionMethod()) {
                        if (cMIHologramUserData.getHoveringLine() - 1 == n7) {
                            if (((CMIHologramLine)object2).getHoverText() == null) {
                                CMI.getInstance().getNMS().updateHologram(player, cMIDataWatcher, ((CMIHologramLine)object2).getText(player), null);
                                continue;
                            }
                            CMI.getInstance().getNMS().updateHologram(player, cMIDataWatcher, ((CMIHologramLine)object2).getHoverText(player), null);
                            continue;
                        }
                        object5 = ((CMIHologramLine)object2).getText(player);
                        if (!((String)object5).isEmpty()) {
                            CMI.getInstance().getNMS().updateHologram(player, cMIDataWatcher, (String)object5, null);
                            continue;
                        }
                        CMI.getInstance().getNMS().updateHologram(player, cMIDataWatcher, null, null);
                        continue;
                    }
                    CMI.getInstance().getNMS().updateHologram(player, cMIDataWatcher, ((CMIHologramLine)object2).getText(player), null);
                }
                ++n8;
            }
            if (this.isInteractable() && (fakeInfo = cMIHologramUserData.getFakeInfo()) == null) {
                if (Version.isCurrentEqualOrHigher((Version)Version.v1_20_R1)) {
                    object2 = new CMIInteractionEntity(this.getCenterLocation());
                    object = new FakeInfo().setObj(this).setPlayer(player).setId(((CMIDisplay)object2).getId());
                    ((FakeInfo)object).setEntity(((CMIDisplay)object2).getDisplay());
                    this.clickableById.put(((FakeInfo)object).getId(), (FakeInfo)object);
                    cMIHologramUserData.setFakeInfo((FakeInfo)object);
                    PacketHandler.addFakeEntity((FakeInfo)object);
                    CMIScheduler.runAtLocation((Location)((CMIDisplay)object2).getLocation(), () -> CMIHologram.lambda$14((CMIInteractionEntity)object2, player));
                } else {
                    object2 = null;
                    object2 = !this.isNewIneractionMethod() ? CMI.getInstance().getNMS().spawnClickable(player, this.getCenterLocation(), cMIHologram, this.bigButton) : CMI.getInstance().getNMS().spawnClickable(player, this.getCenterLocation(), cMIHologram, this.bigButton);
                    if (object2 != null) {
                        this.clickableById.put(((FakeInfo)object2).getId(), (FakeInfo)object2);
                        cMIHologramUserData.setFakeInfo((FakeInfo)object2);
                        PacketHandler.addFakeEntity((FakeInfo)object2);
                    }
                }
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    private CMITextDisplay createDisplay(CMIHologramUserData cMIHologramUserData, List<String> list2, double d, boolean bl) {
        CMITextDisplay cMITextDisplay = new CMITextDisplay(this.loc.clone().add(0.0, d, 0.0));
        cMITextDisplay.setText(list2);
        this.updateDisplaySettings(cMIHologramUserData, cMITextDisplay, bl);
        return cMITextDisplay;
    }

    private void updateAnimation(CMIHologramUserData cMIHologramUserData, CMITextDisplay cMITextDisplay) {
        if (this.isFadeInAnimation() && cMIHologramUserData.getFadeInAnimation() != null && !cMIHologramUserData.getFadeInAnimation().finished()) {
            cMITextDisplay.setHeight(this.getScaleH());
            cMITextDisplay.setBackgroundColor(CMIHologramAnimation.applyAlpha(this.getBackgroundColor().getRGBColor(), (int)(cMIHologramUserData.getFadeInAnimation().get(CMIHologramAnimationType.Opacity).getCurrent() * 255.0)));
            cMITextDisplay.setTextOpacity((byte)(cMIHologramUserData.getFadeInAnimation().get(CMIHologramAnimationType.TextOpacity).getCurrent() * 255.0));
            return;
        }
        cMITextDisplay.setBackgroundColor(this.getBackgroundColor().getRGBColor().setAlpha(this.getBackgroundAlpha()));
        cMITextDisplay.setHeight(this.getScaleH());
        cMITextDisplay.setTextOpacity((byte)this.getTextAlpha());
    }

    private void updateDisplaySettings(CMIHologramUserData cMIHologramUserData, CMITextDisplay cMITextDisplay, boolean bl) {
        cMITextDisplay.setShadowed(this.isShadowed());
        cMITextDisplay.setLineWidth(1000);
        cMITextDisplay.setBillboard(this.getBillboard().getBillboard());
        cMITextDisplay.setAligment(this.getTextAlignment().getTextAlignment());
        this.updateAnimation(cMIHologramUserData, cMITextDisplay);
        cMITextDisplay.setWidth(this.getScaleW());
        cMITextDisplay.setRange(this.getShowRange());
        if (this.getSkyLevel() > -1 || this.getBlockLevel() > -1) {
            cMITextDisplay.setBrightness(this.getSkyLevel(), this.getBlockLevel());
        }
        if (this.isSeeThrough()) {
            cMITextDisplay.setSeeThrough(true);
        }
        if (this.getBillboard().equals((Object)CMIBillboard.FIXED)) {
            if (bl) {
                cMITextDisplay.setFacing(this.getPitch(), this.getYaw());
            } else {
                cMITextDisplay.setFacing(-this.getPitch(), (this.getYaw() + 180) % 360);
            }
        }
    }

    void generalUpdate(Player player, boolean bl) {
        CMIHologramUserData cMIHologramUserData = this.getData(player);
        CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> {
            if (!this.playersInHologramVisibilityRange.contains(player.getUniqueId())) {
                return;
            }
            if (Version.isCurrentEqualOrHigher((Version)Version.v1_19_R3) && this.newDisplayMethod) {
                try {
                    this.newUpdate(player);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                return;
            }
            this.oldUpdate(player, bl);
        });
        cMIHologramUserData.addBatch(completableFuture);
    }

    public void update(Player player, boolean bl) {
        if (Version.isCurrentEqualOrLower((Version)Version.v1_7_R4)) {
            return;
        }
        if (player == null || !player.isOnline()) {
            return;
        }
        if (!this.playersInHologramVisibilityRange.contains(player.getUniqueId())) {
            return;
        }
        if (!this.enabled || !CMI.getInstance().isEnabled()) {
            return;
        }
        CMIHologramUserData cMIHologramUserData = this.getData(player);
        long l = cMIHologramUserData.getNextUpdate();
        if (l != 0L && l > System.currentTimeMillis()) {
            return;
        }
        cMIHologramUserData.setNextUpdate(System.currentTimeMillis() + 40L);
        this.generalUpdate(player, bl);
    }

    public void removeFromCache(UUID uUID) {
        CMIHologramUserData cMIHologramUserData = this.getData(uUID);
        CMIHologramBatch cMIHologramBatch = cMIHologramUserData.getHologramBatch();
        if (cMIHologramBatch != null) {
            cMIHologramBatch.destroy(CMIUser.getOnlinePlayer(uUID));
            cMIHologramUserData.setHologramBatch(null);
        }
        cMIHologramUserData.setNextUpdate(0L);
        Player player = CMIUser.getOnlinePlayer(uUID);
        if (player == null || !player.isOnline()) {
            return;
        }
        FakeInfo fakeInfo = cMIHologramUserData.getFakeInfo();
        if (fakeInfo != null) {
            this.clickableById.remove(fakeInfo.getId());
            PacketHandler.removeFakeEntity(fakeInfo);
            CMI.getInstance().getNMS().removeHologram(player, fakeInfo.getId());
        }
        cMIHologramUserData.setFakeInfo(null);
        List<CMIDataWatcher> list2 = cMIHologramUserData.getDataWatcher();
        if (list2 != null) {
            for (CMIDataWatcher cMIDataWatcher : list2) {
                if (cMIDataWatcher == null) continue;
                CMI.getInstance().getNMS().removeHologram(player, cMIDataWatcher.getId());
            }
            cMIHologramUserData.setDataWatcher(null);
        }
        this.removeData(uUID);
    }

    public void clearFakeEntities() {
        PacketHandler.clearFakeEntities();
    }

    private void clearIconLines(UUID uUID, CMIHologramPage cMIHologramPage) {
        Object object;
        CMIHologramUserData cMIHologramUserData = this.getData(uUID);
        if (this.isNewDisplayMethod()) {
            for (CMIDisplay cMIDisplay : cMIHologramUserData.getHologramBatch().getIcons().values()) {
                cMIDisplay.destroy(CMIUser.getOnlinePlayer(uUID));
            }
            cMIHologramUserData.getHologramBatch().getIcons().clear();
            return;
        }
        List<CMIDataWatcher> list2 = cMIHologramUserData.getDataWatcher();
        if (list2 == null) {
            return;
        }
        Player player = CMIUser.getOnlinePlayer(uUID);
        if (player == null || !player.isOnline()) {
            return;
        }
        int n = list2.size() - 1;
        while (n >= 0) {
            object = list2.get(n);
            if (object != null && (((CMIDataWatcher)object).getType() == CMIHoloLineType.icon || ((CMIDataWatcher)object).getType() == CMIHoloLineType.staticIcon)) {
                this.removeFromCache(uUID);
                break;
            }
            --n;
        }
        n = 0;
        while (n < cMIHologramPage.getLines().size()) {
            object = cMIHologramPage.getLines().get(n);
            if (((CMIHologramLine)object).getType() == CMIHoloLineType.icon || ((CMIHologramLine)object).getType() == CMIHoloLineType.staticIcon) {
                this.removeFromCache(uUID);
                break;
            }
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void removeFromCache(UUID var1_1, int var2_2) {
        var3_3 = this.getData(var1_1);
        var4_4 = var3_3.getHologramBatch();
        if (var4_4 != null) {
            var4_4.destroy(CMIUser.getOnlinePlayer(var1_1));
            var3_3.setHologramBatch(null);
        }
        var3_3.setNextUpdate(0L);
        try {
            var5_5 = var3_3.getDataWatcher();
            if (var5_5 == null) {
                return;
            }
            var6_7 = CMIUser.getOnlinePlayer(var1_1);
            if (var6_7 != null && var6_7.isOnline()) ** GOTO lbl19
            return;
lbl-1000:
            // 1 sources

            {
                if (this.isDownOrder().booleanValue()) {
                    var5_5.add(null);
                    continue;
                }
                var5_5.add(0, null);
lbl19:
                // 3 sources

                ** while (var5_5.size() <= var2_2)
            }
lbl20:
            // 1 sources

            if (var5_5.size() > var2_2) {
                var7_8 = var5_5.size();
                var8_10 = var2_2;
                while (var8_10 < var7_8) {
                    var9_11 = null;
                    var9_11 = this.isDownOrder() != false ? var5_5.remove(var5_5.size() - 1) : var5_5.remove(0);
                    if (var9_11 != null) {
                        CMI.getInstance().getNMS().removeHologram(var6_7, var9_11.getId());
                    }
                    ++var8_10;
                }
            }
            if ((var7_9 = var3_3.getFakeInfo()) != null) {
                var3_3.setFakeInfo(null);
                this.clickableById.remove(var7_9.getId());
                PacketHandler.removeFakeEntity(var7_9);
                CMI.getInstance().getNMS().removeHologram(var6_7, var7_9.getId());
            }
        }
        catch (Throwable var5_6) {
            var5_6.printStackTrace();
        }
    }

    private void updateCache(UUID uUID, int n, CMIDataWatcher cMIDataWatcher) {
        CMIHologramUserData cMIHologramUserData = this.getData(uUID);
        List<CMIDataWatcher> list2 = cMIHologramUserData.getDataWatcher();
        if (list2 == null) {
            list2 = new ArrayList<CMIDataWatcher>();
            cMIHologramUserData.setDataWatcher(list2);
        }
        if (list2.size() - 1 < n) {
            while (list2.size() - 1 < n - 1) {
                list2.add(null);
            }
            list2.add(cMIDataWatcher);
        } else {
            list2.set(n, cMIDataWatcher);
        }
    }

    private CMIDataWatcher getCache(UUID uUID, int n) {
        CMIHologramUserData cMIHologramUserData = this.getData(uUID);
        List<CMIDataWatcher> list2 = cMIHologramUserData.getDataWatcher();
        if (list2 == null) {
            list2 = new ArrayList<CMIDataWatcher>();
            cMIHologramUserData.setDataWatcher(list2);
        }
        return list2.size() - 1 < n ? null : list2.get(n);
    }

    public double getUpdateIntervalSec() {
        return this.updateIntervalSec;
    }

    public void setUpdateIntervalSec(double d) {
        this.updateIntervalSec = Math.ceil((int)(d * 100.0)) / 100.0;
        if (this.updateIntervalSec <= 0.0) {
            this.updateIntervalSec = 0.0;
        }
    }

    public int getUpdateRange() {
        this.updateRange = this.updateRange > this.showRange ? this.showRange : this.updateRange;
        return this.updateRange;
    }

    public void setUpdateRange(int n) {
        this.updateRange = n;
        if (this.updateRange < 1) {
            this.updateRange = 1;
        }
        if (!this.isNewDisplayMethod() && this.updateRange > 64) {
            this.updateRange = 64;
        }
        if (this.isNewDisplayMethod() && this.updateRange > 128) {
            this.updateRange = 128;
        }
        if (this.updateRange > this.showRange) {
            this.updateRange = this.showRange;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getShowRange() {
        this.showRange = this.showRange < this.updateRange ? this.updateRange : this.showRange;
        return this.showRange;
    }

    public void setShowRange(int n) {
        this.showRange = n;
        if (this.showRange < 1) {
            this.showRange = 1;
        }
        if (!this.isNewDisplayMethod() && this.showRange > 64) {
            this.showRange = 64;
        }
        if (this.isNewDisplayMethod() && this.showRange > 128) {
            this.showRange = 128;
        }
        if (this.showRange < this.updateRange) {
            n = this.updateRange;
        }
    }

    public Double getIconSpacing() {
        return this.iconSpacing;
    }

    public void setIconSpacing(Double d) {
        this.iconSpacing = d;
        this.updatePages();
    }

    public Double getSpacing() {
        return this.spacing;
    }

    public void setSpacing(Double d) {
        this.spacing = d;
        this.updatePages();
    }

    public Boolean isDownOrder() {
        return this.downOrder;
    }

    public void setDownOrder(Boolean bl) {
        this.downOrder = bl;
    }

    public boolean isInteractable() {
        return this.interactable;
    }

    public void setInteractable(boolean bl) {
        this.interactable = bl;
    }

    public boolean isShowParticle() {
        return this.showParticle;
    }

    public void setShowParticle(boolean bl) {
        this.showParticle = bl;
    }

    public boolean isBigButton() {
        return this.bigButton;
    }

    public void setBigButton(boolean bl) {
        this.bigButton = bl;
    }

    public CMITask getSched() {
        return this.schedId;
    }

    public void setSched(CMITask cMITask) {
        if (this.schedId != null) {
            this.schedId.cancel();
        }
        this.schedId = cMITask;
    }

    public void stop() {
        if (this.lineOfSightSchedId != null) {
            this.lineOfSightSchedId.cancel();
            this.lineOfSightSchedId = null;
        }
        if (this.schedId != null) {
            this.schedId.cancel();
            this.schedId = null;
        }
        if (this.pageSchedId != null) {
            this.pageSchedId.cancel();
            this.pageSchedId = null;
        }
        if (this.hoverOverSchedId != null) {
            this.hoverOverSchedId.cancel();
            this.hoverOverSchedId = null;
        }
        for (CMIHologramUserData cMIHologramUserData : this.userData.values()) {
            cMIHologramUserData.setHoveringLine(-1);
        }
    }

    private void tasker() {
        if (this.playersInHologramUpdateRange.isEmpty()) {
            if (this.schedId != null) {
                this.schedId.cancel();
                this.schedId = null;
            }
            return;
        }
        if (this.schedId != null) {
            return;
        }
        if (this.updateIntervalSec <= 0.0) {
            if (this.schedId != null) {
                this.schedId.cancel();
                this.schedId = null;
            }
            return;
        }
        int n = (int)(this.updateIntervalSec * 1000.0 / 50.0);
        if (n <= 0) {
            return;
        }
        if (n < 1) {
            n = 1;
        }
        boolean bl = true;
        block0: for (Map.Entry<Integer, CMIHologramPage> entry : this.pages.entrySet()) {
            for (CMIHologramLine cMIHologramLine : entry.getValue().getLines()) {
                if (cMIHologramLine.isStaticText()) continue;
                bl = false;
                continue block0;
            }
        }
        if (bl && !this.isChangedLine()) {
            return;
        }
        if (this.schedId != null) {
            this.schedId.cancel();
            this.schedId = null;
        }
        this.schedId = CMIScheduler.scheduleSyncRepeatingTask(() -> {
            if (this.playersInHologramUpdateRange.isEmpty()) {
                if (this.schedId != null) {
                    this.schedId.cancel();
                    this.schedId = null;
                }
                return;
            }
            this.updateHolo();
        }, (long)10L, (long)n);
    }

    private void lineOfSightTasker() {
        if (this.isNewDisplayMethod()) {
            return;
        }
        if (this.playersInHologramVisibilityRange.isEmpty() || !this.isCheckLineOfSight()) {
            if (this.lineOfSightSchedId != null) {
                this.lineOfSightSchedId.cancel();
                this.lineOfSightSchedId = null;
            }
            return;
        }
        if (this.lineOfSightSchedId != null) {
            return;
        }
        if (this.getLOSupdateIntervalSec() <= 0.0) {
            if (this.lineOfSightSchedId != null) {
                this.lineOfSightSchedId.cancel();
                this.lineOfSightSchedId = null;
            }
            return;
        }
        int n = (int)(this.getLOSupdateIntervalSec() * 1000.0 / 50.0);
        if (n < 1) {
            n = 1;
        }
        this.lineOfSightSchedId = CMIScheduler.runTimerAsync(() -> {
            if (this.playersInHologramVisibilityRange.isEmpty() || !this.isCheckLineOfSight() || this.isNewDisplayMethod()) {
                if (this.lineOfSightSchedId != null) {
                    this.lineOfSightSchedId.cancel();
                    this.lineOfSightSchedId = null;
                }
                return;
            }
            HashSet<UUID> hashSet = null;
            try {
                hashSet = new HashSet<UUID>(this.playersInHologramVisibilityRange);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (hashSet == null) {
                return;
            }
            for (UUID uUID : hashSet) {
                Player player = CMIUser.getOnlinePlayer(uUID);
                if (player == null || !player.isOnline() || player.getWorld() != this.getLocation().getWorld()) continue;
                Block block = CMI.getInstance().getNMS().getBlockLookingAt(this.getLocation().getWorld(), player.getEyeLocation().toVector(), this.getCenterLocation().toVector(), false);
                if (block != null) {
                    this.hide(player.getUniqueId());
                    continue;
                }
                this.update(player);
            }
        }, (long)2L, (long)n);
    }

    private void pageTasker() {
        if (this.playersInHologramUpdateRange.isEmpty()) {
            if (this.pageSchedId != null) {
                this.pageSchedId.cancel();
                this.pageSchedId = null;
            }
            return;
        }
        if (this.pageSchedId != null) {
            return;
        }
        if (this.pageChangeIntervalSec <= 0.0) {
            if (this.pageSchedId != null) {
                this.pageSchedId.cancel();
                this.pageSchedId = null;
            }
            return;
        }
        int n = (int)(this.pageChangeIntervalSec * 1000.0 / 50.0);
        if (n < 1) {
            n = 1;
        }
        if (this.pages.size() == 1) {
            return;
        }
        this.pageSchedId = CMIScheduler.scheduleSyncRepeatingTask(() -> {
            if (this.playersInHologramUpdateRange.isEmpty()) {
                if (this.pageSchedId != null) {
                    this.pageSchedId.cancel();
                    this.pageSchedId = null;
                }
                return;
            }
            for (UUID object : this.playersInHologramUpdateRange) {
                this.goToNextPageAuto(object);
                this.getData(object).setSkipUpdate(true);
            }
            for (CMIHologramUserData cMIHologramUserData : this.userData.values()) {
                cMIHologramUserData.setSkipPageChange(false);
            }
            this.update();
        }, (long)1L, (long)n);
    }

    private void hoverOverTasker() {
        if (this.playersInHologramUpdateRange.isEmpty()) {
            if (this.hoverOverSchedId != null) {
                this.hoverOverSchedId.cancel();
                this.hoverOverSchedId = null;
            }
            return;
        }
        if (this.hoverOverSchedId != null) {
            return;
        }
        if (!this.isInteractable() || !this.isNewIneractionMethod()) {
            if (this.hoverOverSchedId != null) {
                this.hoverOverSchedId.cancel();
                this.hoverOverSchedId = null;
            }
            return;
        }
        this.hoverOverSchedId = CMIScheduler.scheduleSyncRepeatingTask(() -> {
            if (this.playersInHologramUpdateRange.isEmpty() || !this.isInteractable()) {
                if (this.hoverOverSchedId != null) {
                    this.hoverOverSchedId.cancel();
                    this.hoverOverSchedId = null;
                }
                return;
            }
            for (UUID uUID : this.playersInHologramUpdateRange) {
                HologramManager.CMIAiming cMIAiming;
                Player player = CMIUser.getOnlinePlayer(uUID);
                if (player == null || (cMIAiming = CMI.getInstance().getHologramManager().getAimAt(player.getUniqueId())) == null || !cMIAiming.getName().equals(this.getName())) continue;
                CMI.getInstance().getHologramManager().removeAimAt(player.getUniqueId());
            }
            this.particlePosition = (short)(this.particlePosition + 1);
            if (this.particlePosition > 10000) {
                this.particlePosition = 0;
            }
            for (UUID uUID : new HashSet<UUID>(this.playersInHologramUpdateRange)) {
                this.checkHoverPosition(CMIUser.getOnlinePlayer(uUID));
            }
        }, (long)1L, (long)1L);
    }

    private void updateHolo() {
        if (this.playersInHologramUpdateRange.isEmpty()) {
            return;
        }
        for (UUID uUID : new HashSet<UUID>(this.playersInHologramUpdateRange)) {
            CMIHologramUserData cMIHologramUserData = this.getData(uUID);
            if (cMIHologramUserData.isSkipUpdate()) {
                cMIHologramUserData.setSkipUpdate(false);
                continue;
            }
            this.update(CMIUser.getOnlinePlayer(uUID));
        }
    }

    public Set<UUID> getLastHoloInRange() {
        return this.playersInHologramUpdateRange;
    }

    public void recheckTaskers() {
        this.tasker();
        this.lineOfSightTasker();
        this.pageTasker();
        this.hoverOverTasker();
    }

    public void addLastHoloInRange(UUID uUID) {
        this.playersInHologramUpdateRange.add(uUID);
        this.recheckTaskers();
    }

    public void removeLastHoloInRange(UUID uUID) {
        this.playersInHologramUpdateRange.remove(uUID);
        this.getData(uUID).getBatcher().cancel();
        this.recheckTaskers();
    }

    public Set<UUID> getLastHoloInRangeExtra() {
        return this.playersInHologramVisibilityRange;
    }

    public void addLastHoloInRangeExtra(UUID uUID) {
        this.playersInHologramVisibilityRange.add(uUID);
        this.recheckTaskers();
    }

    public void removeLastHoloInRangeExtra(UUID uUID) {
        this.playersInHologramVisibilityRange.remove(uUID);
        this.hide(uUID);
    }

    public boolean isuSync() {
        return this.uSync;
    }

    public void setuSync(boolean bl) {
        this.uSync = bl;
    }

    public void disable() {
        this.enabled = false;
        this.hide();
    }

    public void enable() {
        this.enabled = true;
        this.update();
    }

    public boolean isSaveToFile() {
        return this.saveToFile;
    }

    public void setSaveToFile(boolean bl) {
        this.saveToFile = bl;
    }

    public void makePersistent() {
        this.saveToFile = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getPageCount() {
        return this.pages.size();
    }

    public CMIHologramPage getPage(int n) {
        return this.pages.get(n);
    }

    public boolean isRequiresPermission() {
        return this.requestPermission;
    }

    public void setPermissionRequirement(boolean bl) {
        this.requestPermission = bl;
    }

    public double getPageChangeIntervalSec() {
        return this.pageChangeIntervalSec;
    }

    public void setPageChangeIntervalSec(double d) {
        boolean bl = false;
        if (this.pageChangeIntervalSec != d) {
            bl = true;
        }
        this.pageChangeIntervalSec = Math.ceil((int)(d * 100.0)) / 100.0;
        if (this.pageChangeIntervalSec <= 0.0) {
            this.pageChangeIntervalSec = 0.0;
        }
        if (bl) {
            this.pageTasker();
        }
    }

    public void remove() {
        CMI.getInstance().getHologramManager().removeHolo(this);
    }

    public boolean isSticky() {
        return this.sticky;
    }

    public void setSticky(boolean bl) {
        this.sticky = bl;
    }

    public boolean isCheckLineOfSight() {
        return this.LOSupdateIntervalSec > 0.0;
    }

    public void setLOSInterval(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.LOSupdateIntervalSec = Math.ceil((int)(d * 100.0)) / 100.0;
    }

    public double getLOSupdateIntervalSec() {
        return this.LOSupdateIntervalSec;
    }

    public boolean isFollowPlayer() {
        return this.LOSupdateIntervalSec > 0.0;
    }

    public void setFollowPlayer(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.followPlayer = Math.ceil((int)(d * 100.0)) / 100.0;
    }

    public double getFollowPlayer() {
        return this.followPlayer;
    }

    public int getHoveringLine(UUID uUID) {
        return this.userData.getOrDefault(uUID, new CMIHologramUserData()).getHoveringLine();
    }

    public boolean isShowHoverParticle() {
        return this.showHoverParticle;
    }

    public void setShowHoverParticle(boolean bl) {
        this.showHoverParticle = bl;
    }

    public boolean isNewIneractionMethod() {
        return this.newIneractionMethod;
    }

    public void setNewIneractionMethod(boolean bl) {
        this.newIneractionMethod = bl;
    }

    public int getParticleCount() {
        return this.particleCount;
    }

    public void setParticleCount(int n) {
        n = Math.max(1, n);
        this.particleCount = n = Math.min(10, n);
    }

    public double getParticleSpacing() {
        return this.particleSpacing;
    }

    public void setParticleSpacing(double d) {
        d = Math.max(0.0, d);
        this.particleSpacing = d = Math.min(1.0, d);
    }

    public double getExtraParticleHeight() {
        return this.extraParticleHeight;
    }

    public void setExtraParticleHeight(double d) {
        d = Math.max(-this.getHeight() / 2.0, d);
        this.extraParticleHeight = d = Math.min(3.0, d);
    }

    public double getExtraParticleWidth() {
        return this.extraParticleWidth;
    }

    public void setExtraParticleWidth(double d) {
        d = Math.max(-3.0, d);
        this.extraParticleWidth = d = Math.min(3.0, d);
    }

    public double getExtraInteractionHeight() {
        return this.extraInteractionHeight;
    }

    public void setExtraInteractionHeight(double d) {
        this.extraInteractionHeight = d;
    }

    public double getExtraInteractionWidth() {
        return this.extraInteractionWidth;
    }

    public void setExtraInteractionWidth(double d) {
        this.extraInteractionWidth = d;
    }

    public CMIEffect getHoverEffect() {
        return this.effect;
    }

    public void setHoverEffect(CMIEffectManager.CMIParticle cMIParticle) {
        this.effect = new CMIEffect(cMIParticle);
        this.effect.setAmount(0);
        this.effect.setSpeed(1.0f);
    }

    public double getParticleOffsetX() {
        return this.particleOffsetX;
    }

    public void setParticleOffsetX(double d) {
        this.particleOffsetX = d;
    }

    public double getParticleOffsetY() {
        return this.particleOffsetY;
    }

    public void setParticleOffsetY(double d) {
        this.particleOffsetY = d;
    }

    public boolean isStabilizedHoverParticles() {
        return this.stabilizedHoverParticles;
    }

    public void setStabilizedHoverParticles(boolean bl) {
        this.stabilizedHoverParticles = bl;
    }

    public boolean isShowWhenNotPersistent() {
        return this.showWhenNotPersistent;
    }

    public void setShowWhenNotPersistent(boolean bl) {
        this.showWhenNotPersistent = bl;
    }

    public boolean isNewDisplayMethod() {
        return this.newDisplayMethod;
    }

    public CMIHologram setNewDisplayMethod(boolean bl) {
        this.newDisplayMethod = bl;
        return this;
    }

    public CMIBillboard getBillboard() {
        if (this.billboard == null) {
            return CMIBillboard.VERTICAL;
        }
        return this.billboard;
    }

    public CMIHologram setBillboard(CMIBillboard cMIBillboard) {
        this.billboard = cMIBillboard;
        return this;
    }

    public CMIBillboard getIconBillboard() {
        return this.iconBillboard;
    }

    public CMIHologram setIconBillboard(CMIBillboard cMIBillboard) {
        this.iconBillboard = cMIBillboard;
        return this;
    }

    public int getYaw() {
        return this.yaw;
    }

    public CMIHologram setYaw(int n) {
        this.yaw = n;
        return this;
    }

    public int getPitch() {
        return this.pitch;
    }

    public CMIHologram setPitch(int n) {
        this.pitch = CMINumber.clamp((int)n, (int)-180, (int)180);
        return this;
    }

    public CMITextAlignment getTextAlignment() {
        if (this.textAlignment == null) {
            return CMITextAlignment.CENTER;
        }
        return this.textAlignment;
    }

    public CMIHologram setTextAlignment(CMITextAlignment cMITextAlignment) {
        this.textAlignment = cMITextAlignment;
        return this;
    }

    public CMIChatColor getBackgroundColor() {
        if (this.backgroundColor == null) {
            this.backgroundColor = CMIChatColor.BLACK;
        }
        return this.backgroundColor;
    }

    public CMIHologram setBackgroundColor(CMIChatColor cMIChatColor) {
        this.backgroundColor = cMIChatColor;
        return this;
    }

    public int getBackgroundAlpha() {
        return this.backgroundAlpha;
    }

    public CMIHologram setBackgroundAlpha(int n) {
        this.backgroundAlpha = CMINumber.clamp((int)n, (int)0, (int)255);
        return this;
    }

    public int getTextAlpha() {
        return this.textAlpha;
    }

    public CMIHologram setTextAlpha(int n) {
        this.textAlpha = CMINumber.clamp((int)n, (int)0, (int)255);
        return this;
    }

    public boolean isDoubleSided() {
        return this.doubleSided;
    }

    public CMIHologram setDoubleSided(boolean bl) {
        this.doubleSided = bl;
        return this;
    }

    public boolean isShadowed() {
        return this.shadowed;
    }

    public CMIHologram setShadowed(boolean bl) {
        this.shadowed = bl;
        return this;
    }

    public double getScaleW() {
        return this.scaleW;
    }

    public CMIHologram setScaleW(double d) {
        d = (double)((int)(d * 100.0)) / 100.0;
        this.scaleW = CMINumber.clamp((double)d, (double)0.001, (int)9999);
        return this;
    }

    public double getScaleH() {
        return this.scaleH;
    }

    public CMIHologram setScaleH(double d) {
        d = (double)((int)(d * 100.0)) / 100.0;
        this.scaleH = CMINumber.clamp((double)d, (double)0.001, (int)9999);
        return this;
    }

    public double getIconScale() {
        return this.iconScale;
    }

    public CMIHologram setIconScale(double d) {
        this.iconScale = CMINumber.clamp((double)d, (double)0.001, (int)9999);
        return this;
    }

    public int getIconPitch() {
        return this.iconPitch;
    }

    public CMIHologram setIconPitch(int n) {
        this.iconPitch = n;
        return this;
    }

    public int getIconYaw() {
        return this.iconYaw;
    }

    public CMIHologram setIconYaw(int n) {
        this.iconYaw = n;
        return this;
    }

    public int getSkyLevel() {
        return this.skyLevel;
    }

    public CMIHologram setSkyLevel(int n) {
        this.skyLevel = n;
        return this;
    }

    public int getBlockLevel() {
        return this.blockLevel;
    }

    public CMIHologram setBlockLevel(int n) {
        this.blockLevel = n;
        return this;
    }

    public String getWorldName() {
        return this.loc.getWorldName();
    }

    public Player getPlayerToShowFor() {
        return this.playerToShowFor;
    }

    public CMIHologram setPlayerToShowFor(Player player) {
        this.playerToShowFor = player;
        return this;
    }

    public int getSelfDestructIn() {
        return this.selfDestructIn;
    }

    public CMIHologram setSelfDestructIn(int n) {
        this.selfDestructIn = n;
        return this;
    }

    public void showToPlayer() {
        if (this.getPlayerToShowFor() == null || !this.getPlayerToShowFor().isOnline()) {
            return;
        }
        if (this.getSelfDestructIn() > 0) {
            CMIScheduler.runTaskLater(() -> this.hide(this.getPlayerToShowFor().getUniqueId()), (long)this.getSelfDestructIn());
        }
        this.updatePages();
        this.generalUpdate(this.getPlayerToShowFor(), true);
    }

    public boolean isAutoPagination() {
        return this.autoPagination;
    }

    public void setAutoPagination(boolean bl) {
        this.autoPagination = bl;
    }

    public boolean isSeeThrough() {
        return this.seeThrough;
    }

    public void setSeeThrough(boolean bl) {
        this.seeThrough = bl;
    }

    public boolean isFadeInAnimation() {
        return this.fadeInAnimation;
    }

    public void setFadeInAnimation(boolean bl) {
        this.fadeInAnimation = bl;
    }

    public int getAutoPaginationOffset() {
        return this.autoPaginationOffset;
    }

    public void setAutoPaginationOffset(int n) {
        this.autoPaginationOffset = CMINumber.clamp((int)n, (int)0, (int)200);
    }

    private /* synthetic */ void lambda$3(Player player, CMIItemDisplay cMIItemDisplay) {
        if (!this.playersInHologramVisibilityRange.contains(player.getUniqueId())) {
            return;
        }
        cMIItemDisplay.show(player);
    }

    private /* synthetic */ void lambda$4(CMIItemDisplay cMIItemDisplay, CMIItemStack cMIItemStack, Player player) {
        if (cMIItemDisplay.getItemStack() == null || cMIItemDisplay.getItemStack().getType().isAir() || !cMIItemDisplay.getItemStack().equals((Object)cMIItemStack.getItemStack())) {
            if (!this.playersInHologramVisibilityRange.contains(player.getUniqueId())) {
                return;
            }
            cMIItemDisplay.show(player);
        } else {
            cMIItemDisplay.update(player);
        }
    }

    private /* synthetic */ void lambda$5(Player player, CMIItemDisplay cMIItemDisplay) {
        if (!this.playersInHologramVisibilityRange.contains(player.getUniqueId())) {
            return;
        }
        cMIItemDisplay.show(player);
    }

    private /* synthetic */ void lambda$6(Player player, CMIItemDisplay cMIItemDisplay) {
        if (!this.playersInHologramVisibilityRange.contains(player.getUniqueId())) {
            return;
        }
        cMIItemDisplay.show(player);
    }

    private /* synthetic */ void lambda$11(Player player, Location location, CMIItemStack cMIItemStack, int n) {
        CMIDataWatcher cMIDataWatcher = CMI.getInstance().getNMS().spawnHologram(player, location, null, cMIItemStack == null ? null : cMIItemStack.getItemStack());
        if (cMIItemStack != null) {
            cMIDataWatcher.setItem(cMIItemStack);
        }
        if (cMIDataWatcher != null) {
            cMIDataWatcher.setLoc(location);
            if (player.isOnline()) {
                this.updateCache(player.getUniqueId(), n, cMIDataWatcher);
            }
        }
    }

    private /* synthetic */ void lambda$12(CMIItemStack cMIItemStack, Player player, Location location, CMIHologramLine cMIHologramLine, CMIAsyncHead cMIAsyncHead, int n) {
        CMIDataWatcher cMIDataWatcher = null;
        if (cMIItemStack != null && !cMIItemStack.getCMIType().isAir()) {
            cMIDataWatcher = CMI.getInstance().getNMS().makeFloatingIcon(player, location, cMIItemStack.getItemStack(), cMIHologramLine.isGlowing());
            if (cMIDataWatcher != null) {
                cMIDataWatcher.setItem(cMIItemStack);
            }
        } else {
            cMIDataWatcher = CMI.getInstance().getNMS().spawnHologram(player, location, null, null);
            cMIDataWatcher.setItem(null);
        }
        if (cMIDataWatcher != null) {
            cMIDataWatcher.setUpdatingHead(cMIAsyncHead.isAsyncHead());
            cMIDataWatcher.setLoc(location);
            if (player.isOnline()) {
                this.updateCache(player.getUniqueId(), n, cMIDataWatcher);
            }
        }
    }

    private /* synthetic */ void lambda$13(CMIHologramLine cMIHologramLine, Player player, Location location, String string, int n) {
        CMIDataWatcher cMIDataWatcher = null;
        cMIDataWatcher = cMIHologramLine.getType() == CMIHoloLineType.image ? CMI.getInstance().getNMS().spawnHologram(player, location, string, null) : CMI.getInstance().getNMS().spawnHologram(player, location, cMIHologramLine.getText(player), null);
        cMIDataWatcher.setItem(null);
        cMIDataWatcher.setLoc(location);
        this.updateCache(player.getUniqueId(), n, cMIDataWatcher);
    }

    private static /* synthetic */ void lambda$14(CMIInteractionEntity cMIInteractionEntity, Player player) {
        cMIInteractionEntity.show(player);
    }
}

