/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Holograms;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIDirection;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Display.CMIBillboard;
import com.Zrips.CMI.Modules.Display.CMITextAlignment;
import com.Zrips.CMI.Modules.Holograms.CMIHologram;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.Modules.Teleportations.CMITeleportType;
import com.Zrips.CMI.commands.CommandsHandler;
import com.Zrips.CMI.commands.list.hologram;
import com.Zrips.CMI.commands.list.hologrampages;
import java.util.Arrays;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Chat.ChatMessageEdit;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMILocation;
import net.Zrips.CMILib.Container.CMINumber;
import net.Zrips.CMILib.Container.CMIText;
import net.Zrips.CMILib.Effects.CMIEffectManager;
import net.Zrips.CMILib.GUI.CMIGui;
import net.Zrips.CMILib.GUI.CMIGuiButton;
import net.Zrips.CMILib.GUI.GUIManager;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Locale.LC;
import net.Zrips.CMILib.Logs.CMIDebug;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class HologramGUIEditor {
    public static void openGui(final Player player, final CMIHologram cMIHologram) {
        CMIGuiButton cMIGuiButton;
        CMIGui cMIGui = new CMIGui(player);
        cMIGui.setTitle(cMIHologram.getName());
        cMIGui.setInvSize(6);
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_19_R3)) {
            cMIGuiButton = new CMIGuiButton(0, CMIMaterial.ACACIA_BOAT.newItemStack()){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    cMIHologram.setNewDisplayMethod(!cMIHologram.isNewDisplayMethod());
                    CMI.getInstance().getHologramManager().resetHoloForAllPlayers(cMIHologram);
                    HologramGUIEditor.openGui(player, cMIHologram);
                    CMI.getInstance().getHologramManager().save();
                }
            };
            cMIGuiButton.setName(CMILC.getIM(hologram.class, "newDisplayMethod", "[state]", cMIHologram.isNewDisplayMethod()));
            cMIGui.addButton(cMIGuiButton);
        }
        cMIGuiButton = new CMIGuiButton(4, cMIHologram.isEnabled() ? CMIMaterial.GREEN_WOOL.newItemStack() : CMIMaterial.YELLOW_WOOL.newItemStack()){

            public void click(GUIManager.GUIClickType gUIClickType) {
                if (cMIHologram.isEnabled()) {
                    cMIHologram.disable();
                } else {
                    cMIHologram.enable();
                }
                CMI.getInstance().getHologramManager().resetHoloForAllPlayers(cMIHologram);
                HologramGUIEditor.openGui(player, cMIHologram);
                CMI.getInstance().getHologramManager().save();
            }
        };
        cMIGuiButton.setName(CMILC.getIM(hologram.class, "enabled", "[state]", cMIHologram.isEnabled()));
        cMIGui.addButton(cMIGuiButton);
        if (cMIHologram.isNewDisplayMethod()) {
            cMIGuiButton = new CMIGuiButton(9, CMIMaterial.ACACIA_LEAVES.newItemStack()){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    switch (cMIHologram.getBillboard()) {
                        case VERTICAL: {
                            cMIHologram.setBillboard(CMIBillboard.FIXED);
                            break;
                        }
                        default: {
                            cMIHologram.setBillboard(CMIBillboard.VERTICAL);
                        }
                    }
                    CMI.getInstance().getHologramManager().resetHoloForAllPlayers(cMIHologram);
                    HologramGUIEditor.openGui(player, cMIHologram);
                    CMI.getInstance().getHologramManager().save();
                }
            };
            cMIGuiButton.setName(CMILC.getIM(hologram.class, "followType", "[type]", CMIText.firstToUpperCase((String)cMIHologram.getBillboard().toString())));
            cMIGui.addButton(cMIGuiButton);
            if (cMIHologram.getBillboard().equals((Object)CMIBillboard.FIXED)) {
                cMIGuiButton = new CMIGuiButton(10, CMIMaterial.BLACK_BANNER.newItemStack()){

                    public void click(GUIManager.GUIClickType gUIClickType) {
                        cMIHologram.setDoubleSided(!cMIHologram.isDoubleSided());
                        CMI.getInstance().getHologramManager().resetHoloForAllPlayers(cMIHologram);
                        HologramGUIEditor.openGui(player, cMIHologram);
                        CMI.getInstance().getHologramManager().save();
                    }
                };
                cMIGuiButton.setName(CMILC.getIM(hologram.class, "doubleSided", "[state]", cMIHologram.isDoubleSided()));
                cMIGui.addButton(cMIGuiButton);
                cMIGuiButton = new CMIGuiButton(11, CMIMaterial.OAK_SIGN.newItemStack()){

                    public void click(GUIManager.GUIClickType gUIClickType) {
                        int n = cMIHologram.getYaw() + HologramGUIEditor.modifyValue(gUIClickType, 5, 15, -5, -15);
                        n = n < 0 ? n + 360 : n % 360;
                        cMIHologram.setYaw(Math.abs(n));
                        CMI.getInstance().getHologramManager().resetHoloForAllPlayers(cMIHologram);
                        HologramGUIEditor.openGui(player, cMIHologram);
                        CMI.getInstance().getHologramManager().save();
                    }
                };
                cMIGuiButton.setName(CMILC.getIM(hologram.class, "holoYaw", "[angle]", cMIHologram.getYaw()));
                cMIGui.addButton(cMIGuiButton);
                cMIGuiButton = new CMIGuiButton(12, CMIMaterial.ACACIA_PRESSURE_PLATE.newItemStack()){

                    public void click(GUIManager.GUIClickType gUIClickType) {
                        int n = cMIHologram.getPitch() + HologramGUIEditor.modifyValue(gUIClickType, 5, 15, -5, -15);
                        n = n < -180 ? 180 - (-n - 180) : (n > 180 ? -180 + (n - 180) : n);
                        cMIHologram.setPitch(n);
                        CMI.getInstance().getHologramManager().resetHoloForAllPlayers(cMIHologram);
                        HologramGUIEditor.openGui(player, cMIHologram);
                        CMI.getInstance().getHologramManager().save();
                    }
                };
                cMIGuiButton.setName(CMILC.getIM(hologram.class, "holoPitch", "[angle]", cMIHologram.getPitch()));
                cMIGuiButton.addLore(CMILC.getIM(hologram.class, "pitchLimits", new Object[0]));
                cMIGui.addButton(cMIGuiButton);
            }
            cMIGuiButton = new CMIGuiButton(18, CMIMaterial.BOOK.newItemStack()){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    cMIHologram.setTextAlignment(cMIHologram.getTextAlignment().next());
                    CMI.getInstance().getHologramManager().resetHoloForAllPlayers(cMIHologram);
                    HologramGUIEditor.openGui(player, cMIHologram);
                    CMI.getInstance().getHologramManager().save();
                }
            };
            cMIGuiButton.setName(CMILC.getIM(hologram.class, "alignment", "[type]", CMIText.firstToUpperCase((String)cMIHologram.getTextAlignment().toString())));
            cMIGui.addButton(cMIGuiButton);
            cMIGuiButton = new CMIGuiButton(19, CMIMaterial.BLAZE_ROD.newItemStack()){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    cMIHologram.setShadowed(!cMIHologram.isShadowed());
                    CMI.getInstance().getHologramManager().resetHoloForAllPlayers(cMIHologram);
                    HologramGUIEditor.openGui(player, cMIHologram);
                    CMI.getInstance().getHologramManager().save();
                }
            };
            cMIGuiButton.setName(CMILC.getIM(hologram.class, "shadow", "[state]", cMIHologram.isShadowed()));
            cMIGui.addButton(cMIGuiButton);
            cMIGuiButton = new CMIGuiButton(20, CMIMaterial.RAW_GOLD.newItemStack()){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    cMIHologram.setTextAlpha(cMIHologram.getTextAlpha() + HologramGUIEditor.modifyValue(gUIClickType, 5, 15, -5, -15));
                    switch (gUIClickType) {
                        case Q: {
                            cMIHologram.setTextAlpha(255);
                            CMI.getInstance().getHologramManager().resetHoloForAllPlayers(cMIHologram);
                            break;
                        }
                    }
                    cMIHologram.update();
                    HologramGUIEditor.openGui(player, cMIHologram);
                    CMI.getInstance().getHologramManager().save();
                }
            };
            cMIGuiButton.setName(CMILC.getIM(hologram.class, "textAlpha", "[alpha]", cMIHologram.getTextAlpha()));
            cMIGuiButton.addLore(CMILC.getIM(hologram.class, "reset", new Object[0]));
            cMIGui.addButton(cMIGuiButton);
            cMIGuiButton = new CMIGuiButton(29, CMIMaterial.AZALEA.newItemStack()){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    cMIHologram.setBackgroundAlpha(cMIHologram.getBackgroundAlpha() + HologramGUIEditor.modifyValue(gUIClickType, 5, 15, -5, -15));
                    switch (gUIClickType) {
                        case Q: {
                            cMIHologram.setBackgroundAlpha(150);
                            CMI.getInstance().getHologramManager().resetHoloForAllPlayers(cMIHologram);
                            break;
                        }
                    }
                    cMIHologram.update();
                    HologramGUIEditor.openGui(player, cMIHologram);
                    CMI.getInstance().getHologramManager().save();
                }
            };
            cMIGuiButton.setName(CMILC.getIM(hologram.class, "bgAlpha", "[alpha]", cMIHologram.getBackgroundAlpha()));
            cMIGuiButton.addLore(CMILC.getIM(hologram.class, "reset", new Object[0]));
            cMIGui.addButton(cMIGuiButton);
            cMIGuiButton = new CMIGuiButton(28, CMIMaterial.PURPLE_DYE.newItemStack()){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    ChatMessageEdit chatMessageEdit = new ChatMessageEdit((CommandSender)player, cMIHologram.getBackgroundColor().getColorCode()){

                        public void run(String string) {
                            if (!CMIText.isValidString((String)string)) {
                                return;
                            }
                            CMIChatColor cMIChatColor = CMIChatColor.getColor((String)string);
                            if (cMIChatColor == null || !cMIChatColor.isColor()) {
                                CMILC.info_IncorrectColor.sendMessage(player, new Object[0]);
                                return;
                            }
                            cMIHologram.setBackgroundColor(cMIChatColor);
                            CMI.getInstance().getHologramManager().resetHoloForAllPlayers(cMIHologram);
                            HologramGUIEditor.openGui(player, cMIHologram);
                            CMI.getInstance().getHologramManager().save();
                        }

                        public void onDisable() {
                            HologramGUIEditor.openGui(player, cMIHologram);
                        }
                    };
                    chatMessageEdit.setCheckForCancel(true);
                    chatMessageEdit.printMessage();
                    this.getGui().getPlayer().closeInventory();
                }
            };
            cMIGuiButton.setName(CMILC.getIM(hologram.class, "bgColor", "[color]", String.valueOf(cMIHologram.getBackgroundColor().getColorCode()) + (cMIHologram.getBackgroundColor().getName() == null ? cMIHologram.getBackgroundColor().getHex() : cMIHologram.getBackgroundColor().getName())));
            cMIGui.addButton(cMIGuiButton);
            cMIGuiButton = new CMIGuiButton(27, CMIMaterial.CLOCK.newItemStack()){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    double d = HologramGUIEditor.modifyValue(gUIClickType, 1, 1, -1, -1);
                    switch (gUIClickType) {
                        case Left: 
                        case Right: {
                            cMIHologram.setSkyLevel(CMINumber.clamp((int)((int)((double)cMIHologram.getSkyLevel() + d)), (int)-1, (int)15));
                            break;
                        }
                        case LeftShift: 
                        case RightShift: {
                            cMIHologram.setBlockLevel(CMINumber.clamp((int)((int)((double)cMIHologram.getBlockLevel() + d)), (int)-1, (int)15));
                            break;
                        }
                        case MiddleMouse: {
                            break;
                        }
                        case Q: {
                            cMIHologram.setSkyLevel(-1);
                            cMIHologram.setBlockLevel(-1);
                            break;
                        }
                    }
                    if (cMIHologram.getSkyLevel() == -1 && cMIHologram.getBlockLevel() == -1 || cMIHologram.getSkyLevel() == 0 && cMIHologram.getBlockLevel() == -1 || cMIHologram.getSkyLevel() == -1 && cMIHologram.getBlockLevel() == 0) {
                        CMI.getInstance().getHologramManager().resetHoloForAllPlayers(cMIHologram);
                    } else {
                        cMIHologram.update();
                    }
                    HologramGUIEditor.openGui(player, cMIHologram);
                    CMI.getInstance().getHologramManager().save();
                }
            };
            cMIGuiButton.setName(CMILC.getIM(hologram.class, "lightLevels", new Object[0]));
            cMIGuiButton.addLore(CMILC.getIM(hologram.class, "levels", "[sky]", cMIHologram.getSkyLevel(), "[block]", cMIHologram.getBlockLevel()));
            cMIGui.addButton(cMIGuiButton);
            cMIGuiButton = new CMIGuiButton(36, CMIMaterial.PRISMARINE_CRYSTALS.newItemStack()){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    double d = HologramGUIEditor.modifyValue(gUIClickType, 0.1, 1.0, -0.1, -1.0);
                    if (cMIHologram.getScaleW() <= 2.0) {
                        d /= 10.0;
                    }
                    double d2 = cMIHologram.getScaleW();
                    switch (gUIClickType) {
                        case Q: {
                            cMIHologram.setScaleW(1.0);
                            CMI.getInstance().getHologramManager().resetHoloForAllPlayers(cMIHologram);
                            break;
                        }
                        case MiddleMouse: {
                            cMIHologram.setScaleW(cMIHologram.getScaleH());
                            CMI.getInstance().getHologramManager().resetHoloForAllPlayers(cMIHologram);
                            break;
                        }
                        default: {
                            cMIHologram.setScaleW(CMINumber.sum((double)d2, (double)d));
                            cMIHologram.update();
                        }
                    }
                    HologramGUIEditor.openGui(player, cMIHologram);
                    CMI.getInstance().getHologramManager().save();
                }
            };
            cMIGuiButton.setName(CMILC.getIM(hologram.class, "scaleWidth", "[scale]", cMIHologram.getScaleW()));
            cMIGuiButton.addLore(CMILC.getIM(hologram.class, "reset", new Object[0]));
            cMIGui.addButton(cMIGuiButton);
            cMIGuiButton = new CMIGuiButton(37, CMIMaterial.END_CRYSTAL.newItemStack()){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    double d = HologramGUIEditor.modifyValue(gUIClickType, 0.1, 1.0, -0.1, -1.0);
                    if (cMIHologram.getScaleH() <= 2.0) {
                        d /= 10.0;
                    }
                    double d2 = cMIHologram.getScaleH();
                    switch (gUIClickType) {
                        case Q: {
                            cMIHologram.setScaleH(1.0);
                            break;
                        }
                        case MiddleMouse: {
                            cMIHologram.setScaleH(cMIHologram.getScaleW());
                            break;
                        }
                        default: {
                            cMIHologram.setScaleH(CMINumber.sum((double)d2, (double)d));
                        }
                    }
                    CMI.getInstance().getHologramManager().resetHoloForAllPlayers(cMIHologram);
                    HologramGUIEditor.openGui(player, cMIHologram);
                    CMI.getInstance().getHologramManager().save();
                }
            };
            cMIGuiButton.setName(CMILC.getIM(hologram.class, "scaleHeight", "[scale]", cMIHologram.getScaleH()));
            cMIGuiButton.addLore(CMILC.getIM(hologram.class, "reset", new Object[0]));
            cMIGui.addButton(cMIGuiButton);
            cMIGuiButton = new CMIGuiButton(45, CMIMaterial.MUD_BRICK_SLAB.newItemStack()){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    double d = HologramGUIEditor.modifyValue(gUIClickType, 0.1, 1.0, -0.1, -1.0);
                    if (cMIHologram.getIconScale() <= 1.0) {
                        d /= 10.0;
                    }
                    double d2 = cMIHologram.getIconScale();
                    switch (gUIClickType) {
                        case Q: {
                            cMIHologram.setIconScale(1.0);
                            break;
                        }
                        default: {
                            cMIHologram.setIconScale(CMINumber.sum((double)d2, (double)d));
                        }
                    }
                    cMIHologram.update();
                    HologramGUIEditor.openGui(player, cMIHologram);
                    CMI.getInstance().getHologramManager().save();
                }
            };
            cMIGuiButton.setName(CMILC.getIM(hologram.class, "iconScale", "[scale]", cMIHologram.getIconScale()));
            cMIGuiButton.addLore(CMILC.getIM(hologram.class, "reset", new Object[0]));
            cMIGui.addButton(cMIGuiButton);
            cMIGuiButton = new CMIGuiButton(47, CMIMaterial.BIRCH_SIGN.newItemStack()){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    int n = cMIHologram.getIconYaw() + HologramGUIEditor.modifyValue(gUIClickType, 1, 10, -1, -10);
                    n = n < 0 ? n + 360 : n % 360;
                    switch (gUIClickType) {
                        case Q: {
                            cMIHologram.setIconYaw(0);
                            break;
                        }
                        default: {
                            cMIHologram.setIconYaw(n);
                        }
                    }
                    cMIHologram.update();
                    HologramGUIEditor.openGui(player, cMIHologram);
                    CMI.getInstance().getHologramManager().save();
                }
            };
            cMIGuiButton.setName(CMILC.getIM(hologram.class, "iconYaw", "[angle]", cMIHologram.getIconYaw()));
            cMIGuiButton.addLore(CMILC.getIM(hologram.class, "reset", new Object[0]));
            cMIGui.addButton(cMIGuiButton);
            cMIGuiButton = new CMIGuiButton(48, CMIMaterial.BIRCH_PRESSURE_PLATE.newItemStack()){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    int n = cMIHologram.getIconPitch() + HologramGUIEditor.modifyValue(gUIClickType, 1, 10, -1, -10);
                    n = n < -180 ? 180 - (-n - 180) : (n > 180 ? -180 + (n - 180) : n);
                    switch (gUIClickType) {
                        case Q: {
                            cMIHologram.setIconPitch(0);
                            break;
                        }
                        default: {
                            cMIHologram.setIconPitch(n);
                        }
                    }
                    cMIHologram.update();
                    HologramGUIEditor.openGui(player, cMIHologram);
                    CMI.getInstance().getHologramManager().save();
                }
            };
            cMIGuiButton.setName(CMILC.getIM(hologram.class, "iconPitch", "[angle]", cMIHologram.getIconPitch()));
            cMIGuiButton.addLore(CMILC.getIM(hologram.class, "reset", new Object[0]));
            cMIGui.addButton(cMIGuiButton);
        }
        cMIGuiButton = new CMIGuiButton(42, CMIMaterial.BOOK.newItemStack()){

            public void click(GUIManager.GUIClickType gUIClickType) {
                cMIHologram.setuSync(!cMIHologram.isuSync());
                CMI.getInstance().getHologramManager().openGui(player, cMIHologram);
                CMI.getInstance().getHologramManager().save();
            }
        };
        cMIGuiButton.setName(CMILC.getIM("hologram", "usync", "[state]", cMIHologram.isuSync()));
        cMIGui.addButton(cMIGuiButton);
        cMIGuiButton = new CMIGuiButton(33, CMIMaterial.LEVER.newItemStack()){

            public void click(GUIManager.GUIClickType gUIClickType) {
                cMIHologram.setPermissionRequirement(!cMIHologram.isRequiresPermission());
                CMI.getInstance().getHologramManager().openGui(player, cMIHologram);
                CMI.getInstance().getHologramManager().save();
            }
        };
        cMIGuiButton.setName(CMILC.getIM("hologram", "reqPermission", "[state]", cMIHologram.isRequiresPermission()));
        if (cMIHologram.isRequiresPermission()) {
            cMIGuiButton.addLore("&6" + PermissionsManager.CMIPerm.hologram_$1.getPermission(cMIHologram.getName().toLowerCase()));
        }
        cMIGui.addButton(cMIGuiButton);
        cMIGuiButton = new CMIGuiButton(49, CMIMaterial.OAK_FENCE.newItemStack()){

            public void click(GUIManager.GUIClickType gUIClickType) {
                double d = HologramGUIEditor.modifyValue(gUIClickType, 1, 10, -1, -10);
                if (cMIHologram.getPageChangeIntervalSec() < 2.0) {
                    d /= 10.0;
                }
                cMIHologram.setPageChangeIntervalSec(CMINumber.sum((double)cMIHologram.getPageChangeIntervalSec(), (double)d));
                CMI.getInstance().getHologramManager().resetHoloForAllPlayers(cMIHologram);
                CMI.getInstance().getHologramManager().openGui(player, cMIHologram);
                CMI.getInstance().getHologramManager().save();
            }
        };
        cMIGuiButton.setName(CMILC.getIM("hologram", "pageInterval", "[second]", cMIHologram.getPageChangeIntervalSec()));
        cMIGuiButton.addLore(CMILC.getIML("hologram", "pageIntervalLore", new Object[0]));
        if (cMIHologram.getPageCount() == 1) {
            cMIGuiButton.addLore(CMILC.getIM("hologram", "pageIntervalNoPages", new Object[0]));
        }
        cMIGui.addButton(cMIGuiButton);
        cMIGuiButton = new CMIGuiButton(31, CMIMaterial.BLUE_WOOL.newItemStack()){

            public void click(GUIManager.GUIClickType gUIClickType) {
                double d = HologramGUIEditor.modifyValue(gUIClickType, 1, 10, -1, -10);
                if (cMIHologram.getUpdateIntervalSec() < 2.0) {
                    d /= 10.0;
                }
                if (cMIHologram.getUpdateIntervalSec() == -1.0 && d > 0.0) {
                    d += 1.0;
                }
                cMIHologram.setUpdateIntervalSec(CMINumber.sum((double)cMIHologram.getUpdateIntervalSec(), (double)d));
                CMI.getInstance().getHologramManager().resetHoloForAllPlayers(cMIHologram);
                cMIHologram.update();
                CMI.getInstance().getHologramManager().openGui(player, cMIHologram);
                CMI.getInstance().getHologramManager().save();
            }
        };
        cMIGuiButton.setName(CMILC.getIM("hologram", "interval", "[second]", cMIHologram.getUpdateIntervalSec()));
        cMIGuiButton.addLore(CMILC.getIML("hologram", "intervalLore", new Object[0]));
        cMIGui.addButton(cMIGuiButton);
        cMIGuiButton = new CMIGuiButton(22, CMIMaterial.PURPLE_WOOL.newItemStack()){

            public void click(GUIManager.GUIClickType gUIClickType) {
                cMIHologram.setDownOrder(cMIHologram.isDownOrder() == false);
                cMIHologram.hide();
                cMIHologram.update();
                CMI.getInstance().getHologramManager().openGui(player, cMIHologram);
                CMI.getInstance().getHologramManager().save();
            }
        };
        cMIGuiButton.setName(CMILC.getIM("hologram", "order", "[state]", cMIHologram.isDownOrder()));
        cMIGui.addButton(cMIGuiButton);
        if (!cMIHologram.isNewDisplayMethod()) {
            cMIGuiButton = new CMIGuiButton(15, CMIMaterial.BROWN_WOOL.newItemStack()){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    cMIHologram.setSpacing(cMIHologram.getSpacing() - HologramGUIEditor.modifyValue(gUIClickType, 0.01, 0.1, -0.01, -0.1));
                    cMIHologram.setAreaExtra(null);
                    HologramGUIEditor.fullHoloReset(cMIHologram);
                    CMI.getInstance().getHologramManager().save();
                    CMI.getInstance().getSelectionManager().setSelectionCuboid(player, cMIHologram.getAreaExtra());
                    CMI.getInstance().getSelectionManager().showSelection(player);
                    CMI.getInstance().getHologramManager().openGui(player, cMIHologram);
                }
            };
            cMIGuiButton.setName(CMILC.getIM("hologram", "text", "[space]", (double)((int)(cMIHologram.getSpacing() * 100.0)) / 100.0));
            cMIGuiButton.addLore(CMILC.getIML("hologram", "iconLore", new Object[0]));
            cMIGui.addButton(cMIGuiButton);
            cMIGuiButton = new CMIGuiButton(24, CMIMaterial.PINK_WOOL.newItemStack()){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    cMIHologram.setIconSpacing(cMIHologram.getIconSpacing() - HologramGUIEditor.modifyValue(gUIClickType, 0.01, 0.1, -0.01, -0.1));
                    cMIHologram.setAreaExtra(null);
                    HologramGUIEditor.fullHoloReset(cMIHologram);
                    CMI.getInstance().getHologramManager().save();
                    CMI.getInstance().getSelectionManager().setSelectionCuboid(player, cMIHologram.getAreaExtra());
                    CMI.getInstance().getSelectionManager().showSelection(player);
                    CMI.getInstance().getHologramManager().openGui(player, cMIHologram);
                }
            };
            cMIGuiButton.setName(CMILC.getIM("hologram", "icon", "[space]", (double)((int)(cMIHologram.getIconSpacing() * 100.0)) / 100.0));
            cMIGuiButton.addLore(CMILC.getIML("hologram", "iconLore", new Object[0]));
            cMIGui.addButton(cMIGuiButton);
            cMIGuiButton = new CMIGuiButton(51, CMIMaterial.ENDER_EYE.newItemStack()){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    cMIHologram.setLOSInterval(cMIHologram.getLOSupdateIntervalSec() - HologramGUIEditor.modifyValue(gUIClickType, 0.1, 1.0, -0.1, -1.0));
                    CMI.getInstance().getHologramManager().resetHoloForAllPlayers(cMIHologram);
                    CMI.getInstance().getHologramManager().openGui(player, cMIHologram);
                    CMI.getInstance().getHologramManager().save();
                }
            };
            cMIGuiButton.setName(CMILC.getIM("hologram", "los", "[state]", cMIHologram.isCheckLineOfSight()));
            cMIGuiButton.addLore(CMILC.getIML("hologram", "losLore", "[interval]", (double)((int)(cMIHologram.getLOSupdateIntervalSec() * 100.0)) / 100.0));
            cMIGui.addButton(cMIGuiButton);
        }
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_9_R2) && (cMIHologram.getPitch() == 0 || !cMIHologram.getBillboard().equals((Object)CMIBillboard.FIXED))) {
            cMIGuiButton = new CMIGuiButton(44, CMIMaterial.STICK){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    HologramGUIEditor.editInteractions(player, cMIHologram);
                }
            };
            cMIGuiButton.setName(CMILC.getIM(hologram.class, "interactions", new Object[0]));
            cMIGui.addButton(cMIGuiButton);
        }
        cMIGuiButton = new CMIGuiButton(26, CMIMaterial.COMPASS){

            public void click(GUIManager.GUIClickType gUIClickType) {
                HologramGUIEditor.editLocation(player, cMIHologram);
            }
        };
        cMIGuiButton.setName(CMILC.getIM(hologram.class, "locationRange", new Object[0]));
        cMIGui.addButton(cMIGuiButton);
        cMIGui.fillEmptyButtons();
        cMIGui.open();
    }

    public static void editInteractions(final Player player, final CMIHologram cMIHologram) {
        final CMIGui cMIGui = new CMIGui(player);
        cMIGui.setTitle(cMIHologram.getName());
        cMIGui.setInvSize(6);
        CMIGuiButton cMIGuiButton = new CMIGuiButton(4, CMIMaterial.STICK.newItemStack()){

            public void click(GUIManager.GUIClickType gUIClickType) {
                cMIHologram.setInteractable(!cMIHologram.isInteractable());
                if (cMIHologram.isInteractable()) {
                    CMI.getInstance().getPacketInjector().addPlayer(player);
                }
                for (Player player2 : Bukkit.getOnlinePlayers()) {
                    cMIHologram.removeFromCache(player2.getUniqueId());
                    CMI.getInstance().getHologramManager().recheckInteractableHolograms(player2);
                }
                CMI.getInstance().getHologramManager().addPlayersNearHoloExtra(cMIHologram, true);
                CMI.getInstance().getHologramManager().addPlayersNearHolo(cMIHologram, true);
                HologramGUIEditor.editInteractions(player, cMIHologram);
                CMI.getInstance().getHologramManager().save();
            }
        };
        cMIGuiButton.setName(CMILC.getIM("hologram", "interact", "[state]", cMIHologram.isInteractable()));
        cMIGui.addButton(cMIGuiButton);
        if (cMIHologram.isInteractable()) {
            cMIGuiButton = new CMIGuiButton(16, CMIMaterial.BOW.newItemStack()){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    String string = String.valueOf(CommandsHandler.getLabel()) + " hologram editcommands " + cMIHologram.getName();
                    CMI.getInstance().performCommand((CommandSender)player, string);
                    this.setCloseInv(true);
                }
            };
            cMIGuiButton.setName(CMILC.getIM("hologram", "commands", new Object[0]));
            for (String string : cMIHologram.getCommands(null)) {
                cMIGuiButton.addLore("&7/" + string);
            }
            cMIGui.addButton(cMIGuiButton);
            cMIGuiButton = new CMIGuiButton(25, CMIMaterial.PAPER.newItemStack()){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    cMIHologram.setShowParticle(!cMIHologram.isShowParticle());
                    HologramGUIEditor.editInteractions(player, cMIHologram);
                    CMI.getInstance().getHologramManager().save();
                }
            };
            cMIGuiButton.setName(CMILC.getIM("hologram", "particles", "[state]", cMIHologram.isShowParticle()));
            cMIGui.addButton(cMIGuiButton);
            cMIGuiButton = new CMIGuiButton(10, cMIHologram.isNewIneractionMethod() ? CMIMaterial.GREEN_WOOL : CMIMaterial.YELLOW_WOOL){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    cMIHologram.setNewIneractionMethod(!cMIHologram.isNewIneractionMethod());
                    HologramGUIEditor.editInteractions(player, cMIHologram);
                    CMI.getInstance().getHologramManager().save();
                }
            };
            cMIGuiButton.setName(CMILC.getIM("hologram", "newMethod", "[state]", cMIHologram.isNewIneractionMethod()));
            cMIGui.addButton(cMIGuiButton);
            if (cMIHologram.isNewIneractionMethod()) {
                cMIGuiButton = new CMIGuiButton(11, cMIHologram.isShowHoverParticle() ? CMIMaterial.GREEN_CARPET : CMIMaterial.YELLOW_CARPET){

                    public void click(GUIManager.GUIClickType gUIClickType) {
                        cMIHologram.setShowHoverParticle(!cMIHologram.isShowHoverParticle());
                        HologramGUIEditor.editInteractions(player, cMIHologram);
                        CMI.getInstance().getHologramManager().save();
                    }
                };
                cMIGuiButton.setName(CMILC.getIM("hologram", "hoverParticles", "[state]", cMIHologram.isShowHoverParticle()));
                cMIGui.addButton(cMIGuiButton);
                if (cMIHologram.isShowHoverParticle()) {
                    cMIGuiButton = new CMIGuiButton(12, cMIHologram.isStabilizedHoverParticles() ? CMIMaterial.GREEN_STAINED_GLASS : CMIMaterial.YELLOW_STAINED_GLASS){

                        public void click(GUIManager.GUIClickType gUIClickType) {
                            cMIHologram.setStabilizedHoverParticles(!cMIHologram.isStabilizedHoverParticles());
                            HologramGUIEditor.editInteractions(player, cMIHologram);
                            CMI.getInstance().getHologramManager().save();
                        }
                    };
                    cMIGuiButton.setName(CMILC.getIM("hologram", "stabilizedParticles", "[state]", cMIHologram.isStabilizedHoverParticles()));
                    cMIGui.addButton(cMIGuiButton);
                    cMIGuiButton = new CMIGuiButton(28, CMIMaterial.OAK_FENCE){

                        public void click(GUIManager.GUIClickType gUIClickType) {
                            switch (gUIClickType) {
                                case Left: 
                                case LeftShift: {
                                    cMIHologram.setParticleCount(cMIHologram.getParticleCount() + 1);
                                    break;
                                }
                                case Right: 
                                case RightShift: {
                                    cMIHologram.setParticleCount(cMIHologram.getParticleCount() - 1);
                                    break;
                                }
                            }
                            HologramGUIEditor.editInteractions(player, cMIHologram);
                            CMI.getInstance().getHologramManager().save();
                        }
                    };
                    cMIGuiButton.setName(CMILC.getIM("hologram", "particleCount", "[count]", cMIHologram.getParticleCount()));
                    cMIGui.addButton(cMIGuiButton);
                    cMIGuiButton = new CMIGuiButton(29, cMIHologram.getHoverEffect().getParticle().getIcon()){

                        public void click(GUIManager.GUIClickType gUIClickType) {
                            switch (gUIClickType) {
                                case Left: 
                                case LeftShift: {
                                    CMIDebug.d((Object[])new Object[]{CMIEffectManager.CMIParticle.getParticleList().size(), cMIHologram.getHoverEffect().getParticle().getNextPartcileEffect()});
                                    cMIHologram.setHoverEffect(cMIHologram.getHoverEffect().getParticle().getNextPartcileEffect());
                                    break;
                                }
                                case Right: 
                                case RightShift: {
                                    cMIHologram.setHoverEffect(cMIHologram.getHoverEffect().getParticle().getPrevParticleEffect());
                                    break;
                                }
                            }
                            HologramGUIEditor.editInteractions(player, cMIHologram);
                            CMI.getInstance().getHologramManager().save();
                        }
                    };
                    cMIGuiButton.setName(CMILC.getIM("hologram", "particleType", "[type]", cMIHologram.getHoverEffect().getParticle().getName()));
                    cMIGui.addButton(cMIGuiButton);
                    cMIGuiButton = new CMIGuiButton(30, CMIMaterial.LADDER){

                        public void click(GUIManager.GUIClickType gUIClickType) {
                            cMIHologram.setParticleSpacing(CMINumber.sum((double)cMIHologram.getParticleSpacing(), (double)HologramGUIEditor.modifyValue(gUIClickType, -0.01, -0.1, 0.01, 0.1)));
                            switch (gUIClickType) {
                                case MiddleMouse: 
                                case Q: {
                                    cMIHologram.setParticleSpacing(0.0);
                                    break;
                                }
                            }
                            HologramGUIEditor.editInteractions(player, cMIHologram);
                            CMI.getInstance().getHologramManager().save();
                        }
                    };
                    cMIGuiButton.setName(CMILC.getIM("hologram", "particleSpacing", "[amount]", cMIHologram.getParticleSpacing()));
                    cMIGui.addButton(cMIGuiButton);
                    cMIGuiButton = new CMIGuiButton(41, CMIMaterial.BRICK_WALL){

                        public void click(GUIManager.GUIClickType gUIClickType) {
                            cMIHologram.setExtraParticleHeight(CMINumber.sum((double)cMIHologram.getExtraParticleHeight(), (double)HologramGUIEditor.modifyValue(gUIClickType, -0.01, -0.1, 0.01, 0.1)));
                            switch (gUIClickType) {
                                case MiddleMouse: 
                                case Q: {
                                    cMIHologram.setExtraParticleHeight(0.0);
                                    break;
                                }
                            }
                            HologramGUIEditor.editInteractions(player, cMIHologram);
                            CMI.getInstance().getHologramManager().save();
                        }
                    };
                    cMIGuiButton.setName(CMILC.getIM("hologram", "particleHeight", "[amount]", cMIHologram.getExtraParticleHeight()));
                    cMIGui.addButton(cMIGuiButton);
                    cMIGuiButton = new CMIGuiButton(42, CMIMaterial.BRICK_SLAB){

                        public void click(GUIManager.GUIClickType gUIClickType) {
                            cMIHologram.setExtraParticleWidth(CMINumber.sum((double)cMIHologram.getExtraParticleWidth(), (double)HologramGUIEditor.modifyValue(gUIClickType, -0.01, -0.1, 0.01, 0.1)));
                            switch (gUIClickType) {
                                case MiddleMouse: 
                                case Q: {
                                    cMIHologram.setExtraParticleWidth(0.0);
                                    break;
                                }
                            }
                            HologramGUIEditor.editInteractions(player, cMIHologram);
                            CMI.getInstance().getHologramManager().save();
                        }
                    };
                    cMIGuiButton.setName(CMILC.getIM("hologram", "particleWidth", "[amount]", cMIHologram.getExtraParticleWidth()));
                    cMIGui.addButton(cMIGuiButton);
                    cMIGuiButton = new CMIGuiButton(50, CMIMaterial.STONE_BRICK_WALL){

                        public void click(GUIManager.GUIClickType gUIClickType) {
                            cMIHologram.setParticleOffsetX(CMINumber.sum((double)cMIHologram.getParticleOffsetX(), (double)HologramGUIEditor.modifyValue(gUIClickType, -0.01, -0.1, 0.01, 0.1)));
                            switch (gUIClickType) {
                                case MiddleMouse: 
                                case Q: {
                                    cMIHologram.setParticleOffsetX(0.0);
                                    break;
                                }
                            }
                            HologramGUIEditor.editInteractions(player, cMIHologram);
                            CMI.getInstance().getHologramManager().save();
                        }
                    };
                    cMIGuiButton.setName(CMILC.getIM("hologram", "particleOffsetX", "[amount]", cMIHologram.getParticleOffsetX()));
                    cMIGui.addButton(cMIGuiButton);
                    cMIGuiButton = new CMIGuiButton(51, CMIMaterial.STONE_BRICK_SLAB){

                        public void click(GUIManager.GUIClickType gUIClickType) {
                            cMIHologram.setParticleOffsetY(CMINumber.sum((double)cMIHologram.getParticleOffsetY(), (double)HologramGUIEditor.modifyValue(gUIClickType, -0.01, -0.1, 0.01, 0.1)));
                            switch (gUIClickType) {
                                case MiddleMouse: 
                                case Q: {
                                    cMIHologram.setParticleOffsetY(0.0);
                                    break;
                                }
                            }
                            HologramGUIEditor.editInteractions(player, cMIHologram);
                            CMI.getInstance().getHologramManager().save();
                        }
                    };
                    cMIGuiButton.setName(CMILC.getIM("hologram", "particleOffsetY", "[amount]", cMIHologram.getParticleOffsetY()));
                    cMIGui.addButton(cMIGuiButton);
                }
            } else {
                cMIGuiButton = new CMIGuiButton(11, CMIMaterial.STONE.newItemStack()){

                    public void click(GUIManager.GUIClickType gUIClickType) {
                        cMIHologram.setBigButton(!cMIHologram.isBigButton());
                        cMIHologram.removeFromCache(player.getUniqueId());
                        cMIHologram.update();
                        HologramGUIEditor.editInteractions(player, cMIHologram);
                        CMI.getInstance().getHologramManager().save();
                    }
                };
                cMIGuiButton.setName(CMILC.getIM("hologram", "big", "[state]", cMIHologram.isBigButton()));
                cMIGuiButton.addLore(CMILC.getIML("hologram", "bigLore", new Object[0]));
                cMIGui.addButton(cMIGuiButton);
            }
            if (cMIHologram.isNewDisplayMethod()) {
                cMIGuiButton = new CMIGuiButton(14, CMIMaterial.BOOK.newItemStack()){

                    public void click(GUIManager.GUIClickType gUIClickType) {
                        cMIHologram.setAutoPagination(!cMIHologram.isAutoPagination());
                        CMI.getInstance().getHologramManager().resetHoloForAllPlayers(cMIHologram);
                        HologramGUIEditor.editInteractions(player, cMIHologram);
                        CMI.getInstance().getHologramManager().save();
                    }
                };
                cMIGuiButton.setName(CMILC.getIM("hologram", "embeddedAutoButton", "[state]", cMIHologram.isAutoPagination()));
                cMIGui.addButton(cMIGuiButton);
                if (cMIHologram.getTextAlignment() != CMITextAlignment.CENTER) {
                    cMIGuiButton = new CMIGuiButton(15, CMIMaterial.REINFORCED_DEEPSLATE.newItemStack()){

                        public void click(GUIManager.GUIClickType gUIClickType) {
                            switch (gUIClickType) {
                                case Left: 
                                case LeftShift: {
                                    cMIHologram.setAutoPaginationOffset(cMIHologram.getAutoPaginationOffset() + 1);
                                    break;
                                }
                                case MiddleMouse: {
                                    break;
                                }
                                case Q: {
                                    break;
                                }
                                case QControl: {
                                    break;
                                }
                                case Right: 
                                case RightShift: {
                                    cMIHologram.setAutoPaginationOffset(cMIHologram.getAutoPaginationOffset() - 1);
                                    break;
                                }
                                case Unknown: {
                                    break;
                                }
                            }
                            CMI.getInstance().getHologramManager().resetHoloForAllPlayers(cMIHologram);
                            HologramGUIEditor.editInteractions(player, cMIHologram);
                            CMI.getInstance().getHologramManager().save();
                        }
                    };
                    cMIGuiButton.setName(CMILC.getIM("hologram", "embeddedAutoButton", "[state]", cMIHologram.isAutoPagination()));
                    cMIGui.addButton(cMIGuiButton);
                }
            }
            cMIGuiButton = new CMIGuiButton(23, CMIMaterial.ACACIA_BUTTON.newItemStack()){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    String string = cMIHologram.getName();
                    String string2 = String.valueOf(string) + "#>";
                    String string3 = String.valueOf(string) + "#<";
                    CMIHologram cMIHologram3 = CMI.getInstance().getHologramManager().getByName(string2);
                    CMIHologram cMIHologram2 = CMI.getInstance().getHologramManager().getByName(string3);
                    if (cMIHologram3 != null || cMIHologram2 != null) {
                        return;
                    }
                    CMIDirection cMIDirection = CMI.getInstance().getPlayerManager().getUser(cMIGui.getPlayer()).getLookDirection();
                    CMIDirection cMIDirection2 = cMIDirection.rotate90CounterClockWise();
                    CMIDirection cMIDirection3 = cMIDirection.rotate90ClockWise();
                    cMIHologram3 = new CMIHologram(string2, cMIHologram.getLocation().clone().add((double)cMIDirection3.getX() / 2.0, cMIHologram.isDownOrder() != false ? -cMIHologram.getHeight() - 0.1 : -0.2, (double)cMIDirection3.getZ() / 2.0));
                    cMIHologram2 = new CMIHologram(string3, cMIHologram.getLocation().clone().add((double)cMIDirection2.getX() / 2.0, cMIHologram.isDownOrder() != false ? -cMIHologram.getHeight() - 0.1 : -0.2, (double)cMIDirection2.getZ() / 2.0));
                    cMIHologram3.makePersistent();
                    cMIHologram2.makePersistent();
                    cMIHologram3.setInteractable(true);
                    cMIHologram2.setInteractable(true);
                    if (cMIHologram.isNewIneractionMethod()) {
                        cMIHologram3.addLine("<T>" + LC.info_nextPageClean.getLocale(new Object[0]) + "</T><H>" + LC.info_nextPageClean.getLocale(new Object[0]) + "</H><C>" + CommandsHandler.getLabel() + " " + hologrampages.class.getSimpleName() + " " + cMIHologram.getName() + " [playerName] next</C>");
                        cMIHologram2.addLine("<T>" + LC.info_prevPageClean.getLocale(new Object[0]) + "</T><H>" + LC.info_prevPageClean.getLocale(new Object[0]) + "</H><C>" + CommandsHandler.getLabel() + " " + hologrampages.class.getSimpleName() + " " + cMIHologram.getName() + " [playerName] prev</C>");
                    } else {
                        cMIHologram3.setCommands(Arrays.asList(String.valueOf(CommandsHandler.getLabel()) + " " + hologrampages.class.getSimpleName() + " " + cMIHologram.getName() + " [playerName] next"));
                        cMIHologram2.setCommands(Arrays.asList(String.valueOf(CommandsHandler.getLabel()) + " " + hologrampages.class.getSimpleName() + " " + cMIHologram.getName() + " [playerName] prev"));
                        cMIHologram3.setLines(Arrays.asList(LC.info_nextPageClean.getLocale(new Object[0])));
                        cMIHologram2.setLines(Arrays.asList(LC.info_prevPageClean.getLocale(new Object[0])));
                    }
                    CMI.getInstance().getHologramManager().addHologram(cMIHologram3);
                    CMI.getInstance().getHologramManager().addHologram(cMIHologram2);
                    cMIHologram2.update();
                    cMIHologram3.update();
                    CMI.getInstance().getHologramManager().save();
                }
            };
            cMIGuiButton.setName(CMILC.getIM("hologram", "autoButton", new Object[0]));
            if (cMIHologram.getPageCount() == 1) {
                cMIGuiButton.addLore(CMILC.getIML("hologram", "autoButtonLore", new Object[0]));
            }
            if (CMI.getInstance().getHologramManager().getByName(String.valueOf(cMIHologram.getName()) + "#>") != null) {
                cMIGuiButton.addLore(CMILC.getIM("hologram", "autoButtonForward", new Object[0]));
            }
            if (CMI.getInstance().getHologramManager().getByName(String.valueOf(cMIHologram.getName()) + "#<") != null) {
                cMIGuiButton.addLore(CMILC.getIM("hologram", "autoButtonBackward", new Object[0]));
            }
            cMIGui.addButton(cMIGuiButton);
        }
        cMIGuiButton = new CMIGuiButton(45, CMILib.getInstance().getConfigManager().getGUIPreviousPage()){

            public void click(GUIManager.GUIClickType gUIClickType) {
                HologramGUIEditor.openGui(player, cMIHologram);
            }
        };
        cMIGuiButton.setName(LC.info_Back.getLocale(new Object[0]));
        cMIGui.addButton(cMIGuiButton);
        cMIGui.fillEmptyButtons();
        cMIGui.open();
    }

    public static void editLocation(final Player player, final CMIHologram cMIHologram) {
        CMIGui cMIGui = new CMIGui(player);
        cMIGui.setTitle(cMIHologram.getName());
        cMIGui.setInvSize(6);
        CMIGuiButton cMIGuiButton = new CMIGuiButton(4, CMIMaterial.COMPASS.newItemStack()){

            public void click(GUIManager.GUIClickType gUIClickType) {
                player.closeInventory();
                CMI.getInstance().getTeleportHandler().teleportPlayer(player, (Location)cMIHologram.getLocation(), CMITeleportType.HoloEdit);
            }
        };
        cMIGuiButton.setName(CMILC.getIM("hologram", "teleport", new Object[0]));
        cMIGui.addButton(cMIGuiButton);
        cMIGuiButton = new CMIGuiButton(10, CMIMaterial.LIME_CARPET.newItemStack()){

            public void click(GUIManager.GUIClickType gUIClickType) {
                cMIHologram.setUpdateRange(cMIHologram.getUpdateRange() - HologramGUIEditor.modifyValue(gUIClickType, 1, 10, -1, -10));
                cMIHologram.setArea(null);
                HologramGUIEditor.fullHoloReset(cMIHologram);
                CMI.getInstance().getHologramManager().save();
                CMI.getInstance().getSelectionManager().setSelectionCuboid(player, cMIHologram.getArea());
                CMI.getInstance().getSelectionManager().showSelection(player);
                HologramGUIEditor.editLocation(player, cMIHologram);
            }
        };
        cMIGuiButton.setName(CMILC.getIM("hologram", "updateRange", "[blocks]", cMIHologram.getUpdateRange()));
        cMIGuiButton.addLore(CMILC.getIML("hologram", "updateRangeLore", new Object[0]));
        cMIGui.addButton(cMIGuiButton);
        cMIGuiButton = new CMIGuiButton(19, CMIMaterial.MAGENTA_CARPET.newItemStack()){

            public void click(GUIManager.GUIClickType gUIClickType) {
                cMIHologram.setShowRange(cMIHologram.getShowRange() - HologramGUIEditor.modifyValue(gUIClickType, 1, 10, -1, -10));
                cMIHologram.setAreaExtra(null);
                HologramGUIEditor.fullHoloReset(cMIHologram);
                CMI.getInstance().getHologramManager().save();
                CMI.getInstance().getSelectionManager().setSelectionCuboid(player, cMIHologram.getAreaExtra());
                CMI.getInstance().getSelectionManager().showSelection(player);
                HologramGUIEditor.editLocation(player, cMIHologram);
            }
        };
        cMIGuiButton.setName(CMILC.getIM("hologram", "range", "[blocks]", cMIHologram.getShowRange()));
        cMIGuiButton.addLore(CMILC.getIML("hologram", "rangeLore", new Object[0]));
        cMIGui.addButton(cMIGuiButton);
        cMIGuiButton = new CMIGuiButton(31, CMIMaterial.CLOCK.newItemStack()){

            public void click(GUIManager.GUIClickType gUIClickType) {
                Location location = player.getLocation().clone();
                location.add(0.0, 1.0, 0.0);
                double d = cMIHologram.getHeight() / 2.0;
                if (cMIHologram.isDownOrder().booleanValue()) {
                    location.add(0.0, d, 0.0);
                } else {
                    location.add(0.0, -d, 0.0);
                }
                switch (gUIClickType) {
                    case Left: 
                    case Right: {
                        cMIHologram.setLoc(location);
                        break;
                    }
                    case LeftShift: 
                    case RightShift: {
                        location.setX((double)location.getBlockX());
                        location.setZ((double)location.getBlockZ());
                        cMIHologram.setLoc(location.add(0.5, 0.0, 0.5));
                        break;
                    }
                }
                CMI.getInstance().getHologramManager().resetHoloForAllPlayers(cMIHologram);
                HologramGUIEditor.editLocation(player, cMIHologram);
                CMI.getInstance().getSelectionManager().setSelectionCuboid(player, cMIHologram.getAreaExtra());
                CMI.getInstance().getSelectionManager().showSelection(player);
                CMI.getInstance().getHologramManager().save();
            }
        };
        cMIGuiButton.setName(CMILC.getIM("hologram", "relocate", new Object[0]));
        cMIGuiButton.addLore(CMILC.getIML("hologram", "relocateLore", new Object[0]));
        cMIGui.addButton(cMIGuiButton);
        cMIGuiButton = new CMIGuiButton(21, CMIMaterial.BLUE_WOOL.newItemStack()){

            public void click(GUIManager.GUIClickType gUIClickType) {
                CMILocation cMILocation = cMIHologram.getLocation().clone();
                cMILocation.add(HologramGUIEditor.modifyValue(gUIClickType, -0.01, -0.1, 0.01, 0.1), 0.0, 0.0);
                cMIHologram.setLoc((Location)cMILocation);
                CMI.getInstance().getHologramManager().resetHoloForAllPlayers(cMIHologram);
                HologramGUIEditor.editLocation(player, cMIHologram);
                CMI.getInstance().getHologramManager().save();
            }
        };
        cMIGuiButton.setName(CMILC.getIM("hologram", "moveX", "[x]", (double)((int)(cMIHologram.getLocation().getX() * 100.0)) / 100.0));
        cMIGuiButton.addLore(CMILC.getIML("hologram", "shift", new Object[0]));
        cMIGui.addButton(cMIGuiButton);
        cMIGuiButton = new CMIGuiButton(22, CMIMaterial.BROWN_WOOL.newItemStack()){

            public void click(GUIManager.GUIClickType gUIClickType) {
                CMILocation cMILocation = cMIHologram.getLocation().clone();
                cMILocation.add(0.0, HologramGUIEditor.modifyValue(gUIClickType, -0.01, -0.1, 0.01, 0.1), 0.0);
                cMIHologram.setLoc((Location)cMILocation);
                CMI.getInstance().getHologramManager().resetHoloForAllPlayers(cMIHologram);
                HologramGUIEditor.editLocation(player, cMIHologram);
                CMI.getInstance().getHologramManager().save();
            }
        };
        cMIGuiButton.setName(CMILC.getIM("hologram", "moveY", "[y]", (double)((int)(cMIHologram.getLocation().getY() * 100.0)) / 100.0));
        cMIGuiButton.addLore(CMILC.getIML("hologram", "shift", new Object[0]));
        cMIGui.addButton(cMIGuiButton);
        cMIGuiButton = new CMIGuiButton(23, CMIMaterial.GREEN_WOOL.newItemStack()){

            public void click(GUIManager.GUIClickType gUIClickType) {
                CMILocation cMILocation = cMIHologram.getLocation().clone();
                cMILocation.add(0.0, 0.0, HologramGUIEditor.modifyValue(gUIClickType, -0.01, -0.1, 0.01, 0.1));
                cMIHologram.setLoc((Location)cMILocation);
                CMI.getInstance().getHologramManager().resetHoloForAllPlayers(cMIHologram);
                HologramGUIEditor.editLocation(player, cMIHologram);
                CMI.getInstance().getHologramManager().save();
            }
        };
        cMIGuiButton.setName(CMILC.getIM("hologram", "moveZ", "[z]", (double)((int)(cMIHologram.getLocation().getZ() * 100.0)) / 100.0));
        cMIGuiButton.addLore(CMILC.getIML("hologram", "shift", new Object[0]));
        cMIGui.addButton(cMIGuiButton);
        cMIGuiButton = new CMIGuiButton(45, CMILib.getInstance().getConfigManager().getGUIPreviousPage()){

            public void click(GUIManager.GUIClickType gUIClickType) {
                HologramGUIEditor.openGui(player, cMIHologram);
            }
        };
        cMIGuiButton.setName(LC.info_Back.getLocale(new Object[0]));
        cMIGui.addButton(cMIGuiButton);
        cMIGui.fillEmptyButtons();
        cMIGui.open();
    }

    private static void fullHoloReset(CMIHologram cMIHologram) {
        CMI.getInstance().getHologramManager().recalculateChunksExtra(cMIHologram);
        CMI.getInstance().getHologramManager().addPlayersNearHoloExtra(cMIHologram, false);
        CMI.getInstance().getHologramManager().recalculateChunks(cMIHologram);
        CMI.getInstance().getHologramManager().addPlayersNearHolo(cMIHologram, false);
        CMI.getInstance().getHologramManager().resetHoloForAllPlayers(cMIHologram);
    }

    private static int modifyValue(GUIManager.GUIClickType gUIClickType, int n, int n2, int n3, int n4) {
        switch (gUIClickType) {
            case Left: {
                return n;
            }
            case LeftShift: {
                return n2;
            }
            case Right: {
                return n3;
            }
            case RightShift: {
                return n4;
            }
        }
        return 0;
    }

    private static double modifyValue(GUIManager.GUIClickType gUIClickType, double d, double d2, double d3, double d4) {
        switch (gUIClickType) {
            case Left: {
                return d;
            }
            case LeftShift: {
                return d2;
            }
            case Right: {
                return d3;
            }
            case RightShift: {
                return d4;
            }
        }
        return 0.0;
    }
}

