/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Homes;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Containers.Snd;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Homes.CmiHome;
import com.Zrips.CMI.Modules.Homes.HomeWorldLimit;
import com.Zrips.CMI.Modules.Permissions.PermissionInfo;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.Modules.Warps.CmiWarp;
import com.Zrips.CMI.commands.CommandsHandler;
import com.Zrips.CMI.commands.list.dback;
import com.Zrips.CMI.commands.list.home;
import com.Zrips.CMI.commands.list.homes;
import com.Zrips.CMI.commands.list.removehome;
import com.Zrips.CMI.commands.list.sethome;
import com.Zrips.CMI.utils.SpawnUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Container.CMILocation;
import net.Zrips.CMILib.Container.MaterialPicker;
import net.Zrips.CMILib.Container.PageInfo;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.GUI.CMIGui;
import net.Zrips.CMILib.GUI.CMIGuiButton;
import net.Zrips.CMILib.GUI.GUIManager;
import net.Zrips.CMILib.Items.CMIItemStack;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Locale.LC;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.data.type.RespawnAnchor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class HomeManager {
    private CMI plugin;
    HashMap<String, Integer> homeGroups = new HashMap();
    private HashMap<String, HomeWorldLimit> homeLimits = new HashMap();
    private boolean checkBlockbreak = false;
    private boolean pickRealBlock = false;
    private boolean homesWorldLimits = false;
    private boolean confirmation = true;
    private String defaultHomeName = "Home";
    private String defaultBedHomeName = "Home";
    private String homeNameRegex = "/([\\p{L}-]+)/ug";
    private int respawnImmortality = 0;
    private int HomesMaxGuiSlots = 99;
    private boolean HomesGui = true;
    private boolean HomesGuiComplex = true;
    private boolean guiExpanded = false;
    private CMIItemStack guiBorder = null;
    private CMIItemStack guiInfill = null;
    private boolean guiInfoButton = true;
    private int guiInfoButtonSlot = 45;
    private CMIItemStack guiInfoButtonItem = null;
    private List<String> guiInfoButtonCommands = null;
    private boolean guiCloseButton = true;
    private int guiCloseButtonSlot = 45;
    private CMIItemStack guiCloseButtonItem = null;
    private List<String> guiCloseButtonCommands = null;
    private boolean guiBedButton = true;
    private int guiBedButtonSlot = 45;
    private CMIItemStack guiBedButtonItem = null;
    private boolean guiHomeButton = true;
    private int guiHomeButtonSlot = 45;
    private CMIItemStack guiHomeButtonItem = null;
    private boolean guiDeathButton = true;
    private int guiDeathButtonSlot = 45;
    private CMIItemStack guiDeathButtonItem = null;
    private int guiPrevButtonSlot = 49;
    private int guiMiddleButtonSlot = 50;
    private int guiNextButtonSlot = 51;
    private boolean HomesBedInteraction = true;
    private boolean onlyShiftBed = false;
    private boolean RemoveBedLocationOnBedBreak = true;
    private HashMap<String, List<String>> ReSpawnPriorityOrder = new HashMap();
    private HashMap<String, HashMap<CMIUser, CmiHome>> bedHomes = new HashMap();

    public HomeManager(CMI cMI) {
        this.plugin = cMI;
    }

    public void addHomeGroup(String string, int n) {
        this.homeGroups.put(string, n);
    }

    public int getMaxHomes(CommandSender commandSender) {
        if (commandSender instanceof Player) {
            return this.getMaxHomes((Player)commandSender);
        }
        return 999;
    }

    public int getMaxHomes(Player player) {
        int n = 1;
        if (player == null || !player.isOnline()) {
            return n;
        }
        if (PermissionsManager.CMIPerm.command_sethome_unlimited.hasPermission((CommandSender)player)) {
            return 9999;
        }
        for (Map.Entry<String, Integer> object2 : this.homeGroups.entrySet()) {
            if (!PermissionsManager.CMIPerm.command_sethome_$1.hasPermission((CommandSender)player, object2.getKey()) || object2.getValue() <= n) continue;
            n = object2.getValue();
        }
        PermissionInfo permissionInfo = this.plugin.getPermissionsManager().getPermissionInfo(player, PermissionsManager.CMIPerm.command_sethome_$1);
        if (permissionInfo.getMaxValue() != null && permissionInfo.getMaxValue() > (double)n) {
            n = permissionInfo.getMaxValue().intValue();
        }
        return n;
    }

    public void loadConfig() {
        Object object52;
        Object object;
        Object object4;
        ConfigReader configReader = null;
        try {
            configReader = new ConfigReader((Plugin)this.plugin, "Settings" + File.separator + "Homes.yml");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        ConfigReader configReader2 = this.plugin.getConfigManager().getConfig();
        if (configReader2.getC().isConfigurationSection("Homes") && !configReader.getC().isConfigurationSection("Homes")) {
            configReader.set("Homes", (Object)configReader2.getC().getConfigurationSection("Homes"));
            configReader.save();
            try {
                configReader = new ConfigReader((Plugin)this.plugin, "Settings" + File.separator + "Homes.yml");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        configReader.addComment("Homes.Confirmation", new String[]{"When enabled we will require player to click on ingame chat to confirm home location override in case home with same name already exist", "This can be dirrectly confirmed with /cmi sethome [homeName] -override"});
        this.confirmation = configReader.get("Homes.Confirmation", Boolean.valueOf(true));
        configReader.addComment("Homes.MaxGuiSlots", new String[]{"This defines max slot number player could provide while creating home with /sethome [homeName] [slotNumber]"});
        this.HomesMaxGuiSlots = configReader.get("Homes.MaxGuiSlots", 99);
        configReader.addComment("Homes.Gui.Use", new String[]{"Open gui when using /cmi home command if you have more then one home in your saved list"});
        this.HomesGui = configReader.get("Homes.Gui.Use", Boolean.valueOf(configReader.getC().getBoolean("Homes.Gui", true)));
        configReader.addComment("Homes.Gui.Complex", new String[]{"When enabled we will create more complex home UI with extra buttons and options while keeping this disabled we will simply list homes in a row"});
        this.HomesGuiComplex = configReader.get("Homes.Gui.Complex", Boolean.valueOf(true));
        configReader.addComment("Homes.Gui.Options.Expanded", new String[]{"When enabled we will expand area for homes from 10 to 28"});
        this.guiExpanded = configReader.get("Homes.Gui.Options.Expanded", Boolean.valueOf(false));
        configReader.addComment("Homes.Gui.Options.Border", new String[]{"Keep it empty if you want to use global infill material"});
        this.guiBorder = CMILib.getInstance().getItemManager().getItem(configReader.get("Homes.Gui.Options.Border", ""));
        configReader.addComment("Homes.Gui.Options.Infill", new String[]{"Material around homes when its not in expanded state"});
        this.guiInfill = CMILib.getInstance().getItemManager().getItem(configReader.get("Homes.Gui.Options.Infill", "WHITE_STAINED_GLASS_PANE"));
        String string = "Homes.Gui.Options.InfoButton.";
        configReader.addComment(String.valueOf(string) + "Use", new String[]{"Extra button to be used in case you want to provide any aditional information when clicking on it"});
        this.guiInfoButton = configReader.get(String.valueOf(string) + "Use", Boolean.valueOf(false));
        this.guiInfoButtonSlot = configReader.get(String.valueOf(string) + "Slot", 1) - 1;
        this.guiInfoButtonItem = CMILib.getInstance().getItemManager().getItem(configReader.get(String.valueOf(string) + "Material", "head:eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNDZiYTYzMzQ0ZjQ5ZGQxYzRmNTQ4OGU5MjZiZjNkOWUyYjI5OTE2YTZjNTBkNjEwYmI0MGE1MjczZGM4YzgyIn19fQ=="));
        this.guiInfoButtonCommands = configReader.get(String.valueOf(string) + "Commands", Arrays.asList("closeinv!"));
        string = "Homes.Gui.Options.CloseButton.";
        this.guiCloseButton = configReader.get(String.valueOf(string) + "Use", Boolean.valueOf(true));
        this.guiCloseButtonSlot = configReader.get(String.valueOf(string) + "Slot", 9) - 1;
        this.guiCloseButtonItem = CMILib.getInstance().getItemManager().getItem(configReader.get(String.valueOf(string) + "Material", "head:eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNmNjYmY5ODgzZGQzNTlmZGYyMzg1YzkwYTQ1OWQ3Mzc3NjUzODJlYzQxMTdiMDQ4OTVhYzRkYzRiNjBmYyJ9fX0="));
        this.guiCloseButtonCommands = configReader.get(String.valueOf(string) + "Commands", Arrays.asList("closeinv!"));
        string = "Homes.Gui.Options.bedButton.";
        this.guiBedButton = configReader.get(String.valueOf(string) + "Use", Boolean.valueOf(true));
        this.guiBedButtonSlot = configReader.get(String.valueOf(string) + "Slot", 4) - 1;
        this.guiBedButtonItem = CMILib.getInstance().getItemManager().getItem(configReader.get(String.valueOf(string) + "Material", "LIGHT_BLUE_BED"));
        string = "Homes.Gui.Options.homeButton.";
        this.guiHomeButton = configReader.get(String.valueOf(string) + "Use", Boolean.valueOf(true));
        this.guiHomeButtonSlot = configReader.get(String.valueOf(string) + "Slot", 5) - 1;
        this.guiHomeButtonItem = CMILib.getInstance().getItemManager().getItem(configReader.get(String.valueOf(string) + "Material", "head:eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTJkN2E3NTFlYjA3MWUwOGRiYmM5NWJjNWQ5ZDY2ZTVmNTFkYzY3MTI2NDBhZDJkZmEwM2RlZmJiNjhhN2YzYSJ9fX0="));
        string = "Homes.Gui.Options.deathButton.";
        this.guiDeathButton = configReader.get(String.valueOf(string) + "Use", Boolean.valueOf(true));
        this.guiDeathButtonSlot = configReader.get(String.valueOf(string) + "Slot", 6) - 1;
        this.guiDeathButtonItem = CMILib.getInstance().getItemManager().getItem(configReader.get(String.valueOf(string) + "Material", "TOTEM_OF_UNDYING"));
        this.guiPrevButtonSlot = configReader.get("Homes.Gui.Options.prevButton.Slot", 46) - 1;
        this.guiMiddleButtonSlot = configReader.get("Homes.Gui.Options.middleButton.Slot", 50) - 1;
        this.guiNextButtonSlot = configReader.get("Homes.Gui.Options.nextButton.Slot", 54) - 1;
        configReader.addComment("Homes.Groups", new String[]{"Homes groups to define max amount homes player can have. Permission: cmi.command.sethome.[groupname]", "If players home group if not find then amount will be set to 1", "To have unlimited homes use cmi.command.sethome.unlimited permission", "In addition to this you can use simple numeric permission node cmi.command.sethome.[number] which will define max number of homes player can have"});
        if (!configReader.getC().isConfigurationSection("Homes.Groups")) {
            this.addHomeGroup("newbie", configReader.get("Homes.Groups.Newbie", 2));
            this.addHomeGroup("advanced", configReader.get("Homes.Groups.Advanced", 3));
            this.addHomeGroup("vip", configReader.get("Homes.Groups.Vip", 5));
        } else {
            try {
                object4 = configReader.getC().getConfigurationSection("Homes.Groups").getValues(true);
                for (Map.Entry object32 : object4.entrySet()) {
                    this.addHomeGroup(((String)object32.getKey()).toLowerCase(), configReader.get("Homes.Groups." + (String)object32.getKey(), ((Integer)object32.getValue()).intValue()));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        configReader.addComment("Homes.BedInteraction", new String[]{"Requires cmi.bedhome permission node", "When set to true by interacting with bed, regular home location will be created", "When set to false vanilla bed home location will be set"});
        this.HomesBedInteraction = configReader.get("Homes.BedInteraction", Boolean.valueOf(true));
        configReader.addComment("Homes.onlyShiftBed", new String[]{"When set to true, you can only set home location when you shift click a bed"});
        this.onlyShiftBed = configReader.get("Homes.onlyShiftBed", Boolean.valueOf(false));
        configReader.addComment("Homes.RemoveBedLocationOnBedBreak", new String[]{"Removes bed location when home location was created by clicking on that bed"});
        this.RemoveBedLocationOnBedBreak = configReader.get("Homes.RemoveBedLocationOnBedBreak", Boolean.valueOf(true));
        configReader.addComment("Homes.CheckBlockBreak", new String[]{"When enabled, plugin will check if player can break block in that area before creating new home location", "This allows to prevent setting homes in protected areas", "Can be bypassed with cmi.command.sethome.bypass"});
        this.checkBlockbreak = configReader.get("Homes.CheckBlockBreak", Boolean.valueOf(false));
        configReader.addComment("Homes.DefaultName", new String[]{"Name for default home location. By default its \"Home\""});
        this.defaultHomeName = configReader.get("Homes.DefaultName", "Home").replace(" ", "");
        configReader.addComment("Homes.DefaultBedName", new String[]{"Name for bed location. By default its \"Home\"", "Different name can be used to identify home location set by interacting with a bed from home location created with command"});
        this.defaultBedHomeName = configReader.get("Homes.DefaultBedName", configReader.getC().getString("Homes.DefaultName", "Home")).replace(" ", "");
        configReader.addComment("Homes.ValidNameRegex", new String[]{"Defines what characters you can use in your home names"});
        this.homeNameRegex = configReader.get("Homes.ValidNameRegex", "[^a-zA-Z0-9\\-\\_]");
        if (Version.isCurrentEqualOrLower((Version)Version.v1_13_R2)) {
            configReader.addComment("Homes.PickRealBlock", new String[]{"When set to true home icons in GUI will try to pick real blocks from that location for easy way to see which is which", "When set to false, then random wool block will be used"});
            this.pickRealBlock = configReader.get("Homes.PickRealBlock", Boolean.valueOf(true));
        } else {
            this.pickRealBlock = false;
        }
        configReader.addComment("Homes.WorldLimits.Use", new String[]{"When enabled home creation will be limited by defined criteria", "This can be bypassed if you have " + PermissionsManager.CMIPerm.command_sethome_bypasslimit.getPermission() + " permission node"});
        this.homesWorldLimits = configReader.get("Homes.WorldLimits.Use", Boolean.valueOf(false));
        this.homeLimits.clear();
        if (!configReader.getC().isConfigurationSection("Homes.WorldLimits.Groups")) {
            object4 = "Homes.WorldLimits.Groups.";
            configReader.get(String.valueOf(object4) + "Example1.Amount", 3);
            configReader.get(String.valueOf(object4) + "Example1.Worlds", Arrays.asList("testWorld"));
            configReader.get(String.valueOf(object4) + "Example2.Amount", 5);
            configReader.get(String.valueOf(object4) + "Example2.Worlds", Arrays.asList("testWorld2", "testWorld3"));
        } else {
            object4 = configReader.getC().getConfigurationSection("Homes.WorldLimits.Groups").getKeys(false);
            boolean bl = false;
            object = object4.iterator();
            while (object.hasNext()) {
                boolean bl2;
                object52 = (String)object.next();
                if (!bl2) {
                    configReader.addComment("Homes.WorldLimits.Groups." + (String)object52 + ".Worlds", new String[]{"World list where this limit should apply to. Multiple worlds can be defined if you want to group them up"});
                    configReader.addComment("Homes.WorldLimits.Groups." + (String)object52 + ".Amount", new String[]{"Amount of homes you can have in this world home group. Setting to 0 would basically disable home creation in this world. Setting to lower than 0 will ignore this world group entirely"});
                }
                bl2 = true;
                int n = configReader.get("Homes.WorldLimits.Groups." + (String)object52 + ".Amount", 3);
                List list2 = configReader.get("Homes.WorldLimits.Groups." + (String)object52 + ".Worlds", Arrays.asList(""));
                HomeWorldLimit homeWorldLimit = new HomeWorldLimit();
                homeWorldLimit.setWorlds(list2);
                homeWorldLimit.setLimit(n);
                for (String string2 : list2) {
                    this.homeLimits.put(string2.toLowerCase(), homeWorldLimit);
                }
            }
        }
        configReader.save();
        configReader2.addComment("ReSpawn.Immortality", new String[]{"Time in seconds to make player immortal after he respawns", "Can be used to prevent respawn camping", "Set to 0 if you want to disable it", "Max 60 seconds"});
        this.respawnImmortality = configReader2.get("ReSpawn.Immortality", 3);
        if (this.respawnImmortality > 60) {
            this.respawnImmortality = 60;
        }
        configReader2.addComment("ReSpawn.Enabled", new String[]{"If you want 3rd party plugin to handle player respawning, simply set this to false and reload plugin"});
        boolean bl = configReader2.get("ReSpawn.Enabled", Boolean.valueOf(true));
        this.ReSpawnPriorityOrder.clear();
        configReader2.addComment("ReSpawn.Global.PriorityOrder", new String[]{"Defines respawn order if defined world is not present in Specific list", "Possible respawn locations: " + RespawnPriority.getAsString() + ", warp![warpName]", "Spawn is preset spawnlocation with /cmi setspawn command, that location should have RespawnLocation set to true", "bedLocation is location set by interacting with bed, BedInteraction should be set to false and players requires cmi.bedhome to set bed location", "homeLocation is location set by player which is with default (Home) name, if that one doesnt exist then first in the list will be used if possible", "worldSpawn is location preset to this world, this is not CMI location but default world spawn location", "anchor is location defined by interacting with respawn anchor. This in general will only apply when you die in nether world, otherwise bed location is used", "warp![warpName] can be any valid warp you set for players to be teleported, they will bypass any requirements for that warp"});
        List list3 = configReader2.get("ReSpawn.Global.PriorityOrder", RespawnPriority.getAsStringList());
        if (bl) {
            this.ReSpawnPriorityOrder.put("defaultSet", list3);
        }
        configReader2.addComment("ReSpawn.Specific", new String[]{"Defines respawn order for defined worlds", "Set respawn priority to [] or to random respawn criteria if you want to leave respawn handling for server or 3rd party plugin"});
        if (!configReader2.getC().isConfigurationSection("ReSpawn.Specific")) {
            for (Object object52 : Bukkit.getWorlds()) {
                List list4 = configReader2.get("ReSpawn.Specific." + object52.getName(), RespawnPriority.getAsStringList());
                if (!bl) continue;
                this.ReSpawnPriorityOrder.put(object52.getName(), list4);
            }
        } else {
            object52 = configReader2.getC().getConfigurationSection("ReSpawn.Specific").getKeys(false);
            Iterator iterator = object52.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                List list5 = configReader2.get("ReSpawn.Specific." + (String)object, RespawnPriority.getAsStringList());
                if (!bl) continue;
                this.ReSpawnPriorityOrder.put((String)object, list5);
            }
        }
    }

    public boolean isHomesBedInteraction() {
        return this.HomesBedInteraction;
    }

    public Location getReSpawnLocation(Player player) {
        return this.getReSpawnLocation(player, null);
    }

    /*
     * WARNING - void declaration
     */
    public Location getReSpawnLocation(Player player, Location location) {
        World world2 = player.getWorld();
        List<String> list2 = null;
        if (world2 != null) {
            list2 = this.ReSpawnPriorityOrder.get(world2.getName());
        }
        if (list2 == null) {
            list2 = this.ReSpawnPriorityOrder.get("defaultSet");
        }
        if (list2 == null || list2.isEmpty()) {
            return null;
        }
        if (CMIUser.getUser(player).isJailed()) {
            return null;
        }
        block11: for (String string : list2) {
            Object object;
            Object object2;
            if (string.startsWith("warp!")) {
                object2 = string.substring("warp!".length());
                object = this.plugin.getWarpManager().getWarp((String)object2);
                if (object == null) continue;
                return ((CmiWarp)object).getLocIncRand();
            }
            object2 = RespawnPriority.getByName(string);
            if (object2 == null) continue;
            switch (object2) {
                case anchor: {
                    try {
                        if (Version.isCurrentEqualOrHigher((Version)Version.v1_16_R1)) {
                            object = player.getRespawnLocation();
                            if (object == null) continue block11;
                            return object;
                        }
                        if (player.getBedSpawnLocation() == null || !player.getBedSpawnLocation().getWorld().getEnvironment().equals((Object)World.Environment.NETHER) || location == null || !location.clone().add(location.getDirection()).getBlock().getType().equals((Object)Material.RESPAWN_ANCHOR) || (object = (RespawnAnchor)location.clone().add(location.getDirection()).getBlock().getBlockData()).getCharges() <= 0) continue block11;
                        return null;
                    }
                    catch (Throwable throwable) {
                        break;
                    }
                }
                case bedLocation: {
                    try {
                        if (Version.isCurrentEqualOrHigher((Version)Version.v1_16_R1)) {
                            object = player.getRespawnLocation();
                            if (object == null) continue block11;
                            return object;
                        }
                        if (player.getBedSpawnLocation() == null || player.getBedSpawnLocation().getWorld().getEnvironment().equals((Object)World.Environment.NETHER) || player.getBedSpawnLocation() == null) continue block11;
                        return player.getBedSpawnLocation();
                    }
                    catch (Throwable throwable) {}
                    continue block11;
                }
                case homeLocation: {
                    object = this.plugin.getPlayerManager().getUser(player);
                    if (object == null) {
                        return null;
                    }
                    CmiHome cmiHome = ((CMIUser)object).getHome(CMI.getInstance().getHomeManager().getDefaultHomeName());
                    ArrayList<String> arrayList = ((CMIUser)object).getHomesList();
                    if (cmiHome == null && !((CMIUser)object).getHomesList().isEmpty()) {
                        for (String string2 : arrayList) {
                            cmiHome = ((CMIUser)object).getHome(string2);
                            if (cmiHome.getLoc().isValid()) break;
                        }
                    }
                    if (cmiHome == null || cmiHome.getLoc() == null) continue block11;
                    return cmiHome.getLoc();
                }
                case spawn: {
                    void var11_17;
                    CMILocation cMILocation;
                    CMILocation cMILocation2 = SpawnUtil.getGroupReSpawnPoint(player);
                    if (cMILocation2 == null && (cMILocation = SpawnUtil.getSpawnPoint(player)) == null) continue block11;
                    return var11_17;
                }
                case worldSpawn: {
                    Location location2 = player.getWorld().getSpawnLocation();
                    if (location2 == null) continue block11;
                    return location2;
                }
            }
        }
        return null;
    }

    public boolean isCheckBlockbreak() {
        return this.checkBlockbreak;
    }

    public String getDefaultHomeName() {
        return this.defaultHomeName;
    }

    public String getDefaultBedHomeName() {
        return this.defaultBedHomeName;
    }

    public HashMap<String, HashMap<CMIUser, CmiHome>> getBedHomes() {
        return this.bedHomes;
    }

    public void addBedHome(CMIUser cMIUser, CmiHome cmiHome) {
        if (Math.abs(cmiHome.getLoc().getX() % 1.0) != 0.5 && Math.abs(cmiHome.getLoc().getZ() % 1.0) != 0.5) {
            return;
        }
        String string = this.plugin.getPlayerManager().convertBlockLocToString((Location)cmiHome.getLoc());
        HashMap<CMIUser, CmiHome> hashMap = new HashMap<CMIUser, CmiHome>();
        hashMap.put(cMIUser, cmiHome);
        cmiHome.setBed(true);
        this.bedHomes.put(string, hashMap);
    }

    public boolean removeBedHome(Location location) {
        String string = this.plugin.getPlayerManager().convertBlockLocToString(location);
        HashMap<CMIUser, CmiHome> hashMap = this.bedHomes.remove(string);
        if (hashMap == null) {
            return false;
        }
        for (Map.Entry<CMIUser, CmiHome> entry : hashMap.entrySet()) {
            entry.getKey().removeHome(entry.getValue());
            for (Map.Entry<String, CmiHome> entry2 : new HashMap<String, CmiHome>(entry.getKey().getHomes()).entrySet()) {
                if (!this.plugin.getPlayerManager().convertBlockLocToString((Location)entry2.getValue().getLoc()).equals(string)) continue;
                entry.getKey().removeHome(entry2.getValue());
            }
            entry.getKey().addForDelayedSave();
        }
        return false;
    }

    public boolean isRemoveBedLocationOnBedBreak() {
        return this.RemoveBedLocationOnBedBreak;
    }

    public boolean openHomeGui(Player player, CMIUser cMIUser, int n) {
        if (n < 1) {
            n = 1;
        }
        if (this.isHomesGuiComplex()) {
            return this.openComplexHomeGui(player, cMIUser, n);
        }
        return this.openSimpleHomeGui(player, cMIUser, n);
    }

    /*
     * WARNING - void declaration
     */
    public boolean openComplexHomeGui(final Player player, final CMIUser cMIUser, int n) {
        Location location;
        Iterator iterator;
        CmiHome cmiHome;
        void var17_38;
        int n2;
        int n3;
        int n4;
        int n5;
        if (cMIUser == null || player == null || !player.isOnline()) {
            return false;
        }
        Snd snd = new Snd();
        snd.setTarget(cMIUser);
        snd.setSource(cMIUser);
        CMIGui cMIGui = new CMIGui(player){

            public void pageChange(int n) {
                HomeManager.this.openComplexHomeGui(player, cMIUser, n);
            }
        };
        cMIGui.setInvSize(GUIManager.GUIRows.r6);
        int n6 = this.guiExpanded ? 7 : 5;
        int n7 = this.guiExpanded ? n6 * 4 : n6 * 2;
        int n8 = n5 = this.guiExpanded ? 2 : 3;
        int n9 = n5 - 1 + (n8 - 1) * 9;
        if (!this.guiExpanded) {
            int n10 = n7 / n6;
            n4 = n5 - 1;
            while (n4 <= n5 + n6) {
                int n11 = n8 - 1;
                while (n11 <= n8 + n10) {
                    if (n11 == n8 + n10 || n11 == n8 - 1 || n4 == n5 - 1 || n4 == n5 + n6) {
                        int n12 = (n11 - 1) * 9 + n4 - 1;
                        CMIGuiButton object2 = new CMIGuiButton(Integer.valueOf(n12), this.guiInfill);
                        object2.setName(" ");
                        cMIGui.addButton(object2);
                    }
                    ++n11;
                }
                ++n4;
            }
        }
        TreeMap<Integer, CmiHome> treeMap = new TreeMap<Integer, CmiHome>();
        n4 = 0;
        LinkedHashSet<CmiHome> linkedHashSet = new LinkedHashSet<CmiHome>();
        if (n == 1) {
            for (CmiHome cmiHome2 : cMIUser.getHomes().values()) {
                if (!cmiHome2.isFavorite()) continue;
                n4 = 1;
                linkedHashSet.add(cmiHome2);
                if (linkedHashSet.size() != n7) {
                    continue;
                }
                break;
            }
        } else {
            for (CmiHome cmiHome3 : cMIUser.getHomes().values()) {
                if (!cmiHome3.isFavorite()) continue;
                n4 = 1;
            }
        }
        if (n4 == 0 || n > 1 && n4 != 0) {
            linkedHashSet.addAll(cMIUser.getHomes().values());
        }
        if (n > 1 && n4 != 0) {
            int n13 = 0;
            while (n13 < n7) {
                treeMap.put(n13, null);
                ++n13;
            }
        }
        PageInfo pageInfo = new PageInfo(n7, cMIUser.getLastHomeSlot() + (n4 != 0 ? 1 : 0), n);
        if (n4 != 0) {
            pageInfo.setTotalPages(pageInfo.getTotalPages() + 1);
        }
        for (CmiHome cmiHome4 : linkedHashSet) {
            if (cmiHome4.getSlot() == null || n > 1 && cmiHome4.isFavorite()) continue;
            if (treeMap.containsKey(cmiHome4.getSlot())) {
                int n10 = 0;
                n3 = 0;
                while (n3 < treeMap.size() + linkedHashSet.size()) {
                    if (!treeMap.containsKey(cmiHome4.getSlot() + n3)) {
                        n10 = n3;
                        break;
                    }
                    ++n3;
                }
                treeMap.put(cmiHome4.getSlot() + n10, cmiHome4);
                continue;
            }
            treeMap.put(cmiHome4.getSlot(), cmiHome4);
        }
        boolean bl = true;
        for (CmiHome cmiHome5 : linkedHashSet) {
            void var15_28;
            if (cmiHome5.getSlot() != null || n > 1 && cmiHome5.isFavorite()) continue;
            if (treeMap.containsKey((int)var15_28)) {
                n3 = 0;
                n2 = 0;
                while (n2 < treeMap.size() + linkedHashSet.size()) {
                    if (!treeMap.containsKey((int)(var15_28 + n2))) {
                        n3 = n2;
                        break;
                    }
                    ++n2;
                }
                treeMap.put((int)(var15_28 + n3), cmiHome5);
                var15_28 += n3;
                continue;
            }
            treeMap.put((int)var15_28, cmiHome5);
            ++var15_28;
        }
        TreeMap treeMap2 = new TreeMap(treeMap);
        treeMap.clear();
        for (Map.Entry entry : treeMap2.entrySet()) {
            if (pageInfo.getStart() > (Integer)entry.getKey()) continue;
            if (pageInfo.getStart() + n7 < (Integer)entry.getKey()) break;
            treeMap.put((Integer)entry.getKey() - (pageInfo.getCurrentPage() - 1) * n7, (CmiHome)entry.getValue());
        }
        boolean bl2 = false;
        while (var17_38 < n7) {
            if (treeMap.get((int)var17_38) == null) {
                treeMap.put((int)var17_38, null);
            }
            ++var17_38;
        }
        cMIGui.setTitle(CMILC.getIM(home.class, "guiTitle", "[current]", cMIUser.getHomes().size(), "[max]", this.plugin.getHomeManager().getMaxHomes(cMIUser.getPlayer(false)), snd));
        final CmiHome cmiHome6 = cMIUser.getBedHome();
        final boolean bl3 = player.getUniqueId().equals(cMIUser.getUniqueId());
        n2 = PermissionsManager.CMIPerm.command_sethome_$1.hasPermission((CommandSender)player, "others") ? 1 : 0;
        for (Map.Entry entry : treeMap.entrySet()) {
            CmiHome cmiHome7;
            int n11 = (Integer)entry.getKey();
            if (++n11 < 0) {
                n11 = n9;
            }
            n11 = n9 + n11 + (n11 - 1) / n6 * (9 - n6);
            --n11;
            if (entry.getValue() == null) {
                cmiHome7 = new CMIGuiButton(Integer.valueOf(n11));
                cmiHome7.lockField();
                cMIGui.addButton((CMIGuiButton)cmiHome7, n7);
                continue;
            }
            cmiHome7 = (CmiHome)entry.getValue();
            CMILocation cMILocation = cmiHome7.getLoc();
            boolean bl4 = true;
            if (cMILocation == null || cMILocation.getWorld() == null) {
                bl4 = false;
            }
            final boolean bl5 = bl4;
            CMIItemStack cMIItemStack = cmiHome7.getIconMaterial().newCMIItemStack();
            if (cmiHome7.getName().equals(this.defaultHomeName) && cmiHome7.getMaterial() == null) {
                cMIItemStack = this.guiHomeButtonItem;
            }
            if (cmiHome6 != null && cmiHome7.equals(cmiHome6) && cmiHome7.getMaterial() == null) {
                cMIItemStack = this.guiBedButtonItem;
            }
            if (!bl4 && Version.isCurrentEqualOrHigher((Version)Version.v1_13_R1)) {
                cMIItemStack = CMIMaterial.BARRIER.newCMIItemStack();
            }
            CMIGuiButton cMIGuiButton = new CMIGuiButton(n11, cMIItemStack, n2 != 0, n, pageInfo){
                private final /* synthetic */ boolean val$canEdit;
                private final /* synthetic */ int val$page;
                private final /* synthetic */ PageInfo val$pi;
                {
                    this.val$canEdit = bl32;
                    this.val$page = n2;
                    this.val$pi = pageInfo;
                    super(n, cMIItemStack);
                }

                public void click(GUIManager.GUIClickType gUIClickType) {
                    switch (gUIClickType) {
                        case Left: 
                        case Right: {
                            if (!bl5) break;
                            HomeManager.this.plugin.performCommand((CommandSender)player, String.valueOf(CommandsHandler.getLabel()) + " " + home.class.getSimpleName() + " " + cmiHome7.getName() + " " + cMIUser.getName());
                            break;
                        }
                        case LeftShift: {
                            break;
                        }
                        case MiddleMouse: 
                        case Q: {
                            if (!bl3 && !this.val$canEdit) {
                                return;
                            }
                            HomeManager.this.homeEditor(player, cmiHome7, this.val$page);
                            break;
                        }
                        case RightShift: {
                            if (!bl3 && !this.val$canEdit) {
                                return;
                            }
                            HomeManager.this.plugin.performCommand((CommandSender)player, String.valueOf(CommandsHandler.getLabel()) + " " + removehome.class.getSimpleName() + " " + cmiHome7.getName() + " " + cMIUser.getName());
                            if (!cMIUser.getHomes().isEmpty()) {
                                HomeManager.this.openComplexHomeGui(player, cMIUser, this.val$pi.getCurrentPage());
                                break;
                            }
                            player.closeInventory();
                            break;
                        }
                    }
                }
            };
            cMIGuiButton.hideItemFlags();
            cMIGuiButton.setName("&r" + (cmiHome7.isPrivate() ? CMILC.getIM(home.class, "listPrivate", new Object[0]) : CMILC.getIM(home.class, "listNonePrivate", new Object[0])) + cmiHome7.getName());
            if (bl4) {
                cMIGuiButton.addLore(CMILC.getIM(home.class, "click", "[home]", cmiHome7.getName()));
            } else {
                cMIGuiButton.addLore(CMILC.getIM(home.class, "notAccessible", "[worldName]", cmiHome7.getLoc().getWorldName()));
            }
            if (bl3 || n2 != 0) {
                cMIGuiButton.addLore(CMILC.getIM(homes.class, "edit", new Object[0]));
                cMIGuiButton.addLore(CMILC.getIM(home.class, "remove", new Object[0]));
            }
            cMIGui.addButton(cMIGuiButton, n7);
        }
        if (this.guiCloseButton) {
            CMIGuiButton cMIGuiButton = new CMIGuiButton(this.guiCloseButtonSlot, this.guiCloseButtonItem){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    Snd snd = new Snd();
                    snd.setTarget(player);
                    snd.setSender(player);
                    snd.setSource(player);
                    HomeManager.this.plugin.getSpecializedCommandManager().processCmds(HomeManager.this.plugin.getLM().updateSnd(snd, new ArrayList<String>(HomeManager.this.guiCloseButtonCommands)), player);
                }
            };
            cMIGuiButton.setName(CMILC.getIM(homes.class, "closeButton", new Object[0]));
            cMIGui.addButton(cMIGuiButton);
        }
        if (this.guiInfoButton) {
            CMIGuiButton cMIGuiButton = new CMIGuiButton(this.guiInfoButtonSlot, this.guiInfoButtonItem){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    Snd snd = new Snd();
                    snd.setTarget(player);
                    snd.setSender(player);
                    snd.setSource(player);
                    HomeManager.this.plugin.getSpecializedCommandManager().processCmds(HomeManager.this.plugin.getLM().updateSnd(snd, new ArrayList<String>(HomeManager.this.guiInfoButtonCommands)), player);
                }
            };
            cMIGuiButton.setName(CMILC.getIM(homes.class, "infoButton", new Object[0]));
            cMIGui.addButton(cMIGuiButton);
        }
        if (this.guiBedButton && cmiHome6 != null) {
            CMIGuiButton cMIGuiButton = new CMIGuiButton(this.guiBedButtonSlot, this.guiBedButtonItem){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    HomeManager.this.plugin.performCommand((CommandSender)player, String.valueOf(CommandsHandler.getLabel()) + " " + home.class.getSimpleName() + " " + cmiHome6.getName() + " " + player.getName());
                }
            };
            cMIGuiButton.setName(CMILC.getIM(homes.class, "bedButton", new Object[0]));
            cMIGuiButton.addLore(CMILC.getIM(homes.class, "lore", cmiHome6.getLoc().getBukkitLoc()));
            cMIGui.addButton(cMIGuiButton);
        }
        if (this.guiHomeButton && (cmiHome = cMIUser.getHome(this.defaultHomeName)) != null) {
            iterator = new CMIGuiButton(this.guiHomeButtonSlot, this.guiHomeButtonItem){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    HomeManager.this.plugin.performCommand((CommandSender)player, String.valueOf(CommandsHandler.getLabel()) + " " + home.class.getSimpleName() + " " + cmiHome.getName() + " " + player.getName());
                }
            };
            iterator.setName(CMILC.getIM(homes.class, "homeButton", new Object[0]));
            iterator.addLore(CMILC.getIM(homes.class, "lore", cmiHome.getLoc().getBukkitLoc()));
            cMIGui.addButton(iterator);
        }
        if (this.guiDeathButton && PermissionsManager.CMIPerm.command_$1.hasPermission((CommandSender)player, dback.class.getSimpleName()) && (location = cMIUser.getDeathLoc()) != null) {
            iterator = new CMIGuiButton(this.guiDeathButtonSlot, this.guiDeathButtonItem){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    HomeManager.this.plugin.performCommand((CommandSender)player, String.valueOf(CommandsHandler.getLabel()) + " " + dback.class.getSimpleName() + " " + player.getName());
                }
            };
            iterator.setName(CMILC.getIM(homes.class, "deathButton", new Object[0]));
            iterator.addLore(CMILC.getIM(homes.class, "lore", location));
            cMIGui.addButton(iterator);
        }
        cMIGui.setPagePrevButtons(new Integer[]{this.guiPrevButtonSlot});
        cMIGui.setPageMiddleButtons(new Integer[]{this.guiMiddleButtonSlot});
        cMIGui.setPageNextButtons(new Integer[]{this.guiNextButtonSlot});
        cMIGui.addPagination(pageInfo);
        if (this.guiBorder != null && this.guiBorder.getCMIType() != CMIMaterial.NONE) {
            cMIGui.setFiller(this.guiBorder.getCMIType());
        }
        cMIGui.fillEmptyButtons();
        cMIGui.open();
        return true;
    }

    private void homeEditor(final Player player, final CmiHome cmiHome, final int n) {
        CMIGuiButton cMIGuiButton;
        final CMIUser cMIUser = CMIUser.getUser(player);
        CMIGui cMIGui = new CMIGui(player){

            public void onClose() {
                cMIUser.addForDelayedSave();
            }
        };
        final boolean bl = PermissionsManager.CMIPerm.command_sethome_iconpicker.hasPermission((CommandSender)player);
        cMIGui.setTitle(cmiHome.getName());
        cMIGui.setInvSize(GUIManager.GUIRows.r6);
        if (bl) {
            cMIGuiButton = new CMIGuiButton(19, cmiHome.getIconMaterial()){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    if (player.isOnline() && bl) {
                        MaterialPicker materialPicker = new MaterialPicker(player){

                            public void pickedMaterial(GUIManager.GUIClickType gUIClickType, CMIMaterial cMIMaterial) {
                                cmiHome.setMaterial(cMIMaterial);
                                CMILC.info(sethome.class.getSimpleName(), player, "setIcon", "[material]", cMIMaterial.getName());
                                HomeManager.this.homeEditor(player, cmiHome, n);
                                cMIUser.addForDelayedSave();
                            }
                        };
                        materialPicker.openPicker(1, LC.info_pickIcon.getLocale(new Object[0]));
                    }
                }
            };
            cMIGuiButton.addLore(CMILC.getIM(homes.class, "picker", "[worldName]", cmiHome.getLoc().getWorldName()));
            cMIGui.addButton(cMIGuiButton);
        }
        cMIGuiButton = new CMIGuiButton(21, cmiHome.isPrivate() ? CMIMaterial.BLUE_WOOL : CMIMaterial.LIGHT_BLUE_WOOL){

            public void click(GUIManager.GUIClickType gUIClickType) {
                cmiHome.setPrivate(!cmiHome.isPrivate());
                this.updateLooks();
                this.update();
            }

            public void updateLooks() {
                this.setItem(cmiHome.isPrivate() ? CMIMaterial.BLUE_WOOL : CMIMaterial.LIGHT_BLUE_WOOL);
                this.setName(CMILC.getIM(homes.class, "private", "[state]", cmiHome.isPrivate()));
            }
        };
        cMIGui.addButton(cMIGuiButton);
        cMIGuiButton = new CMIGuiButton(23, CMIMaterial.LADDER){

            public void click(GUIManager.GUIClickType gUIClickType) {
                switch (gUIClickType) {
                    case Left: 
                    case LeftShift: {
                        cmiHome.setSlot(cmiHome.getSlot() + 1);
                        break;
                    }
                    case Right: 
                    case RightShift: {
                        cmiHome.setSlot(cmiHome.getSlot() - 1);
                        break;
                    }
                }
                this.updateLooks();
                this.update();
            }

            public void updateLooks() {
                this.setName(CMILC.getIM(homes.class, "slot", "[slot]", cmiHome.getSlot()));
            }
        };
        cMIGui.addButton(cMIGuiButton);
        cMIGuiButton = new CMIGuiButton(25, CMIMaterial.ENCHANTED_GOLDEN_APPLE){

            public void click(GUIManager.GUIClickType gUIClickType) {
                if (!cmiHome.isFavorite() && cMIUser.getTotalFavoriteHomeCount() >= (HomeManager.this.guiExpanded ? 28 : 10)) {
                    CMILC.info(sethome.class, (CommandSender)player, "maxFavorites", "[amount]", HomeManager.this.guiExpanded ? 28 : 10);
                    return;
                }
                cmiHome.setFavorite(!cmiHome.isFavorite());
                this.updateLooks();
                this.update();
            }

            public void updateLooks() {
                this.setName(CMILC.getIM(homes.class, "favorite", "[state]", cmiHome.isFavorite()));
            }
        };
        cMIGui.addButton(cMIGuiButton);
        cMIGuiButton = new CMIGuiButton(8, CMILib.getInstance().getConfigManager().getGUIPreviousPage()){

            public void click(GUIManager.GUIClickType gUIClickType) {
                if (player.isOnline()) {
                    HomeManager.this.openHomeGui(player, cMIUser, n);
                }
            }
        };
        cMIGuiButton.setName(LC.info_Back.getLocale(new Object[0]));
        cMIGui.addButton(cMIGuiButton);
        cMIGui.fillEmptyButtons();
        cMIGui.open();
    }

    /*
     * WARNING - void declaration
     */
    public boolean openSimpleHomeGui(final Player player, final CMIUser cMIUser, int n) {
        void entry;
        if (cMIUser == null || player == null || !player.isOnline()) {
            return false;
        }
        Snd snd = new Snd();
        snd.setTarget(cMIUser);
        snd.setSource(cMIUser);
        CMIGui cMIGui = new CMIGui(player){

            public void pageChange(int n) {
                HomeManager.this.openSimpleHomeGui(player, cMIUser, n);
            }
        };
        if (n < 1) {
            n = 1;
        }
        int n2 = cMIUser.getLastHomeSlot() > 54 ? 45 : 54;
        final PageInfo pageInfo = new PageInfo(n2, cMIUser.getLastHomeSlot(), n);
        cMIGui.setTitle(CMILC.getIM(home.class, "guiTitle", "[current]", cMIUser.getHomes().size(), "[max]", this.plugin.getHomeManager().getMaxHomes(cMIUser.getPlayer(false)), snd));
        int n3 = n2 * (pageInfo.getCurrentPage() - 1);
        while (entry <= n2 * (pageInfo.getCurrentPage() - 1) + n2) {
            Set<CmiHome> set = cMIUser.getHomesBySlot((int)entry);
            if (!set.isEmpty()) {
                for (final CmiHome cmiHome : set) {
                    int n4;
                    CMILocation bl3 = cmiHome.getLoc();
                    boolean bl = true;
                    if (bl3 == null || bl3.getWorld() == null) {
                        bl = false;
                    }
                    final boolean cMIGuiButton = bl;
                    CMIMaterial cMIMaterial = cmiHome.getIconMaterial();
                    if (!bl && Version.isCurrentEqualOrHigher((Version)Version.v1_13_R1)) {
                        cMIMaterial = CMIMaterial.BARRIER;
                    }
                    int n5 = n4 = entry - true > n2 ? (entry - true) % n2 : entry - true;
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    CMIGuiButton cMIGuiButton2 = new CMIGuiButton(n4, cMIMaterial){

                        public void click(GUIManager.GUIClickType gUIClickType) {
                            switch (gUIClickType) {
                                case Left: 
                                case Right: {
                                    if (!cMIGuiButton) break;
                                    HomeManager.this.plugin.performCommand((CommandSender)player, String.valueOf(CommandsHandler.getLabel()) + " " + home.class.getSimpleName() + " " + cmiHome.getName() + " " + cMIUser.getName());
                                    break;
                                }
                                case LeftShift: {
                                    break;
                                }
                                case RightShift: {
                                    HomeManager.this.plugin.performCommand((CommandSender)player, String.valueOf(CommandsHandler.getLabel()) + " " + removehome.class.getSimpleName() + " " + cmiHome.getName() + " " + cMIUser.getName());
                                    if (cMIUser.getLastHomeSlot() > 1) {
                                        HomeManager.this.plugin.performCommand((CommandSender)player, String.valueOf(CommandsHandler.getLabel()) + " " + homes.class.getSimpleName() + " " + cMIUser.getName() + " -p:" + pageInfo.getCurrentPage());
                                        break;
                                    }
                                    player.closeInventory();
                                    break;
                                }
                            }
                        }
                    };
                    cMIGuiButton2.hideItemFlags();
                    cMIGuiButton2.setName("&r" + (cmiHome.isPrivate() ? CMILC.getIM(home.class, "listPrivate", new Object[0]) : CMILC.getIM(home.class, "listNonePrivate", new Object[0])) + cmiHome.getName());
                    if (bl) {
                        cMIGuiButton2.addLore(CMILC.getIM(home.class, "click", "[home]", cmiHome.getName()));
                    } else {
                        cMIGuiButton2.addLore(CMILC.getIM(home.class, "notAccessible", "[worldName]", cmiHome.getLoc().getWorldName()));
                    }
                    cMIGuiButton2.addLore(CMILC.getIM(home.class, "remove", new Object[0]));
                    cMIGui.addButton(cMIGuiButton2, n2);
                }
            }
            ++entry;
        }
        for (final Map.Entry entry2 : cMIUser.getHomes().entrySet()) {
            CmiHome cmiHome;
            if (pageInfo.isContinue()) continue;
            if (pageInfo.isBreak()) break;
            cmiHome = ((CmiHome)entry2.getValue()).getLoc();
            boolean bl = true;
            if (cmiHome == null || cmiHome.getWorld() == null) {
                bl = false;
            }
            final boolean bl2 = bl;
            if (((CmiHome)entry2.getValue()).getSlot() != null) continue;
            CMIMaterial cMIMaterial = ((CmiHome)entry2.getValue()).getIconMaterial();
            if (!bl && Version.isCurrentEqualOrHigher((Version)Version.v1_13_R1)) {
                cMIMaterial = CMIMaterial.BARRIER;
            }
            CMIGuiButton cMIGuiButton = new CMIGuiButton(cMIMaterial){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    switch (gUIClickType) {
                        case Left: 
                        case Right: {
                            if (!bl2) break;
                            HomeManager.this.plugin.performCommand((CommandSender)player, String.valueOf(CommandsHandler.getLabel()) + " " + home.class.getSimpleName() + " " + (String)entry2.getKey() + " " + cMIUser.getName());
                            break;
                        }
                        case RightShift: {
                            HomeManager.this.plugin.performCommand((CommandSender)player, String.valueOf(CommandsHandler.getLabel()) + " " + removehome.class.getSimpleName() + " " + (String)entry2.getKey() + " " + cMIUser.getName());
                            if (cMIUser.getLastHomeSlot() > 1) {
                                HomeManager.this.plugin.performCommand((CommandSender)player, String.valueOf(CommandsHandler.getLabel()) + " " + homes.class.getSimpleName() + " " + cMIUser.getName() + " -p:" + pageInfo.getCurrentPage());
                                break;
                            }
                            player.closeInventory();
                            break;
                        }
                    }
                }
            };
            cMIGuiButton.hideItemFlags();
            cMIGuiButton.setName("&r" + (((CmiHome)entry2.getValue()).isPrivate() ? CMILC.getIM(home.class, "listPrivate", new Object[0]) : CMILC.getIM(home.class, "listNonePrivate", new Object[0])) + (String)entry2.getKey());
            if (bl) {
                cMIGuiButton.addLore(CMILC.getIM(home.class, "click", "[home]", ((CmiHome)entry2.getValue()).getName()));
            } else {
                cMIGuiButton.addLore(CMILC.getIM(home.class, "notAccessible", "[worldName]", ((CmiHome)entry2.getValue()).getLoc().getWorldName()));
            }
            cMIGuiButton.addLore(CMILC.getIM(home.class, "remove", new Object[0]));
            cMIGui.addButton(cMIGuiButton, n2);
        }
        cMIGui.addPagination(pageInfo);
        cMIGui.fillEmptyButtons();
        cMIGui.open();
        return true;
    }

    public boolean isHomesGui() {
        return this.HomesGui;
    }

    public int getRespawnImmortality() {
        return this.respawnImmortality;
    }

    public String getHomeNameRegex() {
        return this.homeNameRegex;
    }

    public void setHomeNameRegex(String string) {
        this.homeNameRegex = string;
    }

    public boolean isPickRealBlock() {
        return this.pickRealBlock;
    }

    public boolean isOnlyShiftBed() {
        return this.onlyShiftBed;
    }

    public boolean isConfirmation() {
        return this.confirmation;
    }

    public boolean isHomesWorldLimits() {
        return this.homesWorldLimits;
    }

    public void setHomesWorldLimits(boolean bl) {
        this.homesWorldLimits = bl;
    }

    public int getWorldLimit(String string) {
        HomeWorldLimit homeWorldLimit = this.getWorldLimitObject(string);
        if (homeWorldLimit == null) {
            return -1;
        }
        return homeWorldLimit.getLimit();
    }

    public HomeWorldLimit getWorldLimitObject(String string) {
        return this.homeLimits.get(string.toLowerCase());
    }

    public boolean isHomesGuiComplex() {
        return this.HomesGuiComplex;
    }

    public int getGuiCloseButtonSlot() {
        return this.guiCloseButtonSlot;
    }

    public CMIItemStack getGuiCloseButtonItem() {
        return this.guiCloseButtonItem;
    }

    public int getHomesMaxGuiSlots() {
        return this.HomesMaxGuiSlots;
    }

    public static enum RespawnPriority {
        anchor,
        bedLocation,
        spawn,
        homeLocation,
        worldSpawn;


        public static RespawnPriority getByName(String string) {
            RespawnPriority[] respawnPriorityArray = RespawnPriority.values();
            int n = respawnPriorityArray.length;
            int n2 = 0;
            while (n2 < n) {
                RespawnPriority respawnPriority = respawnPriorityArray[n2];
                if (respawnPriority.name().equalsIgnoreCase(string)) {
                    return respawnPriority;
                }
                ++n2;
            }
            return null;
        }

        public static List<String> getAsStringList() {
            ArrayList<String> arrayList = new ArrayList<String>();
            RespawnPriority[] respawnPriorityArray = RespawnPriority.values();
            int n = respawnPriorityArray.length;
            int n2 = 0;
            while (n2 < n) {
                RespawnPriority respawnPriority = respawnPriorityArray[n2];
                arrayList.add(respawnPriority.name());
                ++n2;
            }
            return arrayList;
        }

        public static String getAsString() {
            String string = "";
            RespawnPriority[] respawnPriorityArray = RespawnPriority.values();
            int n = respawnPriorityArray.length;
            int n2 = 0;
            while (n2 < n) {
                RespawnPriority respawnPriority = respawnPriorityArray[n2];
                if (!string.isEmpty()) {
                    string = String.valueOf(string) + ", ";
                }
                string = String.valueOf(string) + respawnPriority.name();
                ++n2;
            }
            return string;
        }
    }
}

