/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.ShulkerBoxInventory;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import java.util.Random;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Logs.CMIDebug;
import net.Zrips.CMILib.NBT.CMINBT;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class ShulkerBoxListener
implements Listener {
    private CMI plugin;

    public ShulkerBoxListener(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void CheckForChulker(InventoryClickEvent inventoryClickEvent) {
        if (!(inventoryClickEvent.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        if (!this.plugin.getShulkerBoxManager().isEditing(player)) {
            return;
        }
        try {
            if (inventoryClickEvent.getClick() == ClickType.NUMBER_KEY) {
                inventoryClickEvent.setCancelled(true);
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ItemStack itemStack = inventoryClickEvent.getCurrentItem();
        if (itemStack == null) {
            return;
        }
        if (CMIMaterial.isShulkerBox((Material)itemStack.getType())) {
            CMINBT cMINBT;
            if (inventoryClickEvent.getClickedInventory().getType() == InventoryType.PLAYER) {
                inventoryClickEvent.setCancelled(true);
            }
            if (inventoryClickEvent.getClick() != ClickType.SHIFT_RIGHT) {
                return;
            }
            if (inventoryClickEvent.getClickedInventory().getType() != InventoryType.PLAYER) {
                return;
            }
            if (!this.plugin.getShulkerBoxManager().isShulkerBox(itemStack)) {
                cMINBT = this.plugin.getReflectionManager().tryToMakeShulkerBox(itemStack);
                if (!this.plugin.getShulkerBoxManager().isShulkerBox((ItemStack)cMINBT)) {
                    return;
                }
                itemStack = cMINBT;
                player.getInventory().setItem(inventoryClickEvent.getSlot(), itemStack);
            }
            cMINBT = new CMINBT(itemStack);
            itemStack = (ItemStack)cMINBT.setInt("CMIBackPack", Integer.valueOf(new Random().nextInt(Integer.MAX_VALUE)));
            player.getInventory().setItem(inventoryClickEvent.getSlot(), itemStack);
            inventoryClickEvent.setCancelled(true);
            this.plugin.getShulkerBoxManager().openShulkerBox(player, player.getInventory().getItem(inventoryClickEvent.getSlot()));
            if (!player.isOnline()) {
                return;
            }
            return;
        }
        try {
            if (inventoryClickEvent.getAction() == InventoryAction.HOTBAR_SWAP) {
                inventoryClickEvent.setCancelled(true);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (inventoryClickEvent.getAction() == InventoryAction.HOTBAR_MOVE_AND_READD) {
                inventoryClickEvent.setCancelled(true);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void ShulkerItemOpen(InventoryClickEvent inventoryClickEvent) {
        CMINBT cMINBT;
        if (inventoryClickEvent.isCancelled()) {
            return;
        }
        if (!(inventoryClickEvent.getWhoClicked() instanceof Player)) {
            return;
        }
        if (inventoryClickEvent.getClick() != ClickType.SHIFT_RIGHT) {
            return;
        }
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        if (this.plugin.getShulkerBoxManager().isEditing(player)) {
            return;
        }
        ItemStack itemStack = inventoryClickEvent.getCurrentItem();
        if (inventoryClickEvent.getClickedInventory() == null) {
            return;
        }
        if (inventoryClickEvent.getClickedInventory().getType() != InventoryType.PLAYER) {
            return;
        }
        if (inventoryClickEvent.getCurrentItem() == null) {
            return;
        }
        if (!CMIMaterial.isShulkerBox((Material)inventoryClickEvent.getCurrentItem().getType())) {
            return;
        }
        if (inventoryClickEvent.getRawSlot() < 9 || inventoryClickEvent.getRawSlot() > 44) {
            return;
        }
        if (!PermissionsManager.CMIPerm.openshulker.hasPermission((CommandSender)player)) {
            return;
        }
        if (!this.plugin.getShulkerBoxManager().isShulkerBox(itemStack)) {
            cMINBT = this.plugin.getReflectionManager().tryToMakeShulkerBox(itemStack);
            if (!this.plugin.getShulkerBoxManager().isShulkerBox((ItemStack)cMINBT)) {
                return;
            }
            itemStack = cMINBT;
            player.getInventory().setItem(inventoryClickEvent.getSlot(), itemStack);
        }
        cMINBT = new CMINBT(itemStack);
        itemStack = (ItemStack)cMINBT.setInt("CMIBackPack", Integer.valueOf(new Random().nextInt(Integer.MAX_VALUE)));
        player.getInventory().setItem(inventoryClickEvent.getSlot(), itemStack);
        inventoryClickEvent.setCancelled(true);
        if (!player.isOnline()) {
            return;
        }
        CMIScheduler.runTaskLater(() -> {
            if (!player.isOnline()) {
                return;
            }
            this.plugin.getShulkerBoxManager().openShulkerBox(player, player.getInventory().getItem(inventoryClickEvent.getSlot()));
        }, (long)1L);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void PlayerInteractEvent(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.getAction() != Action.RIGHT_CLICK_AIR && playerInteractEvent.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        Player player = playerInteractEvent.getPlayer();
        if (this.plugin.getShulkerBoxManager().isEditing(player)) {
            return;
        }
        if (!player.isSneaking()) {
            return;
        }
        ItemStack itemStack = CMILib.getInstance().getReflectionManager().getItemInMainHand(player);
        if (!CMIMaterial.isShulkerBox((Material)itemStack.getType())) {
            return;
        }
        try {
            if (Version.isCurrentHigher((Version)Version.v1_8_R3) && playerInteractEvent.getHand() != EquipmentSlot.HAND) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!PermissionsManager.CMIPerm.openshulker_shift.hasPermission((CommandSender)player)) {
            return;
        }
        ItemStack itemStack2 = itemStack;
        if (!this.plugin.getShulkerBoxManager().isShulkerBox(itemStack2)) {
            itemStack2 = this.plugin.getReflectionManager().tryToMakeShulkerBox(itemStack);
        }
        if (!this.plugin.getShulkerBoxManager().isShulkerBox(itemStack2)) {
            return;
        }
        CMINBT cMINBT = new CMINBT(itemStack2);
        itemStack2 = (ItemStack)cMINBT.setInt("CMIBackPack", Integer.valueOf(new Random().nextInt(Integer.MAX_VALUE)));
        CMIDebug.c((Object[])new Object[]{itemStack2.serialize()});
        CMILib.getInstance().getReflectionManager().setItemInMainHand(player, itemStack2);
        player.updateInventory();
        playerInteractEvent.setCancelled(true);
        ItemStack itemStack3 = CMILib.getInstance().getReflectionManager().getItemInMainHand(player);
        if (!player.isOnline()) {
            return;
        }
        CMIScheduler.runTaskLater(() -> this.plugin.getShulkerBoxManager().openShulkerBox(player, itemStack3), (long)1L);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void ShulkerEdit(InventoryClickEvent inventoryClickEvent) {
        if (inventoryClickEvent.isCancelled()) {
            return;
        }
        if (!(inventoryClickEvent.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        if (!this.plugin.getShulkerBoxManager().isEditing(player)) {
            return;
        }
        if (!this.plugin.getShulkerBoxManager().stillHaveItem(player)) {
            inventoryClickEvent.setCancelled(true);
            player.closeInventory();
        }
        if (inventoryClickEvent.getAction() == InventoryAction.HOTBAR_SWAP) {
            inventoryClickEvent.setCancelled(true);
            CMIScheduler.runTaskLater(() -> player.updateInventory(), (long)1L);
            return;
        }
        CMIScheduler.runTaskLater(() -> this.plugin.getShulkerBoxManager().updateShulkerItem(player), (long)1L);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void ShulkerEdit(InventoryDragEvent inventoryDragEvent) {
        if (inventoryDragEvent.isCancelled()) {
            return;
        }
        if (!(inventoryDragEvent.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)inventoryDragEvent.getWhoClicked();
        if (!this.plugin.getShulkerBoxManager().isEditing(player)) {
            return;
        }
        if (!this.plugin.getShulkerBoxManager().stillHaveItem(player)) {
            inventoryDragEvent.setCancelled(true);
            player.closeInventory();
        }
        CMIScheduler.runTaskLater(() -> this.plugin.getShulkerBoxManager().updateShulkerItem(player), (long)1L);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void InventoryCloseEvent(InventoryCloseEvent inventoryCloseEvent) {
        Player player = (Player)inventoryCloseEvent.getPlayer();
        if (!this.plugin.getShulkerBoxManager().isEditing(player)) {
            return;
        }
        this.plugin.getShulkerBoxManager().updateEntireShulkerInv(player, inventoryCloseEvent.getInventory().getContents());
        this.plugin.getShulkerBoxManager().remove(player);
    }
}

