/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Teleportations;

import com.Zrips.CMI.Modules.Portals.CMIVector3D;
import net.Zrips.CMILib.Container.CMINumber;
import net.Zrips.CMILib.Container.CMIWorld;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class CMITeleportationBounds {
    private World world;
    private CMIVector3D position;
    private int maxY;
    private int minY;
    private float yaw;
    private float pitch;
    private boolean imortal = false;
    private boolean canFly = false;
    private boolean flying = false;
    private Player player = null;
    private boolean ignoreYLimits = false;

    CMITeleportationBounds(Location location) {
        this.world = location.getWorld();
        this.yaw = location.getYaw();
        this.pitch = location.getPitch();
        this.position = new CMIVector3D(location.getX(), location.getY(), location.getZ());
        this.maxY = location.getBlockY();
        this.minY = location.getBlockY() - 2;
    }

    public World getWorld() {
        return this.world;
    }

    public CMITeleportationBounds setUpRange(double d) {
        this.maxY = CMINumber.clamp((int)((int)(this.position.getY() + d)), (int)CMIWorld.getMinHeight((World)this.world), (int)CMIWorld.getMaxHeight((World)this.world));
        return this;
    }

    public CMITeleportationBounds setDownRange(double d) {
        this.minY = CMINumber.clamp((int)((int)(this.position.getY() - d)), (int)CMIWorld.getMinHeight((World)this.world), (int)CMIWorld.getMaxHeight((World)this.world));
        return this;
    }

    public CMITeleportationBounds setRange(double d) {
        this.setUpRange(d);
        this.setDownRange(d);
        return this;
    }

    public CMITeleportationBounds setWorld(World world2) {
        this.world = world2;
        return this;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public CMITeleportationBounds setMaxY(int n) {
        this.maxY = n;
        return this;
    }

    public int getMinY() {
        return this.minY;
    }

    public CMITeleportationBounds setMinY(int n) {
        this.minY = n;
        return this;
    }

    public CMIVector3D getPosition() {
        return this.position;
    }

    public CMITeleportationBounds setPosition(CMIVector3D cMIVector3D) {
        this.position = cMIVector3D;
        return this;
    }

    public float getYaw() {
        return this.yaw;
    }

    public CMITeleportationBounds setYaw(float f) {
        this.yaw = f;
        return this;
    }

    public float getPitch() {
        return this.pitch;
    }

    public CMITeleportationBounds setPitch(float f) {
        this.pitch = f;
        return this;
    }

    public boolean isCanFly() {
        return this.canFly;
    }

    public CMITeleportationBounds setCanFly(boolean bl) {
        this.canFly = bl;
        return this;
    }

    public boolean isFlying() {
        return this.flying;
    }

    public void setFlying(boolean bl) {
        this.flying = bl;
    }

    public boolean isImortal() {
        return this.imortal;
    }

    public CMITeleportationBounds setImortal(boolean bl) {
        this.imortal = bl;
        return this;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public boolean isIgnoreYLimits() {
        return this.ignoreYLimits;
    }

    public void setIgnoreYLimits(boolean bl) {
        this.ignoreYLimits = bl;
    }
}

