/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Afk;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Containers.Snd;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Afk.AfkInfo;
import com.Zrips.CMI.Modules.ModuleHandling.CMIModule;
import com.Zrips.CMI.Modules.Permissions.PermissionInfo;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.Modules.Statistics.StatsManager;
import com.Zrips.CMI.commands.list.afk;
import com.Zrips.CMI.events.CMIAfkEnterEvent;
import com.Zrips.CMI.events.CMIAfkKickEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.Zrips.CMILib.Container.CMIList;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Time.CMITimeManager;
import net.Zrips.CMILib.TitleMessages.CMITitleMessage;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Schedulers.CMITask;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class AfkManager {
    private HashMap<CMIUser, Long> lastAction = new HashMap();
    private HashMap<UUID, AfkInfo> afkPlayersMap = new HashMap();
    private CMI plugin;
    private CMITask sched = null;
    private long awayTrigerTime = 3000L;
    private List<String> awayTrigerCommands = new ArrayList<String>();
    private List<String> manualAwayTrigerCommands = new ArrayList<String>();
    private List<String> leaveTrigerCommands = new ArrayList<String>();
    private long kickTrigerTime = 5000L;
    private long RepeatingAutoKickInterval = 5000L;
    private List<String> kickTrigerCommands = new ArrayList<String>();
    private List<String> disabledWorlds = new ArrayList<String>();
    private boolean AfkEnabled = true;
    private boolean PreventJumping = true;
    private boolean TitleMessage = true;
    private boolean SubTitleMessage = true;
    private boolean PreventDamage = true;
    private boolean StopPlayTime = false;
    private int interval = 1;
    private boolean disableOnPublicChat = true;
    private boolean disableOnPrivateChat = true;
    private boolean disableOnInteract = true;
    private boolean SmartInteractCheck = true;
    private boolean AntiAfkMachines = true;
    private boolean DisableOnInventoryClick = true;
    private boolean DisableOnitemDrop = true;
    private boolean RepeatKickCommand = false;
    private boolean disableOnCommand = true;
    private boolean disableOnMove = true;
    private boolean disableOnLookAround = true;
    private boolean disableItemPickup = false;
    private boolean disableFishing = true;
    private boolean PreventMobSpawning = false;
    private boolean PreventMobSpawningNatural = false;
    private boolean PreventMobSpawningSpawners = true;
    private boolean PreventMobVillageDefence = true;
    private boolean PreventPushing = true;
    private boolean PreventHook = true;
    private boolean disableExpPickup = false;
    int messageSize = -1;
    List<String> afkSubTitle = new ArrayList<String>();
    private CMITask afkSched = null;
    List<CMIUser> afkList = new ArrayList<CMIUser>();

    public boolean isAfk(UUID uUID) {
        if (!this.afkPlayersMap.containsKey(uUID)) {
            return false;
        }
        return this.getAfkInfo(uUID).getAfkFrom() > 0L;
    }

    public AfkInfo getAfkInfo(UUID uUID) {
        return this.afkPlayersMap.get(uUID);
    }

    public AfkInfo createAfkInfo(UUID uUID2) {
        return this.afkPlayersMap.computeIfAbsent(uUID2, uUID -> new AfkInfo());
    }

    public void removeAfkInfo(UUID uUID) {
        this.afkPlayersMap.remove(uUID);
    }

    public AfkManager(CMI cMI) {
        this.plugin = cMI;
    }

    public void stop() {
        if (this.sched != null) {
            this.sched.cancel();
            this.sched = null;
        }
        if (this.afkSched != null) {
            this.afkSched.cancel();
            this.afkSched = null;
        }
    }

    public void loadConfig() {
        ConfigReader configReader = this.plugin.getConfigManager().getConfig();
        configReader.addComment("Afk.Enabled", new String[]{"Enable or disable auto afk system entirely"});
        this.AfkEnabled = configReader.get("Afk.Enabled", Boolean.valueOf(false));
        configReader.addComment("Afk.TitleMessage", new String[]{"When enabled shows title message informing that player is in afk mode"});
        this.TitleMessage = configReader.get("Afk.TitleMessage", Boolean.valueOf(true));
        configReader.addComment("Afk.SubTitleMessage", new String[]{"When enabled shows random subtitle message"});
        this.SubTitleMessage = configReader.get("Afk.SubTitleMessage", Boolean.valueOf(true));
        configReader.addComment("Afk.PreventJumping", new String[]{"Prevents jumping in one place to avoid afk status"});
        this.PreventJumping = configReader.get("Afk.PreventJumping", Boolean.valueOf(true));
        configReader.addComment("Afk.PreventDamage", new String[]{"Prevents damage while afk"});
        this.PreventDamage = configReader.get("Afk.PreventDamage", Boolean.valueOf(true));
        configReader.addComment("Afk.CheckInterval", new String[]{"Defines how often in seconds plugin will check for afk players state"});
        this.interval = configReader.get("Afk.CheckInterval", 10);
        int n = this.interval = this.interval < 1 ? 1 : this.interval;
        if (this.plugin.isEnabled()) {
            this.tasker();
        }
        configReader.addComment("Afk.StopPlayTime", new String[]{"When set to true, players playtime counter stops", "As of nature how this system works you can see +-1second jumping up and down while checking players playtime"});
        this.StopPlayTime = configReader.get("Afk.StopPlayTime", Boolean.valueOf(false));
        configReader.addComment("Afk.AutoAfkIn", new String[]{"Defines how long to wait after player stops moving to set him as afk", "Player needs to have cmi.command.afk.auto permission node", "Set to 0 if you want to disable it"});
        this.awayTrigerTime = configReader.get("Afk.AutoAfkIn", 300) * 1000;
        configReader.addComment("Afk.AutoAfkCmds", new String[]{"Defines commands to be performed when player enters afk mode automatically while addling", "Supports specialized commands"});
        this.awayTrigerCommands = configReader.get("Afk.AutoAfkCmds", Arrays.asList("cmi broadcast !&6[playerDisplayName] &eis now AFK"));
        configReader.addComment("Afk.ManualAfkCmds", new String[]{"Defines commands to be performed when player enters /cmi afk", "Supports specialized commands"});
        this.manualAwayTrigerCommands = configReader.get("Afk.ManualAfkCmds", configReader.get("Afk.AutoAfkCmds", Arrays.asList("cmi broadcast !&6[playerDisplayName] &eis now AFK")));
        configReader.addComment("Afk.AfkLeaveCmds", new String[]{"Defines commands to be performed when player leaves afk mode"});
        this.leaveTrigerCommands = configReader.get("Afk.AfkLeaveCmds", Arrays.asList("cmi broadcast !&6[playerDisplayName] &eis no longer AFK"));
        configReader.addComment("Afk.AutoKickIn", new String[]{"Defines how long to wait after player stops moving to kick player", "This is additional timer to AutoAfkIn and in case player entered afk mode manually he will get kicked after AutoAfkIn+AutoKickIn seconds", "This can be used not only to kick but to perform repeating action every x seconds if needed", "Keep it at -1 to disable auto kick", "Can be bypassed with cmi.command.afk.kickbypass permission node", "Additionally players kick time can be changed with " + PermissionsManager.CMIPerm.command_afk_kickOutIn_$1.getPermission("[seconds]") + " permission node where bigger value takes priority"});
        this.kickTrigerTime = configReader.get("Afk.AutoKickIn", -1) * 1000;
        configReader.addComment("Afk.RepeatingAutoKickInterval", new String[]{"This will define how long to wait before performing kick commands again"});
        this.RepeatingAutoKickInterval = configReader.get("Afk.RepeatingAutoKickInterval", 300) * 1000;
        configReader.addComment("Afk.RepeatKickCommand", new String[]{"When set to true, kick command will be repeated each RepeatingAutoKickInterval seconds"});
        this.RepeatKickCommand = configReader.get("Afk.RepeatKickCommand", Boolean.valueOf(false));
        configReader.addComment("Afk.AutoKickCmds", new String[]{"Defines commands to be performed when player can be kicked", "If player is not kicked then commands will be repeated every RepeatingAutoKickInterval seconds"});
        this.kickTrigerCommands = configReader.get("Afk.AutoKickCmds", Arrays.asList("cmi kick [playerName] &eYou have been kicked for idling more than [time]"));
        configReader.addComment("Afk.DisabledWorlds", new String[]{"Defines worlds where players will not be placed into afk mode after they idled for defined time"});
        this.disabledWorlds = configReader.get("Afk.DisabledWorlds", Arrays.asList("oneTestWorld", "secondTestWorld"));
        CMIList.toLowerCase(this.disabledWorlds);
        configReader.addComment("Afk.DisableOnInteract", new String[]{"Disables afk on interaction"});
        this.disableOnInteract = configReader.get("Afk.DisableOnInteract", Boolean.valueOf(true));
        configReader.addComment("Afk.SmartInteractCheck", new String[]{"Prevents player from going bypassing afk mode while continuously holding one button with particular items or on particular blocks"});
        this.SmartInteractCheck = configReader.get("Afk.SmartInteractCheck", Boolean.valueOf(true));
        configReader.addComment("Afk.AntiAfkMachines", new String[]{"Prevents from players abusing afk by constantly moving in afk machine"});
        this.AntiAfkMachines = configReader.get("Afk.AntiAfkMachines", Boolean.valueOf(true));
        configReader.addComment("Afk.PreventHook", new String[]{"Prevents players from being  pooled around while player is in afk mode"});
        this.PreventHook = configReader.get("Afk.PreventHook", Boolean.valueOf(true));
        configReader.addComment("Afk.PreventPushing", new String[]{"EXPERIMENTAL! Prevents players from being pushed around while player is in afk mode", "Keep in mind that player can still be moved around the same block he is in"});
        this.PreventPushing = configReader.get("Afk.PreventPushing", Boolean.valueOf(false));
        configReader.addComment("Afk.DisableOnInventoryClick", new String[]{"Disables afk on inventory click"});
        this.DisableOnInventoryClick = configReader.get("Afk.DisableOnInventoryClick", Boolean.valueOf(true));
        configReader.addComment("Afk.DisableOnitemDrop", new String[]{"Disables afk on item drop"});
        this.DisableOnitemDrop = configReader.get("Afk.DisableOnitemDrop", Boolean.valueOf(true));
        configReader.addComment("Afk.DisableOnCommand", new String[]{"Disables afk on command usage"});
        this.disableOnCommand = configReader.get("Afk.DisableOnCommand", Boolean.valueOf(true));
        configReader.addComment("Afk.DisableOnPublicChat", new String[]{"Disables afk on public chat message"});
        this.disableOnPublicChat = configReader.get("Afk.DisableOnPublicChat", Boolean.valueOf(true));
        configReader.addComment("Afk.DisableOnPrivateChat", new String[]{"Disables afk on private chat message"});
        this.disableOnPrivateChat = configReader.get("Afk.DisableOnPrivateChat", Boolean.valueOf(true));
        configReader.addComment("Afk.DisableOnMove", new String[]{"Disables afk on move"});
        this.disableOnMove = configReader.get("Afk.DisableOnMove", Boolean.valueOf(true));
        configReader.addComment("Afk.DisableOnLookAround", new String[]{"Disables afk on camera movement"});
        this.disableOnLookAround = configReader.get("Afk.DisableOnLookAround", Boolean.valueOf(false));
        configReader.addComment("Afk.DisableOnFishing", new String[]{"Disables afk on fishing when you catch fish"});
        this.disableFishing = configReader.get("Afk.DisableOnFishing", Boolean.valueOf(configReader.getC().getBoolean("Afk.DisableFishing", false)));
        configReader.addComment("Afk.DisableItemPickup", new String[]{"Disables item pickup while afk"});
        this.disableItemPickup = configReader.get("Afk.DisableItemPickup", Boolean.valueOf(false));
        configReader.addComment("Afk.PreventMobSpawning.Enabled", new String[]{"When enabled we can prevent mob spawning near players who are afk"});
        this.PreventMobSpawning = configReader.get("Afk.PreventMobSpawning.Enabled", Boolean.valueOf(false));
        configReader.addComment("Afk.PreventMobSpawning.Natural", new String[]{"Prevents natural mob spawning", "This can be more on heavy side of the server as it will try constantly to spawn in monsters near afk players"});
        this.PreventMobSpawningNatural = configReader.get("Afk.PreventMobSpawning.Natural", Boolean.valueOf(false));
        configReader.addComment("Afk.PreventMobSpawning.Spawners", new String[]{"Prevent mob spawning from spawners"});
        this.PreventMobSpawningSpawners = configReader.get("Afk.PreventMobSpawning.Spawners", Boolean.valueOf(true));
        configReader.addComment("Afk.PreventMobSpawning.VillageDefence", new String[]{"Usually responsible for spawning in iron golems"});
        this.PreventMobVillageDefence = configReader.get("Afk.PreventMobSpawning.VillageDefence", Boolean.valueOf(true));
        configReader.addComment("Afk.DisableExpPickup", new String[]{"Disables exp pickup while afk", "Attention! Because of weird minecraft handling of exp orbs, best way is to set orb to 0exp and allow it to be obsorbed", "So by enabling this exp obsorbed by afk players will have no effect"});
        this.disableExpPickup = configReader.get("Afk.DisableExpPickup", Boolean.valueOf(false));
        this.afkSubTitle.clear();
        this.messageSize = -1;
    }

    private void loadAfk() {
        this.afkSubTitle = CMILC.getIML("afk", "afkSubTitle", new Object[0]);
        this.messageSize = this.afkSubTitle.size();
    }

    private void tasker() {
        if (this.sched != null) {
            return;
        }
        if (!CMIModule.afk.isEnabled()) {
            return;
        }
        this.sched = CMIScheduler.scheduleSyncRepeatingTask(() -> {
            for (Map.Entry<CMIUser, Long> entry : new HashMap<CMIUser, Long>(this.lastAction).entrySet()) {
                CMIUser cMIUser = entry.getKey();
                if (!cMIUser.isOnline()) {
                    this.removeUser(cMIUser);
                    cMIUser.setAfk(false, CMIAfkEnterEvent.AfkType.auto);
                    continue;
                }
                Long l = System.currentTimeMillis() - (!this.isAfk(cMIUser.getUniqueId()) || cMIUser.getAfkInfo().getAfkFrom() == 0L ? entry.getValue().longValue() : cMIUser.getAfkInfo().getAfkFrom());
                if (this.awayTrigerTime > 0L) {
                    if (!cMIUser.isAfk() && l < this.awayTrigerTime) continue;
                    if (!cMIUser.isAfk() && this.AfkEnabled && l > this.awayTrigerTime) {
                        cMIUser.setAfk(true, CMIAfkEnterEvent.AfkType.auto);
                    }
                }
                if (!cMIUser.isAfk()) continue;
                long l2 = (long)cMIUser.getAfkInfo().getKickOutInSec() * 1000L;
                if (l2 > 0L && l > l2 + (long)cMIUser.getAfkInfo().getKicksPerformed() * this.RepeatingAutoKickInterval && cMIUser.isAfk()) {
                    if (cMIUser.getAfkInfo().getKicksPerformed() > 0 && this.RepeatKickCommand || cMIUser.getAfkInfo().getKicksPerformed() == 0) {
                        CMIAfkKickEvent cMIAfkKickEvent = new CMIAfkKickEvent(cMIUser.getPlayer(false), new ArrayList<String>(this.kickTrigerCommands));
                        Bukkit.getServer().getPluginManager().callEvent((Event)cMIAfkKickEvent);
                        if (!cMIAfkKickEvent.isCancelled()) {
                            Snd snd = new Snd().setSender(cMIUser).setTarget(cMIUser);
                            List<String> list2 = cMIAfkKickEvent.getKickTrigerCommands();
                            list2 = new ArrayList<String>(list2);
                            int n = 0;
                            while (n < list2.size()) {
                                String string = this.plugin.getLM().updateSnd(snd, list2.get(n));
                                string = string.replace("[time]", CMITimeManager.to24hourShort((Long)l2));
                                list2.set(n, string);
                                ++n;
                            }
                            this.plugin.getSpecializedCommandManager().processCmds(list2, cMIUser.isOnline() ? cMIUser.getPlayer() : null);
                        }
                    }
                    cMIUser.getAfkInfo().addKicksPerformed();
                }
                this.showTitle(cMIUser, false);
            }
        }, (long)0L, (long)((long)this.interval * 20L));
    }

    public void showTitle(CMIUser cMIUser, boolean bl) {
        if (!(this.TitleMessage && cMIUser.isAfk() && cMIUser.isOnline())) {
            return;
        }
        CMITitleMessage.send((Player)cMIUser.getPlayer(), (Object)this.getTitle(cMIUser), (Object)this.getSubtitle(cMIUser), (int)(bl ? 20 : 0), (int)(this.interval * 20 + 3), (int)0);
    }

    public void hideTitle(CMIUser cMIUser) {
        if (!this.TitleMessage || !cMIUser.isOnline()) {
            return;
        }
        CMITitleMessage.send((Player)cMIUser.getPlayer(), (Object)this.getTitle(cMIUser), (Object)this.getSubtitle(cMIUser), (int)0, (int)0, (int)20);
    }

    private String getTitle(CMIUser cMIUser) {
        String string = CMILC.getIM(afk.class, "afkTitle", new Object[0]);
        return this.plugin.getPlaceholderAPIManager().updatePlaceHolders(cMIUser.getPlayer(), string);
    }

    private String getSubtitle(CMIUser cMIUser) {
        String string = null;
        if (this.SubTitleMessage) {
            if (this.messageSize == -1) {
                this.loadAfk();
            }
            if (this.messageSize > 0 && !this.afkSubTitle.isEmpty()) {
                int n;
                int n2 = n = !this.isAfk(cMIUser.getUniqueId()) || cMIUser.getAfkInfo().getAfkFrom() == 0L ? 1 : (int)(cMIUser.getAfkInfo().getAfkFrom() % (long)this.messageSize);
                if (n >= this.messageSize) {
                    string = this.afkSubTitle.isEmpty() ? "" : this.afkSubTitle.get(0);
                } else if (n + 1 <= this.afkSubTitle.size()) {
                    string = this.afkSubTitle.get(n);
                }
            }
        }
        return this.plugin.getPlaceholderAPIManager().updatePlaceHolders(cMIUser.getPlayer(), string);
    }

    public void setUserToAfk(CMIUser cMIUser, List<String> list2) {
        if (!cMIUser.isAfk()) {
            Snd snd = new Snd().setSender(cMIUser).setTarget(cMIUser);
            list2 = new ArrayList<String>(list2);
            PermissionInfo permissionInfo = this.plugin.getPermissionsManager().getPermissionInfo(cMIUser.getPlayer(), PermissionsManager.CMIPerm.command_afk_kickOutIn_$1.getPermission(""));
            long l = permissionInfo.getMaxValue((double)this.kickTrigerTime / 1000.0).longValue() * 1000L;
            cMIUser.getAfkInfoSafe().setKickOutInSec((int)(l / 1000L));
            int n = 0;
            while (n < list2.size()) {
                String string = this.plugin.getLM().updateSnd(snd, list2.get(n));
                string = string.replace("[time]", CMITimeManager.to24hourShort((Long)l));
                list2.set(n, string);
                ++n;
            }
            ArrayList<String> arrayList = new ArrayList<String>(list2);
            CMIScheduler.runTaskLater(() -> this.plugin.getSpecializedCommandManager().processCmds((List<String>)arrayList, cMIUser.isOnline() ? cMIUser.getPlayer() : null), (long)1L);
        }
    }

    public void removeUserFromAfk(CMIUser cMIUser, List<String> list2) {
        if (cMIUser.isOnline()) {
            this.hideTitle(cMIUser);
            if (cMIUser.isAfk()) {
                Snd snd = new Snd().setSender(cMIUser).setTarget(cMIUser);
                list2 = new ArrayList<String>(list2);
                long l = (long)cMIUser.getAfkInfoSafe().getKickOutInSec() * 1000L;
                int n = 0;
                while (n < list2.size()) {
                    String string = this.plugin.getLM().updateSnd(snd, list2.get(n));
                    string = string.replace("[time]", CMITimeManager.to24hourShort((Long)l));
                    list2.set(n, string);
                    ++n;
                }
                this.plugin.getSpecializedCommandManager().processCmds(list2, cMIUser.isOnline() ? cMIUser.getPlayer() : null);
                this.updateUser(cMIUser);
                this.removeAfkInfo(cMIUser.getUniqueId());
            }
        }
    }

    public void removeUser(CMIUser cMIUser) {
        this.lastAction.remove(cMIUser);
        if (this.lastAction.isEmpty() && this.sched != null) {
            this.sched.cancel();
            this.sched = null;
        }
    }

    public void updateUser(CMIUser cMIUser) {
        if (cMIUser.isOnline() && this.isDisabledWorld(cMIUser.getLocation().getWorld())) {
            this.lastAction.remove(cMIUser);
            return;
        }
        if (cMIUser.getAfkImunityUntil() > 0L && cMIUser.getAfkImunityUntil() > System.currentTimeMillis()) {
            return;
        }
        if (this.sched == null) {
            this.tasker();
        }
        this.setLastAction(cMIUser, System.currentTimeMillis());
    }

    public void setLastAction(CMIUser cMIUser, long l) {
        if (this.sched == null) {
            this.tasker();
        }
        this.lastAction.put(cMIUser, l);
    }

    public Long getLastAction(CMIUser cMIUser) {
        Long l = this.lastAction.get(cMIUser);
        return l;
    }

    public boolean isAfkEnabled() {
        return this.AfkEnabled;
    }

    public boolean isDisableOnMove() {
        return this.disableOnMove;
    }

    public boolean isDisableOnFishing() {
        return this.disableFishing;
    }

    public boolean isDisableOnInteract() {
        return this.disableOnInteract;
    }

    public boolean isDisableOnInventoryClick() {
        return this.DisableOnInventoryClick;
    }

    public boolean isDisableOnCommand() {
        return this.disableOnCommand;
    }

    public boolean isDisableItemPickup() {
        return this.disableItemPickup;
    }

    public boolean isDisableOnPublicChat() {
        return this.disableOnPublicChat;
    }

    public boolean isDisableOnPrivateChat() {
        return this.disableOnPrivateChat;
    }

    public List<String> getAwayTrigerCommands() {
        return this.awayTrigerCommands;
    }

    public void setAwayTrigerCommands(List<String> list2) {
        this.awayTrigerCommands = list2;
    }

    public boolean isPreventDamage() {
        return this.PreventDamage;
    }

    public boolean isPreventJumping() {
        return this.PreventJumping;
    }

    public List<String> getLeaveTrigerCommands() {
        return this.leaveTrigerCommands;
    }

    public void setLeaveTrigerCommands(List<String> list2) {
        this.leaveTrigerCommands = list2;
    }

    public boolean isSmartInteractCheck() {
        return this.SmartInteractCheck;
    }

    public boolean isAntiAfkMachines() {
        return this.AntiAfkMachines;
    }

    public int getCheckInterval() {
        return this.interval;
    }

    public boolean isStopPlayTime() {
        return this.StopPlayTime;
    }

    public void setStopPlayTime(boolean bl) {
        this.StopPlayTime = bl;
    }

    public void removeFromAfkTimePreventer(CMIUser cMIUser) {
        this.afkList.remove(cMIUser);
    }

    public void AddToAfkTimePreventer(CMIUser cMIUser) {
        this.afkList.add(cMIUser);
        this.AfkTimePreventer();
    }

    private void AfkTimePreventer() {
        if (this.afkSched != null) {
            return;
        }
        if (!CMIModule.afk.isEnabled()) {
            return;
        }
        this.afkSched = CMIScheduler.runTimerAsync(() -> {
            try {
                if (this.afkList.isEmpty()) {
                    if (this.afkSched != null) {
                        this.afkSched.cancel();
                        this.afkSched = null;
                    }
                    return;
                }
                ArrayList<CMIUser> arrayList = new ArrayList<CMIUser>(this.afkList);
                for (CMIUser cMIUser : arrayList) {
                    if (!cMIUser.isOnline() || !cMIUser.isAfk()) {
                        this.afkList.remove(cMIUser);
                        continue;
                    }
                    long l = cMIUser.getAfkInfo().getPlaytimeAtAfkStart();
                    if (l < 1000L) continue;
                    Long l2 = l / 50L;
                    if (CMI.getInstance().getConfigManager().PlayTimeFromStats) {
                        this.plugin.getStatsManager().changeTo(cMIUser.getPlayer(), StatsManager.CMIStatistic.PLAY_ONE_TICK, "none", l2);
                        continue;
                    }
                    cMIUser.getPlayer().setTicksLived(l2.intValue());
                }
            }
            catch (Exception exception) {
                this.afkList = new ArrayList<CMIUser>();
                if (this.afkSched != null) {
                    this.afkSched.cancel();
                    this.afkSched = null;
                }
                exception.printStackTrace();
            }
        }, (long)0L, (long)10L);
    }

    public List<String> getManualAwayTrigerCommands() {
        return this.manualAwayTrigerCommands;
    }

    public void setManualAwayTrigerCommands(List<String> list2) {
        this.manualAwayTrigerCommands = list2;
    }

    public long getAwayTrigerTime() {
        return this.awayTrigerTime;
    }

    public boolean nearActivePlayer(Location location, CreatureSpawnEvent.SpawnReason spawnReason) {
        if (this.afkPlayersMap.isEmpty()) {
            return true;
        }
        if (!this.isPreventMobSpawning()) {
            return true;
        }
        ArrayList<Player> arrayList = new ArrayList<Player>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            Object object;
            if (player == null || !AfkManager.isNear((Location)(object = player.getLocation()), location).booleanValue()) continue;
            arrayList.add(player);
        }
        boolean bl = true;
        if (spawnReason.equals((Object)CreatureSpawnEvent.SpawnReason.NATURAL) && this.isPreventMobSpawningNatural() || spawnReason.equals((Object)CreatureSpawnEvent.SpawnReason.SPAWNER) && this.isPreventMobSpawningSpawners()) {
            bl = !arrayList.isEmpty();
        }
        for (Player player : arrayList) {
            CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
            if (cMIUser.isVanished()) continue;
            if (!cMIUser.isAfk()) {
                return true;
            }
            if (!(spawnReason.equals((Object)CreatureSpawnEvent.SpawnReason.SPAWNER) && this.isPreventMobSpawningSpawners() || spawnReason.equals((Object)CreatureSpawnEvent.SpawnReason.NATURAL) && this.isPreventMobSpawningNatural()) && (!spawnReason.equals((Object)CreatureSpawnEvent.SpawnReason.VILLAGE_DEFENSE) || !this.isPreventMobVillageDefence())) continue;
            bl = false;
        }
        return bl;
    }

    public static Boolean isNear(Location location, Location location2) {
        if (location.getWorld() != location2.getWorld()) {
            return false;
        }
        if (Math.abs(location.getX() - location2.getX()) > 64.0) {
            return false;
        }
        if (Math.abs(location.getY() - location2.getY()) > 64.0) {
            return false;
        }
        if (Math.abs(location.getZ() - location2.getZ()) > 64.0) {
            return false;
        }
        return true;
    }

    public boolean isDisableExpPickup() {
        return this.disableExpPickup;
    }

    public boolean isDisableOnItemDrop() {
        return this.DisableOnitemDrop;
    }

    public boolean isDisabledWorld(World world2) {
        if (world2 == null) {
            return false;
        }
        return this.isDisabledWorld(world2.getName());
    }

    public boolean isDisabledWorld(String string) {
        if (string == null) {
            return false;
        }
        return this.disabledWorlds.contains(string.toLowerCase());
    }

    public boolean isPreventMobSpawning() {
        return this.PreventMobSpawning;
    }

    public boolean isPreventMobSpawningNatural() {
        return this.PreventMobSpawningNatural;
    }

    public boolean isPreventMobSpawningSpawners() {
        return this.PreventMobSpawningSpawners;
    }

    public boolean isPreventMobVillageDefence() {
        return this.PreventMobVillageDefence;
    }

    public boolean isPreventPushing() {
        return this.PreventPushing;
    }

    public Set<CMIUser> getAfkPlayers() {
        return this.afkPlayersMap.keySet().stream().map(CMIUser::getUser).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public HashMap<UUID, AfkInfo> getAfkPlayersMap() {
        return this.afkPlayersMap;
    }

    public int getAfkPlayerCount() {
        return this.afkPlayersMap.size();
    }

    public boolean isDisableOnLookAround() {
        return this.disableOnLookAround;
    }

    public boolean isPreventHook() {
        return this.PreventHook;
    }
}

