/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.FindBiome;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.FindBiome.FindBiomeInfo;
import com.Zrips.CMI.Modules.Region.CMIRegion;
import com.Zrips.CMI.Modules.Region.WorldInfo;
import com.Zrips.CMI.Modules.Teleportations.CMITeleportType;
import com.Zrips.CMI.commands.list.findbiome;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.Zrips.CMILib.ActionBar.CMIActionBar;
import net.Zrips.CMILib.Time.CMITimeManager;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class FindBiomeManager {
    public ConcurrentHashMap<UUID, FindBiomeInfo> FindBiomeInfo = new ConcurrentHashMap();
    private CMI plugin;

    public FindBiomeManager(CMI cMI) {
        this.plugin = cMI;
    }

    public boolean stop(Player player) {
        if (this.FindBiomeInfo.containsKey(player.getUniqueId())) {
            FindBiomeInfo findBiomeInfo = this.FindBiomeInfo.get(player.getUniqueId());
            findBiomeInfo.setRunning(false);
            if (findBiomeInfo.getScheduleTask() != null) {
                findBiomeInfo.getScheduleTask().cancel();
            }
            return true;
        }
        return false;
    }

    public void start(FindBiomeInfo findBiomeInfo) {
        if (this.FindBiomeInfo.containsKey(findBiomeInfo.getPlayer().getUniqueId())) {
            FindBiomeInfo findBiomeInfo2 = this.FindBiomeInfo.remove(findBiomeInfo.getPlayer().getUniqueId());
            findBiomeInfo2.setRunning(false);
            if (findBiomeInfo2.getScheduleTask() != null) {
                findBiomeInfo2.getScheduleTask().cancel();
            }
        }
        this.FindBiomeInfo.put(findBiomeInfo.getPlayer().getUniqueId(), findBiomeInfo);
        if (findBiomeInfo.getStartTime() == 0L) {
            findBiomeInfo.setShowInfo(System.currentTimeMillis());
        }
        this.loadChunk(findBiomeInfo);
    }

    private void loadChunk(FindBiomeInfo findBiomeInfo) {
        if (findBiomeInfo.getScheduleTask() != null) {
            findBiomeInfo.getScheduleTask().cancel();
        }
        findBiomeInfo.setScheduleTask(CMIScheduler.runLaterAsync(() -> {
            if (!this.FindBiomeInfo.containsKey(findBiomeInfo.getPlayer().getUniqueId())) {
                return;
            }
            if (!findBiomeInfo.isRunning()) {
                return;
            }
            Location location2 = findBiomeInfo.getRI().getWorld().getWorldBorder().getCenter();
            double d = findBiomeInfo.getRI().getWorld().getWorldBorder().getSize() / 2.0;
            double d2 = location2.getX() - d;
            double d3 = location2.getX() + d;
            double d4 = location2.getZ() - d;
            double d5 = location2.getZ() + d;
            int n = 0;
            while (n < findBiomeInfo.getSpeed()) {
                WorldInfo worldInfo = findBiomeInfo.getRI();
                CMIRegion cMIRegion = worldInfo.getNextChunkLoc(true);
                worldInfo.addLastChecked();
                if (worldInfo.allChecked()) {
                    findBiomeInfo.setRunning(false);
                    if (findBiomeInfo.getScheduleTask() != null) {
                        findBiomeInfo.getScheduleTask().cancel();
                    }
                    this.FindBiomeInfo.remove(findBiomeInfo.getPlayer().getUniqueId());
                    if (findBiomeInfo.getPlayer().isOnline()) {
                        findBiomeInfo.getPlayer().sendMessage(this.plugin.getLM().getMessage("command.findbiome.info.cantFindBiome", "[amount]", findBiomeInfo.getRI().getTotalChunks()));
                    }
                    return;
                }
                if (!(cMIRegion == null || (double)(cMIRegion.getX() * 16) < d2 || (double)(cMIRegion.getX() * 16) > d3 || (double)(cMIRegion.getZ() * 16) < d4 || (double)(cMIRegion.getZ() * 16) > d5)) {
                    Location location3;
                    Biome biome = findBiomeInfo.getRI().getWorld().getBiome(cMIRegion.getX() * 16, cMIRegion.getZ() * 16);
                    if (findBiomeInfo.isMessages() && findBiomeInfo.getShowInfo() + 2000L < System.currentTimeMillis()) {
                        findBiomeInfo.setShowRegionInfo(false);
                        long l = worldInfo.getLastChecked();
                        l = l < 1L ? 1L : l;
                        Long l2 = worldInfo.getLeftToScan();
                        long l3 = System.currentTimeMillis() - findBiomeInfo.getStartTime();
                        double d6 = l3 / l;
                        double d7 = (double)l2.longValue() * d6;
                        CMIActionBar.send((Player)findBiomeInfo.getPlayer(), (String)this.plugin.getLM().getMessage("command.findbiome.info.infoShow", "[tps]", String.format("%.2f", this.plugin.getLagMeter().getTPS()), "[left]", l2, "[time]", CMITimeManager.to24hourShort((Long)((long)d7)), "[speed]", findBiomeInfo.getSpeed()));
                        if (this.plugin.getLagMeter().getTPS() > this.plugin.getConfigManager().scanSoftCap) {
                            findBiomeInfo.setSpeed(findBiomeInfo.getSpeed() + 100);
                        } else if (findBiomeInfo.getSpeed() - 500 >= 0) {
                            findBiomeInfo.setSpeed(findBiomeInfo.getSpeed() - 500);
                        } else {
                            findBiomeInfo.setSpeed(1);
                        }
                        findBiomeInfo.setShowInfo(System.currentTimeMillis());
                    }
                    if (biome.equals((Object)findBiomeInfo.getBiome()) && findBiomeInfo.getPlayer().isOnline() && (!(location3 = new Location(findBiomeInfo.getRI().getWorld(), (double)(cMIRegion.getX() * 16 + 8), 64.0, (double)(cMIRegion.getZ() * 16 + 8))).getWorld().equals(findBiomeInfo.getPlayer().getWorld()) || !(location3.distance(findBiomeInfo.getPlayer().getLocation()) < (double)(this.plugin.getViewRange(null) * 16 / 2)))) {
                        findBiomeInfo.setRunning(false);
                        if (findBiomeInfo.getScheduleTask() != null) {
                            findBiomeInfo.getScheduleTask().cancel();
                        }
                        this.FindBiomeInfo.remove(findBiomeInfo.getPlayer().getUniqueId());
                        if (!findBiomeInfo.getPlayer().isOnline()) {
                            return;
                        }
                        if (location3.getWorld().getEnvironment() == World.Environment.NETHER) {
                            location3.setY(64.0);
                            this.plugin.getTeleportHandler().teleportPlayer(findBiomeInfo.getPlayer(), location3, true, CMITeleportType.Biome).thenAccept(cMITeleportFeedback -> CMILC.info(findbiome.class, (CommandSender)findBiomeInfo.getPlayer(), "teleportedTo", "[biome]", biome.name().toLowerCase()));
                        } else {
                            this.plugin.getTeleportHandler().getTopLocation(location3).thenAccept(location -> this.plugin.getTeleportHandler().teleportPlayer(findBiomeInfo.getPlayer(), (Location)location, true, CMITeleportType.Biome).thenAccept(cMITeleportFeedback -> CMILC.info(findbiome.class, (CommandSender)findBiomeInfo.getPlayer(), "teleportedTo", "[biome]", biome.name().toLowerCase())));
                        }
                        return;
                    }
                }
                ++n;
            }
            this.loadChunk(findBiomeInfo);
        }, (long)1L));
    }
}

