/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Ips;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class IpManager {
    private CMI plugin;
    HashMap<String, Set<CMIUser>> ips = new HashMap();
    private static final Pattern PATTERN = Pattern.compile("^(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");
    private static final Pattern ALTPATTERN = Pattern.compile("^(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\_){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");

    public boolean ipIsOk(String string) {
        return PATTERN.matcher(string).matches();
    }

    public boolean alternateIpIsOk(String string) {
        return ALTPATTERN.matcher(string).matches();
    }

    public IpManager(CMI cMI) {
        this.plugin = cMI;
    }

    public void addIp(HashMap<String, Integer> hashMap, CMIUser cMIUser) {
        for (Map.Entry<String, Integer> entry : hashMap.entrySet()) {
            this.addIp(entry.getKey(), cMIUser);
        }
    }

    public void addIp(String string, CMIUser cMIUser) {
        Set<CMIUser> set = this.ips.get(string);
        if (set == null) {
            set = new HashSet<CMIUser>();
        }
        set.add(cMIUser);
        this.ips.put(string, set);
    }

    public Set<CMIUser> getUsers(String string) {
        return this.ips.get(string);
    }
}

