/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Scan;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIHitBox;
import com.Zrips.CMI.Containers.ScanFindPlace;
import com.Zrips.CMI.Containers.itemInfo;
import com.Zrips.CMI.Modules.Region.WorldInfo;
import com.Zrips.CMI.Modules.Scan.ScanInfo;
import com.Zrips.CMI.Modules.Scan.ScanResultLocations;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import net.Zrips.CMILib.ActionBar.CMIActionBar;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMIBlock;
import net.Zrips.CMILib.Container.CMINumber;
import net.Zrips.CMILib.Container.CMIWorld;
import net.Zrips.CMILib.Entities.CMIEntityType;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Time.CMITimeManager;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.HopperMinecart;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.inventory.HorseInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.util.Vector;

public class Scan {
    public Pattern regionPattern = Pattern.compile("r\\.([0-9-]+)\\.([0-9-]+)\\.mca");
    public ConcurrentHashMap<UUID, ScanInfo> ScanInfo = new ConcurrentHashMap();
    private CMI plugin;

    public Scan(CMI cMI) {
        this.plugin = cMI;
    }

    public void start(ScanInfo scanInfo) {
        if (scanInfo.getStartTime() == 0L) {
            scanInfo.setShowInfo(System.currentTimeMillis());
        }
        this.loadChunk(scanInfo);
    }

    private void loadChunk(ScanInfo scanInfo) {
        if (scanInfo.getScheduleTask() != null) {
            scanInfo.getScheduleTask().cancel();
        }
        scanInfo.setScheduleTask(CMIScheduler.runTaskLater(() -> {
            if (!this.ScanInfo.containsKey(scanInfo.getPlayer().getUniqueId())) {
                return;
            }
            if (!scanInfo.isRunning()) {
                return;
            }
            int n = 0;
            while (n < scanInfo.getSpeed()) {
                boolean bl = false;
                WorldInfo worldInfo = scanInfo.getRI();
                Chunk chunk = worldInfo.getNextChunk(true);
                worldInfo.addLastChecked();
                if (worldInfo.allChecked()) {
                    scanInfo.setRunning(false);
                    scanInfo.setRI(null);
                    if (scanInfo.getScheduleTask() != null) {
                        scanInfo.getScheduleTask().cancel();
                    }
                    if (scanInfo.getPlayer().isOnline()) {
                        CMIScheduler.runTask(() -> {
                            boolean bl = Bukkit.dispatchCommand((CommandSender)scanInfo.getPlayer(), (String)"cmi scan info 1");
                        });
                    }
                    return;
                }
                if (scanInfo.isMessages() && scanInfo.getShowInfo() + 2000L < System.currentTimeMillis()) {
                    scanInfo.setShowRegionInfo(false);
                    long l = worldInfo.getLastChecked();
                    Long l2 = worldInfo.getLeftToScan();
                    long l3 = System.currentTimeMillis() - scanInfo.getStartTime();
                    double d = l3 / l;
                    double d2 = (double)l2.longValue() * d;
                    CMIActionBar.send((Player)scanInfo.getPlayer(), (String)this.plugin.getLM().getMessage("command.scan.info.infoShow", "[tps]", String.format("%.2f", this.plugin.getLagMeter().getTPS()), "[left]", l2, "[time]", CMITimeManager.to24hourShort((Long)((long)d2)), "[speed]", scanInfo.getSpeed(), "[found]", scanInfo.getFound()));
                    if (scanInfo.isAutoSpeed()) {
                        if (this.plugin.getLagMeter().getTPS() > this.plugin.getConfigManager().scanSoftCap) {
                            scanInfo.setSpeed(scanInfo.getSpeed() + 1);
                        } else if (scanInfo.getSpeed() - 2 > 0) {
                            scanInfo.setSpeed(scanInfo.getSpeed() - 2);
                        }
                    }
                    scanInfo.setShowInfo(System.currentTimeMillis());
                }
                if (chunk != null) {
                    Object object;
                    Inventory inventory;
                    Object object2;
                    Object object3;
                    ScanResultLocations scanResultLocations;
                    Block block;
                    int n2;
                    int n3 = this.plugin.getUtilManager().getMaxWorldHeight(worldInfo.getWorld());
                    n3 = n3 > 255 ? 255 : n3;
                    int n4 = chunk.getX() * 16;
                    int n5 = chunk.getZ() * 16;
                    int n6 = CMIWorld.getMaxHeight((World)worldInfo.getWorld());
                    int n7 = com.Zrips.CMI.Modules.Worlds.CMIWorld.getMinHeight(chunk.getWorld());
                    int n8 = 0;
                    while (n8 < 16) {
                        int n9 = 0;
                        while (n9 < 16) {
                            int n10 = worldInfo.getWorld().getHighestBlockYAt(n4 + n8, n5 + n9);
                            n10 = CMINumber.clamp((int)n10, (int)0, (int)n6);
                            n2 = n7;
                            while (n2 <= n10) {
                                block = chunk.getBlock(n8, n2, n9);
                                if (block.getState() instanceof InventoryHolder) {
                                    scanResultLocations = (InventoryHolder)block.getState();
                                    object3 = new ScanResultLocations();
                                    object2 = scanResultLocations.getInventory().getContents();
                                    ((ScanResultLocations)object3).setcontents((ItemStack[])object2);
                                    inventory = CMIMaterial.get((Block)block);
                                    if (inventory != null && inventory.isValidItem()) {
                                        ((ScanResultLocations)object3).setScanPlace((CMIMaterial)inventory);
                                    }
                                    if (!(object = this.CheckContent(scanInfo, (ScanResultLocations)object3, block, null)).isEmpty()) {
                                        Scan.RemoveItemsFromBlock((List<ItemStack>)object, block);
                                    }
                                }
                                ++n2;
                            }
                            ++n9;
                        }
                        ++n8;
                    }
                    BlockFace blockFace = null;
                    block = chunk.getEntities();
                    n2 = ((Entity[])block).length;
                    int n11 = 0;
                    while (n11 < n2) {
                        Entity entity = block[n11];
                        scanResultLocations = null;
                        object3 = entity.getLocation();
                        switch (CMIEntityType.getByType((EntityType)entity.getType())) {
                            case ITEM_FRAME: {
                                scanResultLocations = new ScanResultLocations();
                                scanResultLocations.setFound(true);
                                object2 = (InventoryHolder)entity;
                                blockFace = object2.getFacing();
                                object3.add(-0.5, 0.0, -0.5);
                                inventory = new ItemStack[64];
                                inventory[0] = object2.getItem();
                                scanResultLocations.setUUID(object2.getUniqueId());
                                scanResultLocations.setcontents((ItemStack[])inventory);
                                scanResultLocations.setScanPlace(CMIMaterial.ITEM_FRAME);
                                break;
                            }
                            case HORSE: {
                                scanResultLocations = new ScanResultLocations();
                                object = (Horse)entity;
                                if (object.isCarryingChest()) {
                                    scanResultLocations.setcontents(object.getInventory().getContents());
                                    scanResultLocations.setUUID(object.getUniqueId());
                                }
                                scanResultLocations.setScanPlace(ScanFindPlace.HORSE);
                                scanResultLocations.setFound(true);
                                break;
                            }
                            case CHEST_MINECART: {
                                scanResultLocations = new ScanResultLocations();
                                StorageMinecart storageMinecart = (StorageMinecart)entity;
                                scanResultLocations.setcontents(storageMinecart.getInventory().getContents());
                                scanResultLocations.setScanPlace(CMIMaterial.CHEST_MINECART);
                                scanResultLocations.setUUID(storageMinecart.getUniqueId());
                                scanResultLocations.setFound(true);
                                break;
                            }
                            case HOPPER_MINECART: {
                                scanResultLocations = new ScanResultLocations();
                                HopperMinecart hopperMinecart = (HopperMinecart)entity;
                                scanResultLocations.setcontents(hopperMinecart.getInventory().getContents());
                                scanResultLocations.setScanPlace(CMIMaterial.HOPPER_MINECART);
                                scanResultLocations.setUUID(hopperMinecart.getUniqueId());
                                scanResultLocations.setFound(true);
                                break;
                            }
                            default: {
                                scanResultLocations = new ScanResultLocations();
                                scanResultLocations = Scan.checkArmorStand(scanResultLocations, entity);
                                if (!scanResultLocations.isFound()) break;
                                object3.add(-0.5, 1.0, -0.5);
                            }
                        }
                        if (entity instanceof InventoryHolder && !(entity instanceof Player) && (inventory = (object2 = (InventoryHolder)entity).getInventory()) != null) {
                            scanResultLocations = new ScanResultLocations();
                            scanResultLocations.setcontents(inventory.getContents());
                            scanResultLocations.setScanPlace(ScanFindPlace.ENTITY);
                            scanResultLocations.setUUID(entity.getUniqueId());
                            scanResultLocations.setFound(true);
                        }
                        if (scanResultLocations != null && scanResultLocations.isFound() && !(object2 = this.CheckContent(scanInfo, scanResultLocations, null, entity)).isEmpty()) {
                            this.RemoveItemsFromEntity((List<ItemStack>)object2, entity);
                        }
                        ++n11;
                    }
                    if (!bl) {
                        chunk.unload(false);
                    }
                }
                ++n;
            }
            this.loadChunk(scanInfo);
        }, (long)5L));
    }

    private static void RemoveItemsFromBlock(List<ItemStack> list2, Block block) {
        if (block.getType() == Material.AIR) {
            return;
        }
        if (!(block.getState() instanceof InventoryHolder)) {
            return;
        }
        CMIBlock cMIBlock = new CMIBlock(block);
        Inventory inventory = cMIBlock.getInventory();
        if (CMIMaterial.get((Block)block).isShulkerBox()) {
            inventory = CMI.getInstance().getNMS().getShulkerInv(block);
        }
        if (inventory != null) {
            for (ItemStack itemStack : list2) {
                inventory.removeItem(new ItemStack[]{itemStack});
            }
        }
        try {
            block.getChunk().unload(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void RemoveItemsFromEntity(List<ItemStack> list2, Entity entity) {
        if (entity instanceof InventoryHolder && !(entity instanceof Player)) {
            InventoryHolder inventoryHolder = (InventoryHolder)entity;
            Inventory inventory = inventoryHolder.getInventory();
            if (inventory != null) {
                for (ItemStack itemStack : list2) {
                    inventory.removeItem(new ItemStack[]{itemStack});
                }
            }
        } else {
            switch (CMIEntityType.getByType((EntityType)entity.getType())) {
                case ITEM_FRAME: {
                    ItemFrame itemFrame = (ItemFrame)entity;
                    if (list2.contains(itemFrame.getItem())) {
                        itemFrame.setItem(null);
                    }
                    break;
                }
                case HORSE: {
                    HorseInventory horseInventory;
                    Horse horse = (Horse)entity;
                    if (horse.isCarryingChest() && (horseInventory = horse.getInventory()) != null) {
                        for (ItemStack itemStack : list2) {
                            horseInventory.removeItem(new ItemStack[]{itemStack});
                        }
                    }
                    break;
                }
                case CHEST_MINECART: {
                    StorageMinecart storageMinecart = (StorageMinecart)entity;
                    Inventory inventory = storageMinecart.getInventory();
                    if (inventory != null) {
                        for (ItemStack itemStack : list2) {
                            inventory.removeItem(new ItemStack[]{itemStack});
                        }
                    }
                    break;
                }
                case HOPPER_MINECART: {
                    HopperMinecart hopperMinecart = (HopperMinecart)entity;
                    Inventory inventory = hopperMinecart.getInventory();
                    if (inventory != null) {
                        for (ItemStack itemStack : list2) {
                            inventory.removeItem(new ItemStack[]{itemStack});
                        }
                    }
                    break;
                }
                default: {
                    Scan.removeFromArmorStand(list2, entity);
                }
            }
        }
    }

    public boolean isValidContainer(Block block) {
        return block.getState() instanceof InventoryHolder;
    }

    private static ScanResultLocations checkArmorStand(ScanResultLocations scanResultLocations, Entity entity) {
        if (Version.isCurrentEqualOrLower((Version)Version.v1_7_R4)) {
            return scanResultLocations;
        }
        if (entity.getType() == EntityType.ARMOR_STAND) {
            ArmorStand armorStand = (ArmorStand)entity;
            ItemStack[] itemStackArray = new ItemStack[64];
            itemStackArray[0] = armorStand.getBoots();
            itemStackArray[1] = armorStand.getChestplate();
            itemStackArray[2] = armorStand.getHelmet();
            itemStackArray[3] = armorStand.getLeggings();
            itemStackArray[4] = armorStand.getItemInHand();
            if (Version.isCurrentEqualOrHigher((Version)Version.v1_13_R1)) {
                itemStackArray[5] = armorStand.getEquipment().getItemInOffHand();
            }
            scanResultLocations.setScanPlace(CMIMaterial.ARMOR_STAND);
            scanResultLocations.setUUID(armorStand.getUniqueId());
            scanResultLocations.setFound(true);
            scanResultLocations.setcontents(itemStackArray);
        }
        return scanResultLocations;
    }

    private static void removeFromArmorStand(List<ItemStack> list2, Entity entity) {
        if (Version.isCurrentEqualOrLower((Version)Version.v1_7_R4)) {
            return;
        }
        if (entity.getType() == EntityType.ARMOR_STAND) {
            ArmorStand armorStand = (ArmorStand)entity;
            if (list2.contains(armorStand.getBoots())) {
                armorStand.setBoots(null);
            }
            if (list2.contains(armorStand.getChestplate())) {
                armorStand.setChestplate(null);
            }
            if (list2.contains(armorStand.getHelmet())) {
                armorStand.setHelmet(null);
            }
            if (list2.contains(armorStand.getLeggings())) {
                armorStand.setLeggings(null);
            }
            if (list2.contains(armorStand.getItemInHand())) {
                armorStand.setItemInHand(null);
            }
        }
    }

    /*
     * Could not resolve type clashes
     */
    public List<ItemStack> CheckContent(ScanInfo scanInfo, ScanResultLocations scanResultLocations, Block block, Entity entity) {
        ItemStack itemStack;
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        Location location = null;
        BlockFace blockFace = null;
        if (block != null) {
            location = block.getLocation().clone();
            blockFace = new CMIBlock(block).getFacing();
        } else if (entity != null) {
            location = entity.getLocation().clone();
            switch (entity.getType()) {
                case ITEM_FRAME: {
                    blockFace = ((ItemFrame)entity).getFacing();
                    location.add(-0.5, 0.0, -0.5);
                    break;
                }
                case ARMOR_STAND: {
                    if (Version.isCurrentEqualOrHigher((Version)Version.v1_9_R1)) {
                        try {
                            blockFace = ((ArmorStand)entity).getFacing();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    location.add(-0.5, 1.0, -0.5);
                    break;
                }
            }
        }
        if (scanResultLocations.getContents() == null) {
            return arrayList;
        }
        boolean bl = false;
        int n = 0;
        Location location2 = scanResultLocations.getContents();
        int n2 = ((ItemStack[])location2).length;
        int n3 = 0;
        while (n3 < n2) {
            block45: {
                block52: {
                    Map.Entry entry2;
                    Object object;
                    block51: {
                        block50: {
                            block49: {
                                block47: {
                                    Object object22;
                                    block48: {
                                        Object object3;
                                        block46: {
                                            Inventory inventory;
                                            itemStack = location2[n3];
                                            if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) break block45;
                                            CMIMaterial cMIMaterial = CMIMaterial.get((ItemStack)itemStack);
                                            if (cMIMaterial.isShulkerBox() && (inventory = this.plugin.getNMS().getShulkerInv(itemStack)) != null) {
                                                Object object4 = new ScanResultLocations();
                                                ((ScanResultLocations)object4).setcontents(inventory.getContents());
                                                ((ScanResultLocations)object4).setScanPlace(ScanFindPlace.SHULKER_INCEPTION);
                                                object22 = this.CheckContent(scanInfo, (ScanResultLocations)object4, block, entity);
                                                if (!object22.isEmpty()) {
                                                    object = object22.iterator();
                                                    while (object.hasNext()) {
                                                        object3 = (ItemStack)object.next();
                                                        inventory.removeItem(new ItemStack[]{object3});
                                                    }
                                                    this.plugin.getShulkerBoxManager().setShulkerInv(itemStack, inventory.getContents());
                                                }
                                            }
                                            boolean bl2 = false;
                                            for (Object object4 : scanInfo.getItemInfo()) {
                                                if (cMIMaterial != ((itemInfo)object4).getMat()) continue;
                                                bl2 = true;
                                            }
                                            if (!bl2 && !scanInfo.getItemInfo().isEmpty()) break block45;
                                            boolean bl3 = false;
                                            for (Object object22 : scanInfo.getItemInfo()) {
                                                if (cMIMaterial != ((itemInfo)object22).getMat()) continue;
                                                bl3 = true;
                                            }
                                            if (!bl3 && !scanInfo.getItemInfo().isEmpty()) break block45;
                                            object22 = scanInfo.getName();
                                            if (object22 == null || !itemStack.hasItemMeta() || !itemStack.getItemMeta().hasDisplayName()) break block46;
                                            object3 = CMIChatColor.stripColor((String)itemStack.getItemMeta().getDisplayName().toLowerCase());
                                            if (((String)object3).contains((CharSequence)object22)) break block47;
                                            break block45;
                                        }
                                        if (object22 == null || itemStack.getType() != Material.WRITTEN_BOOK) break block48;
                                        object3 = (BookMeta)itemStack.getItemMeta();
                                        object = object3.getTitle();
                                        if (itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName()) {
                                            object = itemStack.getItemMeta().getDisplayName();
                                        }
                                        if (object == null || ((String)((Object)(entry2 = CMIChatColor.stripColor((String)((String)object).toLowerCase())))).contains((CharSequence)object22)) break block47;
                                        break block45;
                                    }
                                    if (object22 != null && (!itemStack.hasItemMeta() || itemStack.hasItemMeta() && !itemStack.getItemMeta().hasDisplayName())) break block45;
                                }
                                if (scanInfo.getLore() == null || !itemStack.hasItemMeta() || !itemStack.getItemMeta().hasLore()) break block49;
                                boolean bl4 = false;
                                entry2 = itemStack.getItemMeta().getLore().iterator();
                                while (entry2.hasNext()) {
                                    object = (String)entry2.next();
                                    if (!CMIChatColor.stripColor((String)((String)object).toLowerCase()).contains(scanInfo.getLore())) continue;
                                    bl4 = true;
                                    break;
                                }
                                if (bl4) break block50;
                                break block45;
                            }
                            if (scanInfo.getLore() != null && (!itemStack.hasItemMeta() || itemStack.hasItemMeta() && !itemStack.getItemMeta().hasLore())) break block45;
                        }
                        if (scanInfo.getEnchant() == null) break block51;
                        if (!itemStack.hasItemMeta()) break block45;
                        boolean bl5 = false;
                        if (itemStack.getItemMeta().hasEnchants() && (object = (Integer)itemStack.getItemMeta().getEnchants().get(scanInfo.getEnchant())) != null) {
                            if (scanInfo.getEnchantLvl() > -1) {
                                if ((Integer)object >= scanInfo.getEnchantLvl()) {
                                    bl5 = true;
                                }
                            } else {
                                bl5 = true;
                            }
                        }
                        if (itemStack.getItemMeta() instanceof EnchantmentStorageMeta && (entry2 = (Integer)(object = (EnchantmentStorageMeta)itemStack.getItemMeta()).getStoredEnchants().get(scanInfo.getEnchant())) != null) {
                            if (scanInfo.getEnchantLvl() > -1) {
                                if ((Integer)((Object)entry2) >= scanInfo.getEnchantLvl()) {
                                    bl5 = true;
                                }
                            } else {
                                bl5 = true;
                            }
                        }
                        if (!bl5) break block45;
                    }
                    if (scanInfo.isOversize() && itemStack.getAmount() > 0 && itemStack.getAmount() <= itemStack.getMaxStackSize()) break block45;
                    if (scanInfo.getEnchantLvl() == -1) break block52;
                    if (!itemStack.hasItemMeta()) break block45;
                    boolean bl6 = false;
                    if (itemStack.getItemMeta().hasEnchants()) {
                        entry2 = itemStack.getItemMeta().getEnchants().entrySet().iterator();
                        while (entry2.hasNext()) {
                            object = (Map.Entry)entry2.next();
                            if ((Integer)object.getValue() < scanInfo.getEnchantLvl()) continue;
                            bl6 = true;
                            break;
                        }
                    }
                    if (itemStack.getItemMeta() instanceof EnchantmentStorageMeta) {
                        object = (EnchantmentStorageMeta)itemStack.getItemMeta();
                        for (Map.Entry entry2 : object.getStoredEnchants().entrySet()) {
                            if ((Integer)entry2.getValue() < scanInfo.getEnchantLvl()) continue;
                            bl6 = true;
                            break;
                        }
                    }
                    if (!bl6) break block45;
                }
                bl = true;
                n += itemStack.getAmount();
                if (scanInfo.isPurge()) {
                    arrayList.add(itemStack);
                }
            }
            ++n3;
        }
        if (bl && scanInfo.getAmount() != -1 && scanInfo.getAmount() > n) {
            bl = false;
        }
        if (bl && n > 0) {
            scanResultLocations.setLocation(location);
            itemStack = null;
            CMIHitBox cMIHitBox = new CMIHitBox((Entity)scanInfo.getPlayer());
            n2 = 0;
            while (n2 < 4) {
                location2 = this.findLocation(location, blockFace, false, n2);
                if (cMIHitBox.isEmptySpace(location2)) {
                    itemStack = location2;
                    break;
                }
                ++n2;
            }
            if (itemStack == null) {
                n2 = 0;
                while (n2 < 4) {
                    location2 = this.findLocation(location, blockFace, true, n2);
                    if (cMIHitBox.isEmptySpace(location2)) {
                        itemStack = location2;
                        break;
                    }
                    ++n2;
                }
            }
            if (itemStack == null) {
                itemStack = this.findLocation(location, blockFace, false, 0);
            }
            scanResultLocations.setTPLocation((Location)itemStack);
            scanResultLocations.setId(scanInfo.getCurrentId());
            scanResultLocations.setType(block != null ? block.getType().toString() : (entity != null ? entity.getType().toString() : ""));
            scanInfo.setCurrentId(scanInfo.getCurrentId() + 1);
            scanInfo.addLocation(n, scanResultLocations);
            scanInfo.addFound();
        }
        return arrayList;
    }

    public Location findLocation(Location location, BlockFace blockFace, boolean bl, int n) {
        int n2;
        int n3;
        Material material;
        Material material2;
        Material material3;
        Location location2 = location.clone();
        Block block = location.getBlock();
        BlockFace blockFace2 = new CMIBlock(block).getFacing();
        if (blockFace != null) {
            blockFace2 = blockFace;
        }
        if (this.isValidContainer(block)) {
            if (bl && block.getState() instanceof Chest && (material3 = (Chest)block.getState()).getInventory().getHolder() instanceof DoubleChest) {
                material2 = (DoubleChest)material3.getInventory().getHolder();
                material = (Chest)material2.getLeftSide();
                block = material.getLocation().getBlock();
                location2 = new Location(block.getLocation().getWorld(), block.getLocation().getX(), block.getLocation().getY(), block.getLocation().getZ());
            }
            if (blockFace2 != null) {
                block0 : switch (blockFace2) {
                    case SOUTH: {
                        switch (n) {
                            case 1: {
                                blockFace2 = BlockFace.WEST;
                                break;
                            }
                            case 2: {
                                blockFace2 = BlockFace.NORTH;
                                break;
                            }
                            case 3: {
                                blockFace2 = BlockFace.EAST;
                            }
                        }
                        break;
                    }
                    case WEST: {
                        switch (n) {
                            case 1: {
                                blockFace2 = BlockFace.NORTH;
                                break;
                            }
                            case 2: {
                                blockFace2 = BlockFace.EAST;
                                break;
                            }
                            case 3: {
                                blockFace2 = BlockFace.SOUTH;
                            }
                        }
                        break;
                    }
                    case NORTH: {
                        switch (n) {
                            case 1: {
                                blockFace2 = BlockFace.EAST;
                                break;
                            }
                            case 2: {
                                blockFace2 = BlockFace.SOUTH;
                                break;
                            }
                            case 3: {
                                blockFace2 = BlockFace.WEST;
                            }
                        }
                        break;
                    }
                    case EAST: {
                        switch (n) {
                            case 1: {
                                blockFace2 = BlockFace.SOUTH;
                                break block0;
                            }
                            case 2: {
                                blockFace2 = BlockFace.WEST;
                                break block0;
                            }
                            case 3: {
                                blockFace2 = BlockFace.NORTH;
                            }
                        }
                    }
                }
            }
        }
        material3 = Material.AIR;
        material2 = Material.SNOW;
        material = CMIMaterial.GRASS.getMaterial();
        location2.add(0.5, 0.0, 0.5);
        Location location3 = location.clone().add(0.5, 0.5, 0.5);
        if (blockFace2 != null) {
            switch (blockFace2) {
                case SOUTH: {
                    location2.add(0.0, 0.0, 1.0);
                    location3.add(0.0, 0.0, 0.5);
                    break;
                }
                case NORTH: {
                    location2.add(0.0, 0.0, -1.0);
                    location3.add(0.0, 0.0, -0.5);
                    break;
                }
                case EAST: {
                    location2.add(1.0, 0.0, 0.0);
                    location3.add(0.5, 0.0, 0.0);
                    break;
                }
                case WEST: {
                    location2.add(-1.0, 0.0, 0.0);
                    location3.add(-0.5, 0.0, 0.0);
                    break;
                }
            }
            n3 = location2.getBlockX();
            n2 = location2.getBlockY();
            int n4 = location2.getBlockZ();
            int n5 = 0;
            while (n5 < 5) {
                Material material4 = location2.getWorld().getBlockAt(n3, n2 + n5 - 2, n4).getType();
                Material material5 = location2.getWorld().getBlockAt(n3, n2 + n5 - 1, n4).getType();
                if ((material4 == material3 || material4 == material2 || material4 == material) && material5 == material3) {
                    location2.add(0.0, (double)(n5 - 2), 0.0);
                    break;
                }
                ++n5;
            }
        } else {
            Material material6;
            Material material7;
            n3 = location.getBlockX();
            n2 = location.getBlockY();
            int n6 = location.getBlockZ();
            boolean bl2 = false;
            int n7 = 0;
            while (n7 < 4) {
                material7 = location2.getWorld().getBlockAt(n3 + 1, n2 + n7 - 2, n6).getType();
                material6 = location2.getWorld().getBlockAt(n3 + 1, n2 + n7 - 1, n6).getType();
                if ((material7 == material3 || material7 == material2) && material6 == material3) {
                    location2.add(1.0, (double)(n7 - 2), 0.0);
                    bl2 = true;
                    break;
                }
                ++n7;
            }
            if (!bl2) {
                n7 = 0;
                while (n7 < 4) {
                    material7 = location2.getWorld().getBlockAt(n3 - 1, n2 + n7 - 2, n6).getType();
                    material6 = location2.getWorld().getBlockAt(n3 - 1, n2 + n7 - 1, n6).getType();
                    if ((material7 == material3 || material7 == material2) && material6 == material3) {
                        location2.add(-1.0, (double)(n7 - 2), 0.0);
                        bl2 = true;
                        break;
                    }
                    ++n7;
                }
            }
            if (!bl2) {
                n7 = 0;
                while (n7 < 4) {
                    material7 = location2.getWorld().getBlockAt(n3, n2 + n7 - 2, n6 + 1).getType();
                    material6 = location2.getWorld().getBlockAt(n3, n2 + n7 - 1, n6 + 1).getType();
                    if ((material7 == material3 || material7 == material2) && material6 == material3) {
                        location2.add(0.0, (double)(n7 - 2), 1.0);
                        bl2 = true;
                        break;
                    }
                    ++n7;
                }
            }
            if (!bl2) {
                n7 = 0;
                while (n7 < 4) {
                    material7 = location2.getWorld().getBlockAt(n3, n2 + n7 - 2, n6 - 1).getType();
                    material6 = location2.getWorld().getBlockAt(n3, n2 + n7 - 1, n6 - 1).getType();
                    if ((material7 == material3 || material7 == material2) && material6 == material3) {
                        location2.add(0.0, (double)(n7 - 2), -1.0);
                        bl2 = true;
                        break;
                    }
                    ++n7;
                }
            }
        }
        Location location4 = new Location(location.getWorld(), location2.getX(), location2.getY() + 1.5, location2.getZ());
        Vector vector = location3.toVector().subtract(location4.toVector());
        location2.setDirection(vector);
        return location2;
    }

    public void setCheckedPlace(Player player, int n) {
        ScanInfo scanInfo = this.ScanInfo.get(player.getUniqueId());
        if (scanInfo == null) {
            return;
        }
        block0: for (Map.Entry<Integer, ArrayList<ScanResultLocations>> entry : scanInfo.getLocations().entrySet()) {
            for (ScanResultLocations scanResultLocations : entry.getValue()) {
                if (scanResultLocations.getId() != n) continue;
                scanResultLocations.setChecked(true);
                break block0;
            }
        }
    }
}

