/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Teleportations;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIHitBox;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.Modules.Teleportations.CMIChunkSnapShot;
import com.Zrips.CMI.Modules.Teleportations.CMITeleportCondition;
import com.Zrips.CMI.Modules.Teleportations.CMITeleportFeedback;
import com.Zrips.CMI.Modules.Teleportations.CMITeleportLocation;
import com.Zrips.CMI.Modules.Teleportations.CMITeleportType;
import com.Zrips.CMI.Modules.Teleportations.CMITeleportationBounds;
import com.Zrips.CMI.Modules.Teleportations.DangerousTp;
import com.Zrips.CMI.Modules.Teleportations.PositionRelativeData;
import com.Zrips.CMI.Modules.Teleportations.SafeTeleport;
import com.Zrips.CMI.events.CMIAsyncPlayerTeleportEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.Zrips.CMILib.Container.CMINumber;
import net.Zrips.CMILib.Container.CMIWorld;
import net.Zrips.CMILib.Items.CMIMC;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Version.PaperMethods.PaperLib;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.ChunkSnapshot;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.util.Vector;

public class TeleportHandler {
    private CMI plugin;
    private Set<CMIMaterial> emptyBlockMap = new HashSet<CMIMaterial>();
    private Set<CMIMaterial> badBlockMap = new HashSet<CMIMaterial>();
    private HashMap<UUID, DangerousTp> badTeleports = new HashMap();
    private int btprange = 15;
    static Method getBlockTypeId = null;

    public TeleportHandler(CMI cMI) {
        this.plugin = cMI;
        this.fill();
    }

    public void addBadTeleport(UUID uUID, Location location) {
        DangerousTp dangerousTp = new DangerousTp(uUID, location);
        this.badTeleports.put(uUID, dangerousTp);
    }

    public void removeBadTeleport(UUID uUID) {
        this.badTeleports.remove(uUID);
    }

    public Location getBadTeleport(UUID uUID) {
        DangerousTp dangerousTp = this.badTeleports.get(uUID);
        if (dangerousTp == null) {
            return null;
        }
        if (dangerousTp.getTime() + (long)(this.btprange * 1000) < System.currentTimeMillis()) {
            this.badTeleports.remove(uUID);
            return null;
        }
        return dangerousTp.getLocation();
    }

    public CompletableFuture<Material> getBlockType(Location location, boolean bl) {
        return this.getSnapshot(location, bl, false).thenApplyAsync(cMIChunkSnapShot -> cMIChunkSnapShot.getSnapshot().getBlockType(location.getBlockX() & 0xF, location.getBlockY(), location.getBlockZ() & 0xF));
    }

    public CompletableFuture<CMIChunkSnapShot> getSnapshot(Location location, boolean bl, boolean bl2) {
        return this.getSnapshot(location.getWorld(), location.getBlockX() >> 4, location.getBlockZ() >> 4, bl, bl2);
    }

    public CompletableFuture<CMIChunkSnapShot> getSnapshot(World world2, int n, int n2, boolean bl, boolean bl2) {
        if (world2 == null) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture completableFuture = null;
        try {
            if (Version.isSpigot()) {
                return CompletableFuture.supplyAsync(() -> {
                    CMIChunkSnapShot cMIChunkSnapShot = new CMIChunkSnapShot(world2);
                    try {
                        CMIScheduler.runAtLocation((Location)new Location(world2, (double)(n * 16), 0.0, (double)(n2 * 16)), () -> {
                            CMIChunkSnapShot cMIChunkSnapShot2 = cMIChunkSnapShot.setSnapshot(world2.getChunkAt(n, n2).getChunkSnapshot(true, bl2, false));
                        }).get();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        Thread.currentThread().interrupt();
                    }
                    return cMIChunkSnapShot;
                });
            }
            completableFuture = PaperLib.getChunkAtAsync((World)world2, (int)n, (int)n2, (boolean)bl);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (completableFuture == null) {
            return CompletableFuture.completedFuture(null);
        }
        return completableFuture.thenComposeAsync(chunk -> CompletableFuture.supplyAsync(() -> {
            CMIChunkSnapShot cMIChunkSnapShot = new CMIChunkSnapShot(world2);
            if (chunk == null) {
                return cMIChunkSnapShot;
            }
            try {
                CompletableFuture completableFuture = CMIScheduler.runAtLocation((Location)new Location(world2, (double)(n * 16), 0.0, (double)(n2 * 16)), () -> {
                    CMIChunkSnapShot cMIChunkSnapShot2 = cMIChunkSnapShot.setSnapshot(chunk.getChunkSnapshot(true, bl2, false));
                });
                completableFuture.get();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                Thread.currentThread().interrupt();
            }
            return cMIChunkSnapShot;
        }));
    }

    public CMIMaterial getBlockType(ChunkSnapshot chunkSnapshot, int n, PositionRelativeData positionRelativeData) {
        if (n >= positionRelativeData.getMaxWorldY() || n < positionRelativeData.getMinWorldY()) {
            return CMIMaterial.AIR;
        }
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_13_R1)) {
            return CMIMaterial.get((Material)chunkSnapshot.getBlockType(positionRelativeData.getLocalX(), n, positionRelativeData.getLocalZ()));
        }
        if (getBlockTypeId == null) {
            try {
                getBlockTypeId = chunkSnapshot.getClass().getMethod("getBlockTypeId", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        try {
            return CMIMaterial.get((int)((Integer)getBlockTypeId.invoke((Object)chunkSnapshot, positionRelativeData.getLocalX(), n, positionRelativeData.getLocalZ())));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return CMIMaterial.NONE;
        }
    }

    public CompletableFuture<CMITeleportLocation> getSafeTeleportationLocation(CMITeleportationBounds cMITeleportationBounds, CompletableFuture<CMIChunkSnapShot> completableFuture) {
        return completableFuture.thenComposeAsync(cMIChunkSnapShot -> CompletableFuture.supplyAsync(() -> {
            CMIMaterial cMIMaterial;
            CMITeleportLocation cMITeleportLocation = new CMITeleportLocation(cMIChunkSnapShot.getWorld());
            cMITeleportLocation.setYaw(cMITeleportationBounds.getYaw());
            cMITeleportLocation.setPitch(cMITeleportationBounds.getPitch());
            if (cMIChunkSnapShot.getWorld() == null) {
                return cMITeleportLocation.setCondition(CMITeleportCondition.MissingWorld);
            }
            ChunkSnapshot chunkSnapshot = cMIChunkSnapShot.getSnapshot();
            PositionRelativeData positionRelativeData = new PositionRelativeData(new Location(cMIChunkSnapShot.getWorld(), cMITeleportationBounds.getPosition().getX(), 64.0, cMITeleportationBounds.getPosition().getZ()));
            int n = -999;
            double d = -1.0;
            if (cMITeleportationBounds.getWorld().getEnvironment() == World.Environment.NETHER && cMITeleportationBounds.getPosition().getY() <= 128.0) {
                cMITeleportationBounds.setMaxY(CMI.getInstance().getUtilManager().getMaxWorldHeight(cMITeleportationBounds.getWorld()) - 3);
            }
            try {
                CMIHitBox cMIHitBox = new CMIHitBox((Entity)cMITeleportationBounds.getPlayer());
                cMIHitBox.setSnapshot(chunkSnapshot);
                if (cMIHitBox.isEmptySpace(cMITeleportationBounds.getPosition().toLocation(cMITeleportationBounds.getWorld()).add(0.0, 0.01, 0.0)) && !this.isEmpty(cMIMaterial = this.getBlockType(chunkSnapshot, (int)cMITeleportationBounds.getPosition().getY() - 1, positionRelativeData), false)) {
                    n = (int)cMITeleportationBounds.getPosition().getY();
                }
                d = cMIHitBox.getHeightAtLocation(cMITeleportationBounds.getPosition().toLocation(cMITeleportationBounds.getWorld()));
                if (n == -999 && cMIHitBox.isEmptySpace(cMITeleportationBounds.getPosition().toLocation(cMITeleportationBounds.getWorld()).add(0.0, 1.01, 0.0)) && !this.isEmpty(cMIMaterial = this.getBlockType(chunkSnapshot, (int)cMITeleportationBounds.getPosition().getY(), positionRelativeData), false)) {
                    n = (int)cMITeleportationBounds.getPosition().getY() + 1;
                    d = cMIHitBox.getHeightAtLocation(cMITeleportationBounds.getPosition().toLocation(cMITeleportationBounds.getWorld()).clone().add(0.0, 1.0, 0.0));
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (n == -999 && !this.isEmptySpaceForPlayer(chunkSnapshot, (int)cMITeleportationBounds.getPosition().getY(), positionRelativeData)) {
                int n2 = (int)cMITeleportationBounds.getPosition().getY();
                while (n2 <= cMITeleportationBounds.getMaxY() + 2) {
                    if (!this.isEmptySpaceForPlayer(chunkSnapshot, n2, positionRelativeData)) {
                        if (cMITeleportationBounds.isImortal()) {
                            n = n2;
                        }
                    } else {
                        cMIMaterial = this.getBlockType(chunkSnapshot, n2 - 1, positionRelativeData);
                        if (!cMIMaterial.isAir()) {
                            n = n2;
                            break;
                        }
                    }
                    ++n2;
                }
            }
            if (n == -999 && cMITeleportationBounds.isCanFly() && this.isEmptySpaceForPlayer(chunkSnapshot, (int)cMITeleportationBounds.getPosition().getY(), positionRelativeData)) {
                n = (int)cMITeleportationBounds.getPosition().getY();
            }
            if (n == -999 && this.isEmptySpaceForPlayer(chunkSnapshot, (int)cMITeleportationBounds.getPosition().getY(), positionRelativeData)) {
                int n3 = (int)cMITeleportationBounds.getPosition().getY();
                while (n3 >= cMITeleportationBounds.getMinY()) {
                    if (!this.isEmptySpaceForPlayer(chunkSnapshot, n3, positionRelativeData)) {
                        if (!cMITeleportationBounds.isImortal()) break;
                        n = n3 + 1;
                        break;
                    }
                    n = n3--;
                }
            }
            if (n == -999 && cMITeleportationBounds.isImortal()) {
                n = (int)cMITeleportationBounds.getPosition().getY();
            }
            if (n > -999) {
                int n4 = 0;
                int n5 = CMIWorld.getMinHeight((World)cMITeleportationBounds.getWorld());
                CMIMaterial cMIMaterial2 = null;
                try {
                    int n6 = n;
                    while (n6 >= n5) {
                        cMIMaterial2 = n6 >= positionRelativeData.getMaxWorldY() ? CMIMaterial.AIR : this.getBlockType(chunkSnapshot, n6, positionRelativeData);
                        if (this.isEmpty(cMIMaterial2, false)) {
                            ++n4;
                            --n6;
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                cMITeleportLocation.setFloor(cMIMaterial2);
                if (!cMITeleportationBounds.isImortal() && n4 > 5) {
                    if (n - n4 <= n5) {
                        cMITeleportLocation.setCondition(CMITeleportCondition.Void);
                    } else if (cMIMaterial2 == null || !cMIMaterial2.isWater() && !cMIMaterial2.equals((Object)CMIMaterial.SLIME_BLOCK)) {
                        cMITeleportLocation.setCondition(CMITeleportCondition.Fall);
                    }
                }
                cMITeleportLocation.setFallDistance(n4);
                if (!cMITeleportationBounds.isImortal() && this.isBad(cMIMaterial2)) {
                    cMITeleportLocation.setCondition(CMITeleportCondition.BadFloor);
                }
                if (d == -1.0 && !this.getBlockType(chunkSnapshot, n, positionRelativeData).isAir() || cMIMaterial2 != null && (cMIMaterial2.isFence() || cMIMaterial2.isGate() || cMIMaterial2.isWall())) {
                    d = 0.501;
                }
                return cMITeleportLocation.setPosition(new Vector(cMITeleportationBounds.getPosition().getX(), (double)n + d, cMITeleportationBounds.getPosition().getZ()));
            }
            cMITeleportLocation.setCondition(CMITeleportCondition.Suffocation);
            return cMITeleportLocation;
        }));
    }

    public CompletableFuture<Boolean> teleportEntity(Entity entity, Location location, PlayerTeleportEvent.TeleportCause teleportCause) {
        return PaperLib.teleportAsync((Entity)entity, (Location)location, (PlayerTeleportEvent.TeleportCause)teleportCause);
    }

    public CompletableFuture<CMITeleportFeedback> teleportPlayer(Player player, Location location, boolean bl) {
        return this.teleportPlayer(player, location, PlayerTeleportEvent.TeleportCause.PLUGIN, bl, null, false);
    }

    public CompletableFuture<CMITeleportFeedback> teleportPlayer(Player player, Location location) {
        return this.teleportPlayer(player, location, PlayerTeleportEvent.TeleportCause.PLUGIN, false, null, false);
    }

    public CompletableFuture<CMITeleportFeedback> teleportPlayer(Player player, Location location, CMITeleportType cMITeleportType) {
        return this.teleportPlayer(player, location, PlayerTeleportEvent.TeleportCause.PLUGIN, false, cMITeleportType, false);
    }

    public CompletableFuture<CMITeleportFeedback> teleportPlayer(Player player, Location location, boolean bl, CMITeleportType cMITeleportType) {
        return this.teleportPlayer(player, location, PlayerTeleportEvent.TeleportCause.PLUGIN, bl, cMITeleportType, false);
    }

    public CompletableFuture<CMITeleportFeedback> teleportPlayer(Player player, Location location, boolean bl, CMITeleportType cMITeleportType, boolean bl2) {
        return this.teleportPlayer(player, location, PlayerTeleportEvent.TeleportCause.PLUGIN, bl, cMITeleportType, bl2);
    }

    public CompletableFuture<CMITeleportFeedback> teleportPlayer(Player player, Location location, PlayerTeleportEvent.TeleportCause teleportCause) {
        return this.teleportPlayer(player, location, teleportCause, false, null, false);
    }

    public CompletableFuture<CMITeleportFeedback> teleportPlayer(Player player, Location location, PlayerTeleportEvent.TeleportCause teleportCause, boolean bl) {
        return this.teleportPlayer(player, location, teleportCause, bl, null, false);
    }

    public CompletableFuture<Boolean> finalizeTeleportation(Player player, PlayerTeleportEvent.TeleportCause teleportCause, CMITeleportLocation cMITeleportLocation) {
        SafeTeleport safeTeleport = new SafeTeleport(cMITeleportLocation.getLocation(), cMITeleportLocation.getLocation(), cMITeleportLocation.getCondition());
        CMIAsyncPlayerTeleportEvent cMIAsyncPlayerTeleportEvent = new CMIAsyncPlayerTeleportEvent((CommandSender)player, player, safeTeleport, cMITeleportLocation.getType());
        Bukkit.getServer().getPluginManager().callEvent((Event)cMIAsyncPlayerTeleportEvent);
        if (cMIAsyncPlayerTeleportEvent.isCancelled()) {
            return CompletableFuture.completedFuture(false);
        }
        if (this.setTeleportInvulnerability(player) && cMITeleportLocation.getCondition().equals((Object)CMITeleportCondition.Fall)) {
            cMITeleportLocation.setCondition(CMITeleportCondition.Good);
        }
        if (player.isOnline()) {
            return PaperLib.teleportAsync((Entity)player, (Location)cMITeleportLocation.getLocation(), (PlayerTeleportEvent.TeleportCause)teleportCause);
        }
        this.plugin.getNMS().setMiscLocation(player, cMITeleportLocation.getLocation());
        return CompletableFuture.completedFuture(true);
    }

    public CompletableFuture<CMITeleportFeedback> teleportPlayer(Player player, Location location, PlayerTeleportEvent.TeleportCause teleportCause, boolean bl, CMITeleportType cMITeleportType) {
        return this.teleportPlayer(player, location, teleportCause, bl, cMITeleportType, false);
    }

    public CompletableFuture<CMITeleportFeedback> teleportPlayer(Player player, Location location, PlayerTeleportEvent.TeleportCause teleportCause, boolean bl2, CMITeleportType cMITeleportType, boolean bl3) {
        Object object;
        try {
            location.setWorld(Bukkit.getServer().getWorld(location.getWorld().getUID()));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        Location location2 = player.getLocation();
        CompletableFuture<CMIChunkSnapShot> completableFuture = this.getSnapshot(location, true, true);
        CMITeleportFeedback cMITeleportFeedback = new CMITeleportFeedback(location, false);
        if (completableFuture == null) {
            return CompletableFuture.completedFuture(cMITeleportFeedback);
        }
        CompletableFuture<CMITeleportLocation> completableFuture2 = null;
        if (bl2) {
            object = new CMITeleportationBounds(location);
            ((CMITeleportationBounds)object).setUpRange(0.0);
            ((CMITeleportationBounds)object).setMaxY(((CMITeleportationBounds)object).getMaxY() < location.getBlockY() ? location.getBlockY() : ((CMITeleportationBounds)object).getMaxY());
            ((CMITeleportationBounds)object).setMinY(CMIWorld.getMinHeight((World)location.getWorld()) + 1);
            ((CMITeleportationBounds)object).setImortal(TeleportHandler.isImortal(player));
            ((CMITeleportationBounds)object).setCanFly(player.getAllowFlight());
            ((CMITeleportationBounds)object).setFlying(player.isFlying());
            ((CMITeleportationBounds)object).setPlayer(player);
            ((CMITeleportationBounds)object).setIgnoreYLimits(bl3);
            completableFuture2 = this.getSafeTeleportationLocation((CMITeleportationBounds)object, completableFuture);
        } else {
            completableFuture2 = CompletableFuture.completedFuture(new CMITeleportLocation(location.getWorld()).setPosition(location.toVector()).setPitch(location.getPitch()).setYaw(location.getYaw()));
        }
        object = completableFuture2.thenComposeAsync(cMITeleportLocation -> {
            cMITeleportFeedback.setCondition(cMITeleportLocation.getCondition());
            cMITeleportFeedback.setFloor(cMITeleportLocation.getFloor());
            cMITeleportFeedback.setFallDistance(cMITeleportLocation.getFallDistance());
            if (cMITeleportLocation.getPosition() == null) {
                return CompletableFuture.completedFuture(false);
            }
            cMITeleportFeedback.setLocation(cMITeleportLocation.getLocation());
            cMITeleportLocation.setType(cMITeleportType);
            try {
                if (bl2 && !cMITeleportFeedback.getCondition().equals((Object)CMITeleportCondition.Good)) {
                    if ((cMITeleportFeedback.getCondition().equals((Object)CMITeleportCondition.Fall) || cMITeleportFeedback.getCondition().equals((Object)CMITeleportCondition.Void) || cMITeleportFeedback.getCondition().equals((Object)CMITeleportCondition.BadFloor)) && player.isFlying() && player.getWorld().equals(location.getWorld()) && cMITeleportFeedback.getFallDistance() >= 1) {
                        cMITeleportFeedback.setCondition(CMITeleportCondition.Good);
                        return this.finalizeTeleportation(player, teleportCause, (CMITeleportLocation)cMITeleportLocation);
                    }
                    if (this.plugin.getTeleportManager().getInvulnerabilityTime() >= 0 && cMITeleportFeedback.getCondition().equals((Object)CMITeleportCondition.Fall)) {
                        cMITeleportFeedback.setCondition(CMITeleportCondition.Good);
                        return this.finalizeTeleportation(player, teleportCause, (CMITeleportLocation)cMITeleportLocation);
                    }
                    return CompletableFuture.completedFuture(false);
                }
                return this.finalizeTeleportation(player, teleportCause, (CMITeleportLocation)cMITeleportLocation);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return CompletableFuture.completedFuture(false);
            }
        });
        return ((CompletableFuture)object).thenComposeAsync(bl -> {
            if (bl.booleanValue() && cMITeleportType != null) {
                try {
                    if (cMITeleportType.getFrom() != null) {
                        cMITeleportType.getFrom().show(location2);
                    }
                    if (cMITeleportType.getTo() != null) {
                        cMITeleportType.getTo().show(cMITeleportFeedback.getLocation());
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            if (bl.booleanValue()) {
                if (cMITeleportFeedback.getFallDistance() == 0 && !this.isBad(cMITeleportFeedback.getFloor()) && player.isFlying()) {
                    player.setFlying(false);
                } else if (cMITeleportFeedback.getFallDistance() > 1 && player.getAllowFlight()) {
                    player.setFlying(true);
                }
            }
            return CompletableFuture.completedFuture(cMITeleportFeedback.setSuccess((boolean)bl));
        });
    }

    public List<Entity> shakePassengers(Entity entity) {
        ArrayList<Entity> arrayList = new ArrayList<Entity>();
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_11_R1)) {
            for (Entity entity2 : entity.getPassengers()) {
                if (entity2 == null) continue;
                arrayList.add(entity2);
                entity2.leaveVehicle();
                if (entity2 instanceof Slime && entity2.getCustomName().equalsIgnoreCase("CMIFakeSlime")) {
                    entity2.remove();
                }
                return arrayList;
            }
        }
        if (entity.getPassenger() == null) {
            return arrayList;
        }
        arrayList.add(entity.getPassenger());
        entity.getPassenger().leaveVehicle();
        if (entity.getPassenger() instanceof Slime && entity.getPassenger().getCustomName().equalsIgnoreCase("CMIFakeSlime")) {
            entity.getPassenger().remove();
        }
        return arrayList;
    }

    public boolean isEmptySpaceForPlayer(ChunkSnapshot chunkSnapshot, int n, PositionRelativeData positionRelativeData) {
        if (n <= positionRelativeData.getMaxWorldY() && n >= positionRelativeData.getMinWorldY() && !this.isEmpty(this.getBlockType(chunkSnapshot, n, positionRelativeData), true)) {
            return false;
        }
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_14_R1)) {
            return true;
        }
        return n >= positionRelativeData.getMaxWorldY() || n < positionRelativeData.getMinWorldY() || this.isEmpty(this.getBlockType(chunkSnapshot, n + 1, positionRelativeData), true);
    }

    public boolean isEmpty(ChunkSnapshot chunkSnapshot, int n, PositionRelativeData positionRelativeData) {
        return n >= positionRelativeData.getMaxWorldY() - 1 || n < positionRelativeData.getMinWorldY() || this.isEmpty(this.getBlockType(chunkSnapshot, n, positionRelativeData), true);
    }

    public boolean isEmpty(CMIMaterial cMIMaterial, boolean bl) {
        if (cMIMaterial == null) {
            return false;
        }
        if (cMIMaterial.isNone()) {
            return true;
        }
        if (cMIMaterial.isAir()) {
            return true;
        }
        if (cMIMaterial.isLava()) {
            return false;
        }
        if (bl && cMIMaterial.isWater()) {
            return true;
        }
        return this.emptyBlockMap.contains(cMIMaterial);
    }

    public boolean isBad(CMIMaterial cMIMaterial) {
        return this.badBlockMap.contains(cMIMaterial);
    }

    private boolean setTeleportInvulnerability(Player player) {
        boolean bl;
        if (!player.isOnline() || this.plugin.getTeleportManager().getInvulnerabilityTime() <= 0) {
            return false;
        }
        CMIUser cMIUser = CMIUser.getUser(player);
        boolean bl2 = bl = cMIUser.getTgod() > System.currentTimeMillis();
        if (!bl) {
            player.setNoDamageTicks(this.plugin.getTeleportManager().getInvulnerabilityTime() * 20);
        }
        cMIUser.setTeleportInvulnerability(System.currentTimeMillis() + 1000L * (long)this.plugin.getTeleportManager().getInvulnerabilityTime());
        return true;
    }

    public boolean needToFly(Player player) {
        int n = 0;
        Location location = player.getLocation().clone();
        int n2 = location.getBlockY();
        int n3 = CMIWorld.getMinHeight((World)location.getWorld());
        while (this.isEmpty(CMIMaterial.get((Block)location.getBlock()), true) && n2 > n3) {
            ++n;
            location.setY((double)(--n2));
        }
        if (this.isBad(CMIMaterial.get((Block)location.getBlock()))) {
            return true;
        }
        if (n2 <= n3) {
            return true;
        }
        return n > 4;
    }

    public CompletableFuture<Double> getDistanceToDrop(Location location) {
        CompletableFuture<CMIChunkSnapShot> completableFuture = this.getSnapshot(location, true, true);
        return completableFuture.thenComposeAsync(cMIChunkSnapShot -> CompletableFuture.supplyAsync(() -> {
            PositionRelativeData positionRelativeData = new PositionRelativeData(location);
            int n = 0;
            int n2 = location.getBlockY();
            while (n2 >= CMIWorld.getMinHeight((World)location.getWorld())) {
                if (!this.isEmpty(cMIChunkSnapShot.getSnapshot(), n2, positionRelativeData)) break;
                ++n;
                --n2;
            }
            return n;
        }));
    }

    public CompletableFuture<CMITeleportFeedback> getSafeLocation(Player player, Location location, int n, int n2) {
        return this.getSafeLocation(player, location, n, n2, true);
    }

    public CompletableFuture<CMITeleportFeedback> getSafeLocation(Player player, Location location, int n, int n2, boolean bl) {
        CompletableFuture<CMIChunkSnapShot> completableFuture = this.getSnapshot(location, true, true);
        CMITeleportationBounds cMITeleportationBounds = new CMITeleportationBounds(location);
        cMITeleportationBounds.setUpRange(n);
        cMITeleportationBounds.setDownRange(n2);
        if (bl) {
            cMITeleportationBounds.setImortal(TeleportHandler.isImortal(player));
            cMITeleportationBounds.setCanFly(player.getAllowFlight());
            cMITeleportationBounds.setFlying(player.isFlying());
        }
        CompletableFuture<CMITeleportLocation> completableFuture2 = this.getSafeTeleportationLocation(cMITeleportationBounds, completableFuture);
        CMITeleportFeedback cMITeleportFeedback = new CMITeleportFeedback(location, false);
        return completableFuture2.thenComposeAsync(cMITeleportLocation -> CompletableFuture.supplyAsync(() -> {
            cMITeleportFeedback.setCondition(cMITeleportLocation.getCondition());
            if (cMITeleportLocation.getPosition() == null) {
                return cMITeleportFeedback;
            }
            cMITeleportFeedback.setLocation(cMITeleportLocation.getLocation());
            cMITeleportFeedback.setFallDistance(cMITeleportLocation.getFallDistance());
            cMITeleportFeedback.setFloor(cMITeleportLocation.getFloor());
            if ((cMITeleportFeedback.getCondition().equals((Object)CMITeleportCondition.Fall) || cMITeleportFeedback.getCondition().equals((Object)CMITeleportCondition.Void) || cMITeleportFeedback.getCondition().equals((Object)CMITeleportCondition.BadFloor)) && player.isFlying() && player.getWorld().equals(location.getWorld()) && cMITeleportFeedback.getFallDistance() >= 1) {
                cMITeleportFeedback.setCondition(CMITeleportCondition.Good);
            }
            return cMITeleportFeedback;
        }));
    }

    private static boolean isImortal(Player player) {
        CMIUser cMIUser = CMI.getInstance().getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return false;
        }
        return cMIUser.isGod() || !player.getGameMode().equals((Object)GameMode.SURVIVAL) && !player.getGameMode().equals((Object)GameMode.ADVENTURE);
    }

    public boolean bypassesBadLocation(Player player, CMITeleportCondition cMITeleportCondition) {
        return PermissionsManager.CMIPerm.safeteleport_bypass_$1.hasPermission((CommandSender)player, cMITeleportCondition.name());
    }

    public CompletableFuture<Location> getTopLocation(Location location) {
        if (location == null) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<CMIChunkSnapShot> completableFuture = this.getSnapshot(location, true, true);
        return completableFuture.thenComposeAsync(cMIChunkSnapShot -> CompletableFuture.supplyAsync(() -> {
            int n;
            if (cMIChunkSnapShot.getWorld() == null) {
                return null;
            }
            ChunkSnapshot chunkSnapshot = cMIChunkSnapShot.getSnapshot();
            PositionRelativeData positionRelativeData = new PositionRelativeData(location);
            int n2 = n = location.getWorld().getEnvironment().equals((Object)World.Environment.NETHER) ? CMINumber.clamp((int)(positionRelativeData.getMaxWorldY() - 3), (int)0, (int)125) : positionRelativeData.getMaxWorldY();
            while (n2 > positionRelativeData.getMinWorldY()) {
                if (this.isValidPosition(chunkSnapshot, n2, positionRelativeData)) {
                    return new Location(cMIChunkSnapShot.getWorld(), location.getX(), (double)(n2 + 1), location.getZ());
                }
                --n2;
            }
            return new Location(cMIChunkSnapShot.getWorld(), location.getX(), (double)cMIChunkSnapShot.getSnapshot().getHighestBlockYAt(positionRelativeData.getLocalX(), positionRelativeData.getLocalZ()), location.getZ());
        }));
    }

    public CompletableFuture<Location> getDownLocation(Location location) {
        if (location == null) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<CMIChunkSnapShot> completableFuture = this.getSnapshot(location, true, true);
        return completableFuture.thenComposeAsync(cMIChunkSnapShot -> CompletableFuture.supplyAsync(() -> {
            if (cMIChunkSnapShot.getWorld() == null) {
                return null;
            }
            ChunkSnapshot chunkSnapshot = cMIChunkSnapShot.getSnapshot();
            PositionRelativeData positionRelativeData = new PositionRelativeData(location);
            int n = location.getBlockY() - 2;
            while (n > positionRelativeData.getMinWorldY()) {
                if (this.isValidPosition(chunkSnapshot, n, positionRelativeData)) {
                    return new Location(cMIChunkSnapShot.getWorld(), location.getX(), (double)(n + 1), location.getZ());
                }
                --n;
            }
            return null;
        }));
    }

    private boolean isValidPosition(ChunkSnapshot chunkSnapshot, int n, PositionRelativeData positionRelativeData) {
        CMIMaterial cMIMaterial = this.getBlockType(chunkSnapshot, n, positionRelativeData);
        if (cMIMaterial.isAir()) {
            return false;
        }
        if (this.isEmpty(cMIMaterial, false)) {
            return false;
        }
        return this.isEmptySpaceForPlayer(chunkSnapshot, n + 1, positionRelativeData);
    }

    public CompletableFuture<Location> getBottomLocation(Location location) {
        if (location == null) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<CMIChunkSnapShot> completableFuture = this.getSnapshot(location, true, true);
        return completableFuture.thenComposeAsync(cMIChunkSnapShot -> CompletableFuture.supplyAsync(() -> {
            if (cMIChunkSnapShot.getWorld() == null) {
                return null;
            }
            ChunkSnapshot chunkSnapshot = cMIChunkSnapShot.getSnapshot();
            PositionRelativeData positionRelativeData = new PositionRelativeData(location);
            int n = positionRelativeData.getMinWorldY();
            while (n < location.getBlockY()) {
                if (this.isValidPosition(chunkSnapshot, n, positionRelativeData)) {
                    return new Location(cMIChunkSnapShot.getWorld(), location.getX(), (double)(n + 1), location.getZ());
                }
                ++n;
            }
            return null;
        }));
    }

    private void fill() {
        this.emptyBlockMap.clear();
        CMIMaterial[] cMIMaterialArray = CMIMaterial.values();
        int n = cMIMaterialArray.length;
        int n2 = 0;
        while (n2 < n) {
            CMIMaterial cMIMaterial = cMIMaterialArray[n2];
            if (cMIMaterial.containsCriteria(new CMIMC[]{CMIMC.CARPET, CMIMC.NOCOLLISIONBOX})) {
                this.emptyBlockMap.add(cMIMaterial);
            }
            ++n2;
        }
        this.badBlockMap.add(CMIMaterial.LAVA);
        this.badBlockMap.add(CMIMaterial.FIRE);
        if (!Version.isCurrentEqualOrHigher((Version)Version.v1_13_R1)) {
            this.badBlockMap.add(CMIMaterial.LEGACY_STATIONARY_LAVA);
        }
        this.badBlockMap.add(CMIMaterial.MAGMA_BLOCK);
        this.badBlockMap.add(CMIMaterial.CACTUS);
    }
}

