/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Votifier;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Containers.Snd;
import com.Zrips.CMI.Modules.ModuleHandling.CMIModule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Time.CMITimeManager;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Schedulers.CMITask;

public class VotifierManager {
    private CMI plugin;
    private List<String> CommandsOnVote = new ArrayList<String>();
    private List<String> ExcludeList = new ArrayList<String>();
    private boolean CountVotes = true;
    private boolean PerformCommands = true;
    private int cooldown = 0;
    private int MaxVotesInADay = 0;
    private HashMap<Integer, List<String>> rewards = new HashMap();
    private HashMap<UUID, HashMap<String, Long>> cooldowns = new HashMap();
    private HashMap<UUID, voteReminder> voteReminder = new HashMap();
    private ConcurrentSkipListMap<Double, CMIUser> Top = new ConcurrentSkipListMap(Collections.reverseOrder());
    private Set<CMIUser> withVotes = new HashSet<CMIUser>();
    Long lastUpdate = 0L;
    CMITask sched = null;
    int updateDelay = 5;
    boolean calculating = false;

    public void removeVoteReminder(UUID uUID) {
        this.voteReminder.remove(uUID);
    }

    public void addToVoteReminder(UUID uUID) {
        this.voteReminder.put(uUID, new voteReminder());
    }

    public VotifierManager(CMI cMI) {
        this.plugin = cMI;
    }

    public void loadConfig() {
        ConfigReader configReader = this.plugin.getConfigManager().getConfig();
        configReader.addComment("Votifier.CountVotes", new String[]{"When set to true votifier votes will be counted for player"});
        this.CountVotes = configReader.get("Votifier.CountVotes", Boolean.valueOf(true));
        configReader.addComment("Votifier.MaxVotesInADay", new String[]{"Number of votes one IP can make in last 24 hours", "Set it to 0 to have unlimited amount"});
        this.MaxVotesInADay = configReader.get("Votifier.MaxVotesInADay", 0);
        this.MaxVotesInADay = this.MaxVotesInADay < 0 ? 0 : this.MaxVotesInADay;
        configReader.addComment("Votifier.GeneralCooldown", new String[]{"Cooldown between votes from same service", "In most cases voting service will have its own cooldown setup", "But if you need extra one to prevent rapid voting you can define time in seconds over here"});
        this.cooldown = configReader.get("Votifier.GeneralCooldown", 0);
        this.cooldown = this.cooldown < 0 ? 0 : this.cooldown;
        configReader.addComment("Votifier.PerformCommands", new String[]{"When set to false, commands on sucessfull vote will not be performed"});
        this.PerformCommands = configReader.get("Votifier.PerformCommands", Boolean.valueOf(true));
        configReader.addComment("Votifier.CommandsOnVote", new String[]{"Defines commands to be performed when player votes", "Supports specialized commands and placeholders", "[serviceName] variable can be used to insert address"});
        this.CommandsOnVote = configReader.get("Votifier.CommandsOnVote", Arrays.asList("cmi broadcast !&6[playerDisplayName] &evoted!", "cmi give [playerName] diamond"));
        configReader.addComment("Votifier.ExtraRewardsEnabled", new String[]{"Keep it at false if you dont want to give out extra rewards"});
        boolean bl = configReader.get("Votifier.ExtraRewardsEnabled", Boolean.valueOf(false));
        configReader.addComment("Votifier.ExtraRewards", new String[]{"Commands will be performed when player collect determined amount of votes"});
        if (configReader.getC().isConfigurationSection("Votifier.ExtraRewards")) {
            for (String string : configReader.getC().getConfigurationSection("Votifier.ExtraRewards").getKeys(false)) {
                try {
                    int n = Integer.parseInt(string);
                    List list2 = configReader.get("Votifier.ExtraRewards." + string, new ArrayList());
                    if (!bl || n <= 0 || list2 == null || list2.isEmpty()) continue;
                    this.rewards.put(n, list2);
                }
                catch (Exception exception) {
                    this.plugin.consoleMessage("&cCan't load vote rewards (" + string + ")");
                }
            }
        } else {
            configReader.get("Votifier.ExtraRewards.10", Arrays.asList("cmi heal [playerName]", "cmi money give [playerName] 100"));
            configReader.get("Votifier.ExtraRewards.100", Arrays.asList("cmi heal [playerName]", "cmi money give [playerName] 1000", "cmi give [playerName] diamond 32"));
        }
        configReader.addComment("Votifier.ExcludeList", new String[]{"List of players to be excluded from top voter list"});
        this.ExcludeList = configReader.get("Votifier.ExcludeList", Arrays.asList("None"));
        int n = 0;
        while (n < this.ExcludeList.size()) {
            this.ExcludeList.set(n, this.ExcludeList.get(n).toLowerCase());
            ++n;
        }
    }

    @Deprecated
    public void processVote(CMIUser cMIUser, String string) {
        this.processVote(cMIUser, string, null);
    }

    public void processVote(CMIUser cMIUser, String string, String string2) {
        Object object;
        List<String> list2;
        if (!CMIModule.votifier.isEnabled()) {
            return;
        }
        if (this.cooldown > 0) {
            HashMap<String, Long> hashMap = this.cooldowns.get(cMIUser.getUniqueId());
            List<String> list3 = list2 = string == null ? "None" : string;
            if (hashMap != null && (object = hashMap.get(list2)) != null && (Long)object + (long)this.cooldown * 1000L > System.currentTimeMillis()) {
                hashMap.put((String)((Object)list2), System.currentTimeMillis());
                this.cooldowns.put(cMIUser.getUniqueId(), hashMap);
                cMIUser.sendMessage("votes", "voteCooldown", "[time]", CMITimeManager.to24hourShort((Long)((Long)object + (long)this.cooldown * 1000L - System.currentTimeMillis())));
                return;
            }
            object = new HashMap();
            ((HashMap)object).put(list2, System.currentTimeMillis());
            this.cooldowns.put(cMIUser.getUniqueId(), (HashMap<String, Long>)object);
        }
        boolean bl = false;
        if (this.CountVotes) {
            bl = cMIUser.addVotifierVote();
            cMIUser.addForDelayedSave();
        }
        if (!bl && cMIUser.getLastDailyVoteTime() != null) {
            cMIUser.sendMessage("votes", "voteLimit", "[time]", CMITimeManager.to24hourShort((Long)(cMIUser.getLastDailyVoteTime() + 86400000L - System.currentTimeMillis())));
            return;
        }
        if (this.PerformCommands) {
            list2 = new Snd().setSender(cMIUser).setTarget(cMIUser);
            object = new ArrayList<String>(this.CommandsOnVote);
            int n = 0;
            while (n < ((ArrayList)object).size()) {
                String string3 = this.plugin.getLM().updateSnd((Snd)((Object)list2), (String)((ArrayList)object).get(n));
                string3 = string3.replace("[serviceName]", string == null ? "" : string);
                string3 = this.plugin.getPlaceholderAPIManager().updatePlaceHolders(cMIUser.getPlayer(), string3);
                ((ArrayList)object).set(n, string3);
                ++n;
            }
            this.plugin.getSpecializedCommandManager().processCmds((List<String>)object, cMIUser.getPlayer());
        }
        if ((list2 = this.rewards.get(cMIUser.getVotifierVotes())) != null) {
            object = new Snd().setSender(cMIUser).setTarget(cMIUser);
            ArrayList<String> arrayList = new ArrayList<String>(list2);
            int n = 0;
            while (n < arrayList.size()) {
                String string4 = this.plugin.getLM().updateSnd((Snd)object, arrayList.get(n));
                string4 = string4.replace("[serviceName]", string == null ? "" : string);
                string4 = this.plugin.getPlaceholderAPIManager().updatePlaceHolders(cMIUser.getPlayer(), string4);
                arrayList.set(n, string4);
                ++n;
            }
            this.plugin.getSpecializedCommandManager().processCmds(arrayList, cMIUser.getPlayer());
        }
    }

    public void updateVoteCountList(CMIUser cMIUser) {
        if (cMIUser.getVotifierVotes() <= 0) {
            this.withVotes.remove(cMIUser);
        } else {
            this.withVotes.add(cMIUser);
        }
    }

    private void delayUpdate() {
        if (this.sched != null) {
            this.sched.cancel();
            this.sched = null;
            if (this.lastUpdate + (long)(this.updateDelay * 1000 + 1000) < System.currentTimeMillis()) {
                this.updateTopList();
            }
        }
        this.sched = CMIScheduler.runTaskLater(() -> {
            this.recalculate();
            this.sched = null;
        }, (long)(this.updateDelay * 20));
    }

    public void updateTopList() {
        if (this.lastUpdate + (long)(this.updateDelay * 1000 + 1000) > System.currentTimeMillis() || this.sched != null) {
            this.delayUpdate();
            return;
        }
        if (this.sched != null) {
            this.sched.cancel();
            this.sched = null;
        }
        this.recalculate();
        this.lastUpdate = System.currentTimeMillis();
    }

    private void recalculate() {
        if (this.calculating) {
            return;
        }
        int n = this.withVotes.size();
        Random random = new Random(System.nanoTime());
        HashSet<CMIUser> hashSet = new HashSet<CMIUser>(this.withVotes);
        this.calculating = true;
        CMIScheduler.runTaskAsynchronously(() -> {
            ConcurrentSkipListMap concurrentSkipListMap = new ConcurrentSkipListMap(Collections.reverseOrder());
            try {
                for (CMIUser cMIUser : hashSet) {
                    Double d;
                    if (cMIUser.getName(false) == null || (d = Double.valueOf(cMIUser.getVotifierVotes())) == 0.0 || this.ExcludeList.contains(cMIUser.getName().toLowerCase())) continue;
                    int n2 = 0;
                    while (n2 < n - concurrentSkipListMap.size()) {
                        if (!concurrentSkipListMap.containsKey(d)) break;
                        d = d + (double)random.nextInt(10000) / 1.0E8;
                        ++n2;
                    }
                    concurrentSkipListMap.put(d, cMIUser);
                }
            }
            catch (Error | Exception throwable) {
                throwable.printStackTrace();
            }
            CMIScheduler.runTask(() -> {
                this.Top.clear();
                this.Top.putAll(concurrentSkipListMap);
                this.calculating = false;
            });
        });
    }

    public ConcurrentSkipListMap<Double, CMIUser> getTop() {
        if (this.lastUpdate == 0L) {
            this.recalculate();
        }
        return this.Top;
    }

    public int getMaxVotesInADay() {
        return this.MaxVotesInADay;
    }

    private class voteReminder {
        private int times = 0;
        private long last = System.currentTimeMillis();

        public void recordNotified() {
            ++this.times;
            this.last = System.currentTimeMillis();
        }

        public int getTimes() {
            return this.times;
        }

        public long getLast() {
            return this.last;
        }
    }
}

