/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Warnings;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.Snd;
import com.Zrips.CMI.Modules.Warnings.CMIPlayerWarning;
import com.Zrips.CMI.Modules.Warnings.CMIWarningCategory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import org.bukkit.entity.Player;

public class WarningManager {
    private CMI plugin;
    private LinkedHashMap<Integer, List<String>> commands = new LinkedHashMap();
    private HashMap<String, CMIWarningCategory> Categories = new HashMap();
    private HashMap<UUID, List<CMIPlayerWarning>> warnings = new HashMap();

    public List<CMIPlayerWarning> getWarnings(UUID uUID2) {
        List list2 = this.warnings.computeIfAbsent(uUID2, uUID -> new ArrayList());
        if (list2 != null) {
            list2.removeIf(cMIPlayerWarning -> cMIPlayerWarning.getGivenAt() + cMIPlayerWarning.getCategory().getLifeTime() < System.currentTimeMillis());
        }
        return list2;
    }

    public void setWarnings(UUID uUID, List<CMIPlayerWarning> list2) {
        if (list2 == null || list2.isEmpty()) {
            this.warnings.remove(uUID);
        } else {
            this.warnings.put(uUID, list2);
        }
    }

    public WarningManager(CMI cMI) {
        this.plugin = cMI;
    }

    public void loadConfig() {
        Long l = System.currentTimeMillis();
        this.commands.clear();
        this.Categories.clear();
        this.warnings.clear();
        ConfigReader configReader = CMI.getInstance().getConfigManager().getConfig();
        CMIWarningCategory cMIWarningCategory = new CMIWarningCategory("Default");
        cMIWarningCategory.setLifeTime((long)configReader.get("Warnings.Default.LifeTime", 86400) * 1000L);
        cMIWarningCategory.setPoints(configReader.get("Warnings.Default.Points", 1));
        cMIWarningCategory.setDefaultReason(configReader.get("Warnings.Default.DefaultReason", "&7Violated server rules"));
        this.Categories.put(cMIWarningCategory.getName().toLowerCase(), cMIWarningCategory);
        if (!configReader.getC().isConfigurationSection("Warnings.Categories")) {
            cMIWarningCategory = new CMIWarningCategory("Swear");
            cMIWarningCategory.setLifeTime((long)configReader.get("Warnings.Categories.Swear.LifeTime", 86400) * 1000L);
            cMIWarningCategory.setPoints(configReader.get("Warnings.Categories.Swear.Points", 3));
            cMIWarningCategory.setDefaultReason(configReader.get("Warnings.Categories.Swear.DefaultReason", "&7Swearing"));
            this.Categories.put(cMIWarningCategory.getName().toLowerCase(), cMIWarningCategory);
            cMIWarningCategory = new CMIWarningCategory("Grief");
            cMIWarningCategory.setLifeTime((long)configReader.get("Warnings.Categories.Grief.LifeTime", 86400) * 1000L);
            cMIWarningCategory.setPoints(configReader.get("Warnings.Categories.Grief.Points", 10));
            cMIWarningCategory.setDefaultReason(configReader.get("Warnings.Categories.Grief.DefaultReason", "&7Griefing"));
            this.Categories.put(cMIWarningCategory.getName().toLowerCase(), cMIWarningCategory);
            cMIWarningCategory = new CMIWarningCategory("Bug");
            cMIWarningCategory.setLifeTime((long)configReader.get("Warnings.Categories.Bug.LifeTime", 86400) * 1000L);
            cMIWarningCategory.setPoints(configReader.get("Warnings.Categories.Bug.Points", 30));
            cMIWarningCategory.setDefaultReason(configReader.get("Warnings.Categories.Bug.DefaultReason", "&7Using bugs"));
            this.Categories.put(cMIWarningCategory.getName().toLowerCase(), cMIWarningCategory);
            cMIWarningCategory = new CMIWarningCategory("Cheat");
            cMIWarningCategory.setLifeTime((long)configReader.get("Warnings.Categories.Cheat.LifeTime", 86400) * 1000L);
            cMIWarningCategory.setPoints(configReader.get("Warnings.Categories.Cheat.Points", 50));
            cMIWarningCategory.setDefaultReason(configReader.get("Warnings.Categories.Cheat.DefaultReason", "&7Using cheats"));
            this.Categories.put(cMIWarningCategory.getName().toLowerCase(), cMIWarningCategory);
        } else {
            for (String string : configReader.getC().getConfigurationSection("Warnings.Categories").getKeys(false)) {
                try {
                    cMIWarningCategory = new CMIWarningCategory(string);
                    cMIWarningCategory.setLifeTime((long)configReader.get("Warnings.Categories." + string + ".LifeTime", 600) * 1000L);
                    cMIWarningCategory.setPoints(configReader.get("Warnings.Categories." + string + ".Points", 5));
                    cMIWarningCategory.setDefaultReason(configReader.get("Warnings.Categories." + string + ".DefaultReason", "&7Violated server rules"));
                    this.Categories.put(cMIWarningCategory.getName().toLowerCase(), cMIWarningCategory);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.plugin.loadMessage(this.Categories.size(), "warning categories", System.currentTimeMillis() - l);
        l = System.currentTimeMillis();
        if (!configReader.getC().isConfigurationSection("Warnings.Perform")) {
            this.commands.put(3, configReader.get("Warnings.Perform.3", Arrays.asList("cmi mute [playerName] 10m", "cmi msg [playerName] !&cMuted for &710 &cminutes for getting &73 &cwarnings!")));
            this.commands.put(5, configReader.get("Warnings.Perform.5", Arrays.asList("cmi kick [playerName] &cKicked for getting 5 warnings!")));
            this.commands.put(10, configReader.get("Warnings.Perform.10", Arrays.asList("cmi tempban [playerName] 5m &cTemporary banned for getting 10 warnings!")));
        } else {
            for (String string : configReader.getC().getConfigurationSection("Warnings.Perform").getKeys(false)) {
                try {
                    this.commands.put(Integer.parseInt(string), configReader.get("Warnings.Perform." + string, Arrays.asList("")));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.plugin.loadMessage(this.commands.size(), "warning commands", System.currentTimeMillis() - l);
    }

    public CMIWarningCategory getDefaultCategory() {
        return this.Categories.get("default");
    }

    public CMIWarningCategory getCategory(String string) {
        if (string == null) {
            return null;
        }
        return this.Categories.get(string.toLowerCase());
    }

    public List<String> getCommandsByWarns(Player player, int n, int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Snd snd = new Snd();
        snd.setSource(player);
        snd.setTarget(player);
        Integer n3 = 0;
        for (Map.Entry<Integer, List<String>> entry : this.commands.entrySet()) {
            if (entry.getKey() < n || entry.getKey() > n2 || entry.getKey() <= n3) continue;
            n3 = entry.getKey();
        }
        if (n3 > 0 && this.commands.containsKey(n3)) {
            arrayList.addAll(this.plugin.getLM().updateSnd(snd, new ArrayList<String>((Collection)this.commands.get(n3))));
        }
        return arrayList;
    }

    public List<String> getCommandsByWarns(int n) {
        return this.commands.get(n) != null ? new ArrayList(this.commands.get(n)) : null;
    }

    public HashMap<String, CMIWarningCategory> getCategories() {
        return this.Categories;
    }
}

