/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Containers;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Items.CMIItemStack;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.NBT.CMINBT;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class CMIPlayerInventory {
    private CMIUser user;

    public CMIPlayerInventory(CMIUser cMIUser) {
        this.user = cMIUser;
    }

    public void setItem(CMIInventorySlot cMIInventorySlot, ItemStack itemStack) {
        Player player = this.user.getPlayer();
        if (cMIInventorySlot.equals((Object)CMIInventorySlot.MainHand)) {
            CMILib.getInstance().getReflectionManager().setItemInMainHand(this.user.getPlayer(), itemStack);
        } else {
            for (Integer n : cMIInventorySlot.getSlots()) {
                player.getInventory().setItem(n.intValue(), itemStack);
            }
        }
    }

    public HashMap<Integer, ItemStack> addItem(ItemStack itemStack, int n) {
        return this.addItem(itemStack, CMIFullInventoryAction.Drop, n);
    }

    public HashMap<Integer, ItemStack> addItem(ItemStack itemStack) {
        return this.addItem(itemStack, CMIFullInventoryAction.Drop, -1);
    }

    public HashMap<Integer, ItemStack> addItem(ItemStack itemStack, CMIFullInventoryAction cMIFullInventoryAction) {
        return this.addItem(itemStack, cMIFullInventoryAction, -1);
    }

    public HashMap<Integer, ItemStack> addItem(ItemStack itemStack, CMIFullInventoryAction cMIFullInventoryAction, int n) {
        Object object;
        Player player = this.user.getPlayer();
        if (n >= 0 && n <= 40) {
            player.updateInventory();
            object = itemStack.clone();
            if (itemStack.getAmount() > itemStack.getType().getMaxStackSize()) {
                object.setAmount(itemStack.getType().getMaxStackSize());
                itemStack.setAmount(itemStack.getAmount() - itemStack.getType().getMaxStackSize());
                ItemStack object2 = player.getInventory().getItem(n);
                if (object2 == null || object2.getType() == Material.AIR) {
                    player.getInventory().setItem(n, (ItemStack)object);
                } else {
                    itemStack.setAmount(itemStack.getAmount() + object.getAmount());
                }
            } else {
                ItemStack itemStack2 = player.getInventory().getItem(n);
                if (itemStack2 == null || itemStack2.getType() == Material.AIR) {
                    player.getInventory().setItem(n, (ItemStack)object);
                    return new HashMap<Integer, ItemStack>();
                }
            }
        }
        object = CMIPlayerInventory.addItem((Inventory)player.getInventory(), itemStack);
        switch (cMIFullInventoryAction) {
            case Abort: {
                break;
            }
            case Drop: {
                if (object == null || !this.user.isOnline()) break;
                for (Map.Entry entry : ((HashMap)object).entrySet()) {
                    int n2 = ((ItemStack)entry.getValue()).getAmount() / ((ItemStack)entry.getValue()).getMaxStackSize();
                    if (n2 > 1) {
                        int n3 = ((ItemStack)entry.getValue()).getAmount() - n2 * ((ItemStack)entry.getValue()).getMaxStackSize();
                        int n4 = 0;
                        while (n4 < n2) {
                            ItemStack itemStack3 = ((ItemStack)entry.getValue()).clone();
                            itemStack3.setAmount(itemStack3.getType().getMaxStackSize());
                            if (!CMIMaterial.isAir((Material)itemStack3.getType())) {
                                this.user.dropItemNearPlayer(itemStack3);
                            }
                            ++n4;
                        }
                        if (n3 <= 0) continue;
                        ItemStack itemStack4 = ((ItemStack)entry.getValue()).clone();
                        itemStack4.setAmount(n3);
                        if (CMIMaterial.isAir((Material)itemStack4.getType())) continue;
                        this.user.dropItemNearPlayer(itemStack4);
                        continue;
                    }
                    if (CMIMaterial.isAir((Material)((ItemStack)entry.getValue()).getType())) continue;
                    this.user.dropItemNearPlayer((ItemStack)entry.getValue());
                }
                ((HashMap)object).clear();
                break;
            }
            case Return: {
                break;
            }
        }
        return object;
    }

    private static HashMap<Integer, ItemStack> addItem(Inventory inventory, ItemStack ... itemStackArray) {
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        if (itemStackArray == null) {
            return new HashMap<Integer, ItemStack>();
        }
        ItemStack[] itemStackArray2 = itemStackArray;
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack itemStack = itemStackArray2[n2];
            int n3 = itemStack.getMaxStackSize();
            int n4 = itemStack.getAmount();
            while (n4 > 0) {
                int n5 = n4 < n3 ? n4 : n3;
                ItemStack itemStack2 = itemStack.clone();
                itemStack2.setAmount(n5);
                arrayList.add(itemStack2);
                n4 -= n5;
            }
            ++n2;
        }
        if (!arrayList.isEmpty()) {
            return inventory.addItem(arrayList.toArray(new ItemStack[arrayList.size()]));
        }
        return new HashMap<Integer, ItemStack>();
    }

    public HashMap<Integer, ItemStack> removeItemByCriteria(ItemStack itemStack, itemCheckType ... itemCheckTypeArray) {
        HashMap<Integer, ItemStack> hashMap = new HashMap<Integer, ItemStack>();
        if (itemStack == null) {
            return hashMap;
        }
        int n = itemStack.getAmount();
        do {
            int n2;
            if ((n2 = this.check(itemStack, itemCheckTypeArray)) == -1) {
                itemStack.setAmount(n);
                hashMap.put(0, itemStack);
                break;
            }
            ItemStack itemStack2 = this.getItem(n2);
            if (itemStack2 == null) break;
            int n3 = itemStack2.getAmount();
            if (n3 <= n) {
                n -= n3;
                this.clear(n2);
                continue;
            }
            itemStack2.setAmount(n3 - n);
            this.setItem(n2, itemStack2);
            n = 0;
        } while (n > 0);
        return hashMap;
    }

    public HashMap<Integer, ItemStack> removeItem(ItemStack ... itemStackArray) {
        HashMap<Integer, ItemStack> hashMap = new HashMap<Integer, ItemStack>();
        if (itemStackArray == null) {
            return hashMap;
        }
        int n = 0;
        while (n < itemStackArray.length) {
            ItemStack itemStack = itemStackArray[n];
            int n2 = itemStack.getAmount();
            do {
                int n3;
                if ((n3 = this.first(itemStack, false)) == -1) {
                    itemStack.setAmount(n2);
                    hashMap.put(n, itemStack);
                    break;
                }
                ItemStack itemStack2 = this.getItem(n3);
                int n4 = itemStack2.getAmount();
                if (n4 <= n2) {
                    n2 -= n4;
                    this.clear(n3);
                    continue;
                }
                itemStack2.setAmount(n4 - n2);
                this.setItem(n3, itemStack2);
                n2 = 0;
            } while (n2 > 0);
            ++n;
        }
        return hashMap;
    }

    public ItemStack getItem(int n) {
        return this.user.getPlayer().getInventory().getItem(n);
    }

    public void clear(int n) {
        this.user.getPlayer().getInventory().setItem(n, null);
    }

    public void setItem(int n, ItemStack itemStack) {
        this.user.getPlayer().getInventory().setItem(n, itemStack);
    }

    private ItemStack[] getStorageContents() {
        if (Version.isCurrentEqualOrLower((Version)Version.v1_9_R1)) {
            return this.user.getPlayer().getInventory().getContents();
        }
        return this.user.getPlayer().getInventory().getStorageContents();
    }

    public boolean has(ItemStack itemStack, itemCheckType ... itemCheckTypeArray) {
        if (itemStack == null) {
            return true;
        }
        return this.getTotalAmount(itemStack, itemCheckTypeArray) >= itemStack.getAmount();
    }

    public int getTotalAmount(ItemStack itemStack, itemCheckType ... itemCheckTypeArray) {
        itemCheckType[] itemCheckTypeArray2;
        if (itemStack == null) {
            return 0;
        }
        int n = 0;
        if (itemCheckTypeArray == null || itemCheckTypeArray.length == 0) {
            itemCheckType[] itemCheckTypeArray3 = new itemCheckType[1];
            itemCheckTypeArray2 = itemCheckTypeArray3;
            itemCheckTypeArray3[0] = itemCheckType.material;
        } else {
            itemCheckTypeArray2 = itemCheckTypeArray;
        }
        itemCheckTypeArray = itemCheckTypeArray2;
        ItemStack[] itemStackArray = this.getStorageContents();
        int n2 = 0;
        while (n2 < itemStackArray.length) {
            ItemStack itemStack2 = itemStackArray[n2];
            if (itemStack2 != null && (itemStack == itemStack2 || CMIPlayerInventory.matches(itemStack2, itemStack, itemCheckTypeArray))) {
                n += itemStack2.getAmount();
            }
            ++n2;
        }
        ItemStack itemStack3 = this.user.getItemInOffHand();
        if (itemStack3 != null && CMIPlayerInventory.matches(itemStack3, itemStack, itemCheckTypeArray)) {
            n += itemStack3.getAmount();
        }
        return n;
    }

    private int check(ItemStack itemStack, itemCheckType ... itemCheckTypeArray) {
        itemCheckType[] itemCheckTypeArray2;
        if (itemStack == null) {
            return -1;
        }
        if (itemCheckTypeArray == null || itemCheckTypeArray.length == 0) {
            itemCheckType[] itemCheckTypeArray3 = new itemCheckType[1];
            itemCheckTypeArray2 = itemCheckTypeArray3;
            itemCheckTypeArray3[0] = itemCheckType.material;
        } else {
            itemCheckTypeArray2 = itemCheckTypeArray;
        }
        itemCheckTypeArray = itemCheckTypeArray2;
        ItemStack[] itemStackArray = this.getStorageContents();
        int n = 0;
        while (n < itemStackArray.length) {
            ItemStack itemStack2 = itemStackArray[n];
            if (itemStack2 != null && (itemStack == itemStack2 || CMIPlayerInventory.matches(itemStack2, itemStack, itemCheckTypeArray))) {
                return n;
            }
            ++n;
        }
        ItemStack itemStack3 = this.user.getItemInOffHand();
        if (itemStack3 != null && CMIPlayerInventory.matches(itemStack3, itemStack, itemCheckTypeArray)) {
            return 40;
        }
        return -1;
    }

    public static boolean matches(ItemStack itemStack, ItemStack itemStack2, itemCheckType ... itemCheckTypeArray) {
        if (itemStack == null || itemStack2 == null) {
            return false;
        }
        itemCheckType[] itemCheckTypeArray2 = itemCheckTypeArray;
        int n = itemCheckTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            itemCheckType itemCheckType2 = itemCheckTypeArray2[n2];
            switch (itemCheckType2) {
                case amount: {
                    if (itemStack.getAmount() == itemStack2.getAmount()) break;
                    return false;
                }
                case lore: {
                    ItemMeta itemMeta = itemStack2.getItemMeta();
                    ItemMeta itemMeta2 = itemStack.getItemMeta();
                    if (itemMeta == null && itemMeta2 != null || itemMeta != null && itemMeta2 == null) {
                        return false;
                    }
                    if (itemMeta == null || itemMeta2 == null || itemMeta.getLore().equals(itemMeta2.getLore())) break;
                    return false;
                }
                case material: {
                    if (itemStack.getType() == itemStack2.getType()) break;
                    return false;
                }
                case name: {
                    ItemMeta itemMeta = itemStack2.getItemMeta();
                    ItemMeta itemMeta2 = itemStack.getItemMeta();
                    if (itemMeta == null && itemMeta2 != null || itemMeta != null && itemMeta2 == null) {
                        return false;
                    }
                    if (itemMeta == null || itemMeta2 == null || itemMeta.getDisplayName().equals(itemMeta2.getDisplayName())) break;
                    return false;
                }
                case custommodel: {
                    Integer n3 = null;
                    Integer n4 = null;
                    if (Version.isCurrentEqualOrHigher((Version)Version.v1_20_R4)) {
                        n3 = itemStack2.getItemMeta().getCustomModelData();
                        n4 = itemStack.getItemMeta().getCustomModelData();
                    } else {
                        n3 = new CMINBT(itemStack2).getInt("CustomModelData");
                        n4 = new CMINBT(itemStack).getInt("CustomModelData");
                    }
                    return n3 == null && n4 == null || n3 != null && n4 != null && n3.equals(n4);
                }
                case nbt: {
                    if (Version.isCurrentEqualOrHigher((Version)Version.v1_20_R4)) break;
                    CMINBT cMINBT = new CMINBT(itemStack2);
                    CMINBT cMINBT2 = new CMINBT(itemStack);
                    if (cMINBT.getNbt().equals(cMINBT2.getNbt())) break;
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    private int first(ItemStack itemStack, boolean bl) {
        if (itemStack == null) {
            return -1;
        }
        ItemStack[] itemStackArray = this.getStorageContents();
        int n = 0;
        while (n < itemStackArray.length) {
            if (itemStackArray[n] != null && (bl ? itemStack.equals((Object)itemStackArray[n]) : CMIPlayerInventory.isSimilar(itemStack, itemStackArray[n]))) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private static boolean isSimilar(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null) {
            return false;
        }
        if (itemStack == itemStack2) {
            return true;
        }
        CMIMaterial cMIMaterial = CMIMaterial.get((ItemStack)itemStack);
        CMIMaterial cMIMaterial2 = CMIMaterial.get((ItemStack)itemStack2);
        if (cMIMaterial.isShulkerBox() && cMIMaterial2.isShulkerBox()) {
            ItemStack itemStack3;
            int n;
            int n2;
            ItemStack[] itemStackArray;
            Inventory inventory = CMI.getInstance().getNMS().getShulkerInv(itemStack);
            if (inventory != null) {
                itemStackArray = inventory.getContents();
                n2 = itemStackArray.length;
                n = 0;
                while (n < n2) {
                    itemStack3 = itemStackArray[n];
                    if (itemStack3 != null) {
                        return false;
                    }
                    ++n;
                }
            }
            if ((inventory = CMI.getInstance().getNMS().getShulkerInv(itemStack2)) != null) {
                itemStackArray = inventory.getContents();
                n2 = itemStackArray.length;
                n = 0;
                while (n < n2) {
                    itemStack3 = itemStackArray[n];
                    if (itemStack3 != null) {
                        return false;
                    }
                    ++n;
                }
            }
            return itemStack2.getType().equals((Object)itemStack.getType()) && itemStack2.getDurability() == itemStack.getDurability();
        }
        if (cMIMaterial == CMIMaterial.WRITTEN_BOOK && cMIMaterial2 == CMIMaterial.WRITTEN_BOOK) {
            boolean bl;
            BookMeta bookMeta = (BookMeta)itemStack.getItemMeta();
            BookMeta bookMeta2 = (BookMeta)itemStack2.getItemMeta();
            boolean bl2 = bl = bookMeta.getPages().isEmpty() || bookMeta.getPages().size() == bookMeta2.getPages().size();
            if (bookMeta.getPages().size() == bookMeta2.getPages().size()) {
                int n = 1;
                while (n <= bookMeta.getPages().size()) {
                    String string = bookMeta.getPage(n);
                    if (!string.equalsIgnoreCase(bookMeta2.getPage(n))) {
                        bl = false;
                        break;
                    }
                    ++n;
                }
            }
            if (bookMeta.getAuthor() != null && bookMeta2.getAuthor() == null || bookMeta.getAuthor() != null && bookMeta2.getAuthor() != null && !bookMeta.getAuthor().equalsIgnoreCase(bookMeta2.getAuthor())) {
                bl = false;
            }
            if (bookMeta.getTitle() != null && bookMeta2.getTitle() == null || bookMeta.getTitle() != null && bookMeta2.getTitle() != null && !bookMeta.getTitle().equalsIgnoreCase(bookMeta2.getTitle())) {
                bl = false;
            }
            return bl;
        }
        return itemStack2.getType().equals((Object)itemStack.getType()) && itemStack2.getDurability() == itemStack.getDurability() && itemStack2.hasItemMeta() == itemStack.hasItemMeta() && (!itemStack2.hasItemMeta() || Bukkit.getItemFactory().equals(itemStack2.getItemMeta(), itemStack.getItemMeta()));
    }

    public boolean canFit(List<ItemStack> list2) {
        ItemStack itemStack2;
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        for (ItemStack itemStack2 : list2) {
            if (itemStack2 == null) continue;
            arrayList.add(itemStack2);
        }
        itemStack2 = new ItemStack[arrayList.size()];
        arrayList.toArray((T[])itemStack2);
        return this.canFit((ItemStack[])itemStack2);
    }

    public boolean canFit(ItemStack ... itemStackArray) {
        Player player = this.user.getPlayer();
        if (player == null) {
            return false;
        }
        Inventory inventory = Bukkit.createInventory(null, (int)36);
        int n = 0;
        while (n < 36) {
            ItemStack itemStack = player.getInventory().getItem(n);
            if (itemStack != null) {
                inventory.setItem(n, itemStack.clone());
            }
            ++n;
        }
        return inventory.addItem(itemStackArray).isEmpty();
    }

    public void removeItemFromMainHand(ItemStack itemStack) {
        Player player = this.user.getPlayer();
        ItemStack itemStack2 = this.user.getItemInHand();
        if (itemStack2 == null || itemStack2.getType().equals((Object)Material.AIR)) {
            return;
        }
        if (!itemStack2.getType().equals((Object)itemStack.getType())) {
            return;
        }
        if (itemStack2.getAmount() > itemStack.getAmount()) {
            itemStack2.setAmount(itemStack2.getAmount() - itemStack.getAmount());
        } else if (!this.user.isOnline()) {
            CMILib.getInstance().getReflectionManager().setItemInMainHand(player, null);
        } else {
            this.user.getPlayer().getInventory().setItemInHand(null);
        }
        if (this.user.isOnline()) {
            this.user.updateInventory();
        }
        CMI.getInstance().save(player);
    }

    public ItemStack getItem(CMIInventorySlot cMIInventorySlot) {
        if (cMIInventorySlot.equals((Object)CMIInventorySlot.MainHand)) {
            return CMILib.getInstance().getReflectionManager().getItemInMainHand(this.user.getPlayer());
        }
        if (cMIInventorySlot.equals((Object)CMIInventorySlot.OffHand) && Version.isCurrentHigher((Version)Version.v1_8_R3)) {
            return this.user.getPlayer().getInventory().getItemInOffHand();
        }
        List<ItemStack> list2 = this.getItems(cMIInventorySlot);
        if (list2.isEmpty()) {
            return null;
        }
        return list2.get(0);
    }

    public List<ItemStack> getItems(CMIInventorySlot cMIInventorySlot) {
        Player player = this.user.getPlayer();
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        if (cMIInventorySlot.equals((Object)CMIInventorySlot.MainHand)) {
            arrayList.add(CMILib.getInstance().getReflectionManager().getItemInMainHand(player));
            return arrayList;
        }
        if (cMIInventorySlot.equals((Object)CMIInventorySlot.OffHand)) {
            if (Version.isCurrentHigher((Version)Version.v1_8_R3)) {
                arrayList.add(this.user.getPlayer().getInventory().getItemInOffHand());
            }
            return arrayList;
        }
        if (player == null) {
            return arrayList;
        }
        PlayerInventory playerInventory = player.getInventory();
        for (Integer n : cMIInventorySlot.getSlots()) {
            ItemStack itemStack = null;
            try {
                itemStack = playerInventory.getItem(n.intValue());
            }
            catch (Exception exception) {
                continue;
            }
            if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) continue;
            arrayList.add(itemStack);
        }
        return arrayList;
    }

    public int getFreeSlots() {
        return this.getFreeSlots(CMIInventorySlot.MainInventory);
    }

    public int getFreeSlots(CMIInventorySlot cMIInventorySlot) {
        return cMIInventorySlot.getSlots().size() - this.getItems(cMIInventorySlot).size();
    }

    public boolean contains(ItemStack itemStack) {
        CMIItemStack cMIItemStack = CMILib.getInstance().getItemManager().getItem(itemStack);
        Integer n = new CMINBT(itemStack).getInt("CustomModelData");
        List<ItemStack> list2 = this.getItems(CMIInventorySlot.MainInventory);
        list2.addAll(this.getItems(CMIInventorySlot.OffHand));
        list2.addAll(this.getItems(CMIInventorySlot.Armor));
        int n2 = 0;
        for (ItemStack itemStack2 : list2) {
            Integer n3;
            CMIItemStack cMIItemStack2;
            if (itemStack2 == null || (cMIItemStack2 = CMILib.getInstance().getItemManager().getItem(itemStack2)) == null || !cMIItemStack2.getType().equals((Object)cMIItemStack.getType()) || Version.isCurrentEqualOrLower((Version)Version.v1_12_R1) && cMIItemStack2.getData() != cMIItemStack.getData()) continue;
            try {
                if (itemStack2.getItemMeta() instanceof SkullMeta && itemStack.getItemMeta() instanceof SkullMeta) {
                    n3 = (SkullMeta)itemStack2.getItemMeta();
                    SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
                    if (n3.getOwner() != null && skullMeta.getOwner() == null || n3.getOwner() == null && skullMeta.getOwner() != null || n3.getOwner() != null && skullMeta.getOwner() != null && !n3.getOwner().equals(skullMeta.getOwner())) {
                        continue;
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            n3 = new CMINBT(itemStack2).getInt("CustomModelData");
            if (n == null && n3 != null || n != null && n3 == null || n != null && n3 != null && !n.equals(n3)) continue;
            n2 += cMIItemStack2.getAmount();
        }
        return n2 >= cMIItemStack.getAmount();
    }

    public static enum CMIFullInventoryAction {
        Abort,
        Drop,
        Return;

    }

    public static enum CMIInventorySlot {
        Armor(36, 39),
        Helmet(39),
        ChestPlate(38),
        Pants(37),
        Boots(36),
        OffHand(40),
        MainHand(-1),
        QuickBar(0, 8),
        PartInventory(9, 35),
        MainInventory(0, 35),
        CraftingIngredients(1, 4),
        CraftingResult(0);

        private List<Integer> slot = new ArrayList<Integer>();

        private CMIInventorySlot(Integer n2, Integer n3) {
            int n4 = n2;
            while (n4 <= n3) {
                this.slot.add(n4);
                ++n4;
            }
        }

        private CMIInventorySlot(Integer n2) {
            this.slot.add(n2);
        }

        private CMIInventorySlot(List<Integer> list2) {
            this.slot.addAll(list2);
        }

        public List<Integer> getSlots() {
            return this.slot;
        }

        public Integer getSlot() {
            return this.slot.get(0);
        }
    }

    public static enum itemCheckType {
        name,
        lore,
        amount,
        nbt,
        material,
        custommodel;

    }
}

