/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.utils;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.Zrips.CMILib.Container.CMIList;
import net.Zrips.CMILib.Container.CMILocation;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class SpawnUtil {
    public static final String defaultG = "CMISpawnGroup";
    public static final String defaultGW = "CMISWG";
    static HashMap<String, SpawnPoint> map = new HashMap();
    private static Set<String> ignoredSpawnWorlds = new HashSet<String>();
    private static boolean SpawnSpawnOnJoin = false;

    public static void addNew(String string, CMILocation cMILocation, boolean bl) {
        SpawnUtil.addNew(string, cMILocation, bl, null);
    }

    public static void addNew(String string, CMILocation cMILocation, boolean bl, Integer n) {
        SpawnUtil.addNew(string, cMILocation, bl, n, new ArrayList<World>());
    }

    public static void addNew(String string, CMILocation cMILocation, boolean bl, Integer n, List<World> list2) {
        if (string == null && !list2.isEmpty()) {
            string = defaultGW + new Random(Integer.MAX_VALUE).nextInt(100000);
        }
        if (string == null) {
            string = defaultG;
        }
        if (cMILocation == null) {
            return;
        }
        map.put(string, new SpawnPoint(string, cMILocation, bl, n, list2));
    }

    public static CMILocation getSpawnPoint(Player player) {
        SpawnPoint spawnPoint;
        if (player != null) {
            spawnPoint = null;
            for (Map.Entry<String, SpawnPoint> entry : map.entrySet()) {
                if (entry.getKey().equals(defaultG) || entry.getKey().startsWith(defaultGW) || !PermissionsManager.CMIPerm.spawngroup_$1.hasPermission((CommandSender)player, entry.getKey())) continue;
                if (!entry.getValue().getWorlds().isEmpty()) {
                    if (!entry.getValue().getWorlds().contains(player.getWorld())) continue;
                    spawnPoint = entry.getValue().getLocation();
                    break;
                }
                spawnPoint = entry.getValue().getLocation();
                break;
            }
            if (spawnPoint == null) {
                for (Map.Entry<String, SpawnPoint> entry : map.entrySet()) {
                    if (entry.getValue().getWorlds().isEmpty() || !entry.getValue().getWorlds().contains(player.getWorld())) continue;
                    spawnPoint = entry.getValue().getLocation();
                    break;
                }
            }
            if (spawnPoint != null) {
                return spawnPoint.clone();
            }
        }
        if ((spawnPoint = map.get(defaultG)) != null) {
            return spawnPoint.getLocation().clone();
        }
        return null;
    }

    public static CMILocation getGroupReSpawnPoint(Player player) {
        SpawnPoint spawnPoint;
        if (player != null) {
            spawnPoint = null;
            for (Map.Entry<String, SpawnPoint> entry : map.entrySet()) {
                if (entry.getKey().equals(defaultG) || entry.getKey().startsWith(defaultGW) || !entry.getValue().isRespawn() || !PermissionsManager.CMIPerm.respawngroup_$1.hasPermission((CommandSender)player, entry.getKey())) continue;
                if (!entry.getValue().getWorlds().isEmpty()) {
                    if (!entry.getValue().getWorlds().contains(player.getWorld())) continue;
                    spawnPoint = entry.getValue().getLocation();
                    break;
                }
                spawnPoint = entry.getValue().getLocation();
                break;
            }
            if (spawnPoint == null) {
                for (Map.Entry<String, SpawnPoint> entry : map.entrySet()) {
                    if (entry.getValue().getWorlds().isEmpty() || !entry.getValue().isRespawn() || !entry.getValue().getWorlds().contains(player.getWorld())) continue;
                    spawnPoint = entry.getValue().getLocation();
                    break;
                }
            }
            if (spawnPoint != null) {
                return spawnPoint;
            }
        }
        if ((spawnPoint = map.get(defaultG)) != null && spawnPoint.isRespawn()) {
            return spawnPoint.getLocation();
        }
        return null;
    }

    public static void save() {
        File file = new File(CMI.getInstance().getDataFolder(), "config.yml");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        yamlConfiguration.options().copyDefaults(true);
        for (Map.Entry<String, SpawnPoint> entry : map.entrySet()) {
            String string = entry.getKey();
            CMILocation cMILocation = entry.getValue().getLocation();
            if (string.equals(defaultG)) {
                yamlConfiguration.set("Spawn.Main.World", (Object)cMILocation.getWorldName());
                yamlConfiguration.set("Spawn.Main.X", (Object)cMILocation.getX());
                yamlConfiguration.set("Spawn.Main.Y", (Object)cMILocation.getY());
                yamlConfiguration.set("Spawn.Main.Z", (Object)cMILocation.getZ());
                yamlConfiguration.set("Spawn.Main.Yaw", (Object)Float.valueOf(cMILocation.getYaw()));
                yamlConfiguration.set("Spawn.Main.Pitch", (Object)Float.valueOf(cMILocation.getPitch()));
                yamlConfiguration.set("Spawn.Main.RespawnLocation", (Object)entry.getValue().isRespawn());
                yamlConfiguration.set("Spawn.Main.Rng", (Object)entry.getValue().getRng());
                if (entry.getValue().getWorlds().isEmpty()) continue;
                yamlConfiguration.set("Spawn.Main.TeleportFrom", entry.getValue().getWorldsAsStringList());
                continue;
            }
            String string2 = "Spawn.Groups." + string + ".";
            yamlConfiguration.set(String.valueOf(string2) + "World", (Object)cMILocation.getWorldName());
            yamlConfiguration.set(String.valueOf(string2) + "X", (Object)cMILocation.getX());
            yamlConfiguration.set(String.valueOf(string2) + "Y", (Object)cMILocation.getY());
            yamlConfiguration.set(String.valueOf(string2) + "Z", (Object)cMILocation.getZ());
            yamlConfiguration.set(String.valueOf(string2) + "Yaw", (Object)Float.valueOf(cMILocation.getYaw()));
            yamlConfiguration.set(String.valueOf(string2) + "Pitch", (Object)Float.valueOf(cMILocation.getPitch()));
            yamlConfiguration.set(String.valueOf(string2) + "RespawnLocation", (Object)entry.getValue().isRespawn());
            yamlConfiguration.set(String.valueOf(string2) + "Rng", (Object)entry.getValue().getRng());
            if (entry.getValue().getWorlds().isEmpty()) continue;
            yamlConfiguration.set(String.valueOf(string2) + "TeleportFrom", entry.getValue().getWorldsAsStringList());
        }
        try {
            yamlConfiguration.save(file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        CMI.getInstance().getConfigManager().load();
    }

    public static void loadConfig() {
        Object object;
        Object object2;
        Object object32;
        ConfigReader configReader = CMI.getInstance().getConfigManager().getConfig();
        configReader.addComment("Spawn.SpawnOnJoin", new String[]{"Forces players to login in defined spawn point when logging into server", "Can be bypasses with " + PermissionsManager.CMIPerm.spawnonjoin_bypass.getPermission() + " permission node"});
        SpawnSpawnOnJoin = configReader.get("Spawn.SpawnOnJoin", Boolean.valueOf(false));
        configReader.addComment("Spawn.IgnoredWorlds", new String[]{"List of worlds which should be ignored and players joining in those servers will not be teleported to appropriate spawn point but will login at their log out location"});
        List list2 = configReader.get("Spawn.IgnoredWorlds", new ArrayList());
        CMIList.toLowerCase((List)list2);
        ignoredSpawnWorlds.clear();
        ignoredSpawnWorlds.addAll(list2);
        configReader.addComment("Spawn.Main", new String[]{"Defines players spawn point after death if set to true, if not, then it will be used only for /cmi spawn command", "RespawnLocation will indicate if you want to use this location as possible respawn point for player after death"});
        String string = configReader.get("Spawn.Main.World", "None");
        double d = configReader.get("Spawn.Main.X", Double.valueOf(0.0));
        double d2 = configReader.get("Spawn.Main.Y", Double.valueOf(0.0));
        double d3 = configReader.get("Spawn.Main.Z", Double.valueOf(0.0));
        double d4 = configReader.get("Spawn.Main.Pitch", Double.valueOf(0.0));
        double d5 = configReader.get("Spawn.Main.Yaw", Double.valueOf(0.0));
        Boolean bl = configReader.get("Spawn.Main.RespawnLocation", Boolean.valueOf(false));
        Integer n = configReader.get("Spawn.Main.Rng", 0);
        ArrayList<Object> arrayList = new ArrayList<World>();
        if (configReader.getC().isList("Spawn.Main.TeleportFrom")) {
            object32 = configReader.get("Spawn.Main.TeleportFrom", Arrays.asList(""));
            object2 = object32.iterator();
            while (object2.hasNext()) {
                String string2 = (String)object2.next();
                object = CMI.getInstance().getUtilManager().getWorld(string2);
                if (object == null) continue;
                arrayList.add((World)object);
            }
        }
        if (!string.equalsIgnoreCase("none")) {
            object32 = new CMILocation(string, d, d2, d3);
            object32.setPitch((float)d4);
            object32.setYaw((float)d5);
            SpawnUtil.addNew(null, (CMILocation)object32, bl, n, arrayList);
        }
        try {
            if (configReader.getC().isConfigurationSection("Spawn.Groups")) {
                for (Object object32 : configReader.getC().getConfigurationSection("Spawn.Groups").getKeys(false)) {
                    arrayList = new ArrayList();
                    object2 = "Spawn.Groups." + (String)object32 + ".";
                    string = configReader.get(String.valueOf(object2) + "World", "None");
                    d = configReader.get(String.valueOf(object2) + "X", Double.valueOf(0.0));
                    d2 = configReader.get(String.valueOf(object2) + "Y", Double.valueOf(0.0));
                    d3 = configReader.get(String.valueOf(object2) + "Z", Double.valueOf(0.0));
                    d4 = configReader.get(String.valueOf(object2) + "Pitch", Double.valueOf(0.0));
                    d5 = configReader.get(String.valueOf(object2) + "Yaw", Double.valueOf(0.0));
                    bl = configReader.get(String.valueOf(object2) + "RespawnLocation", Boolean.valueOf(false));
                    if (configReader.getC().isInt(String.valueOf(object2) + "Rng")) {
                        n = configReader.get(String.valueOf(object2) + "Rng", 0);
                    }
                    if (configReader.getC().isList(String.valueOf(object2) + "TeleportFrom")) {
                        object = configReader.get(String.valueOf(object2) + "TeleportFrom", Arrays.asList(""));
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            String string3 = (String)iterator.next();
                            World world2 = CMI.getInstance().getUtilManager().getWorld(string3);
                            if (world2 == null) continue;
                            arrayList.add(world2);
                        }
                    }
                    if (string.equalsIgnoreCase("none")) continue;
                    object = new CMILocation(string, d, d2, d3);
                    object.setPitch((float)d4);
                    object.setYaw((float)d5);
                    SpawnUtil.addNew((String)object32, (CMILocation)object, bl, n, arrayList);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isSpawnSpawnOnJoin() {
        return SpawnSpawnOnJoin;
    }

    public static Set<String> getIgnoredSpawnWorlds() {
        return ignoredSpawnWorlds;
    }

    public static boolean isIgnoresSpawnWorld(String string) {
        if (ignoredSpawnWorlds.isEmpty()) {
            return false;
        }
        return ignoredSpawnWorlds.contains(string.toLowerCase());
    }

    public static class SpawnPoint {
        private String group;
        private CMILocation location;
        private boolean respawn = false;
        private Integer rng = null;
        private List<World> worlds;

        public SpawnPoint(String string, CMILocation cMILocation, boolean bl) {
            this(string, cMILocation, bl, null, null);
        }

        public SpawnPoint(String string, CMILocation cMILocation, boolean bl, Integer n) {
            this(string, cMILocation, bl, n, null);
        }

        public SpawnPoint(String string, CMILocation cMILocation, boolean bl, Integer n, List<World> list2) {
            this.group = string;
            this.location = cMILocation;
            this.respawn = bl;
            this.rng = n;
            this.worlds = list2;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String string) {
            this.group = string;
        }

        public CMILocation getLocation() {
            if (this.rng != null && this.rng > 0) {
                Random random = new Random(System.currentTimeMillis());
                double d = (double)(random.nextInt(this.rng * 10 * 2) - this.rng * 10) / 10.0;
                double d2 = (double)(random.nextInt(this.rng * 10 * 2) - this.rng * 10) / 10.0;
                return new CMILocation(this.location.clone().add(d, 0.0, d2));
            }
            return this.location;
        }

        public void setLocation(CMILocation cMILocation) {
            this.location = cMILocation;
        }

        public boolean isRespawn() {
            return this.respawn;
        }

        public void setRespawn(boolean bl) {
            this.respawn = bl;
        }

        public Integer getRng() {
            return this.rng;
        }

        public void setRng(Integer n) {
            this.rng = n;
        }

        public List<World> getWorlds() {
            if (this.worlds == null) {
                this.worlds = new ArrayList<World>();
            }
            return this.worlds;
        }

        public List<String> getWorldsAsStringList() {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.worlds != null) {
                for (World world2 : this.worlds) {
                    if (world2 == null) continue;
                    arrayList.add(world2.getName());
                }
            }
            return arrayList;
        }

        public void setWorlds(List<World> list2) {
            this.worlds = list2;
        }
    }
}

