/*
 * Decompiled with CFR 0.152.
 */
package net.Zrips.CMILib.Container;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.Zrips.CMILib.Colors.CMIChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class CMIBook {
    ItemStack item;
    HashMap<Integer, List<String>> content = new HashMap();

    public CMIBook() {
        this.item = new ItemStack(Material.WRITTEN_BOOK);
    }

    public ItemStack getItemStack() {
        if (!this.hasAuthor()) {
            this.setAuthor("None");
        }
        if (!this.hasTitle()) {
            this.setTitle("None");
        }
        BookMeta bm = (BookMeta)this.item.getItemMeta();
        ArrayList pages = new ArrayList();
        for (Map.Entry<Integer, List<String>> oneP : this.content.entrySet()) {
            String page = "";
            for (String one : oneP.getValue()) {
                page = page + CMIChatColor.translate(one) + " \n";
            }
            bm.addPage(new String[]{page});
        }
        this.item.setItemMeta((ItemMeta)bm);
        return this.item;
    }

    public boolean hasAuthor() {
        BookMeta bm = (BookMeta)this.item.getItemMeta();
        return bm.hasAuthor();
    }

    public boolean hasTitle() {
        BookMeta bm = (BookMeta)this.item.getItemMeta();
        return bm.hasTitle();
    }

    public CMIBook setTitle(String text) {
        BookMeta bm = (BookMeta)this.item.getItemMeta();
        bm.setTitle(text);
        this.item.setItemMeta((ItemMeta)bm);
        return this;
    }

    public CMIBook setAuthor(String text) {
        BookMeta bm = (BookMeta)this.item.getItemMeta();
        bm.setAuthor(text);
        this.item.setItemMeta((ItemMeta)bm);
        return this;
    }

    public CMIBook addNewPage() {
        int page = this.content.size() + 1;
        ArrayList lines = new ArrayList();
        this.content.put(page, lines);
        return this;
    }

    public CMIBook addLine(String text) {
        int page = 1;
        List<Object> lines = new ArrayList();
        if (!this.content.isEmpty()) {
            page = this.content.size();
            lines = this.content.get(this.content.size());
        }
        if (lines.size() >= 14) {
            this.addNewPage();
            this.addLine(text);
            return this;
        }
        ArrayList<String> t = new ArrayList<String>(lines);
        t.add(text);
        if (CMIBook.linesToString(t, true).length() > 300) {
            this.addNewPage();
            this.addLine(text);
            return this;
        }
        lines.add(text);
        this.content.put(page, lines);
        return this;
    }

    private static String linesToString(List<String> lines, boolean clean) {
        String page = "";
        for (String one : lines) {
            if (clean) {
                page = page + one;
                continue;
            }
            page = page + one + " \n";
        }
        return page;
    }
}

