/*
 * Decompiled with CFR 0.152.
 */
package me.mylogo.chestlock;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public class JsonSerialization<T> {
    private Function<T, JsonObject> serialize;
    private Function<JsonObject, T> deserialize;
    private Function<Boolean, File> fileFunction;
    private Consumer<JsonObject> additionalSerialization;
    private Consumer<JsonObject> additionalDeserialization;
    private boolean saving = false;

    public JsonSerialization(Function<T, JsonObject> function, Function<JsonObject, T> function2, Function<Boolean, File> function3) {
        this.serialize = function;
        this.deserialize = function2;
        this.fileFunction = function3;
    }

    public JsonSerialization(Function<T, JsonObject> function, Function<JsonObject, T> function2, Function<Boolean, File> function3, Consumer<JsonObject> consumer, Consumer<JsonObject> consumer2) {
        this.serialize = function;
        this.deserialize = function2;
        this.fileFunction = function3;
        this.additionalSerialization = consumer;
        this.additionalDeserialization = consumer2;
    }

    public void save(List<T> list) {
        if (list != null && !this.saving) {
            this.saving = true;
            try {
                Object object2;
                File file = this.fileFunction.apply(true);
                FileWriter fileWriter = new FileWriter(file);
                JsonArray jsonArray = new JsonArray();
                for (Object object2 : list) {
                    try {
                        JsonObject jsonObject = this.serialize.apply(object2);
                        if (jsonObject == null) continue;
                        jsonArray.add((JsonElement)jsonObject);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                JsonObject jsonObject = new JsonObject();
                if (this.additionalSerialization != null) {
                    try {
                        this.additionalSerialization.accept(jsonObject);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                jsonObject.add("arr", (JsonElement)jsonArray);
                new Gson().toJson((JsonElement)jsonObject, (Appendable)fileWriter);
                fileWriter.flush();
                fileWriter.close();
                object2 = this.fileFunction.apply(false);
                if (((File)object2).exists()) {
                    ((File)object2).delete();
                }
                file.renameTo((File)object2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.saving = false;
        }
    }

    public List<T> read() {
        File file = this.fileFunction.apply(false);
        if (file.exists()) {
            try {
                JsonParser jsonParser = new JsonParser();
                JsonObject jsonObject = jsonParser.parse((Reader)new FileReader(file)).getAsJsonObject();
                JsonArray jsonArray = jsonObject.get("arr").getAsJsonArray();
                int n = jsonArray.size();
                ArrayList<T> arrayList = new ArrayList<T>(n);
                for (int i = 0; i < n; ++i) {
                    try {
                        arrayList.add(this.deserialize.apply(jsonArray.get(i).getAsJsonObject()));
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        System.err.println("Could not deserialize element at index " + i + " which was:" + jsonArray.get(i).getAsJsonObject().toString());
                    }
                }
                if (this.additionalDeserialization != null) {
                    try {
                        this.additionalDeserialization.accept(jsonObject);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                return arrayList;
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
        return new ArrayList();
    }
}

