/*
 * Decompiled with CFR 0.152.
 */
package me.mylogo.chestlock.gui;

import java.util.Objects;
import me.mylogo.chestlock.Lock;
import me.mylogo.chestlock.gui.Gui;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.server.PluginDisableEvent;

public class GuiListener
implements Listener {
    private Lock plugin;

    public GuiListener(Lock lock) {
        this.plugin = lock;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent inventoryClickEvent) {
        Gui gui = this.plugin.getGuiManager().getGui(inventoryClickEvent.getWhoClicked().getUniqueId());
        if (gui != null) {
            inventoryClickEvent.setCancelled(true);
            gui.onClick(inventoryClickEvent);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent inventoryCloseEvent) {
        Gui gui = this.plugin.getGuiManager().getGui(inventoryCloseEvent.getPlayer());
        if (gui != null && gui.inv.equals(inventoryCloseEvent.getInventory())) {
            gui.onClose(inventoryCloseEvent);
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent inventoryDragEvent) {
        Gui gui = this.plugin.getGuiManager().getGui(inventoryDragEvent.getWhoClicked().getUniqueId());
        if (gui != null) {
            gui.onDrag(inventoryDragEvent);
        }
    }

    @EventHandler
    public void onPluginDisable(PluginDisableEvent pluginDisableEvent) {
        if (pluginDisableEvent.getPlugin() == this.plugin) {
            this.plugin.getGuiManager().getGuis().keySet().stream().map(Bukkit::getPlayer).filter(Objects::nonNull).forEach(HumanEntity::closeInventory);
        }
    }
}

