/*
 * Decompiled with CFR 0.152.
 */
package me.mylogo.chestlock.items;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemBuilder {
    private List<String> lore;
    private ItemMeta meta;
    private ItemStack item;

    public ItemBuilder(ItemStack itemStack) {
        this.item = itemStack;
        this.meta = itemStack.getItemMeta();
    }

    public ItemBuilder(Material material, int n, short s) {
        this(new ItemStack(material, n, s));
    }

    public ItemBuilder(Material material, int n) {
        this(material, n, 0);
    }

    public ItemBuilder(Material material) {
        this(material, 1);
    }

    public ItemBuilder setName(String string) {
        if (this.meta != null) {
            this.meta.setDisplayName(string);
        }
        return this;
    }

    public String getName() {
        return this.meta != null ? this.meta.getDisplayName() : null;
    }

    public ItemBuilder setAmount(int n) {
        this.item.setAmount(n);
        return this;
    }

    public int getAmount() {
        return this.item.getAmount();
    }

    public ItemStack build() {
        if (this.meta != null) {
            if (this.lore != null) {
                this.meta.setLore(this.lore);
            }
            this.item.setItemMeta(this.meta);
        }
        return this.item;
    }

    public ItemStack buildCloned() {
        return this.build().clone();
    }

    public ItemBuilder setLore(String ... stringArray) {
        return this.setLore(new ArrayList<String>(Arrays.asList(stringArray)));
    }

    public ItemBuilder setLore(List<String> list) {
        this.lore = new ArrayList<String>(list);
        return this;
    }

    public ItemBuilder addLore(String ... stringArray) {
        return this.addLore(Arrays.asList(stringArray));
    }

    public ItemBuilder addLore(List<String> list) {
        if (this.lore == null) {
            this.lore = !this.meta.hasLore() ? new ArrayList<String>() : new ArrayList<String>(this.meta.getLore());
        }
        this.lore.addAll(list);
        return this;
    }

    public ItemBuilder setData(short s) {
        this.item.setDurability(s);
        return this;
    }

    public ItemBuilder addEnchantment(Enchantment enchantment, int n) {
        this.meta.addEnchant(enchantment, n, false);
        return this;
    }
}

