/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.chestprotect.hikari.metrics.dropwizard;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import java.util.Properties;
import java.util.SortedMap;
import me.angeschossen.chestprotect.hikari.HikariConfig;
import me.angeschossen.chestprotect.hikari.metrics.dropwizard.CodahaleHealthChecker$Connection99Percent;
import me.angeschossen.chestprotect.hikari.metrics.dropwizard.CodahaleHealthChecker$ConnectivityHealthCheck;
import me.angeschossen.chestprotect.hikari.pool.HikariPool;

public final class CodahaleHealthChecker {
    public static void registerHealthChecks(HikariPool hikariPool, HikariConfig hikariConfig, HealthCheckRegistry healthCheckRegistry) {
        SortedMap sortedMap;
        Properties properties = hikariConfig.getHealthCheckProperties();
        MetricRegistry metricRegistry = (MetricRegistry)hikariConfig.getMetricRegistry();
        long l = Long.parseLong(properties.getProperty("connectivityCheckTimeoutMs", String.valueOf(hikariConfig.getConnectionTimeout())));
        healthCheckRegistry.register(MetricRegistry.name((String)hikariConfig.getPoolName(), (String[])new String[]{"pool", "ConnectivityCheck"}), (HealthCheck)new CodahaleHealthChecker$ConnectivityHealthCheck(hikariPool, l));
        long l2 = Long.parseLong(properties.getProperty("expected99thPercentileMs", "0"));
        if (metricRegistry != null && l2 > 0L && !(sortedMap = metricRegistry.getTimers((string, metric) -> string.equals(MetricRegistry.name((String)hikariConfig.getPoolName(), (String[])new String[]{"pool", "Wait"})))).isEmpty()) {
            Timer timer = (Timer)sortedMap.entrySet().iterator().next().getValue();
            healthCheckRegistry.register(MetricRegistry.name((String)hikariConfig.getPoolName(), (String[])new String[]{"pool", "Connection99Percent"}), (HealthCheck)new CodahaleHealthChecker$Connection99Percent(timer, l2));
        }
    }

    private CodahaleHealthChecker() {
    }
}

