/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence;

import NL.martijnpu.ChunkDefence.Main;
import NL.martijnpu.ChunkDefence.Messages;
import NL.martijnpu.ChunkDefence.arenas.ArenaManager;
import NL.martijnpu.ChunkDefence.data.ConfigData;
import NL.martijnpu.ChunkDefence.events.CapturePackages;
import NL.martijnpu.ChunkDefence.gui.GuiManager;
import NL.martijnpu.ChunkDefence.statistics.ScoreManager;
import NL.martijnpu.ChunkDefence.traps.TrapManager;
import NL.martijnpu.ChunkDefence.waves.FireWorks;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.plugin.Plugin;

public class TimeHandler {
    private static TimeHandler instance;
    private static long time;
    private int particleTask = 0;
    private int secondTask = 0;
    private int engineTask = 0;
    private int scoreboardTask = 0;

    private TimeHandler() {
    }

    static TimeHandler getInstance() {
        if (instance == null) {
            instance = new TimeHandler();
        }
        return instance;
    }

    public static long getTime() {
        return time;
    }

    void start() {
        int n = ConfigData.getInstance().getParticleFrequency();
        this.particleTask = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Main.getInstance(), () -> {
            TrapManager.getInstance().handleEngineTick();
            GuiManager.getInstance().inventoryTick();
        }, 60L, (long)n);
        Messages.sendConsole("Started particle updates at every " + n + " ticks. Lower can cause more lag");
        this.secondTask = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Main.getInstance(), () -> {
            ArenaManager.getInstance().updateSec();
            ++time;
        }, 60L, 20L);
        this.engineTask = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Main.getInstance(), () -> {
            this.removeDrops();
            FireWorks.updateTick();
            CapturePackages.checkQue();
        }, 60L, 3L);
        if (Main.isPlaceholderApiAvailable()) {
            this.scoreboardTask = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Main.getInstance(), () -> ScoreManager.getInstance().updateHighScores(), 20L * (long)ConfigData.getInstance().getScoreboardUpdate(), 20L * (long)ConfigData.getInstance().getScoreboardUpdate());
            Messages.sendConsole("Started placeholder reloading at every " + ConfigData.getInstance().getScoreboardUpdate() + " second(s). Faster can cause more lag");
        }
    }

    void stop() {
        if (this.particleTask != 0) {
            Bukkit.getScheduler().cancelTask(this.particleTask);
        }
        if (this.secondTask != 0) {
            Bukkit.getScheduler().cancelTask(this.secondTask);
        }
        if (this.engineTask != 0) {
            Bukkit.getScheduler().cancelTask(this.engineTask);
        }
        if (this.scoreboardTask != 0) {
            Bukkit.getScheduler().cancelTask(this.scoreboardTask);
        }
        this.particleTask = 0;
        this.secondTask = 0;
        this.engineTask = 0;
        this.scoreboardTask = 0;
    }

    private void removeDrops() {
        for (World world : Main.getInstance().getServer().getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (entity.getType() != EntityType.DROPPED_ITEM) continue;
                entity.remove();
            }
        }
    }

    static {
        time = 0L;
    }
}

