/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.arenas;

import NL.martijnpu.ChunkDefence.Messages;
import NL.martijnpu.ChunkDefence.TimeHandler;
import NL.martijnpu.ChunkDefence.arenas.ArenaData;
import NL.martijnpu.ChunkDefence.arenas.ArenaManager;
import NL.martijnpu.ChunkDefence.data.ConfigData;
import NL.martijnpu.ChunkDefence.data.MessageData;
import NL.martijnpu.ChunkDefence.players.Economy;
import NL.martijnpu.ChunkDefence.statistics.ScoreManager;
import NL.martijnpu.ChunkDefence.waves.WaveController;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class Arena {
    private final ArenaData arenaData;
    private final List<Player> onlinePlayers;
    private final List<Player> playerQueue;
    private WaveController waveController;
    private long arenaTime;
    private long lastChangeTime = 0L;

    Arena(Vector vector) {
        this.arenaData = new ArenaData(vector);
        this.onlinePlayers = new ArrayList<Player>();
        this.playerQueue = new ArrayList<Player>();
    }

    Arena(ArenaData arenaData, String string) {
        this.arenaData = arenaData;
        arenaData.setGamemode(string);
        this.onlinePlayers = new ArrayList<Player>();
        this.playerQueue = new ArrayList<Player>();
        ScoreManager.getInstance().updateArenaScore(this);
    }

    Arena(String string) {
        this.arenaData = new ArenaData(string);
        this.onlinePlayers = new ArrayList<Player>();
        this.playerQueue = new ArrayList<Player>();
        ScoreManager.getInstance().updateArenaScore(this);
    }

    public long getSecondsSinceLastChange() {
        return TimeHandler.getTime() - this.lastChangeTime;
    }

    void changeArena(Arena arena) {
        this.arenaData.changeArena(arena.arenaData);
        this.lastChangeTime = TimeHandler.getTime();
        for (Player player : this.onlinePlayers) {
            this.teleportHome(player, true);
            Messages.sendMessage(player, "arena.change");
        }
    }

    void prepareForDeletion() {
        ArrayList<Player> arrayList = new ArrayList<Player>(this.onlinePlayers);
        for (Player player : arrayList) {
            Messages.sendMessage(player, "arena.deletion");
            if (!this.isInsideArena(player.getLocation())) continue;
            this.playerRemove(player, false);
        }
        this.playerQueue.clear();
        this.onlinePlayers.clear();
        this.shutDown();
        this.arenaData.prepareForDeletion();
    }

    void delete() {
        this.arenaData.remove();
    }

    void shutDown() {
        if (this.waveController != null) {
            this.waveController.shutdown();
        }
    }

    public void restartWave() {
        this.shutDown();
        this.waveController = new WaveController(this);
    }

    public ArenaData getArenaData() {
        return this.arenaData;
    }

    public WaveController getWaveController() {
        return this.waveController;
    }

    public List<Player> getOnlinePlayers() {
        return this.onlinePlayers;
    }

    public Player getRandomOnlinePlayer() {
        if (this.onlinePlayers.size() == 0) {
            return null;
        }
        if (this.onlinePlayers.size() == 1) {
            return this.onlinePlayers.get(0);
        }
        return this.onlinePlayers.get(new Random().nextInt(this.onlinePlayers.size() - 1));
    }

    public void playerAdd(Player player) {
        List list = (List)this.arenaData.getMembers().clone();
        this.arenaData.addMember(player.getUniqueId());
        ScoreManager.getInstance().updateMembers(this, list);
        this.sendMessageToAll(MessageData.getMessage("arena.add").replace("%NAME%", player.getName()));
        this.playerJoin(player);
    }

    public void playerJoin(Player player) {
        if (!this.arenaData.getMembers().contains(player.getUniqueId())) {
            return;
        }
        player.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue((double)ConfigData.getInstance().getMaxHealth(this.arenaData.getGamemode()));
        player.setHealth((double)ConfigData.getInstance().getMaxHealth(this.arenaData.getGamemode()));
        if (this.waveController != null && this.waveController.isInWave()) {
            this.playerQueue.add(player);
            if (ConfigData.getInstance().getSpawn_location() == null) {
                Messages.sendMessage(player, "spawn.not-set");
            } else {
                player.teleport(ConfigData.getInstance().getSpawn_location());
            }
            Messages.sendMessage(player, "wave.progress");
            return;
        }
        this.sendMessageToAll(MessageData.getMessage("arena.join").replace("%NAME%", player.getName()));
        this.onlinePlayers.add(player);
        player.setPlayerTime(this.arenaTime, false);
        if (this.onlinePlayers.size() == 1) {
            this.waveController = new WaveController(this);
        } else if (this.waveController.isInWave()) {
            if (ConfigData.getInstance().getSpawn_location() == null) {
                Messages.sendMessage(player, "spawn.not-set");
            } else {
                player.teleport(ConfigData.getInstance().getSpawn_location());
            }
            Messages.sendMessage(player, "wave.progress");
        } else {
            this.teleportHome(player, false);
            this.waveController.updatePlayers();
        }
    }

    public void playerRemove(Player player, boolean bl) {
        player.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(20.0);
        List list = (List)this.arenaData.getMembers().clone();
        if (this.arenaData.removeMember(player.getUniqueId())) {
            this.playerQuit(player);
            player.setPlayerTime(12000L, true);
            if (bl) {
                this.sendMessageToAll(MessageData.getMessage("arena.quit").replace("%NAME%", player.getName()));
            }
            if (this.isInsideArena(player.getLocation())) {
                if (ConfigData.getInstance().getSpawn_location() == null) {
                    player.teleport(player.getWorld().getSpawnLocation());
                } else {
                    player.teleport(ConfigData.getInstance().getSpawn_location());
                }
            }
            if (this.arenaData.getMembers().size() == 0) {
                ArenaManager.getInstance().removeArena(this, false);
            } else if (!bl) {
                ScoreManager.getInstance().updateMembers(this, list);
            }
            if (ConfigData.getInstance().isInvResetOnLeave()) {
                Economy.setBalance(player, 0.0);
                player.getInventory().clear();
                player.setHealth(20.0);
                player.setExhaustion(20.0f);
                player.getActivePotionEffects().forEach(potionEffect -> player.removePotionEffect(potionEffect.getType()));
            }
        }
    }

    public void playerQuit(Player player) {
        if (!this.onlinePlayers.remove(player)) {
            return;
        }
        this.sendMessageToAll(MessageData.getMessage("arena.left").replace("%NAME%", player.getName()));
        if (this.waveController != null) {
            this.waveController.updatePlayers();
            if (this.onlinePlayers.size() == 0) {
                this.waveController.shutdown();
                this.waveController = null;
            }
        }
    }

    public void sendMessageToAll(String string) {
        this.onlinePlayers.forEach(player -> Messages.sendMessage(player, string));
    }

    public void teleportHome(Player player, boolean bl) {
        if (!this.onlinePlayers.contains(player)) {
            return;
        }
        if ((bl || !this.isInsideArena(player.getLocation())) && this.arenaData.getSpawnLocation() != null) {
            player.teleport(this.arenaData.getSpawnLocation());
        }
    }

    public boolean isInsideArena(Location location) {
        return location.getX() >= this.arenaData.getArenaLoc().getX() - (double)((float)ConfigData.getInstance().getArena_space() / 2.0f) && location.getX() <= this.arenaData.getArenaLoc().getX() + (double)((float)ConfigData.getInstance().getArena_space() / 2.0f) && location.getZ() >= this.arenaData.getArenaLoc().getZ() - (double)((float)ConfigData.getInstance().getArena_space() / 2.0f) && location.getZ() <= this.arenaData.getArenaLoc().getZ() + (double)((float)ConfigData.getInstance().getArena_space() / 2.0f);
    }

    void pingSec() {
        this.updateSunAndMoon();
        if (this.waveController == null) {
            return;
        }
        this.waveController.pingSec();
        if (!this.waveController.isInWave() && this.playerQueue.size() > 0) {
            for (Player player : this.playerQueue) {
                if (!this.arenaData.getMembers().contains(player.getUniqueId())) continue;
                this.onlinePlayers.add(player);
                Messages.sendMessage(player, "wave.finish");
            }
            this.playerQueue.clear();
        }
    }

    private void updateSunAndMoon() {
        for (Player player : this.onlinePlayers) {
            if (player.getPlayerTime() - this.arenaTime <= 10L && player.getPlayerTime() - this.arenaTime >= -10L) continue;
            player.setPlayerTime(player.getPlayerTime() + (this.arenaTime - player.getPlayerTime()), false);
        }
    }

    public void setArenaTime(long l) {
        this.arenaTime = l;
    }

    public String getArenaMembers() {
        StringBuilder stringBuilder = new StringBuilder();
        for (UUID uUID : this.arenaData.getMembers()) {
            Player player = Bukkit.getPlayer((UUID)uUID);
            if (player != null) {
                stringBuilder.append(player.getName());
            } else {
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uUID);
                if (offlinePlayer.getName() != null) {
                    stringBuilder.append(offlinePlayer.getName());
                } else {
                    stringBuilder.append("Unknown Player");
                }
            }
            stringBuilder.append(", ");
        }
        if (stringBuilder.length() >= 2) {
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        }
        return stringBuilder.toString();
    }
}

