/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.arenas;

import NL.martijnpu.ChunkDefence.arenas.ArenaManager;
import NL.martijnpu.ChunkDefence.data.ConfigData;
import NL.martijnpu.ChunkDefence.data.FileHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class ArenaData {
    private final String _LOCATION_PATH = ".location";
    private final String _BOUGHT_PATH = ".bought-arenas";
    private final String _DELETION_PATH = ".is-in-deletion";
    private final String _MEMBERS_PATH = ".members";
    private final String _WAVE_PATH = ".wave";
    private final String _DIFFICULTY_PATH = ".difficulty";
    private final String _GAMEMODE_PATH = ".gamemode";
    private final String _SCHEMATIC_PATH = ".schematic";
    private final String ARENA_PATH_ = "arena.";
    private final String path;
    private final ArrayList<UUID> members;
    private final List<String> boughtArenas;
    private Vector arenaLoc;
    private Location spawnLocation;

    ArenaData(Vector vector) {
        this.path = this.getFreePath();
        this.members = new ArrayList();
        this.boughtArenas = new ArrayList<String>();
        this.arenaLoc = vector;
        FileHandler.getInstance().getArenaConfig().set(this.path + ".location", (Object)FileHandler.getStringFromXYZ(vector));
        FileHandler.getInstance().saveArenaConfig();
        this.spawnLocation = ConfigData.getInstance().getArena_delta(this.getSchematicName());
        if (this.spawnLocation != null) {
            this.spawnLocation.setWorld(ArenaManager.getArenaWorld());
            this.spawnLocation.setX(this.spawnLocation.getX() + (double)vector.getBlockX());
            this.spawnLocation.setY(this.spawnLocation.getY() + (double)vector.getBlockY());
            this.spawnLocation.setZ(this.spawnLocation.getZ() + (double)vector.getBlockZ());
        }
    }

    ArenaData(String string) {
        this.path = "arena." + string;
        this.members = new ArrayList();
        this.boughtArenas = FileHandler.getInstance().getArenaConfig().getStringList(this.path + ".bought-arenas");
        this.arenaLoc = FileHandler.getXYZFromString(FileHandler.getInstance().getArenaConfig().getString(this.path + ".location", null));
        if (this.arenaLoc == null) {
            throw new IllegalArgumentException("Location is null");
        }
        List list = FileHandler.getInstance().getArenaConfig().getStringList(this.path + ".members");
        list.stream().map(UUID::fromString).forEach(this.members::add);
        this.spawnLocation = ConfigData.getInstance().getArena_delta(this.getSchematicName() != null ? this.getSchematicName() : ConfigData.getInstance().getArena_default_schematic());
        if (this.spawnLocation != null) {
            this.spawnLocation.setWorld(ArenaManager.getArenaWorld());
            this.spawnLocation.add(this.arenaLoc);
        }
    }

    void remove() {
        FileHandler.getInstance().getArenaConfig().set(this.path, null);
        FileHandler.getInstance().saveArenaConfig();
    }

    void prepareForDeletion() {
        FileHandler.getInstance().getArenaConfig().set(this.path + ".is-in-deletion", (Object)true);
        FileHandler.getInstance().getArenaConfig().set(this.path + ".members", null);
        FileHandler.getInstance().saveArenaConfig();
    }

    boolean needsDeletion() {
        return FileHandler.getInstance().getArenaConfig().isSet(this.path + ".is-in-deletion");
    }

    public Vector getArenaLoc() {
        return this.arenaLoc == null ? null : this.arenaLoc.clone();
    }

    public Location getSpawnLocation() {
        return this.spawnLocation != null ? this.spawnLocation.clone() : null;
    }

    public ArrayList<UUID> getMembers() {
        return this.members;
    }

    public int getWave() {
        return FileHandler.getInstance().getArenaConfig().getInt(this.path + ".wave", 1);
    }

    public int getDifficulty() {
        return FileHandler.getInstance().getArenaConfig().getInt(this.path + ".difficulty", ConfigData.getInstance().getDefaultDifficulty(this.getGamemode()));
    }

    public String getSchematicName() {
        return FileHandler.getInstance().getArenaConfig().getString(this.path + ".schematic", ConfigData.getInstance().getArena_default_schematic());
    }

    void setSchematicName(String string) {
        FileHandler.getInstance().getArenaConfig().set(this.path + ".schematic", (Object)string);
        FileHandler.getInstance().saveArenaConfig();
    }

    public String getGamemode() {
        return FileHandler.getInstance().getArenaConfig().getString(this.path + ".gamemode", "default");
    }

    void setGamemode(String string) {
        FileHandler.getInstance().getArenaConfig().set(this.path + ".gamemode", (Object)string);
        FileHandler.getInstance().saveArenaConfig();
    }

    public void addWave() {
        FileHandler.getInstance().getArenaConfig().set(this.path + ".wave", (Object)(this.getWave() + 1));
        FileHandler.getInstance().saveArenaConfig();
    }

    public void resetWave() {
        FileHandler.getInstance().getArenaConfig().set(this.path + ".wave", (Object)1);
        FileHandler.getInstance().saveArenaConfig();
    }

    private void setLocation(Vector vector) {
        this.arenaLoc = vector;
        FileHandler.getInstance().getArenaConfig().set(this.path + ".location", (Object)FileHandler.getStringFromXYZ(vector));
        FileHandler.getInstance().saveArenaConfig();
    }

    void addMember(UUID uUID) {
        this.members.add(uUID);
        FileHandler.getInstance().getArenaConfig().set(this.path + ".members", this.members.stream().map(UUID::toString).collect(Collectors.toList()));
        FileHandler.getInstance().saveArenaConfig();
    }

    boolean removeMember(UUID uUID) {
        if (this.members.remove(uUID)) {
            FileHandler.getInstance().getArenaConfig().set(this.path + ".members", null);
            FileHandler.getInstance().getArenaConfig().set(this.path + ".members", this.members.stream().map(UUID::toString).collect(Collectors.toList()));
            FileHandler.getInstance().saveArenaConfig();
            return true;
        }
        return false;
    }

    public void editDifficulty(boolean bl) {
        if (this.getDifficulty() >= ConfigData.getInstance().getMinDifficulty(this.getGamemode())) {
            FileHandler.getInstance().getArenaConfig().set(this.path + ".difficulty", (Object)(this.getDifficulty() + (bl ? ConfigData.getInstance().getWinDifficulty(this.getGamemode()) : -ConfigData.getInstance().getLoseDifficulty(this.getGamemode()))));
        }
        FileHandler.getInstance().saveArenaConfig();
    }

    public boolean hasBoughtArena(String string) {
        if (ConfigData.getInstance().getArena_save_bought(this.getGamemode())) {
            return this.boughtArenas.contains(string) || this.getSchematicName().equals(string);
        }
        return this.getSchematicName().equals(string);
    }

    void changeArena(ArenaData arenaData) {
        Vector vector = this.arenaLoc.clone();
        String string = this.getSchematicName();
        if (!this.boughtArenas.contains(this.getSchematicName())) {
            this.boughtArenas.add(this.getSchematicName());
        }
        if (!this.boughtArenas.contains(arenaData.getSchematicName())) {
            this.boughtArenas.add(arenaData.getSchematicName());
        }
        this.setLocation(arenaData.arenaLoc);
        arenaData.setLocation(vector);
        FileHandler.getInstance().getArenaConfig().set(this.path + ".schematic", (Object)arenaData.getSchematicName());
        FileHandler.getInstance().getArenaConfig().set(arenaData.path + ".schematic", (Object)string);
        FileHandler.getInstance().getArenaConfig().set(this.path + ".bought-arenas", this.boughtArenas);
        FileHandler.getInstance().getArenaConfig().set(arenaData.path + ".bought-arenas", null);
        FileHandler.getInstance().saveArenaConfig();
        this.spawnLocation = ConfigData.getInstance().getArena_delta(this.getSchematicName());
        if (this.spawnLocation != null) {
            this.spawnLocation.setWorld(ArenaManager.getArenaWorld());
            this.spawnLocation.add(this.arenaLoc);
        }
    }

    private String getFreePath() {
        int n = 1;
        while (FileHandler.getInstance().getArenaConfig().isSet("arena." + n)) {
            ++n;
        }
        return "arena." + n;
    }
}

