/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.cmds;

import NL.martijnpu.ChunkDefence.Messages;
import NL.martijnpu.ChunkDefence.arenas.Arena;
import NL.martijnpu.ChunkDefence.arenas.ArenaManager;
import NL.martijnpu.ChunkDefence.cmds.SubCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;

class AdminArenaChangeCmd
extends SubCommand {
    AdminArenaChangeCmd() {
    }

    @Override
    String getCommand() {
        return "chunkdefenceadmin";
    }

    @Override
    String getDescription() {
        return "Change the arena of others";
    }

    @Override
    String[] getArgs() {
        return new String[]{"change"};
    }

    @Override
    String getPermission() {
        return "chunkdefence.admin.arena";
    }

    @Override
    int getPlayerArguments() {
        return 2;
    }

    @Override
    String getUsage() {
        return super.getUsage() + " <player> <arenaName>";
    }

    @Override
    List<List<String>> getTabComplete() {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        arrayList.add(Bukkit.getOnlinePlayers().stream().map(HumanEntity::getName).collect(Collectors.toList()));
        arrayList.add(ArenaManager.getInstance().getAllSchematics());
        return arrayList;
    }

    @Override
    void onCommand(Player player, String[] stringArray) {
        Player player2 = Bukkit.getPlayer((String)stringArray[0]);
        if (player2 == null) {
            Messages.sendMessage(player, "exception.offline");
            return;
        }
        Arena arena = ArenaManager.getInstance().getArena(player2);
        if (arena == null) {
            Messages.sendMessage(player, "arena.none");
            return;
        }
        if (ArenaManager.getInstance().isInvalidSchematic(stringArray[1])) {
            Messages.sendMessage(player, "arena.schematic.no-file");
            return;
        }
        ArenaManager.getInstance().changeArena(arena, stringArray[1]);
        Messages.sendMessage(player, "command.succeeded");
    }
}

