/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.cmds;

import NL.martijnpu.ChunkDefence.Messages;
import NL.martijnpu.ChunkDefence.arenas.Arena;
import NL.martijnpu.ChunkDefence.arenas.ArenaManager;
import NL.martijnpu.ChunkDefence.cmds.SubCommand;
import NL.martijnpu.ChunkDefence.data.MessageData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;

class ArenaInfoOthersCmd
extends SubCommand {
    ArenaInfoOthersCmd() {
    }

    @Override
    String getCommand() {
        return "arena";
    }

    @Override
    String getDescription() {
        return "Get arena info of the given player or the arena you're in";
    }

    @Override
    String[] getArgs() {
        return new String[]{"info"};
    }

    @Override
    String getPermission() {
        return "chunkdefence.admin.info";
    }

    @Override
    int getPlayerArguments() {
        return 1;
    }

    @Override
    String getUsage() {
        return super.getUsage() + " <Player>";
    }

    @Override
    List<List<String>> getTabComplete() {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        arrayList.add(Bukkit.getOnlinePlayers().stream().map(HumanEntity::getName).collect(Collectors.toList()));
        return arrayList;
    }

    @Override
    void onCommand(Player player, String[] stringArray) {
        Arena arena;
        Player player2 = Bukkit.getPlayer((String)stringArray[0]);
        if (player2 == null) {
            Messages.sendMessage(player, "exception.offline");
        }
        if ((arena = ArenaManager.getInstance().getArena(player2)) == null) {
            Messages.sendMessage(player, "arena.none");
            return;
        }
        Messages.sendBigMessage(player, Arrays.asList(MessageData.getMessage("wave.current").replace("%AMOUNT%", arena.getArenaData().getWave() + ""), arena.getWaveController().getInfo()));
    }
}

