/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.cmds;

import NL.martijnpu.ChunkDefence.Messages;
import NL.martijnpu.ChunkDefence.arenas.Arena;
import NL.martijnpu.ChunkDefence.arenas.ArenaManager;
import NL.martijnpu.ChunkDefence.cmds.SubCommand;
import NL.martijnpu.ChunkDefence.data.ConfigData;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;

public class ArenaStartGamemodeCmd
extends SubCommand {
    @Override
    String getCommand() {
        return "arena";
    }

    @Override
    String getDescription() {
        return "Start or force-start the next wave with a specific gamemode (only for first wave)";
    }

    @Override
    String[] getArgs() {
        return new String[]{"start"};
    }

    @Override
    boolean playerOnly() {
        return true;
    }

    @Override
    int getPlayerArguments() {
        return 1;
    }

    @Override
    List<List<String>> getTabComplete() {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        arrayList.add(ConfigData.getInstance().getGamemodes());
        return arrayList;
    }

    @Override
    void onCommand(Player player, String[] stringArray) {
        ArenaStartGamemodeCmd.arenaStartGamemodeCmd(player, stringArray[0]);
    }

    public static void arenaStartGamemodeCmd(Player player, String string) {
        if (ConfigData.getInstance().getGamemodes().stream().noneMatch(string2 -> string2.equalsIgnoreCase(string))) {
            Messages.sendMessage(player, "exception.gamemode");
            return;
        }
        try {
            Arena arena = ArenaManager.getInstance().getArena(player);
            if (arena == null) {
                arena = ArenaManager.getInstance().getArenaCreateIfNotExist(player, string);
            }
            if (arena == null) {
                return;
            }
            arena.getWaveController().start();
        }
        catch (NullPointerException nullPointerException) {
            Messages.sendMessage(player, "exception.administrator");
            nullPointerException.printStackTrace();
        }
    }
}

