/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.cmds;

import NL.martijnpu.ChunkDefence.Messages;
import NL.martijnpu.ChunkDefence.arenas.Arena;
import NL.martijnpu.ChunkDefence.arenas.ArenaManager;
import NL.martijnpu.ChunkDefence.cmds.SubCommand;
import NL.martijnpu.ChunkDefence.data.ConfigData;
import NL.martijnpu.ChunkDefence.data.DefinedMobData;
import NL.martijnpu.ChunkDefence.waves.SpawnWaves;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ArenaWaveInfoCmd
extends SubCommand {
    @Override
    String getCommand() {
        return "arena";
    }

    @Override
    String getDescription() {
        return "Get mob info about the current wave";
    }

    @Override
    String[] getArgs() {
        return new String[]{"waveinfo"};
    }

    @Override
    boolean playerOnly() {
        return true;
    }

    @Override
    void onCommand(Player player, String[] stringArray) {
    }

    public static void onCommand(Player player) {
        Arena arena = ArenaManager.getInstance().getArena(player);
        if (arena == null) {
            Messages.sendMessage(player, "arena.none");
            return;
        }
        int n = arena.getArenaData().getWave();
        ItemStack itemStack = new ItemStack(Material.WRITTEN_BOOK, 1);
        BookMeta bookMeta = (BookMeta)itemStack.getItemMeta();
        assert (bookMeta != null);
        bookMeta.setGeneration(BookMeta.Generation.ORIGINAL);
        bookMeta.setAuthor("ChunkDefence");
        bookMeta.setTitle("Info wave " + n);
        BookMeta.Spigot spigot = bookMeta.spigot();
        BaseComponent[] baseComponentArray = new BaseComponent[]{new TextComponent()};
        try {
            Map<Integer, DefinedMobData> map = ConfigData.getInstance().isWaveDefined(n) ? ConfigData.getInstance().getWave(n) : SpawnWaves.getGeneratedWave(n);
            baseComponentArray[0].addExtra("Wave " + n + "\n");
            baseComponentArray[0].setBold(Boolean.valueOf(true));
            baseComponentArray[0].setColor(ChatColor.GOLD);
            for (Map.Entry<Integer, DefinedMobData> entry : map.entrySet()) {
                TextComponent textComponent = new TextComponent("  - " + entry.getKey() % 100 + " " + entry.getValue().getEntityType().name().toLowerCase().replace("_", " ") + "\n");
                textComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(ArenaWaveInfoCmd.getMobData(entry.getValue(), entry.getKey() % 100, ""))}));
                textComponent.setColor(ChatColor.BLACK);
                baseComponentArray[0].addExtra((BaseComponent)textComponent);
            }
        }
        catch (Exception exception) {
            baseComponentArray[0].addExtra("Wave " + n + "\n");
            baseComponentArray[0].setBold(Boolean.valueOf(true));
            baseComponentArray[0].setColor(ChatColor.DARK_RED);
            baseComponentArray[0].addExtra("Unable to generate" + exception.getMessage());
        }
        spigot.addPage((BaseComponent[][])new BaseComponent[][]{(BaseComponent[])baseComponentArray.clone()});
        itemStack.setItemMeta((ItemMeta)bookMeta);
        player.openBook(itemStack);
    }

    private static String getMobData(DefinedMobData definedMobData, int n, String string) {
        return string + "\u00a76Type: \u00a7f" + definedMobData.getEntityType().toString().toLowerCase() + "\n" + string + "\u00a76Coins: \u00a7f" + definedMobData.getCoins() + "\n" + string + "\u00a76Amount: \u00a7f" + definedMobData.getAmount() * n + (definedMobData.getEntityHealth() == -1 ? "" : "\n" + string + "\u00a76Health: \u00a7f" + definedMobData.getEntityHealth()) + (definedMobData.getCustomName() == null ? "" : "\n" + string + "\u00a76Custom name: \u00a7f" + ChatColor.translateAlternateColorCodes((char)'&', (String)definedMobData.getCustomName())) + (definedMobData.getEntityType() != EntityType.SLIME ? "" : "\n" + string + "\u00a76Size: \u00a7f" + definedMobData.getSize()) + (definedMobData.getEntityType() != EntityType.CREEPER ? "" : "\n" + string + "\u00a76ExplosionRadius: \u00a7f" + definedMobData.getExplosionRadius()) + (definedMobData.getColor() == null ? "" : "\n" + string + "\u00a76Color: \u00a7f" + definedMobData.getColor().toLowerCase()) + (!definedMobData.getSilent() ? "" : "\n" + string + "\u00a76Silent: \u00a7ftrue") + (!definedMobData.getGlowing() ? "" : "\n" + string + "\u00a76Glowing: \u00a7ftrue") + (!definedMobData.getGliding() ? "" : "\n" + string + "\u00a76Gliding: \u00a7ftrue") + (definedMobData.getEntityMainHand() == null ? "" : "\n" + string + "\u00a76Hand: \u00a7f" + definedMobData.getEntityMainHand().getType().toString().toLowerCase()) + (definedMobData.getEntityHelmet() == null ? "" : "\n" + string + "\u00a76Helmet: \u00a7f" + definedMobData.getEntityHelmet().getType().toString().toLowerCase()) + (definedMobData.getEntityChestPlate() == null ? "" : "\n" + string + "\u00a76Chestplate: \u00a7f" + definedMobData.getEntityChestPlate().getType().toString().toLowerCase()) + (definedMobData.getEntityLeggings() == null ? "" : "\n" + string + "\u00a76Leggings: \u00a7f" + definedMobData.getEntityLeggings().getType().toString().toLowerCase()) + (definedMobData.getEntityBoots() == null ? "" : "\n" + string + "\u00a76Boots: \u00a7f" + definedMobData.getEntityBoots().getType().toString().toLowerCase()) + (definedMobData.getPassenger() == null ? "" : "\n" + string + "\u00a76Passenger:\n" + ArenaWaveInfoCmd.getMobData(definedMobData.getPassenger(), n, "\u00a7f-"));
    }
}

