/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.data;

import NL.martijnpu.ChunkDefence.Messages;
import javax.annotation.Nullable;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public class DefinedMobData {
    private final ConfigurationSection config;
    private final EntityType entityType;
    private final DefinedMobData passenger;

    public DefinedMobData(@Nullable ConfigurationSection configurationSection) {
        this.config = configurationSection;
        if (configurationSection == null) {
            throw new NullPointerException("Passenger data is null");
        }
        this.entityType = EntityType.valueOf((String)configurationSection.getString("type", "NoEntityTypeDefined"));
        if (!this.entityType.isAlive() || !this.entityType.isSpawnable()) {
            Messages.sendConsoleWarning(configurationSection.getName() + " is not an LivingEntity");
            throw new IllegalArgumentException(configurationSection.getName() + " is not an LivingEntity");
        }
        DefinedMobData definedMobData = null;
        if (configurationSection.isSet("passenger")) {
            try {
                definedMobData = new DefinedMobData(configurationSection.getConfigurationSection("passenger"));
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {
                Messages.sendConsoleWarning("Unable to process " + configurationSection.getCurrentPath() + ".passenger! Mob has no passenger.\nError: " + runtimeException.getLocalizedMessage());
            }
        }
        this.passenger = definedMobData;
    }

    public int getCoins() {
        return this.config.getInt("coins", 10);
    }

    public int getWeight() {
        return this.config.getInt("weight", 1);
    }

    public int getAmount() {
        return this.config.getInt("amount", 1);
    }

    public int getSize() {
        return this.config.getInt("size", 3);
    }

    public int getExplosionRadius() {
        return this.config.getInt("explosion-radius", 3);
    }

    public boolean getPowered() {
        return this.config.getBoolean("powered", false);
    }

    public boolean getSilent() {
        return this.config.getBoolean("silent", false);
    }

    public boolean getGlowing() {
        return this.config.getBoolean("glowing", false);
    }

    public boolean getGliding() {
        return this.config.getBoolean("gliding", false);
    }

    public String getColor() {
        return this.config.getString("color", null);
    }

    public String getCustomName() {
        return this.config.getString("customname");
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public int getEntityHealth() {
        return this.config.getInt("health", -1);
    }

    public double getAdditionalDamage() {
        return this.config.getDouble("additional-damage", 0.0);
    }

    public boolean getEntityAdult() {
        return this.config.getBoolean("adult", true);
    }

    public ItemStack getEntityMainHand() {
        return this.config.getItemStack("equipment.mainhand");
    }

    public ItemStack getEntityOffHand() {
        return this.config.getItemStack("equipment.offhand");
    }

    public ItemStack getEntityHelmet() {
        return this.config.getItemStack("equipment.helmet");
    }

    public ItemStack getEntityChestPlate() {
        return this.config.getItemStack("equipment.chestplate");
    }

    public ItemStack getEntityLeggings() {
        return this.config.getItemStack("equipment.leggings");
    }

    public ItemStack getEntityBoots() {
        return this.config.getItemStack("equipment.boots");
    }

    public DefinedMobData getPassenger() {
        return this.passenger;
    }
}

