/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.gui;

import NL.martijnpu.ChunkDefence.Messages;
import NL.martijnpu.ChunkDefence.data.ConfigData;
import NL.martijnpu.ChunkDefence.data.MessageData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class GuiSlot {
    private final ItemStack itemStack;
    private final List<Material> animationList = new ArrayList<Material>();
    private Runnable onLeftClick;
    private Runnable onRightClick;
    private Runnable onLeftShiftClick;
    private Runnable onRightShiftClick;
    private Runnable onMiddleClick;
    private String name;
    private List<String> lore;
    private boolean canEdit;
    private double animationSpeed;
    private double animatedState;

    public GuiSlot() {
        this.itemStack = new ItemStack(Material.AIR);
        this.defaultMeta();
        this.name = " ";
    }

    public GuiSlot(@Nullable ItemStack itemStack) {
        this.itemStack = itemStack;
        this.defaultMeta();
    }

    public GuiSlot(Material material) {
        this.itemStack = new ItemStack(material);
        this.defaultMeta();
    }

    public GuiSlot(Material material, String string) {
        this.itemStack = new ItemStack(material);
        this.checkMaterial();
        this.name = MessageData.getMessage(string);
        this.defaultMeta();
    }

    private void checkMaterial() {
        if (this.itemStack.getType().equals((Object)Material.AIR)) {
            this.itemStack.setType(Material.LIGHT_GRAY_STAINED_GLASS_PANE);
        }
    }

    private void defaultMeta() {
        ItemMeta itemMeta = this.itemStack.getItemMeta();
        if (itemMeta != null) {
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_PLACED_ON});
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
            this.itemStack.setItemMeta(itemMeta);
        }
    }

    public GuiSlot setLeftClick(Runnable runnable) {
        this.onLeftClick = runnable;
        return this;
    }

    public GuiSlot setRightClick(Runnable runnable) {
        this.onRightClick = runnable;
        return this;
    }

    public GuiSlot setLeftShiftClick(Runnable runnable) {
        this.onLeftShiftClick = runnable;
        return this;
    }

    public GuiSlot setRightShiftClick(Runnable runnable) {
        this.onRightShiftClick = runnable;
        return this;
    }

    public GuiSlot setMiddleClick(Runnable runnable) {
        this.onMiddleClick = runnable;
        return this;
    }

    public GuiSlot setEdible(boolean bl) {
        this.canEdit = bl;
        return this;
    }

    public GuiSlot setShiny() {
        this.checkMaterial();
        ItemMeta itemMeta = this.itemStack.getItemMeta();
        itemMeta.addEnchant(Enchantment.DAMAGE_ALL, 0, false);
        this.itemStack.setItemMeta(itemMeta);
        return this;
    }

    public GuiSlot setLore(List<String> list) {
        this.checkMaterial();
        this.lore = list;
        return this;
    }

    public GuiSlot setMaterial(Material material) {
        this.itemStack.setType(material);
        return this;
    }

    public GuiSlot setAnimated(double d, double d2) {
        this.checkMaterial();
        this.animationSpeed = d;
        this.animatedState = d2;
        return this;
    }

    public GuiSlot addAnimation(Material material, int n) {
        for (int i = 0; i < n; ++i) {
            this.animationList.add(material);
        }
        return this;
    }

    public GuiSlot addAnimation(Material material) {
        this.animationList.add(material);
        return this;
    }

    public void onLeftClick() {
        if (this.onLeftClick != null) {
            this.onLeftClick.run();
        }
    }

    public void onRightClick() {
        if (this.onRightClick != null) {
            this.onRightClick.run();
        } else {
            this.onLeftClick();
        }
    }

    public void onShiftRightClick() {
        if (this.onRightShiftClick != null) {
            this.onRightShiftClick.run();
        } else if (this.onRightClick != null) {
            this.onRightClick();
        } else {
            this.onLeftShiftClick();
        }
    }

    public void onLeftShiftClick() {
        if (this.onLeftShiftClick != null) {
            this.onLeftShiftClick.run();
        } else {
            this.onLeftClick();
        }
    }

    public void onMiddleClick() {
        if (this.onMiddleClick != null) {
            this.onMiddleClick.run();
        }
    }

    @Nullable
    public ItemStack getItem() {
        ItemMeta itemMeta = this.itemStack.getItemMeta();
        if (itemMeta != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.lore != null) {
                for (String string : this.lore) {
                    arrayList.add(Messages.format(string));
                }
            }
            itemMeta.setLore(arrayList);
            itemMeta.setDisplayName(Messages.format(this.name));
            this.itemStack.setItemMeta(itemMeta);
        }
        return this.itemStack;
    }

    public String getName() {
        return this.name;
    }

    public GuiSlot setName(String string) {
        this.checkMaterial();
        this.name = MessageData.getMessage(string);
        return this;
    }

    public boolean canEdit() {
        return this.canEdit;
    }

    public boolean isAnimated() {
        return this.animationList.size() > 1 && this.animationSpeed > 0.0;
    }

    public Material tickAnimation() {
        this.animatedState += 0.05 * (double)ConfigData.getInstance().getParticleFrequency() * this.animationSpeed;
        if (this.animatedState >= (double)this.animationList.size()) {
            this.animatedState %= (double)this.animationList.size();
        }
        return this.animationList.get((int)this.animatedState);
    }

    public GuiSlot addLore(String string) {
        this.checkMaterial();
        this.lore.add(string);
        return this;
    }

    public GuiSlot removeLore(String string) {
        this.checkMaterial();
        this.lore.remove(string);
        return this;
    }

    public GuiSlot setAmount(int n) {
        this.checkMaterial();
        this.itemStack.setAmount(n);
        return this;
    }

    public GuiSlot setPlayerHead(OfflinePlayer offlinePlayer) {
        this.itemStack.setType(Material.PLAYER_HEAD);
        SkullMeta skullMeta = (SkullMeta)this.itemStack.getItemMeta();
        if (skullMeta != null) {
            skullMeta.setOwningPlayer(offlinePlayer);
        }
        this.itemStack.setItemMeta((ItemMeta)skullMeta);
        return this;
    }
}

