/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.players;

import NL.martijnpu.ChunkDefence.Messages;
import NL.martijnpu.ChunkDefence.data.FileHandler;
import NL.martijnpu.ChunkDefence.players.Economy;
import NL.martijnpu.ChunkDefence.players.PlayerData;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.configuration.ConfigurationSection;

public class PlayerDataManager {
    private static PlayerDataManager instance;
    private final List<PlayerData> players;

    private PlayerDataManager() {
        String string = "user";
        this.players = new ArrayList<PlayerData>();
        if (Economy.usingVault()) {
            return;
        }
        ConfigurationSection configurationSection = FileHandler.getInstance().getEconomyConfig().getConfigurationSection(string);
        if (configurationSection == null) {
            return;
        }
        for (String string2 : configurationSection.getKeys(false)) {
            try {
                this.players.add(new PlayerData(UUID.fromString(string2)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Messages.sendConsoleWarning(illegalArgumentException.toString());
            }
        }
    }

    public static PlayerDataManager getInstance() {
        if (instance == null) {
            instance = new PlayerDataManager();
        }
        return instance;
    }

    public static void resetInstance() {
        instance = null;
    }

    public void printInitData() {
        if (this.players.size() == 0) {
            if (!Economy.usingVault()) {
                Messages.sendConsoleWarning("Loading an empty user file. This is an error or first startup.");
            } else {
                Messages.sendConsole("Loading none user file. This is correct because of Vault.");
            }
        } else {
            Messages.sendConsole("Loading " + this.players.size() + " users.");
        }
    }

    public PlayerData getUserData(UUID uUID) {
        PlayerData playerData2 = this.players.stream().filter(playerData -> playerData.getUuid().equals(uUID)).findFirst().orElse(null);
        if (playerData2 == null) {
            playerData2 = new PlayerData(uUID);
            this.players.add(playerData2);
        }
        return playerData2;
    }

    public List<UUID> getAllUsers() {
        return this.players.stream().map(PlayerData::getUuid).collect(Collectors.toList());
    }

    public void playerJoin(UUID uUID) {
        if (this.getUserData(uUID) == null) {
            this.players.add(new PlayerData(uUID));
        }
    }
}

