/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.shops;

import NL.martijnpu.ChunkDefence.Messages;
import NL.martijnpu.ChunkDefence.data.MessageData;
import NL.martijnpu.ChunkDefence.shops.FloatingText;
import NL.martijnpu.ChunkDefence.shops.Shop;
import NL.martijnpu.ChunkDefence.shops.ShopArena;
import java.util.List;
import org.bukkit.entity.Player;

public class DisplayText {
    private final Player player;
    private final Shop shop;
    private final List<FloatingText> texts;

    public DisplayText(Player player, Shop shop) {
        this.player = player;
        this.shop = shop;
        this.texts = shop.getTextList();
        this.addPersonalTouch();
        this.texts.forEach(floatingText -> floatingText.spawnText(shop.getShopLocation().getLocation(), player));
        Messages.sendActionBarMessage(player, "shop.hover-actionbar", 2000);
    }

    Shop getShop() {
        return this.shop;
    }

    Player getPlayer() {
        return this.player;
    }

    void update() {
        this.texts.forEach(FloatingText::update);
        Messages.sendActionBarMessage(this.player, "shop.hover-actionbar", 2000);
    }

    void remove() {
        this.texts.forEach(FloatingText::remove);
        Messages.sendActionBarMessage(this.player, "shop.hover-actionbar", 1);
    }

    private void addPersonalTouch() {
        if (!(this.shop instanceof ShopArena)) {
            return;
        }
        String string = ((ShopArena)this.shop).alreadyBought(this.player) ? "shop.buying.arena-already-own" : "shop.buying.arena-lack-own";
        this.texts.forEach(floatingText -> {
            floatingText.text = floatingText.text.replace("%OWNED%", MessageData.getMessage(string));
        });
    }
}

