/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.shops;

import NL.martijnpu.ChunkDefence.data.ConfigData;
import NL.martijnpu.ChunkDefence.packageWrapper.WrapperPlayServerEntityDestroy;
import NL.martijnpu.ChunkDefence.packageWrapper.WrapperPlayServerEntityMetadata;
import NL.martijnpu.ChunkDefence.packageWrapper.WrapperPlayServerEntityTeleport;
import NL.martijnpu.ChunkDefence.packageWrapper.WrapperPlayServerSpawnEntityLiving;
import NL.martijnpu.ChunkDefence.shops.ShopManager;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class FloatingText {
    private final Vector offset;
    String text;
    private int entityID;
    private Player player;
    private Location location;

    FloatingText(@Nonnull String string, @Nonnull Vector vector) {
        this.text = string;
        this.offset = vector;
    }

    FloatingText copy() {
        return new FloatingText(this.text, this.offset);
    }

    void spawnText(Location location, Player player) {
        this.player = player;
        this.location = location;
        this.entityID = (int)(Math.random() * 2.147483647E9 / 4.0);
        this.spawnEntity();
    }

    void update() {
        WrapperPlayServerEntityTeleport wrapperPlayServerEntityTeleport = new WrapperPlayServerEntityTeleport();
        Location location = this.calcLocation();
        wrapperPlayServerEntityTeleport.setEntityID(this.entityID);
        wrapperPlayServerEntityTeleport.setX(location.getX());
        wrapperPlayServerEntityTeleport.setY(location.getY());
        wrapperPlayServerEntityTeleport.setZ(location.getZ());
        wrapperPlayServerEntityTeleport.setPitch(this.player.getEyeLocation().getPitch());
        wrapperPlayServerEntityTeleport.setYaw(this.player.getEyeLocation().getYaw());
        wrapperPlayServerEntityTeleport.sendPacket(this.player);
    }

    void remove() {
        WrapperPlayServerEntityDestroy wrapperPlayServerEntityDestroy = new WrapperPlayServerEntityDestroy();
        wrapperPlayServerEntityDestroy.setEntityIds(new int[]{this.entityID});
        wrapperPlayServerEntityDestroy.sendPacket(this.player);
    }

    private void spawnEntity() {
        WrapperPlayServerSpawnEntityLiving wrapperPlayServerSpawnEntityLiving = new WrapperPlayServerSpawnEntityLiving();
        Location location = this.calcLocation();
        wrapperPlayServerSpawnEntityLiving.setEntityID(this.entityID);
        wrapperPlayServerSpawnEntityLiving.setType(1);
        wrapperPlayServerSpawnEntityLiving.setX(location.getX());
        wrapperPlayServerSpawnEntityLiving.setY(location.getY());
        wrapperPlayServerSpawnEntityLiving.setZ(location.getZ());
        wrapperPlayServerSpawnEntityLiving.setPitch(this.player.getEyeLocation().getPitch());
        wrapperPlayServerSpawnEntityLiving.setYaw(this.player.getEyeLocation().getYaw());
        wrapperPlayServerSpawnEntityLiving.setHeadPitch(this.player.getEyeLocation().getYaw());
        wrapperPlayServerSpawnEntityLiving.sendPacket(this.player);
        this.sendMetaData();
    }

    private void sendMetaData() {
        WrapperPlayServerEntityMetadata wrapperPlayServerEntityMetadata = new WrapperPlayServerEntityMetadata();
        wrapperPlayServerEntityMetadata.setEntityID(this.entityID);
        wrapperPlayServerEntityMetadata.setMetadata(ShopManager.getWatcher(this.text).getWatchableObjects());
        wrapperPlayServerEntityMetadata.sendPacket(this.player);
    }

    private Location calcLocation() {
        Vector vector = this.player.getEyeLocation().getDirection();
        Vector vector2 = vector.clone().multiply(this.offset.getY() * 0.1 * this.offset.getZ()).rotateAroundAxis(vector.clone().setY(0).rotateAroundY(1.5707963267948966), 1.5707963267948966).rotateAroundAxis(vector.clone(), Math.PI);
        Vector vector3 = vector.clone().multiply(this.offset.getX() * 0.1 * this.offset.getZ()).rotateAroundAxis(vector.clone().setY(0).rotateAroundY(1.5707963267948966), 1.5707963267948966).rotateAroundAxis(vector.clone(), 4.71238898038469);
        if (ConfigData.getInstance().isShopRelativePlayer()) {
            Vector vector4 = vector.clone().multiply(this.offset.getZ()).add(new Vector(0.0, -1.35, 0.0));
            return this.player.getEyeLocation().clone().add(vector4).add(vector3).add(vector2);
        }
        Vector vector5 = this.player.getEyeLocation().toVector().subtract(this.location.clone().toVector().add(new Vector(0.0, 0.5, 0.0))).normalize().multiply(3.3 - this.offset.getZ());
        return this.location.clone().add(vector5).add(vector3).add(vector2).add(0.5, 0.5, 0.0);
    }
}

