/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.shops;

import NL.martijnpu.ChunkDefence.Messages;
import NL.martijnpu.ChunkDefence.arenas.Arena;
import NL.martijnpu.ChunkDefence.arenas.ArenaManager;
import NL.martijnpu.ChunkDefence.data.ConfigData;
import NL.martijnpu.ChunkDefence.data.FileHandler;
import NL.martijnpu.ChunkDefence.data.MessageData;
import NL.martijnpu.ChunkDefence.gui.GuiManager;
import NL.martijnpu.ChunkDefence.gui.GuiSlot;
import NL.martijnpu.ChunkDefence.gui.GuiType;
import NL.martijnpu.ChunkDefence.shops.Shop;
import java.util.Collections;
import java.util.HashMap;
import javax.annotation.Nonnull;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;

public class ShopArena
extends Shop {
    public ShopArena(String string) {
        super(string);
        if (ArenaManager.getInstance().isInvalidSchematic(this.getSchematic())) {
            Messages.sendConsole("arena.schematic.not-found");
            return;
        }
        this.loadFloatingText();
        this.setItem(null);
        this.setDisplay(this.getSchematic());
        this.shopLocation.getRelative(BlockFace.UP).setType(Material.BARRIER);
    }

    public ShopArena(Block block, String string, double d) {
        super(block, d, "Arena_" + string);
        this.setSchematic(string);
        if (ArenaManager.getInstance().isInvalidSchematic(string)) {
            Messages.sendConsoleWarning("Unable to load shop " + this.path + ". '" + string + "' is an invalid Arena");
            throw new IllegalArgumentException();
        }
        this.loadFloatingText();
        this.setItem(null);
        this.setDisplay(string);
        this.save();
        this.shopLocation.getRelative(BlockFace.UP).setType(Material.BARRIER);
    }

    public String getSchematic() {
        return FileHandler.getInstance().getShopsConfig().getString(this.path + ".arena", "");
    }

    public void setSchematic(@Nonnull String string) {
        FileHandler.getInstance().getShopsConfig().set(this.path + ".arena", (Object)string);
    }

    public String getName() {
        return FileHandler.getInstance().getShopsConfig().getString(this.path + ".display.name", this.getSchematic());
    }

    public void setName(String string) {
        if (!string.isEmpty()) {
            FileHandler.getInstance().getShopsConfig().set(this.path + ".display.name", (Object)string);
        }
    }

    public boolean alreadyBought(Player player) {
        Arena arena = ArenaManager.getInstance().getArena(player);
        if (arena == null) {
            return false;
        }
        return arena.getArenaData().hasBoughtArena(this.getSchematic());
    }

    @Override
    public void buyItem(Player player) {
        if (!this.canBuy(player)) {
            return;
        }
        if (ArenaManager.getInstance().getArena(player) == null) {
            Messages.sendMessage(player, "arena.none");
            return;
        }
        HashMap<Integer, GuiSlot> hashMap = new HashMap<Integer, GuiSlot>();
        hashMap.put(1, new GuiSlot(Material.LIME_CONCRETE_POWDER, "gui.buy-arena.question").setLore(Collections.singletonList("gui.buy-arena.confirm")).setLeftClick(() -> {
            this.buyConfirmed(player);
            GuiManager.getInstance().closeInventory(player);
        }));
        GuiManager.getInstance().openInventory(player, GuiType.CONFIRM_ARENA_BUY, hashMap);
    }

    @Override
    public boolean hasPermission(Player player) {
        return this.hasPermission(player, "arena", this.getSchematic());
    }

    public void buyConfirmed(Player player) {
        Arena arena = ArenaManager.getInstance().getArena(player);
        if (arena == null) {
            Messages.sendMessage(player, "arena.none");
            return;
        }
        if (!ConfigData.getInstance().canChangeArena(arena.getArenaData().getGamemode())) {
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BELL, SoundCategory.PLAYERS, 1.0f, 0.9f);
            Messages.sendMessage(player, "exception.arena-change");
            return;
        }
        if (arena.getWaveController().isInWave()) {
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BELL, SoundCategory.PLAYERS, 1.0f, 0.9f);
            Messages.sendMessage(player, "wave.progress");
            return;
        }
        if (!ArenaManager.getInstance().canChangeArena(this.getSchematic())) {
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BELL, SoundCategory.PLAYERS, 1.0f, 0.9f);
            Messages.sendMessage(player, "arena.schematic.not-found");
            return;
        }
        if (!player.hasPermission("chunkdefence.bypass.arena_cooldown") && arena.getSecondsSinceLastChange() < (long)ConfigData.getInstance().getArena_cooldown()) {
            Messages.sendMessage(player, MessageData.getMessage("arena.cooldown").replace("%AMOUNT%", (long)ConfigData.getInstance().getArena_cooldown() - arena.getSecondsSinceLastChange() + ""));
            return;
        }
        if (arena.getArenaData().hasBoughtArena(this.getSchematic()) || this.handleMoney(player)) {
            ArenaManager.getInstance().changeArena(arena, this.getSchematic());
        }
    }

    @Override
    protected void loadFloatingText() {
        super.loadFloatingText();
        this.textList.forEach(floatingText -> {
            floatingText.text = floatingText.text.replace("%NAME%", this.getSchematic());
        });
    }

    @Override
    public void editShop(Player player) {
        GuiManager.getInstance().openInventory(player, GuiType.SHOP_EDIT_ARENA, null);
    }
}

