/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.shops;

import NL.martijnpu.ChunkDefence.Messages;
import NL.martijnpu.ChunkDefence.data.FileHandler;
import NL.martijnpu.ChunkDefence.gui.GuiManager;
import NL.martijnpu.ChunkDefence.gui.GuiType;
import NL.martijnpu.ChunkDefence.shops.Shop;
import NL.martijnpu.ChunkDefence.traps.TrapBase;
import NL.martijnpu.ChunkDefence.traps.TrapManager;
import java.util.TreeMap;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ShopTrap
extends Shop {
    private static final TreeMap<Integer, String> map = new TreeMap();
    private TrapBase trapBase;
    private final int amount;

    public ShopTrap(String string) {
        super(string);
        this.trapBase = TrapManager.getInstance().getTrapBase(FileHandler.getInstance().getShopsConfig().getString(string + ".trap-index"));
        this.amount = FileHandler.getInstance().getShopsConfig().getInt(string + ".amount", 1);
        if (this.trapBase == null) {
            Messages.sendConsoleWarning("Unable to load shop " + string + ". Invalid Trap");
            throw new IllegalArgumentException();
        }
        this.loadFloatingText();
        this.removeTrap();
        this.setTrap();
    }

    public ShopTrap(Block block, TrapBase trapBase, double d) {
        super(block, d, trapBase.getName());
        this.trapBase = trapBase;
        this.amount = 1;
        this.loadFloatingText();
        this.setTrap();
        this.save();
    }

    public static String toRoman(int n) {
        int n2 = map.floorKey(n);
        if (n == n2) {
            return map.get(n);
        }
        return map.get(n2) + ShopTrap.toRoman(n - n2);
    }

    @Override
    public void buyItem(Player player) {
        if (!this.canBuy(player)) {
            return;
        }
        if (!this.handleMoney(player)) {
            return;
        }
        player.getInventory().addItem(new ItemStack[]{this.trapBase.generateTrapItem(this.amount)});
    }

    @Override
    public boolean hasPermission(Player player) {
        return this.hasPermission(player, "trap", this.trapBase.getIndexName());
    }

    @Override
    public void save() {
        FileHandler.getInstance().getShopsConfig().set(this.path + ".trap-index", (Object)this.trapBase.getIndexName());
        FileHandler.getInstance().getShopsConfig().set(this.path + ".amount", (Object)this.amount);
        super.save();
    }

    @Override
    void remove() {
        this.removeTrap();
        super.remove();
    }

    @Override
    protected void loadFloatingText() {
        super.loadFloatingText();
        this.textList.forEach(floatingText -> {
            floatingText.text = floatingText.text.replace("%NAME%", this.trapBase.getName() + "").replace("%AMOUNT%", this.amount + "").replace("%FIRE%", this.trapBase.isSetOnFire() + "").replace("%EFFECT%", this.toCapital(this.trapBase.getPotionEffectType().getName())).replace("%EFFECT_AMPLIFIER%", ShopTrap.toRoman(this.trapBase.getPotionAmplify())).replace("%DAMAGE_HEART%", this.trapBase.getDamage() + "").replace("%DAMAGE_SECONDS%", (this.trapBase.getInterval() % 1.0 == 0.0 ? (double)((int)this.trapBase.getInterval()) : this.trapBase.getInterval()) + "").replace("%RANGE%", (this.trapBase.getTargetRange() % 1.0 == 0.0 ? (double)((int)this.trapBase.getTargetRange()) : this.trapBase.getTargetRange()) + "").replace("%TARGET_AMOUNT%", this.trapBase.getTargetAmount() + "").replace("%DURABILITY%", this.trapBase.getMaxDurability() == -1 ? Messages.format("trap.shop-display.durability-infinity") : this.trapBase.getMaxDurability() + "").replace("%BUILD_SECONDS%", (this.trapBase.getSetupTime() % 1.0 == 0.0 ? (double)((int)this.trapBase.getSetupTime()) : this.trapBase.getSetupTime()) + "").replace("%MOBS%", this.getAllMobs());
        });
    }

    private void removeTrap() {
        TrapManager.getInstance().destroyTrap(this.shopLocation.getRelative(BlockFace.UP), null);
        this.shopLocation.getRelative(BlockFace.UP).setType(Material.AIR);
    }

    private void setTrap() {
        TrapManager.getInstance().placeTrap(this.shopLocation.getRelative(BlockFace.UP), this.trapBase, null, -1);
    }

    private String getAllMobs() {
        if (this.trapBase.getTargetEntity().size() == 0) {
            return Messages.format("trap.shop-display.mobs-all");
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.trapBase.getTargetEntity().size(); ++i) {
            stringBuilder.append(this.toCapital(this.trapBase.getTargetEntity().get(i).name()));
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    private String toCapital(String string) {
        string = string + " ";
        return string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase();
    }

    @Override
    public void editShop(Player player) {
        GuiManager.getInstance().openInventory(player, GuiType.SHOP_EDIT_TRAP, null);
    }

    public TrapBase getTrapBase() {
        return this.trapBase;
    }

    public void setTrapbase(TrapBase trapBase) {
        this.trapBase = trapBase;
    }

    static {
        map.put(1000, "M");
        map.put(900, "CM");
        map.put(500, "D");
        map.put(400, "CD");
        map.put(100, "C");
        map.put(90, "XC");
        map.put(50, "L");
        map.put(40, "XL");
        map.put(10, "X");
        map.put(9, "IX");
        map.put(5, "V");
        map.put(4, "IV");
        map.put(1, "I");
    }
}

