/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.traps;

import NL.martijnpu.ChunkDefence.traps.TrapBase;
import NL.martijnpu.ChunkDefence.traps.TrapLocation;
import org.bukkit.Location;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public enum ParticleOnAttack {
    NONE,
    AREA_TRAP,
    AREA_ATTACK,
    AREA_BOTH,
    PROJECTILE;


    void summonAttackParticles(TrapLocation trapLocation, Entity entity) {
        switch (this) {
            case AREA_TRAP: {
                this.summonAreaTrap(trapLocation);
                break;
            }
            case AREA_ATTACK: {
                this.summonAreaAttack(trapLocation.trapBase, entity);
                break;
            }
            case AREA_BOTH: {
                this.summonAreaTrap(trapLocation);
                this.summonAreaAttack(trapLocation.trapBase, entity);
                break;
            }
            case PROJECTILE: {
                this.drawLine(trapLocation.display.getLocation(), entity.getLocation().add(0.0, 1.0, 0.0), trapLocation.display.getWorld(), trapLocation.trapBase);
                break;
            }
        }
        trapLocation.display.getWorld().playSound(trapLocation.display.getLocation(), trapLocation.trapBase.getSoundOnAttack(), SoundCategory.PLAYERS, 0.5f, 1.0f);
    }

    private void summonAreaTrap(TrapLocation trapLocation) {
        trapLocation.display.getWorld().spawnParticle(trapLocation.trapBase.getParticle(), trapLocation.display.getLocation(), trapLocation.trapBase.getParticleAmount() * 2, 1.0, 1.0, 1.0, (double)trapLocation.trapBase.getParticleSpeed());
    }

    private void summonAreaAttack(TrapBase trapBase, Entity entity) {
        entity.getWorld().spawnParticle(trapBase.getParticle(), entity.getLocation(), trapBase.getParticleAmount() * 4, 0.5, 0.5, 0.5, (double)trapBase.getParticleSpeed());
    }

    private void drawLine(Location location, Location location2, World world, TrapBase trapBase) {
        double d = location.distance(location2);
        Vector vector = location.toVector();
        Vector vector2 = location2.toVector();
        Vector vector3 = vector2.clone().subtract(vector).normalize().multiply(0.2);
        for (double d2 = 0.0; d2 < d; d2 += 0.2) {
            world.spawnParticle(trapBase.getParticle(), vector.getX(), vector.getY(), vector.getZ(), trapBase.getParticleAmount() / 4, 0.1, 0.1, 0.1, (double)trapBase.getParticleSpeed());
            vector.add(vector3);
        }
    }
}

