/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.waves;

import NL.martijnpu.ChunkDefence.Main;
import NL.martijnpu.ChunkDefence.Messages;
import NL.martijnpu.ChunkDefence.arenas.Arena;
import NL.martijnpu.ChunkDefence.arenas.ArenaData;
import NL.martijnpu.ChunkDefence.arenas.ArenaEditor;
import NL.martijnpu.ChunkDefence.arenas.ArenaManager;
import NL.martijnpu.ChunkDefence.data.ConfigData;
import NL.martijnpu.ChunkDefence.data.DefinedMobData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Illusioner;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Pillager;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.Lootable;
import org.bukkit.material.Colorable;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class SpawnWaves {
    public static final String METADATA_KEY_COINS = "killCoins";

    public static void spawn(int n2, Arena arena) {
        Map<Integer, DefinedMobData> map = ConfigData.getInstance().isWaveDefined(n2) ? ConfigData.getInstance().getWave(n2) : SpawnWaves.getGeneratedWave(n2);
        List<Location> list = SpawnWaves.availableSpawnLocation(arena.getArenaData().getSpawnLocation());
        if (list.size() == 0) {
            arena.sendMessageToAll("exception.spawnloactions");
        } else {
            map.forEach((n, definedMobData) -> {
                for (int i = n % 100; i > 0; --i) {
                    SpawnWaves.spawnEntity(definedMobData, arena, (Location)list.get(new Random().nextInt(list.size())));
                }
            });
        }
    }

    public static Map<Integer, DefinedMobData> getGeneratedWave(int n) {
        HashMap<Integer, DefinedMobData> hashMap = new HashMap<Integer, DefinedMobData>();
        if (n <= 0) {
            return hashMap;
        }
        Random random = new Random(n);
        int n2 = (int)(Math.pow(n - 1, 2.24) * 0.1 + 2.0);
        int n3 = (int)Math.ceil(Math.pow(n, 0.4) / 2.0);
        int n4 = n2 / n3;
        int n5 = (int)((double)n * 0.2 + 5.0);
        while (n2 > 0) {
            ArrayList<DefinedMobData> arrayList = new ArrayList<DefinedMobData>();
            int n6 = n4;
            if (n6 * 2 > n2) {
                n6 = n2;
            }
            n2 -= n6;
            for (DefinedMobData definedMobData : ConfigData.getInstance().getAllGeneratedMobs()) {
                if (definedMobData.getWeight() > n6 || n6 / definedMobData.getWeight() > n5) continue;
                arrayList.add(definedMobData);
            }
            DefinedMobData definedMobData = (DefinedMobData)arrayList.get(random.nextInt(arrayList.size()));
            random.setSeed(definedMobData.getEntityType().hashCode() + definedMobData.getWeight() + n);
            hashMap.put((int)Math.round((double)n6 * 1.0 / (double)definedMobData.getWeight()) + 100 * hashMap.size(), definedMobData);
        }
        return hashMap;
    }

    static List<Location> availableSpawnLocation(Location location) {
        Location location2 = location.clone();
        ArrayList<Location> arrayList = new ArrayList<Location>();
        Arena arena = ArenaManager.getInstance().getArena(location2);
        if (arena == null) {
            return arrayList;
        }
        Vector vector = arena.getArenaData().getArenaLoc();
        Vector vector2 = ArenaEditor.getInstance().getDimensions(arena.getArenaData().getSchematicName());
        if (vector2 == null) {
            vector2 = new Vector(0, 0, 0);
        }
        vector2 = vector2.add(vector);
        location2.setX((double)vector.getBlockX());
        location2.setY((double)vector.getBlockY());
        location2.setZ((double)vector.getBlockZ());
        if (location2.getWorld() == null) {
            return arrayList;
        }
        for (int i = location2.getBlockX(); i <= vector2.getBlockX(); ++i) {
            for (int j = location2.getBlockY(); j <= vector2.getBlockY(); ++j) {
                for (int k = location2.getBlockZ(); k <= vector2.getBlockZ(); ++k) {
                    if (location2.getWorld().getBlockAt(i, j, k).getType() != ConfigData.getInstance().getSpawnBlock() || !location2.getWorld().getBlockAt(i, j + 1, k).isEmpty()) continue;
                    arrayList.add(new Location(location2.getWorld(), (double)i + 0.5, (double)(j + 1), (double)k + 0.5));
                }
            }
        }
        return arrayList;
    }

    private static LivingEntity spawnEntity(DefinedMobData definedMobData, Arena arena, Location location) {
        LivingEntity livingEntity = (LivingEntity)location.getWorld().spawnEntity(location, definedMobData.getEntityType());
        SpawnWaves.setDefault(livingEntity, arena.getArenaData().getDifficulty(), definedMobData, arena.getArenaData());
        if (livingEntity instanceof Mob) {
            ((Mob)livingEntity).setTarget((LivingEntity)arena.getRandomOnlinePlayer());
        }
        if (definedMobData.getPassenger() != null) {
            LivingEntity livingEntity2 = SpawnWaves.spawnEntity(definedMobData.getPassenger(), arena, location);
            livingEntity.addPassenger((Entity)livingEntity2);
        }
        return livingEntity;
    }

    private static void setDefault(LivingEntity livingEntity, int n, DefinedMobData definedMobData, ArenaData arenaData) {
        livingEntity.setMetadata(METADATA_KEY_COINS, (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)definedMobData.getCoins()));
        livingEntity.setSilent(definedMobData.getSilent());
        livingEntity.setGlowing(definedMobData.getGlowing());
        livingEntity.setGliding(definedMobData.getGliding());
        livingEntity.setRemoveWhenFarAway(false);
        if (livingEntity.getEquipment() != null) {
            livingEntity.getEquipment().clear();
            livingEntity.getEquipment().setItemInMainHand(definedMobData.getEntityMainHand());
            livingEntity.getEquipment().setItemInOffHand(definedMobData.getEntityOffHand());
            livingEntity.getEquipment().setHelmet(definedMobData.getEntityHelmet());
            livingEntity.getEquipment().setChestplate(definedMobData.getEntityChestPlate());
            livingEntity.getEquipment().setLeggings(definedMobData.getEntityLeggings());
            livingEntity.getEquipment().setBoots(definedMobData.getEntityBoots());
        }
        livingEntity.setCanPickupItems(false);
        if (livingEntity instanceof Lootable) {
            ((Lootable)livingEntity).setLootTable(null);
        }
        if (livingEntity instanceof Zombie) {
            ((Zombie)livingEntity).setBaby(!definedMobData.getEntityAdult());
        }
        if (livingEntity instanceof Rabbit) {
            ((Rabbit)livingEntity).setRabbitType(Rabbit.Type.THE_KILLER_BUNNY);
        }
        if (livingEntity instanceof Wolf) {
            ((Wolf)livingEntity).setAngry(true);
        }
        if (livingEntity instanceof Slime) {
            ((Slime)livingEntity).setSize(definedMobData.getSize());
        }
        if ((livingEntity instanceof Skeleton || livingEntity instanceof Illusioner) && definedMobData.getEntityMainHand() == null) {
            livingEntity.getEquipment().setItemInMainHand(new ItemStack(Material.BOW));
        }
        if (livingEntity instanceof Pillager && definedMobData.getEntityMainHand() == null) {
            livingEntity.getEquipment().setItemInMainHand(new ItemStack(Material.CROSSBOW));
        }
        if (livingEntity instanceof Creeper) {
            ((Creeper)livingEntity).setExplosionRadius(definedMobData.getExplosionRadius());
            ((Creeper)livingEntity).setPowered(definedMobData.getPowered());
        }
        if (definedMobData.getCustomName() != null) {
            livingEntity.setCustomName(Messages.format(definedMobData.getCustomName()));
            livingEntity.setCustomNameVisible(true);
        }
        if (livingEntity instanceof Colorable && definedMobData.getColor() != null) {
            try {
                ((Colorable)livingEntity).setColor(DyeColor.valueOf((String)definedMobData.getColor().toUpperCase()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Messages.sendConsoleWarning("Unknown DyeColor: " + definedMobData.getColor() + ". Setting to purple.");
                ((Colorable)livingEntity).setColor(DyeColor.PURPLE);
            }
        }
        if (livingEntity instanceof Ageable) {
            if (definedMobData.getEntityAdult()) {
                ((Ageable)livingEntity).setAdult();
            } else {
                ((Ageable)livingEntity).setBaby();
            }
        }
        if (ConfigData.getInstance().isAdoptiveDifficulty(arenaData.getGamemode())) {
            int n2 = definedMobData.getEntityHealth() != -1 ? definedMobData.getEntityHealth() : (int)(livingEntity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() * ((double)n / ((double)new Random().nextInt(20) + 90.0)));
            livingEntity.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue((double)n2);
            livingEntity.setHealth(livingEntity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getBaseValue());
        }
        if (definedMobData.getAdditionalDamage() != 0.0) {
            double d = livingEntity.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).getBaseValue();
            livingEntity.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(d + definedMobData.getAdditionalDamage());
        }
    }
}

