/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.waves;

import NL.martijnpu.ChunkDefence.Main;
import NL.martijnpu.ChunkDefence.Messages;
import NL.martijnpu.ChunkDefence.TimeHandler;
import NL.martijnpu.ChunkDefence.arenas.Arena;
import NL.martijnpu.ChunkDefence.data.ConfigData;
import NL.martijnpu.ChunkDefence.data.MessageData;
import NL.martijnpu.ChunkDefence.players.Economy;
import NL.martijnpu.ChunkDefence.statistics.ScoreManager;
import NL.martijnpu.ChunkDefence.waves.FireWorks;
import NL.martijnpu.ChunkDefence.waves.SpawnWaves;
import NL.martijnpu.ChunkDefence.waves.WaveData;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.attribute.Attribute;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class WaveController {
    private final Arena arena;
    private final BossBar bossBar;
    private int scheduledTask;
    private WaveData waveData;
    private int counter;
    private boolean isRunning;
    private long threeSecCheck;
    private boolean isPause;

    public WaveController(Arena arena) {
        this.arena = arena;
        this.waveData = null;
        this.isRunning = false;
        this.threeSecCheck = 0L;
        this.isPause = false;
        this.bossBar = Bukkit.createBossBar((String)Messages.format("bosbar.wave-start"), (BarColor)BarColor.RED, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        arena.getOnlinePlayers().forEach(arg_0 -> ((BossBar)this.bossBar).addPlayer(arg_0));
        if (!arena.getOnlinePlayers().get(0).hasPermission("chunkdefence.bypass.directstart")) {
            this.start();
        }
    }

    public WaveData getWaveData() {
        return this.waveData;
    }

    public void updatePlayers() {
        this.bossBar.removeAll();
        this.arena.getOnlinePlayers().forEach(arg_0 -> ((BossBar)this.bossBar).addPlayer(arg_0));
    }

    public void shutdown() {
        this.bossBar.setVisible(false);
        this.bossBar.removeAll();
        if (this.scheduledTask != 0) {
            Main.getInstance().getServer().getScheduler().cancelTask(this.scheduledTask);
        }
        if (this.waveData != null) {
            this.waveData.killWave();
            if (this.isRunning) {
                this.arena.getArenaData().editDifficulty(false);
            }
        }
    }

    public boolean isInWave() {
        return this.isRunning && this.scheduledTask == 0;
    }

    public void start() {
        if (this.isPause) {
            this.arena.sendMessageToAll("wave.pause.pause");
            return;
        }
        if (!this.isRunning) {
            this.isRunning = true;
            this.counter = ConfigData.getInstance().getWaveTimeBetween(this.arena.getArenaData().getGamemode());
            this.arena.getOnlinePlayers().forEach(player -> Messages.sendMessage(player, "wave.skip-timer"));
            this.scheduledTask = Main.getInstance().getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)Main.getInstance(), this::countdown, 20L, 20L);
            this.bossBar.setVisible(true);
            this.arena.getOnlinePlayers().forEach(player -> player.setPlayerTime(-700L, false));
            return;
        }
        if (this.scheduledTask == 0) {
            this.arena.sendMessageToAll("wave.force.in-wave");
            return;
        }
        if (this.counter > 3) {
            this.arena.sendMessageToAll("wave.force.succeed");
            this.counter = 3;
        } else if (this.counter > 0) {
            this.arena.sendMessageToAll("wave.force.already");
        }
    }

    public boolean pause(boolean bl) {
        if (this.isPause == bl) {
            return false;
        }
        this.isPause = bl;
        if (this.isRunning) {
            if (this.waveData == null) {
                if (this.scheduledTask != 0 && this.isPause) {
                    Main.getInstance().getServer().getScheduler().cancelTask(this.scheduledTask);
                } else {
                    this.startCountdown();
                }
            } else {
                this.waveData.pause(this.isPause);
            }
        }
        return true;
    }

    private void countdown() {
        if (this.counter == ConfigData.getInstance().getWaveTimeBetween(this.arena.getArenaData().getGamemode())) {
            this.arena.getOnlinePlayers().forEach(player -> player.setPlayerTime(-700L, false));
        }
        --this.counter;
        this.arena.setArenaTime((long)(12786.0 - 11002.0 * ((double)this.counter * 1.0 / (double)ConfigData.getInstance().getWaveTimeBetween(this.arena.getArenaData().getGamemode()))));
        this.bossBar.setProgress((double)((float)Math.max(this.counter, 0) * 1.0f / (float)ConfigData.getInstance().getWaveTimeBetween(this.arena.getArenaData().getGamemode())));
        if (this.counter >= 1) {
            this.bossBar.setTitle(Messages.format(MessageData.getMessage("bosbar.seconds-till-wave").replace("%AMOUNT%", this.counter + "")));
            this.bossBar.setColor(BarColor.GREEN);
        }
        if (this.counter == 120 || this.counter == 90 || this.counter == 60 || this.counter == 30 || this.counter == 10 || this.counter <= 3 && this.counter > 1) {
            this.arena.sendMessageToAll(MessageData.getMessage("wave.next-multiple").replace("%AMOUNT%", this.counter + ""));
        } else if (this.counter == 1) {
            this.arena.getOnlinePlayers().forEach(player -> this.arena.teleportHome((Player)player, false));
            this.arena.sendMessageToAll(MessageData.getMessage("wave.next-single").replace("%AMOUNT%", this.counter + ""));
            this.bossBar.setTitle(Messages.format("bosbar.wave-start"));
            this.bossBar.setColor(BarColor.RED);
        } else if (this.counter == 0) {
            this.arena.sendMessageToAll("wave.starting");
        } else if (this.counter == -1) {
            this.bossBar.setVisible(false);
            this.arena.getOnlinePlayers().forEach(player -> this.arena.teleportHome((Player)player, false));
            this.waveData = new WaveData(this.arena);
            SpawnWaves.spawn(this.arena.getArenaData().getWave(), this.arena);
            Main.getInstance().getServer().getScheduler().cancelTask(this.scheduledTask);
            this.scheduledTask = 0;
            this.threeSecCheck = 0L;
        }
    }

    public String getInfo() {
        if (this.isPause) {
            return Messages.format("placeholders.wave.pause");
        }
        if (!this.isRunning) {
            return Messages.format("placeholders.wave.none");
        }
        if (this.counter > 0) {
            return Messages.format("placeholders.wave.countdown").replace("%AMOUNT%", this.counter + "");
        }
        if (this.waveData == null) {
            return Messages.format("placeholders.wave.spawning");
        }
        return Messages.format("placeholders.wave.remaining").replace("%AMOUNT%", this.waveData.getRemainingEntities() + "");
    }

    public void pingSec() {
        if (this.waveData != null) {
            this.waveData.checkDeaths();
            this.checkWaveDone();
        }
    }

    private void checkWaveDone() {
        if (this.waveData == null || !this.waveData.isDone() || this.isPause) {
            return;
        }
        if (this.threeSecCheck == 0L) {
            this.threeSecCheck = TimeHandler.getTime();
        }
        if (this.threeSecCheck + 3L > TimeHandler.getTime()) {
            return;
        }
        if (this.arena.getOnlinePlayers().stream().noneMatch(player -> this.arena.isInsideArena(player.getLocation()))) {
            this.pause(true);
            this.arena.sendMessageToAll("arena.away");
        }
        this.bossBar.setTitle(Messages.format("bosbar.wave-finish"));
        this.bossBar.setColor(BarColor.GREEN);
        this.bossBar.setVisible(true);
        for (Player player2 : this.arena.getOnlinePlayers()) {
            player2.playSound(player2.getLocation(), Sound.ENTITY_ENDER_DRAGON_GROWL, SoundCategory.PLAYERS, 1.0f, 1.0f);
            FireWorks.spawnFireWork(player2.getLocation(), 2, 5);
            Economy.depositPlayer(player2, ConfigData.getInstance().getWaveCoinsSucceed(this.arena.getArenaData().getGamemode()));
        }
        this.arena.getArenaData().editDifficulty(true);
        FireWorks.spawnFireWorksArena(this.arena.getArenaData().getSpawnLocation());
        if (this.scheduledTask != 0) {
            Main.getInstance().getServer().getScheduler().cancelTask(this.scheduledTask);
        }
        this.arena.getArenaData().addWave();
        this.arena.getOnlinePlayers().forEach(player -> Economy.depositPlayer(player.getPlayer(), ConfigData.getInstance().getWaveCoinsSucceed(this.arena.getArenaData().getGamemode())));
        if (ConfigData.getInstance().getWaveHealOnSucceed(this.arena.getArenaData().getGamemode())) {
            this.arena.getOnlinePlayers().forEach(player -> player.setHealth(player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getBaseValue()));
        }
        this.counter = ConfigData.getInstance().getWaveTimeBetween(this.arena.getArenaData().getGamemode());
        this.arena.getOnlinePlayers().forEach(player -> Messages.sendBigMessage(player.getPlayer(), Arrays.asList(MessageData.getMessage("wave.survived").replace("%AMOUNT%", this.waveData.getWave() + ""), MessageData.getMessage("wave.next-multiple").replace("%AMOUNT%", this.counter + ""))));
        this.waveData.killWave();
        this.waveData = null;
        ScoreManager.getInstance().updateArenaScore(this.arena);
        this.startCountdown();
    }

    private void startCountdown() {
        this.scheduledTask = Main.getInstance().getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)Main.getInstance(), this::countdown, 60L, 20L);
        this.bossBar.setVisible(true);
        this.arena.getOnlinePlayers().forEach(player -> Messages.sendMessage(player, "wave.skip-timer"));
    }
}

