/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.waves;

import NL.martijnpu.ChunkDefence.Messages;
import NL.martijnpu.ChunkDefence.arenas.Arena;
import NL.martijnpu.ChunkDefence.data.MessageData;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class WaveData {
    private final Arena arena;
    private final List<LivingEntity> waveEntities;
    private final BossBar bossBar;
    private int deaths;
    private boolean isSpawned;

    WaveData(Arena arena) {
        this.arena = arena;
        this.waveEntities = new ArrayList<LivingEntity>();
        this.deaths = 0;
        this.isSpawned = false;
        this.bossBar = Bukkit.createBossBar((String)Messages.format(MessageData.getMessage("bosbar.wave-during").replace("%WAVE%", arena.getArenaData().getWave() + "")), (BarColor)BarColor.RED, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        arena.getOnlinePlayers().forEach(arg_0 -> ((BossBar)this.bossBar).addPlayer(arg_0));
        this.updateBossBar();
    }

    int getWave() {
        return this.arena.getArenaData().getWave();
    }

    int getRemainingEntities() {
        return this.waveEntities.size();
    }

    public void addEntity(LivingEntity livingEntity) {
        this.waveEntities.add(livingEntity);
        this.isSpawned = this.waveEntities.size() != 0;
        this.updateBossBar();
    }

    void pause(boolean bl) {
        if (this.waveEntities.size() > 0) {
            PotionEffect potionEffect = new PotionEffect(PotionEffectType.SLOW, 9999, 9999, false, false);
            PotionEffect potionEffect2 = new PotionEffect(PotionEffectType.WEAKNESS, 9999, 9999, false, false);
            PotionEffect potionEffect3 = new PotionEffect(PotionEffectType.INVISIBILITY, 9999, 9999, false, false);
            this.waveEntities.forEach(livingEntity -> {
                if (bl) {
                    livingEntity.setInvulnerable(true);
                    livingEntity.setGlowing(true);
                    livingEntity.addPotionEffect(potionEffect);
                    livingEntity.addPotionEffect(potionEffect2);
                    livingEntity.addPotionEffect(potionEffect3);
                    this.removeTargets();
                } else {
                    livingEntity.setInvulnerable(false);
                    livingEntity.setGlowing(false);
                    livingEntity.removePotionEffect(PotionEffectType.SLOW);
                    livingEntity.removePotionEffect(PotionEffectType.WEAKNESS);
                    livingEntity.removePotionEffect(PotionEffectType.INVISIBILITY);
                    this.updateTargets(null);
                }
            });
        }
    }

    void killWave() {
        this.bossBar.removeAll();
        for (LivingEntity livingEntity : this.waveEntities) {
            if (livingEntity.isDead()) continue;
            livingEntity.remove();
        }
    }

    public void updateTargets(@Nullable Player player2) {
        List<Player> list = this.arena.getOnlinePlayers();
        list.removeIf(player -> !this.arena.isInsideArena(player.getLocation()));
        for (LivingEntity livingEntity : this.waveEntities) {
            if (livingEntity.isDead() || player2 != null && ((Mob)livingEntity).getTarget() != player2) continue;
            Player player3 = list.size() == 1 ? list.get(0) : list.get(new Random().nextInt(list.size() - 1));
            ((Mob)livingEntity).setTarget((LivingEntity)player3);
        }
    }

    private void removeTargets() {
        for (LivingEntity livingEntity : this.waveEntities) {
            if (livingEntity.isDead()) continue;
            ((Mob)livingEntity).setTarget(null);
        }
    }

    void checkDeaths() {
        int n = this.waveEntities.size();
        this.waveEntities.removeIf(livingEntity -> !livingEntity.isValid());
        this.deaths += n - this.waveEntities.size();
        this.updateBossBar();
    }

    boolean isDone() {
        return this.waveEntities.size() == 0 && this.isSpawned;
    }

    private void updateBossBar() {
        this.bossBar.setVisible(true);
        if (this.waveEntities.size() == 0) {
            this.bossBar.setProgress(0.0);
        } else {
            this.bossBar.setProgress((double)this.waveEntities.size() * 1.0 / (double)(this.waveEntities.size() + this.deaths));
            this.arena.setArenaTime(21000 - 6000 * this.waveEntities.size() / (this.waveEntities.size() + this.deaths));
        }
        if (this.isDone()) {
            this.bossBar.removeAll();
        }
    }

    public void highlightEntities() {
        PotionEffect potionEffect = new PotionEffect(PotionEffectType.GLOWING, 200, 0, false, false, false);
        this.waveEntities.forEach(livingEntity -> livingEntity.addPotionEffect(potionEffect));
    }
}

