/*
 * Decompiled with CFR 0.152.
 */
package clib.net.byteflux.libby.logging.adapters;

import clib.net.byteflux.libby.logging.LogLevel;
import clib.net.byteflux.libby.logging.adapters.LogAdapter;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JDKLogAdapter
implements LogAdapter {
    private final Logger logger;

    public JDKLogAdapter(Logger logger) {
        this.logger = Objects.requireNonNull(logger, "logger");
    }

    @Override
    public void log(LogLevel logLevel, String string) {
        switch (Objects.requireNonNull(logLevel, "level")) {
            case DEBUG: {
                this.logger.log(Level.FINE, string);
                break;
            }
            case INFO: {
                this.logger.log(Level.INFO, string);
                break;
            }
            case WARN: {
                this.logger.log(Level.WARNING, string);
                break;
            }
            case ERROR: {
                this.logger.log(Level.SEVERE, string);
            }
        }
    }

    @Override
    public void log(LogLevel logLevel, String string, Throwable throwable) {
        switch (Objects.requireNonNull(logLevel, "level")) {
            case DEBUG: {
                this.logger.log(Level.FINE, string, throwable);
                break;
            }
            case INFO: {
                this.logger.log(Level.INFO, string, throwable);
                break;
            }
            case WARN: {
                this.logger.log(Level.WARNING, string, throwable);
                break;
            }
            case ERROR: {
                this.logger.log(Level.SEVERE, string, throwable);
            }
        }
    }
}

