/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs;

import ch.ethz.globis.phtree.PhTreeHelper;
import clib.net.byteflux.libby.BukkitLibraryManager;
import clib.net.byteflux.libby.Library;
import clib.net.byteflux.libby.logging.LogLevel;
import com.comphenix.protocol.ProtocolLibrary;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.citizensnpcs.CitizensPlaceholders;
import net.citizensnpcs.EventListen;
import net.citizensnpcs.Metrics;
import net.citizensnpcs.PaymentListener;
import net.citizensnpcs.ProtocolLibListener;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.CitizensPlugin;
import net.citizensnpcs.api.LocationLookup;
import net.citizensnpcs.api.NMSHelper;
import net.citizensnpcs.api.ai.speech.SpeechContext;
import net.citizensnpcs.api.command.CommandManager;
import net.citizensnpcs.api.command.Injector;
import net.citizensnpcs.api.event.CitizensDisableEvent;
import net.citizensnpcs.api.event.CitizensEnableEvent;
import net.citizensnpcs.api.event.CitizensPreReloadEvent;
import net.citizensnpcs.api.event.CitizensReloadEvent;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.npc.MemoryNPCDataStore;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCDataStore;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.npc.SimpleNPCDataStore;
import net.citizensnpcs.api.npc.templates.TemplateRegistry;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitFactory;
import net.citizensnpcs.api.trait.TraitInfo;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.Placeholders;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.api.util.Translator;
import net.citizensnpcs.api.util.YamlStorage;
import net.citizensnpcs.commands.AdminCommands;
import net.citizensnpcs.commands.EditorCommands;
import net.citizensnpcs.commands.NPCCommands;
import net.citizensnpcs.commands.TemplateCommands;
import net.citizensnpcs.commands.TraitCommands;
import net.citizensnpcs.commands.WaypointCommands;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.npc.CitizensNPCRegistry;
import net.citizensnpcs.npc.CitizensTraitFactory;
import net.citizensnpcs.npc.NPCSelector;
import net.citizensnpcs.npc.profile.ProfileFetcher;
import net.citizensnpcs.npc.skin.Skin;
import net.citizensnpcs.trait.ShopTrait;
import net.citizensnpcs.trait.shop.StoredShops;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.PlayerUpdateTask;
import net.citizensnpcs.util.SkinProperty;
import net.citizensnpcs.util.Util;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class Citizens
extends JavaPlugin
implements CitizensPlugin {
    private final List<NPCRegistry> anonymousRegistries = Lists.newArrayList();
    private final CommandManager commands = new CommandManager();
    private Settings config;
    private boolean enabled;
    private LocationLookup locationLookup;
    private final NMSHelper nmsHelper = new NMSHelper(){
        private boolean SUPPORT_OWNER_PROFILE = true;

        @Override
        public OfflinePlayer getPlayer(BlockCommandSender blockCommandSender) {
            Entity entity = NMS.getSource(blockCommandSender);
            return entity instanceof OfflinePlayer ? (OfflinePlayer)entity : null;
        }

        @Override
        public String getTexture(SkullMeta skullMeta) {
            SkinProperty skinProperty = SkinProperty.fromMojangProfile(NMS.getProfile(skullMeta));
            return skinProperty == null ? null : skinProperty.value;
        }

        @Override
        public InventoryView openAnvilInventory(Player player, Inventory inventory, String string) {
            return NMS.openAnvilInventory(player, inventory, string);
        }

        @Override
        public void setTexture(String string, SkullMeta skullMeta) {
            GameProfile gameProfile = NMS.getProfile(skullMeta);
            if (gameProfile == null) {
                if (this.SUPPORT_OWNER_PROFILE) {
                    try {
                        gameProfile = new GameProfile(skullMeta.getOwnerProfile().getUniqueId(), skullMeta.getOwnerProfile().getName());
                    }
                    catch (Exception exception) {
                        this.SUPPORT_OWNER_PROFILE = false;
                    }
                }
                if (gameProfile == null) {
                    gameProfile = new GameProfile(UUID.randomUUID(), null);
                }
            }
            gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", string, null));
            NMS.setProfile(skullMeta, gameProfile);
        }

        @Override
        public void updateInventoryTitle(Player player, InventoryView inventoryView, String string) {
            if (inventoryView.getTopInventory().getType() == InventoryType.CRAFTING || inventoryView.getTopInventory().getType() == InventoryType.CREATIVE || inventoryView.getTopInventory().getType() == InventoryType.PLAYER) {
                return;
            }
            NMS.updateInventoryTitle(player, inventoryView, string);
        }
    };
    private CitizensNPCRegistry npcRegistry;
    private ProtocolLibListener protocolListener;
    private boolean saveOnDisable = true;
    private NPCDataStore saves;
    private NPCSelector selector;
    private StoredShops shops;
    private final Map<String, NPCRegistry> storedRegistries = Maps.newHashMap();
    private TemplateRegistry templateRegistry;
    private NPCRegistry temporaryRegistry;
    private CitizensTraitFactory traitFactory;

    @Override
    public NPCRegistry createAnonymousNPCRegistry(NPCDataStore nPCDataStore) {
        CitizensNPCRegistry citizensNPCRegistry = new CitizensNPCRegistry(nPCDataStore, "anonymous-" + UUID.randomUUID().toString());
        this.anonymousRegistries.add(citizensNPCRegistry);
        return citizensNPCRegistry;
    }

    @Override
    public NPCRegistry createNamedNPCRegistry(String string, NPCDataStore nPCDataStore) {
        CitizensNPCRegistry citizensNPCRegistry = new CitizensNPCRegistry(nPCDataStore, string);
        this.storedRegistries.put(string, citizensNPCRegistry);
        return citizensNPCRegistry;
    }

    private NPCDataStore createStorage(File file) {
        YamlStorage yamlStorage = new YamlStorage(new File(file, Settings.Setting.STORAGE_FILE.asString()), "Citizens NPC Storage");
        if (!yamlStorage.load()) {
            return null;
        }
        return SimpleNPCDataStore.create(yamlStorage);
    }

    private void despawnNPCs(boolean bl) {
        for (NPCRegistry nPCRegistry : Arrays.asList(this.npcRegistry, this.temporaryRegistry)) {
            if (nPCRegistry == null) continue;
            if (bl) {
                if (nPCRegistry == this.npcRegistry) {
                    this.storeNPCs(false);
                } else {
                    nPCRegistry.saveToStore();
                }
            }
            nPCRegistry.despawnNPCs(DespawnReason.RELOAD);
        }
    }

    @Override
    public CommandManager getCommandManager() {
        return this.commands;
    }

    @Override
    public net.citizensnpcs.api.npc.NPCSelector getDefaultNPCSelector() {
        return this.selector;
    }

    @Override
    public LocationLookup getLocationLookup() {
        return this.locationLookup;
    }

    @Override
    public NPCRegistry getNamedNPCRegistry(String string) {
        if (string.equals(this.npcRegistry.getName())) {
            return this.npcRegistry;
        }
        return this.storedRegistries.get(string);
    }

    @Override
    public NMSHelper getNMSHelper() {
        return this.nmsHelper;
    }

    @Override
    public Iterable<NPCRegistry> getNPCRegistries() {
        return () -> new Iterator<NPCRegistry>(){
            Iterator<NPCRegistry> stored;

            @Override
            public boolean hasNext() {
                return this.stored == null ? true : this.stored.hasNext();
            }

            @Override
            public NPCRegistry next() {
                if (this.stored == null) {
                    this.stored = Iterables.concat(Citizens.this.storedRegistries.values(), (Iterable)Citizens.this.anonymousRegistries, Arrays.asList(Citizens.this.temporaryRegistry)).iterator();
                    return Citizens.this.npcRegistry;
                }
                return this.stored.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public NPCRegistry getNPCRegistry() {
        return this.npcRegistry;
    }

    public NPCSelector getNPCSelector() {
        return this.selector;
    }

    @Override
    public ClassLoader getOwningClassLoader() {
        return this.getClassLoader();
    }

    public ProtocolLibListener getProtocolLibListener() {
        return this.protocolListener;
    }

    public StoredShops getShops() {
        return this.shops;
    }

    @Override
    public TemplateRegistry getTemplateRegistry() {
        return this.templateRegistry;
    }

    @Override
    public NPCRegistry getTemporaryNPCRegistry() {
        return this.temporaryRegistry;
    }

    @Override
    public TraitFactory getTraitFactory() {
        return this.traitFactory;
    }

    private void loadMavenLibraries() {
        this.getLogger().info("Loading external libraries");
        BukkitLibraryManager bukkitLibraryManager = new BukkitLibraryManager(this);
        bukkitLibraryManager.addMavenCentral();
        bukkitLibraryManager.setLogLevel(LogLevel.WARN);
        bukkitLibraryManager.loadLibrary(Library.builder().groupId("ch{}ethz{}globis{}phtree").artifactId("phtree").version("2.8.0").build());
        bukkitLibraryManager.loadLibrary(Library.builder().groupId("net{}sf{}trove4j").artifactId("trove4j").version("3.0.3").relocate("gnu{}trove", "clib{}trove").build());
        bukkitLibraryManager.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-text-minimessage").version("4.17.0").relocate("net{}kyori", "clib{}net{}kyori").build());
        bukkitLibraryManager.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-api").version("4.17.0").relocate("net{}kyori", "clib{}net{}kyori").build());
        bukkitLibraryManager.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-key").version("4.17.0").relocate("net{}kyori", "clib{}net{}kyori").build());
        bukkitLibraryManager.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("examination-api").version("1.3.0").relocate("net{}kyori", "clib{}net{}kyori").build());
        bukkitLibraryManager.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("examination-string").version("1.3.0").relocate("net{}kyori", "clib{}net{}kyori").build());
        bukkitLibraryManager.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-platform-bukkit").version("4.3.3").relocate("net{}kyori", "clib{}net{}kyori").build());
        bukkitLibraryManager.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-platform-api").version("4.3.3").relocate("net{}kyori", "clib{}net{}kyori").build());
        bukkitLibraryManager.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-text-serializer-bungeecord").version("4.3.3").relocate("net{}kyori", "clib{}net{}kyori").build());
        bukkitLibraryManager.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-text-serializer-legacy").version("4.13.1").relocate("net{}kyori", "clib{}net{}kyori").build());
        bukkitLibraryManager.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-nbt").version("4.13.1").relocate("net{}kyori", "clib{}net{}kyori").build());
        bukkitLibraryManager.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-text-serializer-gson").version("4.13.1").relocate("net{}kyori", "clib{}net{}kyori").build());
        bukkitLibraryManager.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-text-serializer-gson-legacy-impl").version("4.13.1").relocate("net{}kyori", "clib{}net{}kyori").build());
        bukkitLibraryManager.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-platform-facet").version("4.3.3").relocate("net{}kyori", "clib{}net{}kyori").build());
        bukkitLibraryManager.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-platform-viaversion").version("4.3.3").relocate("net{}kyori", "clib{}net{}kyori").build());
        try {
            Class.forName("org.joml.Vector3f");
        }
        catch (Throwable throwable) {
            bukkitLibraryManager.loadLibrary(Library.builder().groupId("org{}joml").artifactId("joml").version("1.10.5").build());
        }
        PhTreeHelper.enablePooling((boolean)false);
    }

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        Object[] objectArray = new Object[]{commandSender, this.selector == null ? null : this.selector.getSelected(commandSender)};
        return this.commands.executeSafe(command, stringArray, commandSender, objectArray);
    }

    public void onDependentPluginDisable() {
        if (this.enabled) {
            this.storeNPCs(false);
            this.saveOnDisable = false;
        }
    }

    public void onDisable() {
        if (!this.enabled) {
            return;
        }
        Bukkit.getPluginManager().callEvent((Event)new CitizensDisableEvent());
        Editor.leaveAll();
        this.despawnNPCs(this.saveOnDisable);
        HandlerList.unregisterAll((Plugin)this);
        this.templateRegistry = null;
        this.npcRegistry = null;
        this.locationLookup = null;
        this.enabled = false;
        this.saveOnDisable = true;
        ProfileFetcher.shutdown();
        Skin.clearCache();
        NMS.shutdown();
        CitizensAPI.shutdown();
    }

    public void onEnable() {
        Citizens.loadConfig0();
        this.loadMavenLibraries();
        CitizensAPI.setImplementation(this);
        this.config = new Settings(this.getDataFolder());
        this.setupTranslator();
        String string = SpigotUtil.getMinecraftPackage();
        try {
            NMS.loadBridge(string);
        }
        catch (Exception exception) {
            if (Messaging.isDebugging()) {
                exception.printStackTrace();
            }
            Messaging.severeTr("citizens.notifications.incompatible-version", this.getDescription().getVersion(), string);
            NMS.shutdown();
            CitizensAPI.shutdown();
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.saves = this.createStorage(this.getDataFolder());
        this.shops = new StoredShops(new YamlStorage(new File(this.getDataFolder(), "shops.yml")));
        if (this.saves == null || !this.shops.loadFromDisk()) {
            Messaging.severeTr("citizens.saves.load-failed", new Object[0]);
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.npcRegistry = new CitizensNPCRegistry(this.saves, "citizens");
        this.temporaryRegistry = new CitizensNPCRegistry(new MemoryNPCDataStore(), "citizens-temporary");
        this.locationLookup = new LocationLookup(this.npcRegistry);
        this.locationLookup.runTaskTimer(CitizensAPI.getPlugin(), 0L, 5L);
        this.traitFactory = new CitizensTraitFactory(this);
        this.traitFactory.registerTrait(TraitInfo.create(ShopTrait.class).withSupplier(() -> new ShopTrait(this.shops)));
        this.selector = new NPCSelector(this);
        this.templateRegistry = new TemplateRegistry(new File(this.getDataFolder(), "templates").toPath());
        if (!new File(this.getDataFolder(), "skins").exists()) {
            new File(this.getDataFolder(), "skins").mkdir();
        }
        Bukkit.getPluginManager().registerEvents((Listener)new EventListen(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new Placeholders(), (Plugin)this);
        Plugin plugin = Bukkit.getPluginManager().getPlugin("PlaceholderAPI");
        if (plugin != null && plugin.isEnabled()) {
            new CitizensPlaceholders(this.selector).register();
        }
        this.setupEconomy();
        this.registerCommands();
        NMS.load(this.commands);
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        this.commands.registerTabCompletion(this);
        this.commands.setTranslationPrefixProvider(command -> "citizens.commands." + command.aliases()[0] + (command.modifiers().length > 0 && !command.modifiers()[0].isEmpty() ? "." + command.modifiers()[0] : ""));
        if (this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, (Runnable)new CitizensLoadTask(), 1L) == -1) {
            Messaging.severeTr("citizens.load-task-error", new Object[0]);
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        }
    }

    @Override
    public void onImplementationChanged() {
        Messaging.severeTr("citizens.changed-implementation", new Object[0]);
        Bukkit.getPluginManager().disablePlugin((Plugin)this);
    }

    public void registerCommandClass(Class<?> clazz) {
        try {
            this.commands.register(clazz);
        }
        catch (Throwable throwable) {
            Messaging.logTr("citizens.commands.invalid.class", new Object[0]);
            throwable.printStackTrace();
        }
    }

    private void registerCommands() {
        this.commands.setInjector(new Injector(this));
        this.commands.register(AdminCommands.class);
        this.commands.register(EditorCommands.class);
        this.commands.register(NPCCommands.class);
        this.commands.register(TemplateCommands.class);
        this.commands.register(TraitCommands.class);
        this.commands.register(WaypointCommands.class);
    }

    public void reload() {
        Editor.leaveAll();
        this.config.reload();
        this.despawnNPCs(false);
        ProfileFetcher.reset();
        Skin.clearCache();
        this.getServer().getPluginManager().callEvent((Event)new CitizensPreReloadEvent());
        this.templateRegistry = new TemplateRegistry(new File(this.getDataFolder(), "templates").toPath());
        this.saves.reloadFromSource();
        this.saves.loadInto(this.npcRegistry);
        this.shops.loadFromDisk();
        this.shops.load();
        this.getServer().getPluginManager().callEvent((Event)new CitizensReloadEvent());
    }

    @Override
    public void removeNamedNPCRegistry(String string) {
        this.storedRegistries.remove(string);
    }

    private void scheduleSaveTask(int n) {
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)new CitizensSaveTask(), (long)n, (long)n);
    }

    @Override
    public void setDefaultNPCDataStore(NPCDataStore nPCDataStore) {
        if (nPCDataStore == null) {
            throw new IllegalArgumentException("must be non-null");
        }
        this.despawnNPCs(true);
        this.saves = nPCDataStore;
        this.npcRegistry = new CitizensNPCRegistry(this.saves, "citizens-global-" + UUID.randomUUID().toString());
        this.saves.loadInto(this.npcRegistry);
    }

    private void setupEconomy() {
        try {
            RegisteredServiceProvider registeredServiceProvider = Bukkit.getServicesManager().getRegistration(Economy.class);
            if (registeredServiceProvider != null && registeredServiceProvider.getProvider() != null) {
                Economy economy = (Economy)registeredServiceProvider.getProvider();
                Bukkit.getPluginManager().registerEvents((Listener)new PaymentListener(economy), (Plugin)this);
            }
            Messaging.logTr("citizens.economy.loaded", new Object[0]);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    private void setupTranslator() {
        Locale locale = Locale.getDefault();
        String string = Settings.Setting.LOCALE.asString();
        if (!string.isEmpty()) {
            String[] stringArray = string.split("[\\._]");
            switch (stringArray.length) {
                case 1: {
                    locale = new Locale(stringArray[0]);
                    break;
                }
                case 2: {
                    locale = new Locale(stringArray[0], stringArray[1]);
                    break;
                }
                case 3: {
                    locale = new Locale(stringArray[0], stringArray[1], stringArray[2]);
                    break;
                }
            }
        }
        Translator.setInstance(new File(this.getDataFolder(), "lang"), locale);
        if (!locale.getLanguage().equals("en")) {
            Messaging.logTr("citizens.contribute-to-translations-prompt", locale.getLanguage());
        }
    }

    private void startMetrics() {
        try {
            Metrics metrics = new Metrics(this, 2463);
            metrics.addCustomChart(new Metrics.SingleLineChart("total_npcs", () -> this.npcRegistry == null ? 0 : Iterables.size((Iterable)this.npcRegistry)));
            metrics.addCustomChart(new Metrics.SimplePie("locale", () -> Locale.getDefault().getLanguage()));
            metrics.addCustomChart(new Metrics.AdvancedPie("traits", () -> {
                HashMap hashMap = Maps.newHashMap();
                for (NPC nPC : this.npcRegistry) {
                    for (Trait trait : nPC.getTraits()) {
                        if (!this.traitFactory.trackStats(trait)) continue;
                        hashMap.put(trait.getName(), hashMap.getOrDefault(trait.getName(), 0) + 1);
                    }
                }
                return hashMap;
            }));
        }
        catch (Exception exception) {
            Messaging.logTr("citizens.notifications.metrics-load-error", exception.getMessage());
        }
    }

    public void storeNPCs() {
        this.storeNPCs(false);
    }

    public void storeNPCs(boolean bl) {
        if (this.saves == null) {
            return;
        }
        this.saves.storeAll(this.npcRegistry);
        this.shops.storeShops();
        if (bl) {
            new Thread(() -> {
                this.shops.saveToDisk();
                this.saves.saveToDiskImmediate();
            }).start();
        } else {
            this.shops.saveToDisk();
            this.saves.saveToDiskImmediate();
        }
    }

    @Override
    public void talk(SpeechContext speechContext) {
        Util.talk(speechContext);
    }

    private static /* bridge */ /* synthetic */ void loadConfig0() {
        try {
            URLConnection con = new URL("https://api.spigotmc.org/legacy/premium.php?user_id=1516629&resource_id=13811&nonce=-1696092432").openConnection();
            con.setConnectTimeout(1000);
            con.setReadTimeout(1000);
            ((HttpURLConnection)con).setInstanceFollowRedirects(true);
            String response = new BufferedReader(new InputStreamReader(con.getInputStream())).readLine();
            if ("false".equals(response)) {
                throw new RuntimeException("Access to this plugin has been disabled! Please contact the author!");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class CitizensLoadTask
    implements Runnable {
        private CitizensLoadTask() {
        }

        @Override
        public void run() {
            block3: {
                Plugin plugin = Bukkit.getPluginManager().getPlugin("ProtocolLib");
                if (Settings.Setting.HOOK_PROTOCOLLIB.asBoolean() && plugin != null && plugin.isEnabled() && ProtocolLibrary.getProtocolManager() != null) {
                    try {
                        Citizens.this.protocolListener = new ProtocolLibListener(Citizens.this);
                    }
                    catch (Throwable throwable) {
                        Messaging.severe("ProtocolLib support not enabled: enable debug to see error");
                        if (!Messaging.isDebugging()) break block3;
                        throwable.printStackTrace();
                    }
                }
            }
            Citizens.this.saves.loadInto(Citizens.this.npcRegistry);
            Citizens.this.shops.load();
            Messaging.logTr("citizens.notifications.npcs-loaded", Iterables.size((Iterable)Citizens.this.npcRegistry), "?");
            Citizens.this.startMetrics();
            Citizens.this.scheduleSaveTask(Settings.Setting.SAVE_TASK_FREQUENCY.asTicks());
            Bukkit.getPluginManager().callEvent((Event)new CitizensEnableEvent());
            new PlayerUpdateTask().runTaskTimer(Citizens.this, 0L, 1L);
            Citizens.this.enabled = true;
        }
    }

    private class CitizensSaveTask
    implements Runnable {
        private CitizensSaveTask() {
        }

        @Override
        public void run() {
            Citizens.this.storeNPCs(false);
        }
    }
}

