/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs;

import java.util.Optional;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.NPCSelector;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;

public class CitizensPlaceholders
extends PlaceholderExpansion {
    private final NPCSelector selector;

    public CitizensPlaceholders(NPCSelector nPCSelector) {
        this.selector = nPCSelector;
    }

    public String getAuthor() {
        return "fullwall";
    }

    public String getIdentifier() {
        return "citizensplaceholder";
    }

    public String getVersion() {
        return "1.0.0";
    }

    public String onRequest(OfflinePlayer offlinePlayer, String string) {
        if (offlinePlayer == null || !offlinePlayer.isOnline()) {
            return null;
        }
        NPC nPC3 = this.selector.getSelected((CommandSender)offlinePlayer);
        switch (string) {
            case "citizens_selected_npc_name": {
                return nPC3 == null ? "" : nPC3.getFullName();
            }
            case "citizens_selected_npc_id": {
                return nPC3 == null ? "" : Integer.toString(nPC3.getId());
            }
            case "citizens_selected_npc_uuid": {
                return nPC3 == null ? "" : nPC3.getUniqueId().toString();
            }
            case "citizens_nearest_npc_id": {
                Location location = offlinePlayer.getPlayer().getLocation();
                Optional<NPC> optional = offlinePlayer.getPlayer().getNearbyEntities(25.0, 25.0, 25.0).stream().map(CitizensAPI.getNPCRegistry()::getNPC).filter(nPC -> nPC != null && nPC.getEntity() != offlinePlayer).min((nPC, nPC2) -> Double.compare(nPC.getEntity().getLocation().distanceSquared(location), nPC2.getEntity().getLocation().distanceSquared(location)));
                return optional.isPresent() ? Integer.toString(optional.get().getId()) : "";
            }
        }
        return null;
    }

    public boolean persist() {
        return true;
    }
}

