/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs;

import java.util.Objects;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.event.PlayerCreateNPCEvent;
import net.citizensnpcs.api.util.Messaging;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class PaymentListener
implements Listener {
    private final Economy provider;

    public PaymentListener(Economy economy) {
        Objects.requireNonNull(economy, "provider cannot be null");
        this.provider = economy;
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerCreateNPC(PlayerCreateNPCEvent playerCreateNPCEvent) {
        boolean bl = this.provider.hasAccount((OfflinePlayer)playerCreateNPCEvent.getCreator());
        if (!bl || playerCreateNPCEvent.getCreator().hasPermission("citizens.npc.ignore-cost")) {
            return;
        }
        double d = Settings.Setting.NPC_COST.asDouble();
        EconomyResponse economyResponse = this.provider.withdrawPlayer((OfflinePlayer)playerCreateNPCEvent.getCreator(), d);
        if (!economyResponse.transactionSuccess()) {
            playerCreateNPCEvent.setCancelled(true);
            playerCreateNPCEvent.setCancelReason(economyResponse.errorMessage);
            return;
        }
        String string = this.provider.format(d);
        Messaging.sendTr((CommandSender)playerCreateNPCEvent.getCreator(), "citizens.economy.money-withdrawn", string);
    }
}

