/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.ListenerOptions;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataValue;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedSignedProperty;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.api.event.NPCAddTraitEvent;
import net.citizensnpcs.api.event.NPCDespawnEvent;
import net.citizensnpcs.api.event.NPCEvent;
import net.citizensnpcs.api.event.NPCSpawnEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.HologramTrait;
import net.citizensnpcs.trait.MirrorTrait;
import net.citizensnpcs.trait.RotationTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.SkinProperty;
import org.bukkit.Bukkit;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.plugin.Plugin;

public class ProtocolLibListener
implements Listener {
    private ProtocolManager manager;
    private final Map<UUID, MirrorTrait> mirrorTraits = Maps.newConcurrentMap();
    private Citizens plugin;
    private final Map<Integer, RotationTrait> rotationTraits = Maps.newConcurrentMap();
    private static boolean LOGGED_ERROR = false;

    public ProtocolLibListener(Citizens citizens) {
        this.plugin = citizens;
        this.manager = ProtocolLibrary.getProtocolManager();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)citizens);
        this.manager.addPacketListener((PacketListener)new PacketAdapter(citizens, ListenerPriority.HIGHEST, new PacketType[]{PacketType.Play.Server.ENTITY_METADATA}){

            public void onPacketSending(PacketEvent packetEvent) {
                NPC nPC = ProtocolLibListener.this.getNPCFromPacket(packetEvent);
                if (nPC == null) {
                    return;
                }
                PacketContainer packetContainer = packetEvent.getPacket();
                int n = ProtocolLibListener.this.manager.getProtocolVersion(packetEvent.getPlayer());
                if (nPC.data().has(NPC.Metadata.HOLOGRAM_RENDERER)) {
                    HologramTrait.HologramRenderer hologramRenderer = (HologramTrait.HologramRenderer)nPC.data().get(NPC.Metadata.HOLOGRAM_RENDERER);
                    String string = null;
                    String string2 = hologramRenderer.getPerPlayerText(nPC, packetEvent.getPlayer());
                    string = n <= 340 ? string2 : Optional.of(Messaging.minecraftComponentFromRawMessage(string2));
                    boolean bl = hologramRenderer.isSneaking(nPC, packetEvent.getPlayer());
                    boolean bl2 = false;
                    if (n < 761) {
                        List list = (List)packetContainer.getWatchableCollectionModifier().readSafely(0);
                        if (list == null) {
                            return;
                        }
                        for (WrappedWatchableObject wrappedWatchableObject : list) {
                            if (string != null && wrappedWatchableObject.getIndex() == 2) {
                                wrappedWatchableObject.setValue((Object)string);
                                bl2 = true;
                                continue;
                            }
                            if (!bl || wrappedWatchableObject.getIndex() != 0) continue;
                            byte by = (byte)(((Number)wrappedWatchableObject.getValue()).byteValue() | 2);
                            wrappedWatchableObject.setValue((Object)by);
                            bl2 = true;
                        }
                        if (bl2) {
                            packetContainer.getWatchableCollectionModifier().write(0, (Object)list);
                        }
                    } else {
                        List list = (List)packetContainer.getDataValueCollectionModifier().readSafely(0);
                        if (list == null) {
                            return;
                        }
                        for (WrappedDataValue wrappedDataValue : list) {
                            switch (wrappedDataValue.getIndex()) {
                                case 0: {
                                    if (!bl) break;
                                    byte by = (byte)(((Number)wrappedDataValue.getValue()).byteValue() | 2);
                                    wrappedDataValue.setValue((Object)by);
                                    bl2 = true;
                                    break;
                                }
                                case 2: {
                                    if (string == null) break;
                                    wrappedDataValue.setRawValue((Object)string);
                                    bl2 = true;
                                    break;
                                }
                                case 22: {
                                    if (n > 762 || string == null || nPC.getEntity().getType() != EntityType.TEXT_DISPLAY) break;
                                    wrappedDataValue.setRawValue(((Optional)((Object)string)).get());
                                    bl2 = true;
                                    break;
                                }
                                case 23: {
                                    if (n <= 762 || string == null || nPC.getEntity().getType() != EntityType.TEXT_DISPLAY) break;
                                    wrappedDataValue.setRawValue(((Optional)((Object)string)).get());
                                    bl2 = true;
                                }
                            }
                        }
                        if (bl2) {
                            packetContainer.getDataValueCollectionModifier().write(0, (Object)list);
                        }
                    }
                }
            }
        });
        this.manager.addPacketListener((PacketListener)new PacketAdapter(citizens, ListenerPriority.HIGHEST, Arrays.asList(PacketType.Play.Server.PLAYER_INFO), new ListenerOptions[]{ListenerOptions.ASYNC}){

            public void onPacketSending(PacketEvent packetEvent) {
                int n = ProtocolLibListener.this.manager.getProtocolVersion(packetEvent.getPlayer());
                if (n >= 761) {
                    NMS.onPlayerInfoAdd(packetEvent.getPlayer(), packetEvent.getPacket().getHandle(), uUID -> (MirrorTrait)ProtocolLibListener.this.mirrorTraits.get(uUID));
                    return;
                }
                List list = (List)packetEvent.getPacket().getPlayerInfoDataLists().readSafely(0);
                if (list == null) {
                    return;
                }
                boolean bl = false;
                GameProfile gameProfile = null;
                WrappedGameProfile wrappedGameProfile = null;
                WrappedChatComponent wrappedChatComponent = null;
                for (int i = 0; i < list.size(); ++i) {
                    MirrorTrait mirrorTrait;
                    PlayerInfoData playerInfoData = (PlayerInfoData)list.get(i);
                    if (playerInfoData == null || (mirrorTrait = (MirrorTrait)ProtocolLibListener.this.mirrorTraits.get(playerInfoData.getProfile().getUUID())) == null || !mirrorTrait.isMirroring(packetEvent.getPlayer())) continue;
                    if (gameProfile == null) {
                        gameProfile = NMS.getProfile(packetEvent.getPlayer());
                        wrappedGameProfile = WrappedGameProfile.fromPlayer((Player)packetEvent.getPlayer());
                        wrappedChatComponent = WrappedChatComponent.fromText((String)packetEvent.getPlayer().getDisplayName());
                    }
                    if (mirrorTrait.mirrorName()) {
                        list.set(i, new PlayerInfoData(wrappedGameProfile.withId(playerInfoData.getProfile().getId()), playerInfoData.getLatency(), playerInfoData.getGameMode(), wrappedChatComponent));
                        continue;
                    }
                    Collection collection = gameProfile.getProperties().get((Object)"textures");
                    if (collection == null || collection.size() == 0) continue;
                    playerInfoData.getProfile().getProperties().clear();
                    for (String string : gameProfile.getProperties().keySet()) {
                        playerInfoData.getProfile().getProperties().putAll((Object)string, Iterables.transform((Iterable)gameProfile.getProperties().get((Object)string), property -> {
                            SkinProperty skinProperty = SkinProperty.fromMojang(property);
                            return new WrappedSignedProperty(skinProperty.name, skinProperty.value, skinProperty.signature);
                        }));
                    }
                    bl = true;
                }
                if (bl) {
                    packetEvent.getPacket().getPlayerInfoDataLists().write(0, (Object)list);
                }
            }
        });
        this.manager.addPacketListener((PacketListener)new PacketAdapter(citizens, ListenerPriority.HIGHEST, Arrays.asList(PacketType.Play.Server.ENTITY_HEAD_ROTATION, PacketType.Play.Server.ENTITY_LOOK, PacketType.Play.Server.REL_ENTITY_MOVE_LOOK, PacketType.Play.Server.ENTITY_MOVE_LOOK, PacketType.Play.Server.ENTITY_TELEPORT), new ListenerOptions[]{ListenerOptions.ASYNC}){

            public void onPacketSending(PacketEvent packetEvent) {
                Integer n = null;
                try {
                    n = (Integer)packetEvent.getPacket().getIntegers().readSafely(0);
                    if (n == null) {
                        return;
                    }
                }
                catch (FieldAccessException | IllegalArgumentException throwable) {
                    if (!LOGGED_ERROR) {
                        Messaging.severe("Error retrieving entity from ID: ProtocolLib error? Suppressing further exceptions unless debugging.");
                        throwable.printStackTrace();
                        LOGGED_ERROR = true;
                    } else if (Messaging.isDebugging()) {
                        throwable.printStackTrace();
                    }
                    return;
                }
                RotationTrait rotationTrait = (RotationTrait)ProtocolLibListener.this.rotationTraits.get(n);
                if (rotationTrait == null) {
                    return;
                }
                RotationTrait.PacketRotationSession packetRotationSession = rotationTrait.getPacketSession(packetEvent.getPlayer());
                if (packetRotationSession == null || !packetRotationSession.isActive()) {
                    return;
                }
                PacketContainer packetContainer = packetEvent.getPacket();
                PacketType packetType = packetEvent.getPacketType();
                Messaging.debug(Float.valueOf(packetRotationSession.getBodyYaw()), Float.valueOf(packetRotationSession.getHeadYaw()), "OVERWRITTEN " + packetType + " " + packetContainer.getHandle());
                if (packetType == PacketType.Play.Server.ENTITY_HEAD_ROTATION) {
                    packetContainer.getBytes().write(0, (Object)ProtocolLibListener.degToByte(packetRotationSession.getHeadYaw()));
                } else if (packetType == PacketType.Play.Server.ENTITY_LOOK || packetType == PacketType.Play.Server.ENTITY_MOVE_LOOK || packetType == PacketType.Play.Server.REL_ENTITY_MOVE_LOOK || packetType == PacketType.Play.Server.ENTITY_TELEPORT) {
                    packetContainer.getBytes().write(0, (Object)ProtocolLibListener.degToByte(packetRotationSession.getBodyYaw()));
                    packetContainer.getBytes().write(1, (Object)ProtocolLibListener.degToByte(packetRotationSession.getPitch()));
                }
                packetRotationSession.onPacketOverwritten();
            }
        });
    }

    private NPC getNPCFromPacket(PacketEvent packetEvent) {
        PacketContainer packetContainer = packetEvent.getPacket();
        try {
            Object object = packetContainer.getEntityModifier(packetEvent).read(0);
            return object instanceof NPCHolder ? ((NPCHolder)object).getNPC() : null;
        }
        catch (FieldAccessException | IllegalArgumentException throwable) {
            if (!LOGGED_ERROR) {
                Messaging.severe("Error retrieving entity from ID: ProtocolLib error? Suppressing further exceptions unless debugging.");
                throwable.printStackTrace();
                LOGGED_ERROR = true;
            } else if (Messaging.isDebugging()) {
                throwable.printStackTrace();
            }
            return null;
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent entityDeathEvent) {
        this.rotationTraits.remove(entityDeathEvent.getEntity().getEntityId());
    }

    @EventHandler(ignoreCancelled=true)
    public void onNPCDespawn(NPCDespawnEvent nPCDespawnEvent) {
        if (nPCDespawnEvent.getNPC().getEntity() == null) {
            return;
        }
        this.rotationTraits.remove(nPCDespawnEvent.getNPC().getEntity().getEntityId());
        this.mirrorTraits.remove(nPCDespawnEvent.getNPC().getEntity().getUniqueId());
    }

    @EventHandler(ignoreCancelled=true)
    public void onNPCSpawn(NPCSpawnEvent nPCSpawnEvent) {
        this.onSpawn(nPCSpawnEvent);
    }

    private void onSpawn(NPCEvent nPCEvent) {
        if (nPCEvent.getNPC().hasTrait(RotationTrait.class)) {
            this.rotationTraits.put(nPCEvent.getNPC().getEntity().getEntityId(), nPCEvent.getNPC().getTraitNullable(RotationTrait.class));
        }
        if (nPCEvent.getNPC().hasTrait(MirrorTrait.class) && nPCEvent.getNPC().getOrAddTrait(MobType.class).getType() == EntityType.PLAYER) {
            this.mirrorTraits.put(nPCEvent.getNPC().getEntity().getUniqueId(), nPCEvent.getNPC().getTraitNullable(MirrorTrait.class));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onTraitAdd(NPCAddTraitEvent nPCAddTraitEvent) {
        if (!nPCAddTraitEvent.getNPC().isSpawned()) {
            return;
        }
        this.onSpawn(nPCAddTraitEvent);
    }

    private static byte degToByte(float f) {
        return (byte)(f * 256.0f / 360.0f);
    }
}

