/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api;

import java.io.File;
import net.citizensnpcs.api.CitizensPlugin;
import net.citizensnpcs.api.LocationLookup;
import net.citizensnpcs.api.NMSHelper;
import net.citizensnpcs.api.ai.speech.SpeechContext;
import net.citizensnpcs.api.command.CommandManager;
import net.citizensnpcs.api.npc.MemoryNPCDataStore;
import net.citizensnpcs.api.npc.NPCDataStore;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.npc.NPCSelector;
import net.citizensnpcs.api.npc.templates.TemplateRegistry;
import net.citizensnpcs.api.trait.TraitFactory;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public final class CitizensAPI {
    private static volatile CitizensPlugin instance = null;

    private CitizensAPI() {
    }

    public static NPCRegistry createAnonymousNPCRegistry(NPCDataStore nPCDataStore) {
        return CitizensAPI.getImplementation().createAnonymousNPCRegistry(nPCDataStore);
    }

    public static NPCRegistry createInMemoryNPCRegistry(String string) {
        return CitizensAPI.getImplementation().createNamedNPCRegistry(string, new MemoryNPCDataStore());
    }

    public static NPCRegistry createNamedNPCRegistry(String string, NPCDataStore nPCDataStore) {
        return CitizensAPI.getImplementation().createNamedNPCRegistry(string, nPCDataStore);
    }

    public static CommandManager getCommandManager() {
        return CitizensAPI.getImplementation().getCommandManager();
    }

    public static File getDataFolder() {
        return CitizensAPI.getImplementation().getDataFolder();
    }

    public static NPCSelector getDefaultNPCSelector() {
        return CitizensAPI.getImplementation().getDefaultNPCSelector();
    }

    private static CitizensPlugin getImplementation() {
        if (instance == null) {
            throw new IllegalStateException("no implementation set");
        }
        return instance;
    }

    private static ClassLoader getImplementationClassLoader() {
        return CitizensAPI.getImplementation().getOwningClassLoader();
    }

    public static LocationLookup getLocationLookup() {
        return CitizensAPI.getImplementation().getLocationLookup();
    }

    public static NPCRegistry getNamedNPCRegistry(String string) {
        return CitizensAPI.getImplementation().getNamedNPCRegistry(string);
    }

    public static NMSHelper getNMSHelper() {
        return CitizensAPI.getImplementation().getNMSHelper();
    }

    public static Iterable<NPCRegistry> getNPCRegistries() {
        return CitizensAPI.getImplementation().getNPCRegistries();
    }

    public static NPCRegistry getNPCRegistry() {
        return CitizensAPI.getImplementation().getNPCRegistry();
    }

    public static Plugin getPlugin() {
        return CitizensAPI.getImplementation();
    }

    public static TemplateRegistry getTemplateRegistry() {
        return CitizensAPI.getImplementation().getTemplateRegistry();
    }

    public static NPCRegistry getTemporaryNPCRegistry() {
        return CitizensAPI.getImplementation().getTemporaryNPCRegistry();
    }

    public static TraitFactory getTraitFactory() {
        return CitizensAPI.getImplementation().getTraitFactory();
    }

    public static boolean hasImplementation() {
        return instance != null;
    }

    public static void registerEvents(Listener listener) {
        if (Bukkit.getServer() != null && CitizensAPI.getPlugin() != null) {
            Bukkit.getPluginManager().registerEvents(listener, CitizensAPI.getPlugin());
        }
    }

    public static void removeNamedNPCRegistry(String string) {
        CitizensAPI.getImplementation().removeNamedNPCRegistry(string);
    }

    public static void setImplementation(CitizensPlugin citizensPlugin) {
        if (citizensPlugin != null && CitizensAPI.hasImplementation()) {
            CitizensAPI.getImplementation().onImplementationChanged();
        }
        instance = citizensPlugin;
    }

    public static void shutdown() {
        instance = null;
    }

    public static void talk(SpeechContext speechContext) {
        CitizensAPI.getImplementation().talk(speechContext);
    }
}

