/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.citizensnpcs.api.ai.AttackStrategy;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.ai.StuckAction;
import net.citizensnpcs.api.ai.event.NavigatorCallback;
import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import org.bukkit.Location;
import org.bukkit.entity.Entity;

public class NavigatorParameters
implements Cloneable {
    private int attackDelayTicks = 20;
    private double attackRange;
    private AttackStrategy attackStrategy;
    private boolean avoidWater;
    private float baseSpeed = 1.0f;
    private List<NavigatorCallback> callbacks = Lists.newArrayList();
    private boolean debug;
    private AttackStrategy defaultStrategy;
    private double destinationTeleportMargin = -1.0;
    private double distanceMargin = 2.0;
    private List<BlockExaminer> examiners = Lists.newArrayList();
    private Function<Navigator, Location> lookAtFunction;
    private Function<Entity, Location> mapper;
    private double pathDistanceMargin = 1.0;
    private float range;
    private List<Runnable> runCallbacks = Lists.newArrayList();
    private float speedModifier = 1.0f;
    private int stationaryTicks = -1;
    private float straightLineTargetingDistance;
    private StuckAction stuckAction;
    private int updatePathRate;
    private boolean useNewPathfinder;
    private static final Function<Entity, Location> DEFAULT_MAPPER = Entity::getLocation;

    public NavigatorParameters addRunCallback(Runnable runnable) {
        this.runCallbacks.add(runnable);
        return this;
    }

    public NavigatorParameters addSingleUseCallback(NavigatorCallback navigatorCallback) {
        this.callbacks.add(navigatorCallback);
        return this;
    }

    public int attackDelayTicks() {
        return this.attackDelayTicks;
    }

    public NavigatorParameters attackDelayTicks(int n) {
        this.attackDelayTicks = n;
        return this;
    }

    public double attackRange() {
        return this.attackRange;
    }

    public NavigatorParameters attackRange(double d) {
        this.attackRange = d;
        return this;
    }

    public AttackStrategy attackStrategy() {
        return this.attackStrategy == null ? this.defaultStrategy : this.attackStrategy;
    }

    public void attackStrategy(AttackStrategy attackStrategy) {
        this.attackStrategy = attackStrategy;
    }

    public boolean avoidWater() {
        return this.avoidWater;
    }

    public NavigatorParameters avoidWater(boolean bl) {
        this.avoidWater = bl;
        return this;
    }

    public float baseSpeed() {
        return this.baseSpeed;
    }

    public NavigatorParameters baseSpeed(float f) {
        this.baseSpeed = f;
        return this;
    }

    public Iterable<NavigatorCallback> callbacks() {
        return this.callbacks;
    }

    public NavigatorParameters clearExaminers() {
        this.examiners.clear();
        return this;
    }

    public NavigatorParameters clone() {
        try {
            NavigatorParameters navigatorParameters = (NavigatorParameters)super.clone();
            if (this.callbacks instanceof ArrayList) {
                navigatorParameters.callbacks = (List)((ArrayList)this.callbacks).clone();
            }
            if (this.examiners instanceof ArrayList) {
                navigatorParameters.examiners = (List)((ArrayList)this.examiners).clone();
            }
            if (this.runCallbacks instanceof ArrayList) {
                navigatorParameters.runCallbacks = (List)((ArrayList)this.runCallbacks).clone();
            }
            return navigatorParameters;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean debug() {
        return this.debug;
    }

    public NavigatorParameters debug(boolean bl) {
        this.debug = bl;
        return this;
    }

    public AttackStrategy defaultAttackStrategy() {
        return this.defaultStrategy;
    }

    public NavigatorParameters defaultAttackStrategy(AttackStrategy attackStrategy) {
        this.defaultStrategy = attackStrategy;
        return this;
    }

    public double destinationTeleportMargin() {
        return this.destinationTeleportMargin;
    }

    public NavigatorParameters destinationTeleportMargin(double d) {
        this.destinationTeleportMargin = d;
        return this;
    }

    public double distanceMargin() {
        return this.distanceMargin;
    }

    public NavigatorParameters distanceMargin(double d) {
        this.distanceMargin = d;
        return this;
    }

    public Function<Entity, Location> entityTargetLocationMapper() {
        return this.mapper != null ? this.mapper : DEFAULT_MAPPER;
    }

    public NavigatorParameters entityTargetLocationMapper(Function<Entity, Location> function) {
        this.mapper = function;
        return this;
    }

    public NavigatorParameters examiner(BlockExaminer blockExaminer) {
        this.examiners.add(blockExaminer);
        return this;
    }

    public BlockExaminer[] examiners() {
        return this.examiners.toArray(new BlockExaminer[this.examiners.size()]);
    }

    public boolean hasExaminer(Class<? extends BlockExaminer> clazz) {
        return Arrays.asList(this.examiners).stream().anyMatch(list -> clazz.isAssignableFrom(list.getClass()));
    }

    public Function<Navigator, Location> lookAtFunction() {
        return this.lookAtFunction;
    }

    public NavigatorParameters lookAtFunction(Function<Navigator, Location> function) {
        this.lookAtFunction = function;
        return this;
    }

    public float modifiedSpeed(float f) {
        return f * this.speedModifier();
    }

    public double pathDistanceMargin() {
        return this.pathDistanceMargin;
    }

    public NavigatorParameters pathDistanceMargin(double d) {
        this.pathDistanceMargin = d;
        return this;
    }

    public float range() {
        return this.range;
    }

    public NavigatorParameters range(float f) {
        this.range = f;
        return this;
    }

    public NavigatorParameters removeRunCallback(Runnable runnable) {
        this.runCallbacks.remove(runnable);
        return this;
    }

    public void run() {
        for (int i = 0; i < this.runCallbacks.size(); ++i) {
            this.runCallbacks.get(i).run();
        }
    }

    public float speed() {
        return this.modifiedSpeed(this.baseSpeed);
    }

    @Deprecated
    public NavigatorParameters speed(float f) {
        this.baseSpeed = f;
        return this;
    }

    public float speedModifier() {
        return this.speedModifier;
    }

    public NavigatorParameters speedModifier(float f) {
        this.speedModifier = f;
        return this;
    }

    public int stationaryTicks() {
        return this.stationaryTicks;
    }

    public NavigatorParameters stationaryTicks(int n) {
        this.stationaryTicks = n;
        return this;
    }

    public float straightLineTargetingDistance() {
        return this.straightLineTargetingDistance;
    }

    public NavigatorParameters straightLineTargetingDistance(float f) {
        this.straightLineTargetingDistance = f;
        return this;
    }

    public StuckAction stuckAction() {
        return this.stuckAction;
    }

    public NavigatorParameters stuckAction(StuckAction stuckAction) {
        this.stuckAction = stuckAction;
        return this;
    }

    public int updatePathRate() {
        return this.updatePathRate;
    }

    public NavigatorParameters updatePathRate(int n) {
        this.updatePathRate = n;
        return this;
    }

    public boolean useNewPathfinder() {
        return this.useNewPathfinder;
    }

    public NavigatorParameters useNewPathfinder(boolean bl) {
        this.useNewPathfinder = bl;
        return this;
    }
}

